/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.schema;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.schema.SchemaLabel;
import com.baidu.hugegraph.schema.builder.SchemaBuilder;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.Frequency;
import com.baidu.hugegraph.util.E;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class EdgeLabel
extends SchemaLabel {
    private Id sourceLabel;
    private Id targetLabel;
    private Frequency frequency = Frequency.DEFAULT;
    private List<Id> sortKeys = new ArrayList<Id>();

    public EdgeLabel(HugeGraph graph, Id id, String name) {
        super(graph, id, name);
    }

    @Override
    public HugeType type() {
        return HugeType.EDGE_LABEL;
    }

    public Frequency frequency() {
        return this.frequency;
    }

    public void frequency(Frequency frequency) {
        this.frequency = frequency;
    }

    public boolean directed() {
        return true;
    }

    public Id sourceLabel() {
        return this.sourceLabel;
    }

    public void sourceLabel(Id id) {
        E.checkArgument((this.sourceLabel == null ? 1 : 0) != 0, (String)"Not allowed to set source label multi times of edge label '%s'", (Object[])new Object[]{this.name()});
        this.sourceLabel = id;
    }

    public Id targetLabel() {
        return this.targetLabel;
    }

    public void targetLabel(Id id) {
        E.checkArgument((this.targetLabel == null ? 1 : 0) != 0, (String)"Not allowed to set target label multi times of edge label '%s'", (Object[])new Object[]{this.name()});
        this.targetLabel = id;
    }

    public boolean linkWithLabel(Id id) {
        return this.sourceLabel.equals(id) || this.targetLabel.equals(id);
    }

    public boolean checkLinkEqual(Id sourceLabel, Id targetLabel) {
        return this.sourceLabel.equals(sourceLabel) && this.targetLabel.equals(targetLabel);
    }

    public List<Id> sortKeys() {
        return Collections.unmodifiableList(this.sortKeys);
    }

    public void sortKey(Id id) {
        this.sortKeys.add(id);
    }

    public void sortKeys(Id ... ids) {
        this.sortKeys.addAll(Arrays.asList(ids));
    }

    public static interface Builder
    extends SchemaBuilder<EdgeLabel> {
        public Id rebuildIndex();

        public Builder link(String var1, String var2);

        public Builder sourceLabel(String var1);

        public Builder targetLabel(String var1);

        public Builder singleTime();

        public Builder multiTimes();

        public Builder sortKeys(String ... var1);

        public Builder properties(String ... var1);

        public Builder nullableKeys(String ... var1);

        public Builder frequency(Frequency var1);

        public Builder enableLabelIndex(boolean var1);

        public Builder userdata(String var1, Object var2);

        public Builder userdata(Map<String, Object> var1);
    }
}

