/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.schema;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.IdGenerator;
import com.baidu.hugegraph.exception.NotSupportException;
import com.baidu.hugegraph.schema.SchemaElement;
import com.baidu.hugegraph.schema.builder.SchemaBuilder;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.IndexType;
import com.baidu.hugegraph.util.E;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class IndexLabel
extends SchemaElement {
    private HugeType baseType;
    private Id baseValue;
    private IndexType indexType = IndexType.SECONDARY;
    private List<Id> indexFields = new ArrayList<Id>();
    public static final IndexLabel VL_IL = new IndexLabel(-1L, "~vli");
    public static final IndexLabel EL_IL = new IndexLabel(-2L, "~eli");
    public static final IndexLabel PK_NAME_IL = new IndexLabel(-3L, "~pkni");
    public static final IndexLabel VL_NAME_IL = new IndexLabel(-4L, "~vlni");
    public static final IndexLabel EL_NAME_IL = new IndexLabel(-5L, "~elni");
    public static final IndexLabel IL_NAME_IL = new IndexLabel(-6L, "~ilni");

    public IndexLabel(HugeGraph graph, Id id, String name) {
        super(graph, id, name);
    }

    protected IndexLabel(long id, String name) {
        this(null, IdGenerator.of(id), name);
    }

    @Override
    public HugeType type() {
        return HugeType.INDEX_LABEL;
    }

    public HugeType baseType() {
        return this.baseType;
    }

    public void baseType(HugeType baseType) {
        this.baseType = baseType;
    }

    public Id baseValue() {
        return this.baseValue;
    }

    public void baseValue(Id id) {
        this.baseValue = id;
    }

    public IndexType indexType() {
        return this.indexType;
    }

    public void indexType(IndexType indexType) {
        this.indexType = indexType;
    }

    public HugeType queryType() {
        switch (this.baseType) {
            case VERTEX_LABEL: {
                return HugeType.VERTEX;
            }
            case EDGE_LABEL: {
                return HugeType.EDGE;
            }
        }
        throw new AssertionError((Object)String.format("Query type of index label is either '%s' or '%s', but '%s' is used", HugeType.VERTEX_LABEL, HugeType.EDGE_LABEL, this.baseType));
    }

    public List<Id> indexFields() {
        return Collections.unmodifiableList(this.indexFields);
    }

    public void indexFields(Id ... ids) {
        this.indexFields.addAll(Arrays.asList(ids));
    }

    public void indexField(Id id) {
        this.indexFields.add(id);
    }

    public Id indexField() {
        E.checkState((this.indexType == IndexType.RANGE || this.indexType == IndexType.SEARCH ? 1 : 0) != 0, (String)"Can't call indexField() for %s index label", (Object[])new Object[]{this.indexType.string()});
        E.checkState((this.indexFields.size() == 1 ? 1 : 0) != 0, (String)"There should be only one field in %s index label, but got: %s", (Object[])new Object[]{this.indexType.string(), this.indexFields});
        return this.indexFields.get(0);
    }

    @Override
    public Map<String, Object> userdata() {
        throw new NotSupportException("user data for index label");
    }

    @Override
    public void userdata(String key, Object value) {
        throw new NotSupportException("user data for index label");
    }

    public static IndexLabel label(HugeType type) {
        switch (type) {
            case VERTEX: {
                return VL_IL;
            }
            case EDGE: 
            case EDGE_OUT: 
            case EDGE_IN: {
                return EL_IL;
            }
            case PROPERTY_KEY: {
                return PK_NAME_IL;
            }
            case VERTEX_LABEL: {
                return VL_NAME_IL;
            }
            case EDGE_LABEL: {
                return EL_NAME_IL;
            }
            case INDEX_LABEL: {
                return IL_NAME_IL;
            }
        }
        throw new AssertionError((Object)String.format("No primitive index label for '%s'", type));
    }

    public static IndexLabel label(HugeGraph graph, Id id) {
        if (id.asLong() < 0L) {
            switch ((int)id.asLong()) {
                case -1: {
                    return VL_IL;
                }
                case -2: {
                    return EL_IL;
                }
                case -3: {
                    return PK_NAME_IL;
                }
                case -4: {
                    return VL_NAME_IL;
                }
                case -5: {
                    return EL_NAME_IL;
                }
                case -6: {
                    return IL_NAME_IL;
                }
            }
            throw new AssertionError((Object)String.format("No primitive index label for '%s'", id));
        }
        return graph.indexLabel(id);
    }

    public static class CreatedIndexLabel {
        private IndexLabel indexLabel;
        private Id task;

        public CreatedIndexLabel(IndexLabel indexLabel, Id task) {
            E.checkNotNull((Object)indexLabel, (String)"index label");
            this.indexLabel = indexLabel;
            this.task = task;
        }

        public void indexLabel(IndexLabel indexLabel) {
            E.checkNotNull((Object)indexLabel, (String)"index label");
            this.indexLabel = indexLabel;
        }

        public IndexLabel indexLabel() {
            return this.indexLabel;
        }

        public void task(Id task) {
            this.task = task;
        }

        public Id task() {
            return this.task;
        }
    }

    public static interface Builder
    extends SchemaBuilder<IndexLabel> {
        public CreatedIndexLabel createWithTask();

        public Id rebuild();

        public Builder onV(String var1);

        public Builder onE(String var1);

        public Builder by(String ... var1);

        public Builder secondary();

        public Builder range();

        public Builder search();

        public Builder on(HugeType var1, String var2);

        public Builder indexType(IndexType var1);
    }
}

