/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.schema;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.exception.NotSupportException;
import com.baidu.hugegraph.schema.SchemaElement;
import com.baidu.hugegraph.schema.builder.SchemaBuilder;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.Propfiable;
import com.baidu.hugegraph.type.define.Cardinality;
import com.baidu.hugegraph.type.define.DataType;
import com.baidu.hugegraph.util.E;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class PropertyKey
extends SchemaElement
implements Propfiable {
    private DataType dataType = DataType.TEXT;
    private Cardinality cardinality = Cardinality.SINGLE;

    public PropertyKey(HugeGraph graph, Id id, String name) {
        super(graph, id, name);
    }

    @Override
    public HugeType type() {
        return HugeType.PROPERTY_KEY;
    }

    public Class<?> clazz() {
        Class cls;
        switch (this.cardinality) {
            case SINGLE: {
                cls = this.dataType().clazz();
                break;
            }
            case SET: {
                cls = LinkedHashSet.class;
                break;
            }
            case LIST: {
                cls = LinkedList.class;
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unsupported cardinality: '%s'", this.cardinality));
            }
        }
        return cls;
    }

    public <V> boolean checkDataType(V value) {
        if (value instanceof Number) {
            return this.dataType().valueToNumber(value) != null;
        }
        return this.dataType().clazz().isInstance(value);
    }

    public <V> boolean checkDataType(Collection<V> values) {
        boolean valid = true;
        for (V o : values) {
            if (this.checkDataType(o)) continue;
            valid = false;
            break;
        }
        return valid;
    }

    public <V> boolean checkValue(V value) {
        boolean valid;
        switch (this.cardinality) {
            case SINGLE: {
                valid = this.checkDataType(value);
                break;
            }
            case SET: {
                valid = value instanceof Set;
                valid = valid && this.checkDataType((Set)value);
                break;
            }
            case LIST: {
                valid = value instanceof List;
                valid = valid && this.checkDataType((List)value);
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unsupported cardinality: '%s'", this.cardinality));
            }
        }
        return valid;
    }

    public <V> V validValue(V value) {
        return this.convValue(value, true);
    }

    public <V, T> V convValue(V value, boolean checkValue) {
        Object validValue;
        if (value == null) {
            return null;
        }
        if (!(value instanceof Collection)) {
            validValue = this.convSingleValue(value);
        } else {
            AbstractCollection validValues;
            if (value instanceof Set) {
                validValues = new HashSet();
            } else {
                E.checkArgument((boolean)(value instanceof List), (String)"Property value must be Single, Set, List, but got %s", (Object[])new Object[]{value});
                validValues = new ArrayList();
            }
            for (Object element : (Collection)value) {
                if ((element = this.convSingleValue(element)) == null) {
                    return null;
                }
                validValues.add(element);
            }
            validValue = validValues;
        }
        if (!checkValue || this.checkValue(validValue)) {
            return validValue;
        }
        return null;
    }

    private <V> V convSingleValue(V value) {
        if (this.dataType().isNumber()) {
            Number number = this.dataType().valueToNumber(value);
            return (V)number;
        }
        if (this.dataType().isDate()) {
            Date date = this.dataType().valueToDate(value);
            return (V)date;
        }
        if (this.dataType().isUUID()) {
            UUID uuid = this.dataType().valueToUUID(value);
            return (V)uuid;
        }
        return value;
    }

    public DataType dataType() {
        return this.dataType;
    }

    public void dataType(DataType dataType) {
        this.dataType = dataType;
    }

    public Cardinality cardinality() {
        return this.cardinality;
    }

    public void cardinality(Cardinality cardinality) {
        this.cardinality = cardinality;
    }

    @Override
    public Set<Id> properties() {
        return Collections.emptySet();
    }

    public PropertyKey properties(Id ... properties) {
        if (properties.length > 0) {
            throw new NotSupportException("PropertyKey.properties(Id)");
        }
        return this;
    }

    public static interface Builder
    extends SchemaBuilder<PropertyKey> {
        public Builder asText();

        public Builder asInt();

        public Builder asDate();

        public Builder asUuid();

        public Builder asBoolean();

        public Builder asByte();

        public Builder asBlob();

        public Builder asDouble();

        public Builder asFloat();

        public Builder asLong();

        public Builder valueSingle();

        public Builder valueList();

        public Builder valueSet();

        public Builder cardinality(Cardinality var1);

        public Builder dataType(DataType var1);

        public Builder userdata(String var1, Object var2);

        public Builder userdata(Map<String, Object> var1);
    }
}

