/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.schema;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.IdGenerator;
import com.baidu.hugegraph.config.CoreOptions;
import com.baidu.hugegraph.config.HugeConfig;
import com.baidu.hugegraph.type.Namifiable;
import com.baidu.hugegraph.type.Typifiable;
import com.baidu.hugegraph.type.define.SchemaStatus;
import com.baidu.hugegraph.util.E;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Graph;

public abstract class SchemaElement
implements Namifiable,
Typifiable {
    protected final HugeGraph graph;
    private final Id id;
    private final String name;
    private final Map<String, Object> userdata;
    private SchemaStatus status;

    public SchemaElement(HugeGraph graph, Id id, String name) {
        E.checkArgumentNotNull((Object)id, (String)"SchemaElement id can't be null", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)name, (String)"SchemaElement name can't be null", (Object[])new Object[0]);
        this.graph = graph;
        this.id = id;
        this.name = name;
        this.userdata = new HashMap<String, Object>();
        this.status = SchemaStatus.CREATED;
    }

    public HugeGraph graph() {
        return this.graph;
    }

    public Id id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    public Map<String, Object> userdata() {
        return Collections.unmodifiableMap(this.userdata);
    }

    public void userdata(String key, Object value) {
        E.checkArgumentNotNull((Object)key, (String)"userdata key", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)value, (String)"userdata value", (Object[])new Object[0]);
        this.userdata.put(key, value);
    }

    public Object removeUserdata(String key) {
        E.checkArgumentNotNull((Object)key, (String)"The userdata key can't be null", (Object[])new Object[0]);
        return this.userdata.remove(key);
    }

    public SchemaStatus status() {
        return this.status;
    }

    public void status(SchemaStatus status) {
        this.status = status;
    }

    public boolean primitive() {
        return false;
    }

    public boolean hidden() {
        return Graph.Hidden.isHidden((String)this.name());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SchemaElement)) {
            return false;
        }
        SchemaElement other = (SchemaElement)obj;
        return this.type() == other.type() && this.id.equals(other.id());
    }

    public int hashCode() {
        return this.type().hashCode() ^ this.id.hashCode();
    }

    public String toString() {
        return String.format("%s(id=%s)", this.name, this.id);
    }

    public static Id schemaId(String id) {
        return IdGenerator.of(Long.parseLong(id));
    }

    public static void checkName(String name, HugeConfig config) {
        char[] filters;
        String illegalReg = (String)config.get(CoreOptions.SCHEMA_ILLEGAL_NAME_REGEX);
        E.checkNotNull((Object)name, (String)"name");
        E.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (String)"The name can't be empty.", (Object[])new Object[0]);
        E.checkArgument((name.length() < 256 ? 1 : 0) != 0, (String)"The length of name must less than 256 bytes.", (Object[])new Object[0]);
        E.checkArgument((!name.matches(illegalReg) ? 1 : 0) != 0, (String)String.format("Illegal schema name '%s'", name), (Object[])new Object[0]);
        for (char c : filters = new char[]{'#', '>', ':', '!'}) {
            E.checkArgument((name.indexOf(c) == -1 ? 1 : 0) != 0, (String)"The name can't contain character '%s'.", (Object[])new Object[]{Character.valueOf(c)});
        }
    }
}

