/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.schema;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.IdGenerator;
import com.baidu.hugegraph.schema.SchemaElement;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.Indexfiable;
import com.baidu.hugegraph.type.Propfiable;
import com.baidu.hugegraph.util.E;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class SchemaLabel
extends SchemaElement
implements Indexfiable,
Propfiable {
    private final Set<Id> properties = new HashSet<Id>();
    private final Set<Id> nullableKeys = new HashSet<Id>();
    private final Set<Id> indexLabels = new HashSet<Id>();
    private boolean enableLabelIndex = true;

    public SchemaLabel(HugeGraph graph, Id id, String name) {
        super(graph, id, name);
    }

    @Override
    public Set<Id> properties() {
        return Collections.unmodifiableSet(this.properties);
    }

    public void properties(Set<Id> properties) {
        this.properties.addAll(properties);
    }

    public SchemaLabel properties(Id ... ids) {
        this.properties.addAll(Arrays.asList(ids));
        return this;
    }

    public void property(Id id) {
        this.properties.add(id);
    }

    public Set<Id> nullableKeys() {
        return Collections.unmodifiableSet(this.nullableKeys);
    }

    public void nullableKey(Id id) {
        this.nullableKeys.add(id);
    }

    public void nullableKeys(Id ... ids) {
        this.nullableKeys.addAll(Arrays.asList(ids));
    }

    public void nullableKeys(Set<Id> nullableKeys) {
        this.nullableKeys.addAll(nullableKeys);
    }

    @Override
    public Set<Id> indexLabels() {
        return Collections.unmodifiableSet(this.indexLabels);
    }

    public void indexLabel(Id id) {
        this.indexLabels.add(id);
    }

    public void indexLabels(Id ... ids) {
        this.indexLabels.addAll(Arrays.asList(ids));
    }

    public void removeIndexLabel(Id id) {
        this.indexLabels.remove(id);
    }

    public boolean enableLabelIndex() {
        return this.enableLabelIndex;
    }

    public void enableLabelIndex(boolean enable) {
        this.enableLabelIndex = enable;
    }

    public static Id getLabelId(HugeGraph graph, HugeType type, Object label) {
        E.checkNotNull((Object)graph, (String)"graph");
        E.checkNotNull((Object)type, (String)"type");
        E.checkNotNull((Object)label, (String)"label");
        if (label instanceof Number) {
            return IdGenerator.of(((Number)label).longValue());
        }
        if (label instanceof String) {
            if (type.isVertex()) {
                return graph.vertexLabel((String)label).id();
            }
            if (type.isEdge()) {
                return graph.edgeLabel((String)label).id();
            }
            throw new HugeException("Not support query from '%s' with label '%s'", type, label);
        }
        throw new HugeException("The label type must be number or string, but got '%s'", label.getClass());
    }
}

