/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.schema;

import com.baidu.hugegraph.backend.tx.SchemaTransaction;
import com.baidu.hugegraph.exception.NotFoundException;
import com.baidu.hugegraph.schema.EdgeLabel;
import com.baidu.hugegraph.schema.IndexLabel;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.schema.VertexLabel;
import com.baidu.hugegraph.schema.builder.EdgeLabelBuilder;
import com.baidu.hugegraph.schema.builder.IndexLabelBuilder;
import com.baidu.hugegraph.schema.builder.PropertyKeyBuilder;
import com.baidu.hugegraph.schema.builder.VertexLabelBuilder;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.util.E;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Graph;

public class SchemaManager {
    private final SchemaTransaction transaction;

    public SchemaManager(SchemaTransaction transaction) {
        E.checkNotNull((Object)transaction, (String)"transaction");
        this.transaction = transaction;
    }

    public PropertyKey.Builder propertyKey(String name) {
        return new PropertyKeyBuilder(name, this.transaction);
    }

    public VertexLabel.Builder vertexLabel(String name) {
        return new VertexLabelBuilder(name, this.transaction);
    }

    public EdgeLabel.Builder edgeLabel(String name) {
        return new EdgeLabelBuilder(name, this.transaction);
    }

    public IndexLabel.Builder indexLabel(String name) {
        return new IndexLabelBuilder(name, this.transaction);
    }

    public PropertyKey getPropertyKey(String name) {
        E.checkArgumentNotNull((Object)name, (String)"The name parameter can't be null", (Object[])new Object[0]);
        PropertyKey propertyKey = this.transaction.getPropertyKey(name);
        SchemaManager.checkExists(HugeType.PROPERTY_KEY, propertyKey, name);
        return propertyKey;
    }

    public VertexLabel getVertexLabel(String name) {
        E.checkArgumentNotNull((Object)name, (String)"The name parameter can't be null", (Object[])new Object[0]);
        VertexLabel vertexLabel = this.transaction.getVertexLabel(name);
        SchemaManager.checkExists(HugeType.VERTEX_LABEL, vertexLabel, name);
        return vertexLabel;
    }

    public EdgeLabel getEdgeLabel(String name) {
        E.checkArgumentNotNull((Object)name, (String)"The name parameter can't be null", (Object[])new Object[0]);
        EdgeLabel edgeLabel = this.transaction.getEdgeLabel(name);
        SchemaManager.checkExists(HugeType.EDGE_LABEL, edgeLabel, name);
        return edgeLabel;
    }

    public IndexLabel getIndexLabel(String name) {
        E.checkArgumentNotNull((Object)name, (String)"The name parameter can't be null", (Object[])new Object[0]);
        IndexLabel indexLabel = this.transaction.getIndexLabel(name);
        SchemaManager.checkExists(HugeType.INDEX_LABEL, indexLabel, name);
        return indexLabel;
    }

    public List<PropertyKey> getPropertyKeys() {
        return this.transaction.getPropertyKeys().stream().filter(pk -> !Graph.Hidden.isHidden((String)pk.name())).collect(Collectors.toList());
    }

    public List<VertexLabel> getVertexLabels() {
        return this.transaction.getVertexLabels().stream().filter(vl -> !Graph.Hidden.isHidden((String)vl.name())).collect(Collectors.toList());
    }

    public List<EdgeLabel> getEdgeLabels() {
        return this.transaction.getEdgeLabels().stream().filter(el -> !Graph.Hidden.isHidden((String)el.name())).collect(Collectors.toList());
    }

    public List<IndexLabel> getIndexLabels() {
        return this.transaction.getIndexLabels().stream().filter(il -> !Graph.Hidden.isHidden((String)il.name())).collect(Collectors.toList());
    }

    private static void checkExists(HugeType type, Object object, String name) {
        if (object == null) {
            throw new NotFoundException("%s with name '%s' does not exist", type, name);
        }
    }
}

