/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.schema.builder;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.IdGenerator;
import com.baidu.hugegraph.backend.tx.SchemaTransaction;
import com.baidu.hugegraph.exception.ExistedException;
import com.baidu.hugegraph.exception.NotAllowException;
import com.baidu.hugegraph.exception.NotFoundException;
import com.baidu.hugegraph.schema.EdgeLabel;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.schema.SchemaElement;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.Action;
import com.baidu.hugegraph.type.define.Frequency;
import com.baidu.hugegraph.util.CollectionUtil;
import com.baidu.hugegraph.util.E;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class EdgeLabelBuilder
implements EdgeLabel.Builder {
    private Id id;
    private String name;
    private String sourceLabel;
    private String targetLabel;
    private Frequency frequency;
    private Set<String> properties;
    private List<String> sortKeys;
    private Set<String> nullableKeys;
    private Boolean enableLabelIndex;
    private Map<String, Object> userdata;
    private boolean checkExist;
    private SchemaTransaction transaction;

    public EdgeLabelBuilder(String name, SchemaTransaction transaction) {
        E.checkNotNull((Object)name, (String)"name");
        E.checkNotNull((Object)transaction, (String)"transaction");
        this.id = null;
        this.name = name;
        this.sourceLabel = null;
        this.targetLabel = null;
        this.frequency = Frequency.DEFAULT;
        this.properties = new HashSet<String>();
        this.sortKeys = new ArrayList<String>();
        this.nullableKeys = new HashSet<String>();
        this.enableLabelIndex = null;
        this.userdata = new HashMap<String, Object>();
        this.checkExist = true;
        this.transaction = transaction;
    }

    @Override
    public EdgeLabel build() {
        PropertyKey propertyKey;
        Id id = this.transaction.validOrGenerateId(HugeType.EDGE_LABEL, this.id, this.name);
        HugeGraph graph = this.transaction.graph();
        EdgeLabel edgeLabel = new EdgeLabel(graph, id, this.name);
        edgeLabel.sourceLabel(this.transaction.getVertexLabel(this.sourceLabel).id());
        edgeLabel.targetLabel(this.transaction.getVertexLabel(this.targetLabel).id());
        edgeLabel.frequency(this.frequency);
        edgeLabel.enableLabelIndex(this.enableLabelIndex == null || this.enableLabelIndex != false);
        for (String string : this.properties) {
            propertyKey = this.transaction.getPropertyKey(string);
            edgeLabel.property(propertyKey.id());
        }
        for (String string : this.sortKeys) {
            propertyKey = this.transaction.getPropertyKey(string);
            edgeLabel.sortKey(propertyKey.id());
        }
        for (String string : this.nullableKeys) {
            propertyKey = this.transaction.getPropertyKey(string);
            edgeLabel.nullableKey(propertyKey.id());
        }
        for (Map.Entry entry : this.userdata.entrySet()) {
            edgeLabel.userdata((String)entry.getKey(), entry.getValue());
        }
        return edgeLabel;
    }

    @Override
    public EdgeLabel create() {
        SchemaTransaction tx = this.transaction;
        SchemaElement.checkName(this.name, tx.graph().configuration());
        EdgeLabel edgeLabel = tx.getEdgeLabel(this.name);
        if (edgeLabel != null) {
            if (this.checkExist) {
                throw new ExistedException("edge label", (Object)this.name);
            }
            return edgeLabel;
        }
        tx.checkIdIfRestoringMode(HugeType.EDGE_LABEL, this.id);
        if (this.frequency == Frequency.DEFAULT) {
            this.frequency = Frequency.SINGLE;
        }
        this.checkRelation();
        this.checkProperties(Action.INSERT);
        this.checkSortKeys();
        this.checkNullableKeys(Action.INSERT);
        this.checkUserdata(Action.INSERT);
        edgeLabel = this.build();
        tx.addEdgeLabel(edgeLabel);
        return edgeLabel;
    }

    @Override
    public EdgeLabel append() {
        PropertyKey propertyKey;
        EdgeLabel edgeLabel = this.transaction.getEdgeLabel(this.name);
        if (edgeLabel == null) {
            throw new NotFoundException("Can't update edge label '%s' since it doesn't exist", this.name);
        }
        this.checkStableVars();
        this.checkProperties(Action.APPEND);
        this.checkNullableKeys(Action.APPEND);
        this.checkUserdata(Action.APPEND);
        for (String string : this.properties) {
            propertyKey = this.transaction.getPropertyKey(string);
            edgeLabel.property(propertyKey.id());
        }
        for (String string : this.nullableKeys) {
            propertyKey = this.transaction.getPropertyKey(string);
            edgeLabel.nullableKey(propertyKey.id());
        }
        for (Map.Entry entry : this.userdata.entrySet()) {
            edgeLabel.userdata((String)entry.getKey(), entry.getValue());
        }
        this.transaction.addEdgeLabel(edgeLabel);
        return edgeLabel;
    }

    @Override
    public EdgeLabel eliminate() {
        EdgeLabel edgeLabel = this.transaction.getEdgeLabel(this.name);
        if (edgeLabel == null) {
            throw new NotFoundException("Can't update edge label '%s' since it doesn't exist", this.name);
        }
        this.checkStableVars();
        this.checkProperties(Action.ELIMINATE);
        this.checkNullableKeys(Action.ELIMINATE);
        this.checkUserdata(Action.ELIMINATE);
        for (String key : this.userdata.keySet()) {
            edgeLabel.removeUserdata(key);
        }
        this.transaction.addEdgeLabel(edgeLabel);
        return edgeLabel;
    }

    @Override
    public Id remove() {
        EdgeLabel edgeLabel = this.transaction.getEdgeLabel(this.name);
        if (edgeLabel == null) {
            return null;
        }
        return this.transaction.removeEdgeLabel(edgeLabel.id());
    }

    @Override
    public Id rebuildIndex() {
        EdgeLabel edgeLabel = this.transaction.graph().edgeLabel(this.name);
        if (edgeLabel == null) {
            return null;
        }
        return this.transaction.rebuildIndex(edgeLabel);
    }

    public EdgeLabelBuilder id(long id) {
        E.checkArgument((id != 0L ? 1 : 0) != 0, (String)"Not allowed to assign 0 as edge label id", (Object[])new Object[0]);
        this.id = IdGenerator.of(id);
        return this;
    }

    @Override
    public EdgeLabelBuilder properties(String ... properties) {
        this.properties.addAll(Arrays.asList(properties));
        return this;
    }

    @Override
    public EdgeLabelBuilder nullableKeys(String ... keys) {
        this.nullableKeys.addAll(Arrays.asList(keys));
        return this;
    }

    @Override
    public EdgeLabelBuilder sortKeys(String ... keys) {
        if (keys.length == 0) {
            return this;
        }
        E.checkArgument((boolean)this.sortKeys.isEmpty(), (String)"Not allowed to assign sort keys multitimes", (Object[])new Object[0]);
        List<String> sortKeys = Arrays.asList(keys);
        E.checkArgument((boolean)CollectionUtil.allUnique(sortKeys), (String)"Invalid sort keys %s, which contains some duplicate properties", (Object[])new Object[]{sortKeys});
        this.sortKeys.addAll(sortKeys);
        return this;
    }

    @Override
    public EdgeLabelBuilder link(String sourceLabel, String targetLabel) {
        this.sourceLabel(sourceLabel);
        this.targetLabel(targetLabel);
        return this;
    }

    @Override
    public EdgeLabelBuilder sourceLabel(String label) {
        this.sourceLabel = label;
        return this;
    }

    @Override
    public EdgeLabelBuilder targetLabel(String label) {
        this.targetLabel = label;
        return this;
    }

    @Override
    public EdgeLabelBuilder singleTime() {
        this.frequency = Frequency.SINGLE;
        return this;
    }

    @Override
    public EdgeLabelBuilder multiTimes() {
        this.frequency = Frequency.MULTIPLE;
        return this;
    }

    public EdgeLabelBuilder ifNotExist() {
        this.checkExist = false;
        return this;
    }

    @Override
    public EdgeLabelBuilder frequency(Frequency frequency) {
        this.frequency = frequency;
        return this;
    }

    @Override
    public EdgeLabelBuilder enableLabelIndex(boolean enable) {
        this.enableLabelIndex = enable;
        return this;
    }

    @Override
    public EdgeLabelBuilder userdata(String key, Object value) {
        this.userdata.put(key, value);
        return this;
    }

    @Override
    public EdgeLabelBuilder userdata(Map<String, Object> userdata) {
        this.userdata.putAll(userdata);
        return this;
    }

    public EdgeLabelBuilder checkExist(boolean checkExist) {
        this.checkExist = checkExist;
        return this;
    }

    private void checkProperties(Action action) {
        switch (action) {
            case INSERT: 
            case APPEND: {
                for (String key : this.properties) {
                    PropertyKey pkey = this.transaction.getPropertyKey(key);
                    E.checkArgumentNotNull((Object)pkey, (String)"Undefined property key '%s'", (Object[])new Object[]{key});
                }
                break;
            }
            case ELIMINATE: {
                if (this.properties.isEmpty()) break;
                throw new NotAllowException("Not support to eliminate properties for edge label currently");
            }
            case DELETE: {
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unknown schema action '%s'", new Object[]{action}));
            }
        }
    }

    private void checkNullableKeys(Action action) {
        if (action == Action.ELIMINATE) {
            if (!this.nullableKeys.isEmpty()) {
                throw new NotAllowException("Not support to eliminate nullableKeys for edge label currently");
            }
            return;
        }
        EdgeLabel edgeLabel = this.transaction.getEdgeLabel(this.name);
        ImmutableList originProps = edgeLabel == null ? ImmutableList.of() : this.transaction.graph().mapPkId2Name(edgeLabel.properties());
        Set<String> appendProps = this.properties;
        E.checkArgument((boolean)CollectionUtil.union((Collection)originProps, appendProps).containsAll(this.nullableKeys), (String)"The nullableKeys: %s to be created or appended must belong to the origin/new properties: %s/%s ", (Object[])new Object[]{this.nullableKeys, originProps, appendProps});
        E.checkArgument((!CollectionUtil.hasIntersection(this.sortKeys, this.nullableKeys) ? 1 : 0) != 0, (String)"The nullableKeys: %s are not allowed to belong to sortKeys: %s of edge label '%s'", (Object[])new Object[]{this.nullableKeys, this.sortKeys, this.name});
        if (action == Action.APPEND) {
            Collection newAddedProps = CollectionUtils.subtract(appendProps, (Collection)originProps);
            E.checkArgument((boolean)this.nullableKeys.containsAll(newAddedProps), (String)"The new added properties: %s must be nullable", (Object[])new Object[]{newAddedProps});
        }
    }

    private void checkSortKeys() {
        if (this.frequency == Frequency.SINGLE) {
            E.checkArgument((boolean)this.sortKeys.isEmpty(), (String)"EdgeLabel can't contain sortKeys when the cardinality property is single", (Object[])new Object[0]);
        } else {
            E.checkState((this.sortKeys != null ? 1 : 0) != 0, (String)"The sortKeys can't be null when the cardinality property is multiple", (Object[])new Object[0]);
            E.checkArgument((!this.sortKeys.isEmpty() ? 1 : 0) != 0, (String)"EdgeLabel must contain sortKeys when the cardinality property is multiple", (Object[])new Object[0]);
        }
        if (this.sortKeys.isEmpty()) {
            return;
        }
        E.checkArgument((!this.properties.isEmpty() ? 1 : 0) != 0, (String)"The properties can't be empty when exist sort keys for edge label '%s'", (Object[])new Object[]{this.name});
        for (String key : this.sortKeys) {
            E.checkArgument((boolean)this.properties.contains(key), (String)"The sort key '%s' must be contained in properties '%s' for edge label '%s'", (Object[])new Object[]{key, this.name, this.properties});
        }
    }

    private void checkRelation() {
        String srcLabel = this.sourceLabel;
        String tgtLabel = this.targetLabel;
        E.checkArgument((srcLabel != null && tgtLabel != null ? 1 : 0) != 0, (String)"Must set source and target label for edge label '%s'", (Object[])new Object[]{this.name});
        E.checkArgumentNotNull((Object)this.transaction.getVertexLabel(srcLabel), (String)"Undefined source vertex label '%s' in edge label '%s'", (Object[])new Object[]{srcLabel, this.name});
        E.checkArgumentNotNull((Object)this.transaction.getVertexLabel(tgtLabel), (String)"Undefined target vertex label '%s' in edge label '%s'", (Object[])new Object[]{tgtLabel, this.name});
    }

    private void checkStableVars() {
        if (this.sourceLabel != null) {
            throw new NotAllowException("Not allowed to update source label for edge label '%s', it must be null", this.name);
        }
        if (this.targetLabel != null) {
            throw new NotAllowException("Not allowed to update target label for edge label '%s', it must be null", this.name);
        }
        if (this.frequency != Frequency.DEFAULT) {
            throw new NotAllowException("Not allowed to update frequency for edge label '%s'", this.name);
        }
        if (!this.sortKeys.isEmpty()) {
            throw new NotAllowException("Not allowed to update sort keys for edge label '%s'", this.name);
        }
        if (this.enableLabelIndex != null) {
            throw new NotAllowException("Not allowed to update enable_label_index for edge label '%s'", this.name);
        }
    }

    private void checkUserdata(Action action) {
        switch (action) {
            case INSERT: 
            case APPEND: {
                for (Map.Entry<String, Object> e : this.userdata.entrySet()) {
                    if (e.getValue() != null) continue;
                    throw new NotAllowException("Not allowed pass null userdata value when create or append edge label");
                }
                break;
            }
            case ELIMINATE: 
            case DELETE: {
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unknown schema action '%s'", new Object[]{action}));
            }
        }
    }
}

