/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.schema.builder;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.IdGenerator;
import com.baidu.hugegraph.backend.tx.SchemaTransaction;
import com.baidu.hugegraph.config.CoreOptions;
import com.baidu.hugegraph.exception.ExistedException;
import com.baidu.hugegraph.exception.NotSupportException;
import com.baidu.hugegraph.schema.IndexLabel;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.schema.SchemaElement;
import com.baidu.hugegraph.schema.SchemaLabel;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.Cardinality;
import com.baidu.hugegraph.type.define.DataType;
import com.baidu.hugegraph.type.define.IndexType;
import com.baidu.hugegraph.type.define.SchemaStatus;
import com.baidu.hugegraph.util.CollectionUtil;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.InsertionOrderUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;

public class IndexLabelBuilder
implements IndexLabel.Builder {
    private Id id;
    private String name;
    private HugeType baseType;
    private String baseValue;
    private IndexType indexType;
    private List<String> indexFields;
    private boolean checkExist;
    private SchemaTransaction transaction;

    public IndexLabelBuilder(String name, SchemaTransaction transaction) {
        E.checkNotNull((Object)name, (String)"name");
        E.checkNotNull((Object)transaction, (String)"transaction");
        this.id = null;
        this.name = name;
        this.indexType = IndexType.SECONDARY;
        this.indexFields = new ArrayList<String>();
        this.checkExist = true;
        this.transaction = transaction;
    }

    @Override
    public IndexLabel build() {
        Id id = this.transaction.validOrGenerateId(HugeType.INDEX_LABEL, this.id, this.name);
        HugeGraph graph = this.transaction.graph();
        IndexLabel indexLabel = new IndexLabel(graph, id, this.name);
        indexLabel.baseType(this.baseType);
        SchemaLabel schemaLabel = this.loadElement();
        indexLabel.baseValue(schemaLabel.id());
        indexLabel.indexType(this.indexType);
        for (String field : this.indexFields) {
            PropertyKey propertyKey = this.transaction.getPropertyKey(field);
            indexLabel.indexField(propertyKey.id());
        }
        return indexLabel;
    }

    @Override
    public IndexLabel.CreatedIndexLabel createWithTask() {
        SchemaTransaction tx = this.transaction;
        SchemaElement.checkName(this.name, tx.graph().configuration());
        IndexLabel indexLabel = tx.getIndexLabel(this.name);
        if (indexLabel != null) {
            if (this.checkExist) {
                throw new ExistedException("index label", (Object)this.name);
            }
            return new IndexLabel.CreatedIndexLabel(indexLabel, null);
        }
        tx.checkIdIfRestoringMode(HugeType.INDEX_LABEL, this.id);
        SchemaLabel schemaLabel = this.loadElement();
        this.checkFields(schemaLabel.properties());
        this.checkRepeatIndex(schemaLabel);
        Set<Id> removeTasks = this.removeSubIndex(schemaLabel);
        indexLabel = this.build();
        indexLabel.status(SchemaStatus.CREATING);
        tx.addIndexLabel(schemaLabel, indexLabel);
        Id rebuildTask = tx.rebuildIndex(indexLabel, removeTasks);
        E.checkNotNull((Object)rebuildTask, (String)"rebuild-index task");
        return new IndexLabel.CreatedIndexLabel(indexLabel, rebuildTask);
    }

    @Override
    public IndexLabel create() {
        IndexLabel.CreatedIndexLabel createdIndexLabel = this.createWithTask();
        Id task = createdIndexLabel.task();
        if (task == null) {
            return createdIndexLabel.indexLabel();
        }
        HugeGraph graph = this.transaction.graph();
        long timeout = (Long)graph.configuration().get(CoreOptions.TASK_WAIT_TIMEOUT);
        try {
            graph.taskScheduler().waitUntilTaskCompleted(task, timeout);
        }
        catch (TimeoutException e) {
            throw new HugeException("Failed to wait index-creating task completed", e);
        }
        return createdIndexLabel.indexLabel();
    }

    @Override
    public IndexLabel append() {
        throw new NotSupportException("action append on index label");
    }

    @Override
    public IndexLabel eliminate() {
        throw new NotSupportException("action eliminate on index label");
    }

    @Override
    public Id remove() {
        IndexLabel indexLabel = this.transaction.getIndexLabel(this.name);
        if (indexLabel == null) {
            return null;
        }
        return this.transaction.removeIndexLabel(indexLabel.id());
    }

    @Override
    public Id rebuild() {
        IndexLabel indexLabel = this.transaction.graph().indexLabel(this.name);
        if (indexLabel == null) {
            return null;
        }
        return this.transaction.rebuildIndex(indexLabel);
    }

    public IndexLabelBuilder id(long id) {
        E.checkArgument((id != 0L ? 1 : 0) != 0, (String)"Not allowed to assign 0 as index label id", (Object[])new Object[0]);
        this.id = IdGenerator.of(id);
        return this;
    }

    @Override
    public IndexLabelBuilder onV(String baseValue) {
        this.baseType = HugeType.VERTEX_LABEL;
        this.baseValue = baseValue;
        return this;
    }

    @Override
    public IndexLabelBuilder onE(String baseValue) {
        this.baseType = HugeType.EDGE_LABEL;
        this.baseValue = baseValue;
        return this;
    }

    @Override
    public IndexLabelBuilder by(String ... fields) {
        E.checkArgument((fields.length > 0 ? 1 : 0) != 0, (String)"Empty index fields", (Object[])new Object[0]);
        E.checkArgument((boolean)this.indexFields.isEmpty(), (String)"Not allowed to assign index fields multitimes", (Object[])new Object[0]);
        List<String> indexFields = Arrays.asList(fields);
        E.checkArgument((boolean)CollectionUtil.allUnique(indexFields), (String)"Invalid index fields %s, which contains some duplicate properties", (Object[])new Object[]{indexFields});
        this.indexFields.addAll(indexFields);
        return this;
    }

    @Override
    public IndexLabelBuilder secondary() {
        this.indexType = IndexType.SECONDARY;
        return this;
    }

    @Override
    public IndexLabelBuilder range() {
        this.indexType = IndexType.RANGE;
        return this;
    }

    @Override
    public IndexLabelBuilder search() {
        this.indexType = IndexType.SEARCH;
        return this;
    }

    @Override
    public IndexLabelBuilder on(HugeType baseType, String baseValue) {
        E.checkArgument((baseType == HugeType.VERTEX_LABEL || baseType == HugeType.EDGE_LABEL ? 1 : 0) != 0, (String)"The base type of index label '%s' can only be either VERTEX_LABEL or EDGE_LABEL", (Object[])new Object[]{this.name});
        if (baseType == HugeType.VERTEX_LABEL) {
            this.onV(baseValue);
        } else {
            assert (baseType == HugeType.EDGE_LABEL);
            this.onE(baseValue);
        }
        return this;
    }

    @Override
    public IndexLabelBuilder indexType(IndexType indexType) {
        this.indexType = indexType;
        return this;
    }

    public IndexLabelBuilder ifNotExist() {
        this.checkExist = false;
        return this;
    }

    public IndexLabelBuilder checkExist(boolean checkExist) {
        this.checkExist = checkExist;
        return this;
    }

    private SchemaLabel loadElement() {
        SchemaLabel schemaLabel;
        E.checkNotNull((Object)this.baseType, (String)"base type", (String)"index label");
        E.checkNotNull((Object)this.baseValue, (String)"base value", (String)"index label");
        switch (this.baseType) {
            case VERTEX_LABEL: {
                schemaLabel = this.transaction.getVertexLabel(this.baseValue);
                break;
            }
            case EDGE_LABEL: {
                schemaLabel = this.transaction.getEdgeLabel(this.baseValue);
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unsupported base type '%s' of index label '%s'", this.baseType, this.name));
            }
        }
        E.checkArgumentNotNull((Object)schemaLabel, (String)"Can't find the %s with name '%s'", (Object[])new Object[]{this.baseType, this.baseValue});
        return schemaLabel;
    }

    private void checkFields(Set<Id> propertyIds) {
        DataType dataType;
        String field2;
        List<String> fields = this.indexFields;
        E.checkNotEmpty(fields, (String)"index fields", (String)this.name);
        for (String field2 : fields) {
            PropertyKey pkey = this.transaction.getPropertyKey(field2);
            E.checkArgumentNotNull((Object)pkey, (String)"Can't build index on undefined property key '%s' for '%s': '%s'", (Object[])new Object[]{field2, this.baseType, this.baseValue});
            E.checkArgument((pkey.cardinality() == Cardinality.SINGLE ? 1 : 0) != 0, (String)"Not allowed to build index on property key '%s' whose cardinality is list or set", (Object[])new Object[]{pkey.name()});
        }
        List<String> properties = this.transaction.graph().mapPkId2Name(propertyIds);
        E.checkArgument((boolean)properties.containsAll(fields), (String)"Not all index fields '%s' are contained in schema properties '%s'", (Object[])new Object[]{fields, properties});
        if (this.indexType == IndexType.RANGE) {
            E.checkArgument((fields.size() == 1 ? 1 : 0) != 0, (String)"Range index can only build on one field, but got %s fields: '%s'", (Object[])new Object[]{fields.size(), fields});
            field2 = fields.iterator().next();
            dataType = this.transaction.getPropertyKey(field2).dataType();
            E.checkArgument((dataType.isNumber() || dataType.isDate() ? 1 : 0) != 0, (String)"Range index can only build on numeric or date property, but got %s(%s)", (Object[])new Object[]{dataType, field2});
        }
        if (this.indexType == IndexType.SEARCH) {
            E.checkArgument((fields.size() == 1 ? 1 : 0) != 0, (String)"Search index can only build on one field, but got %s fields: '%s'", (Object[])new Object[]{fields.size(), fields});
            field2 = fields.iterator().next();
            dataType = this.transaction.getPropertyKey(field2).dataType();
            E.checkArgument((boolean)dataType.isText(), (String)"Search index can only build on text property, but got %s(%s)", (Object[])new Object[]{dataType, field2});
        }
    }

    private void checkRepeatIndex(SchemaLabel schemaLabel) {
        for (Id id : schemaLabel.indexLabels()) {
            IndexLabel old = this.transaction.getIndexLabel(id);
            if (this.indexType != old.indexType()) continue;
            List<String> newFields = this.indexFields;
            List<String> oldFields = this.transaction.graph().mapPkId2Name(old.indexFields());
            E.checkArgument((!CollectionUtil.prefixOf(newFields, oldFields) ? 1 : 0) != 0, (String)"Fields %s of new index label '%s' is prefix of fields %s of existed index label '%s'", (Object[])new Object[]{newFields, this.name, oldFields, old.name()});
        }
    }

    private Set<Id> removeSubIndex(SchemaLabel schemaLabel) {
        Set overrideIndexLabelIds = InsertionOrderUtil.newSet();
        for (Id id : schemaLabel.indexLabels()) {
            List<String> newFields;
            List<String> oldFields;
            IndexLabel old = this.transaction.getIndexLabel(id);
            if (this.indexType != old.indexType() || !CollectionUtil.prefixOf(oldFields = this.transaction.graph().mapPkId2Name(old.indexFields()), newFields = this.indexFields)) continue;
            overrideIndexLabelIds.add(id);
        }
        Set tasks = InsertionOrderUtil.newSet();
        for (Id id : overrideIndexLabelIds) {
            schemaLabel.removeIndexLabel(id);
            Id task = this.transaction.removeIndexLabel(id);
            E.checkNotNull((Object)task, (String)"remove sub index label task");
            tasks.add(task);
        }
        return tasks;
    }
}

