/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.schema.builder;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.IdGenerator;
import com.baidu.hugegraph.backend.tx.SchemaTransaction;
import com.baidu.hugegraph.exception.ExistedException;
import com.baidu.hugegraph.exception.NotAllowException;
import com.baidu.hugegraph.exception.NotFoundException;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.schema.SchemaElement;
import com.baidu.hugegraph.schema.VertexLabel;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.Action;
import com.baidu.hugegraph.type.define.IdStrategy;
import com.baidu.hugegraph.util.CollectionUtil;
import com.baidu.hugegraph.util.E;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class VertexLabelBuilder
implements VertexLabel.Builder {
    private Id id;
    private String name;
    private IdStrategy idStrategy;
    private Set<String> properties;
    private List<String> primaryKeys;
    private Set<String> nullableKeys;
    private Boolean enableLabelIndex;
    private Map<String, Object> userdata;
    private boolean checkExist;
    private SchemaTransaction transaction;

    public VertexLabelBuilder(String name, SchemaTransaction transaction) {
        E.checkNotNull((Object)name, (String)"name");
        E.checkNotNull((Object)transaction, (String)"transaction");
        this.id = null;
        this.name = name;
        this.idStrategy = IdStrategy.DEFAULT;
        this.properties = new HashSet<String>();
        this.primaryKeys = new ArrayList<String>();
        this.nullableKeys = new HashSet<String>();
        this.enableLabelIndex = null;
        this.userdata = new HashMap<String, Object>();
        this.checkExist = true;
        this.transaction = transaction;
    }

    @Override
    public VertexLabel build() {
        PropertyKey propertyKey;
        Id id = this.transaction.validOrGenerateId(HugeType.VERTEX_LABEL, this.id, this.name);
        HugeGraph graph = this.transaction.graph();
        VertexLabel vertexLabel = new VertexLabel(graph, id, this.name);
        vertexLabel.idStrategy(this.idStrategy);
        vertexLabel.enableLabelIndex(this.enableLabelIndex == null || this.enableLabelIndex != false);
        for (String string : this.properties) {
            propertyKey = this.transaction.getPropertyKey(string);
            vertexLabel.property(propertyKey.id());
        }
        for (String string : this.primaryKeys) {
            propertyKey = this.transaction.getPropertyKey(string);
            vertexLabel.primaryKey(propertyKey.id());
        }
        for (String string : this.nullableKeys) {
            propertyKey = this.transaction.getPropertyKey(string);
            vertexLabel.nullableKey(propertyKey.id());
        }
        for (Map.Entry entry : this.userdata.entrySet()) {
            vertexLabel.userdata((String)entry.getKey(), entry.getValue());
        }
        return vertexLabel;
    }

    @Override
    public VertexLabel create() {
        SchemaTransaction tx = this.transaction;
        SchemaElement.checkName(this.name, tx.graph().configuration());
        VertexLabel vertexLabel = tx.getVertexLabel(this.name);
        if (vertexLabel != null) {
            if (this.checkExist) {
                throw new ExistedException("vertex label", (Object)this.name);
            }
            return vertexLabel;
        }
        tx.checkIdIfRestoringMode(HugeType.VERTEX_LABEL, this.id);
        this.checkProperties(Action.INSERT);
        this.checkIdStrategy();
        this.checkNullableKeys(Action.INSERT);
        this.checkUserdata(Action.INSERT);
        vertexLabel = this.build();
        tx.addVertexLabel(vertexLabel);
        return vertexLabel;
    }

    @Override
    public VertexLabel append() {
        PropertyKey propertyKey;
        VertexLabel vertexLabel = this.transaction.getVertexLabel(this.name);
        if (vertexLabel == null) {
            throw new NotFoundException("Can't update vertex label '%s' since it doesn't exist", this.name);
        }
        this.checkStableVars();
        this.checkProperties(Action.APPEND);
        this.checkNullableKeys(Action.APPEND);
        this.checkUserdata(Action.APPEND);
        for (String string : this.properties) {
            propertyKey = this.transaction.getPropertyKey(string);
            vertexLabel.property(propertyKey.id());
        }
        for (String string : this.nullableKeys) {
            propertyKey = this.transaction.getPropertyKey(string);
            vertexLabel.nullableKey(propertyKey.id());
        }
        for (Map.Entry entry : this.userdata.entrySet()) {
            vertexLabel.userdata((String)entry.getKey(), entry.getValue());
        }
        this.transaction.addVertexLabel(vertexLabel);
        return vertexLabel;
    }

    @Override
    public VertexLabel eliminate() {
        VertexLabel vertexLabel = this.transaction.getVertexLabel(this.name);
        if (vertexLabel == null) {
            throw new NotFoundException("Can't update vertex label '%s' since it doesn't exist", this.name);
        }
        this.checkStableVars();
        this.checkProperties(Action.ELIMINATE);
        this.checkNullableKeys(Action.ELIMINATE);
        this.checkUserdata(Action.ELIMINATE);
        for (String key : this.userdata.keySet()) {
            vertexLabel.removeUserdata(key);
        }
        this.transaction.addVertexLabel(vertexLabel);
        return vertexLabel;
    }

    @Override
    public Id remove() {
        VertexLabel vertexLabel = this.transaction.getVertexLabel(this.name);
        if (vertexLabel == null) {
            return null;
        }
        return this.transaction.removeVertexLabel(vertexLabel.id());
    }

    @Override
    public Id rebuildIndex() {
        VertexLabel vertexLabel = this.transaction.graph().vertexLabel(this.name);
        if (vertexLabel == null) {
            return null;
        }
        return this.transaction.rebuildIndex(vertexLabel);
    }

    public VertexLabelBuilder id(long id) {
        E.checkArgument((id != 0L ? 1 : 0) != 0, (String)"Not allowed to assign 0 as vertex label id", (Object[])new Object[0]);
        this.id = IdGenerator.of(id);
        return this;
    }

    @Override
    public VertexLabelBuilder idStrategy(IdStrategy idStrategy) {
        E.checkArgument((this.idStrategy == IdStrategy.DEFAULT || this.idStrategy == idStrategy ? 1 : 0) != 0, (String)"Not allowed to change id strategy for vertex label '%s'", (Object[])new Object[]{this.name});
        this.idStrategy = idStrategy;
        return this;
    }

    @Override
    public VertexLabelBuilder useAutomaticId() {
        E.checkArgument((this.idStrategy == IdStrategy.DEFAULT || this.idStrategy == IdStrategy.AUTOMATIC ? 1 : 0) != 0, (String)"Not allowed to change id strategy for vertex label '%s'", (Object[])new Object[]{this.name});
        this.idStrategy = IdStrategy.AUTOMATIC;
        return this;
    }

    @Override
    public VertexLabelBuilder usePrimaryKeyId() {
        E.checkArgument((this.idStrategy == IdStrategy.DEFAULT || this.idStrategy == IdStrategy.PRIMARY_KEY ? 1 : 0) != 0, (String)"Not allowed to change id strategy for vertex label '%s'", (Object[])new Object[]{this.name});
        this.idStrategy = IdStrategy.PRIMARY_KEY;
        return this;
    }

    @Override
    public VertexLabelBuilder useCustomizeStringId() {
        E.checkArgument((this.idStrategy == IdStrategy.DEFAULT || this.idStrategy == IdStrategy.CUSTOMIZE_STRING ? 1 : 0) != 0, (String)"Not allowed to change id strategy for vertex label '%s'", (Object[])new Object[]{this.name});
        this.idStrategy = IdStrategy.CUSTOMIZE_STRING;
        return this;
    }

    @Override
    public VertexLabelBuilder useCustomizeNumberId() {
        E.checkArgument((this.idStrategy == IdStrategy.DEFAULT || this.idStrategy == IdStrategy.CUSTOMIZE_NUMBER ? 1 : 0) != 0, (String)"Not allowed to change id strategy for vertex label '%s'", (Object[])new Object[]{this.name});
        this.idStrategy = IdStrategy.CUSTOMIZE_NUMBER;
        return this;
    }

    @Override
    public VertexLabelBuilder properties(String ... properties) {
        this.properties.addAll(Arrays.asList(properties));
        return this;
    }

    @Override
    public VertexLabelBuilder primaryKeys(String ... keys) {
        if (keys.length == 0) {
            return this;
        }
        E.checkArgument((boolean)this.primaryKeys.isEmpty(), (String)"Not allowed to assign primary keys multitimes", (Object[])new Object[0]);
        List<String> primaryKeys = Arrays.asList(keys);
        E.checkArgument((boolean)CollectionUtil.allUnique(primaryKeys), (String)"Invalid primary keys %s, which contains some duplicate properties", (Object[])new Object[]{primaryKeys});
        this.primaryKeys.addAll(primaryKeys);
        return this;
    }

    @Override
    public VertexLabelBuilder nullableKeys(String ... keys) {
        this.nullableKeys.addAll(Arrays.asList(keys));
        return this;
    }

    @Override
    public VertexLabelBuilder enableLabelIndex(boolean enable) {
        this.enableLabelIndex = enable;
        return this;
    }

    @Override
    public VertexLabelBuilder userdata(String key, Object value) {
        this.userdata.put(key, value);
        return this;
    }

    @Override
    public VertexLabelBuilder userdata(Map<String, Object> userdata) {
        this.userdata.putAll(userdata);
        return this;
    }

    public VertexLabelBuilder ifNotExist() {
        this.checkExist = false;
        return this;
    }

    public VertexLabelBuilder checkExist(boolean checkExist) {
        this.checkExist = checkExist;
        return this;
    }

    private void checkProperties(Action action) {
        switch (action) {
            case INSERT: 
            case APPEND: {
                for (String key : this.properties) {
                    PropertyKey pkey = this.transaction.getPropertyKey(key);
                    E.checkArgumentNotNull((Object)pkey, (String)"Undefined property key '%s'", (Object[])new Object[]{key});
                }
                break;
            }
            case ELIMINATE: {
                if (this.properties.isEmpty()) break;
                throw new NotAllowException("Not support to eliminate properties for vertex label currently");
            }
            case DELETE: {
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unknown schema action '%s'", new Object[]{action}));
            }
        }
    }

    private void checkNullableKeys(Action action) {
        if (action == Action.ELIMINATE) {
            if (!this.nullableKeys.isEmpty()) {
                throw new NotAllowException("Not support to eliminate nullableKeys for vertex label currently");
            }
            return;
        }
        VertexLabel vertexLabel = this.transaction.getVertexLabel(this.name);
        ImmutableList originProps = vertexLabel == null ? ImmutableList.of() : this.transaction.graph().mapPkId2Name(vertexLabel.properties());
        Set<String> appendProps = this.properties;
        E.checkArgument((boolean)CollectionUtil.union((Collection)originProps, appendProps).containsAll(this.nullableKeys), (String)"The nullableKeys: %s to be created or appended must belong to the origin/new properties: %s/%s", (Object[])new Object[]{this.nullableKeys, originProps, appendProps});
        E.checkArgument((!CollectionUtil.hasIntersection(this.primaryKeys, this.nullableKeys) ? 1 : 0) != 0, (String)"The nullableKeys: %s are not allowed to belong to primaryKeys: %s of vertex label '%s'", (Object[])new Object[]{this.nullableKeys, this.primaryKeys, this.name});
        if (action == Action.APPEND) {
            Collection newAddedProps = CollectionUtils.subtract(appendProps, (Collection)originProps);
            E.checkArgument((boolean)this.nullableKeys.containsAll(newAddedProps), (String)"The new added properties: %s must be nullable", (Object[])new Object[]{newAddedProps});
        }
    }

    private void checkIdStrategy() {
        IdStrategy strategy = this.idStrategy;
        boolean hasPrimaryKey = this.primaryKeys.size() > 0;
        switch (strategy) {
            case DEFAULT: {
                if (hasPrimaryKey) {
                    this.idStrategy = IdStrategy.PRIMARY_KEY;
                    break;
                }
                this.idStrategy = IdStrategy.AUTOMATIC;
                break;
            }
            case AUTOMATIC: 
            case CUSTOMIZE_STRING: 
            case CUSTOMIZE_NUMBER: {
                E.checkArgument((!hasPrimaryKey ? 1 : 0) != 0, (String)"Not allowed to assign primary keys when using '%s' id strategy", (Object[])new Object[]{strategy});
                break;
            }
            case PRIMARY_KEY: {
                E.checkArgument((boolean)hasPrimaryKey, (String)"Must assign some primary keys when using '%s' id strategy", (Object[])new Object[]{strategy});
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unknown id strategy '%s'", strategy));
            }
        }
        if (this.idStrategy == IdStrategy.PRIMARY_KEY) {
            this.checkPrimaryKeys();
        }
    }

    private void checkPrimaryKeys() {
        E.checkArgument((this.idStrategy == IdStrategy.DEFAULT || this.idStrategy == IdStrategy.PRIMARY_KEY ? 1 : 0) != 0, (String)"Not allowed to use id strategy '%s' and assign primary keys at the same time for vertex label '%s'", (Object[])new Object[]{this.idStrategy, this.name});
        E.checkArgument((!this.properties.isEmpty() ? 1 : 0) != 0, (String)"The properties of vertex label '%s' can't be empty when id strategy is '%s'", (Object[])new Object[]{this.name, IdStrategy.PRIMARY_KEY});
        E.checkNotEmpty(this.primaryKeys, (String)"primary keys", (String)this.name);
        for (String key : this.primaryKeys) {
            E.checkArgument((boolean)this.properties.contains(key), (String)"The primary key '%s' of vertex label '%s' must be contained in properties: %s", (Object[])new Object[]{key, this.name, this.properties});
        }
    }

    private void checkStableVars() {
        if (!this.primaryKeys.isEmpty()) {
            throw new NotAllowException("Not allowed to update primary keys for vertex label '%s'", this.name);
        }
        if (this.idStrategy != IdStrategy.DEFAULT) {
            throw new NotAllowException("Not allowed to update id strategy for vertex label '%s'", this.name);
        }
        if (this.enableLabelIndex != null) {
            throw new NotAllowException("Not allowed to update enable_label_index for vertex label '%s'", this.name);
        }
    }

    private void checkUserdata(Action action) {
        switch (action) {
            case INSERT: 
            case APPEND: {
                for (Map.Entry<String, Object> e : this.userdata.entrySet()) {
                    if (e.getValue() != null) continue;
                    throw new NotAllowException("Not allowed pass null userdata value when create or append vertex label");
                }
                break;
            }
            case ELIMINATE: 
            case DELETE: {
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unknown schema action '%s'", new Object[]{action}));
            }
        }
    }
}

