/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.structure;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.EdgeId;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.SplicingIdGenerator;
import com.baidu.hugegraph.backend.tx.GraphTransaction;
import com.baidu.hugegraph.perf.PerfUtil;
import com.baidu.hugegraph.schema.EdgeLabel;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.structure.HugeEdgeProperty;
import com.baidu.hugegraph.structure.HugeElement;
import com.baidu.hugegraph.structure.HugeProperty;
import com.baidu.hugegraph.structure.HugeVertex;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.Cardinality;
import com.baidu.hugegraph.type.define.Directions;
import com.baidu.hugegraph.type.define.HugeKeys;
import com.baidu.hugegraph.util.E;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class HugeEdge
extends HugeElement
implements Edge,
Cloneable {
    protected EdgeLabel label;
    protected String name;
    protected HugeVertex ownerVertex;
    protected HugeVertex sourceVertex;
    protected HugeVertex targetVertex;

    public HugeEdge(HugeVertex owner, Id id, EdgeLabel label) {
        this(owner.graph(), id, label);
        this.ownerVertex = owner;
        this.fresh = true;
    }

    public HugeEdge(HugeGraph graph, Id id, EdgeLabel label) {
        super(graph, id);
        E.checkArgumentNotNull((Object)label, (String)"Edge label can't be null", (Object[])new Object[0]);
        this.label = label;
        this.name = null;
        this.ownerVertex = null;
        this.sourceVertex = null;
        this.targetVertex = null;
    }

    @Override
    public HugeType type() {
        return this.ownerVertex == this.sourceVertex ? HugeType.EDGE_OUT : HugeType.EDGE_IN;
    }

    @Override
    public EdgeId id() {
        return (EdgeId)this.id;
    }

    @Override
    public EdgeLabel schemaLabel() {
        return this.label;
    }

    @Override
    public GraphTransaction tx() {
        if (this.ownerVertex() == null) {
            return null;
        }
        return this.ownerVertex().tx();
    }

    @Override
    public String name() {
        if (this.name == null) {
            this.name = SplicingIdGenerator.concatValues(this.sortValues());
        }
        return this.name;
    }

    public void name(String name) {
        this.name = name;
    }

    public String label() {
        return this.label.name();
    }

    public Directions direction() {
        if (this.ownerVertex == this.sourceVertex) {
            return Directions.OUT;
        }
        assert (this.ownerVertex == this.targetVertex);
        return Directions.IN;
    }

    public boolean matchDirection(Directions direction) {
        if (direction == Directions.BOTH) {
            return true;
        }
        return this.isDirection(direction);
    }

    public boolean isDirection(Directions direction) {
        if (direction == Directions.OUT) {
            return this.ownerVertex == this.sourceVertex;
        }
        if (direction == Directions.IN) {
            return this.ownerVertex == this.targetVertex;
        }
        return false;
    }

    @PerfUtil.Watched(prefix="edge")
    public void assignId() {
        this.id = new EdgeId(this.ownerVertex(), this.direction(), this.schemaLabel().id(), this.name(), this.otherVertex());
        int len = this.id.length();
        E.checkArgument((len <= 32768 ? 1 : 0) != 0, (String)"The max length of edge id is %s, but got %s {%s}", (Object[])new Object[]{32768, len, this.id});
    }

    @PerfUtil.Watched(prefix="edge")
    public EdgeId idWithDirection() {
        return ((EdgeId)this.id).directed(true);
    }

    @PerfUtil.Watched(prefix="edge")
    public List<Object> sortValues() {
        List<Id> sortKeys = this.schemaLabel().sortKeys();
        if (sortKeys.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<Object> propValues = new ArrayList<Object>(sortKeys.size());
        for (Id sk : sortKeys) {
            HugeProperty property = this.getProperty(sk);
            E.checkState((property != null ? 1 : 0) != 0, (String)"The value of sort key '%s' can't be null", (Object[])new Object[]{sk});
            propValues.add(property.serialValue());
        }
        return propValues;
    }

    @PerfUtil.Watched(prefix="edge")
    public void remove() {
        this.removed = true;
        this.sourceVertex.removeEdge(this);
        this.targetVertex.removeEdge(this);
        this.tx().removeEdge(this);
    }

    public <V> Property<V> property(String key, V value) {
        PropertyKey propertyKey = this.graph().propertyKey(key);
        E.checkArgument((boolean)this.label.properties().contains(propertyKey.id()), (String)"Invalid property '%s' for edge label '%s'", (Object[])new Object[]{key, this.label()});
        if (this.schemaLabel().sortKeys().contains(propertyKey.id())) {
            E.checkArgument((!this.hasProperty(propertyKey.id()) ? 1 : 0) != 0, (String)"Can't update sort key: '%s'", (Object[])new Object[]{key});
        }
        return this.addProperty(propertyKey, value, true);
    }

    @PerfUtil.Watched(prefix="edge")
    protected <V> HugeEdgeProperty<V> newProperty(PropertyKey pkey, V val) {
        return new HugeEdgeProperty<V>(this, pkey, val);
    }

    @Override
    @PerfUtil.Watched(prefix="edge")
    protected <V> void onUpdateProperty(Cardinality cardinality, HugeProperty<V> prop) {
        if (prop != null) {
            assert (prop instanceof HugeEdgeProperty);
            this.tx().addEdgeProperty((HugeEdgeProperty)prop);
        }
    }

    @PerfUtil.Watched(prefix="edge")
    protected void ensureEdgeProperties() {
        if (this.propLoaded) {
            return;
        }
        Iterator<Edge> edges = this.tx().queryEdges(this.id());
        E.checkState((boolean)edges.hasNext(), (String)"Edge '%s' does not exist", (Object[])new Object[]{this.id});
        this.copyProperties((HugeEdge)edges.next());
    }

    @PerfUtil.Watched(prefix="edge")
    public <V> Iterator<Property<V>> properties(String ... keys) {
        this.ensureEdgeProperties();
        int propsCapacity = keys.length == 0 ? this.sizeOfProperties() : keys.length;
        ArrayList props = new ArrayList(propsCapacity);
        if (keys.length == 0) {
            for (HugeProperty<?> prop : this.getProperties().values()) {
                assert (prop instanceof Property);
                props.add(prop);
            }
        } else {
            for (String key : keys) {
                HugeProperty prop;
                PropertyKey propertyKey = this.graph().schemaTransaction().getPropertyKey(key);
                if (propertyKey == null || (prop = this.getProperty(propertyKey.id())) == null) continue;
                assert (prop instanceof Property);
                props.add(prop);
            }
        }
        return props.iterator();
    }

    @Override
    public Object sysprop(HugeKeys key) {
        switch (key) {
            case OWNER_VERTEX: {
                return this.ownerVertex().id();
            }
            case LABEL: {
                return this.schemaLabel().id();
            }
            case DIRECTION: {
                return this.direction();
            }
            case OTHER_VERTEX: {
                return this.otherVertex().id();
            }
            case SORT_VALUES: {
                return this.name();
            }
            case PROPERTIES: {
                return this.getPropertiesMap();
            }
        }
        E.checkArgument((boolean)false, (String)"Invalid system property '%s' of Edge", (Object[])new Object[]{key});
        return null;
    }

    public Iterator<Vertex> vertices(Direction direction) {
        ArrayList<HugeVertex> vertices = new ArrayList<HugeVertex>(2);
        switch (direction) {
            case OUT: {
                vertices.add(this.sourceVertex);
                break;
            }
            case IN: {
                vertices.add(this.targetVertex);
                break;
            }
            case BOTH: {
                vertices.add(this.sourceVertex);
                vertices.add(this.targetVertex);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported direction: " + direction));
            }
        }
        return vertices.iterator();
    }

    public Vertex outVertex() {
        return this.sourceVertex;
    }

    public Vertex inVertex() {
        return this.targetVertex;
    }

    public void vertices(HugeVertex source, HugeVertex target) {
        this.ownerVertex = source;
        this.sourceVertex = source;
        this.targetVertex = target;
    }

    public void vertices(HugeVertex owner, HugeVertex source, HugeVertex target) {
        this.ownerVertex = owner;
        this.sourceVertex = source;
        this.targetVertex = target;
    }

    public HugeEdge switchOwner() {
        HugeEdge edge = this.clone();
        if (edge.ownerVertex == edge.sourceVertex) {
            edge.ownerVertex = edge.targetVertex;
        } else {
            assert (edge.ownerVertex == this.targetVertex);
            edge.ownerVertex = edge.sourceVertex;
        }
        edge.assignId();
        return edge;
    }

    public HugeEdge switchToOutDirection() {
        if (this.direction() == Directions.IN) {
            return this.switchOwner();
        }
        return this;
    }

    public HugeVertex ownerVertex() {
        return this.ownerVertex;
    }

    public void ownerVertex(HugeVertex owner) {
        E.checkState((owner == this.sourceVertex || owner == this.targetVertex ? 1 : 0) != 0, (String)"The owner vertex must be sourceVertex or targetVertex", (Object[])new Object[0]);
        this.ownerVertex = owner;
    }

    public HugeVertex sourceVertex() {
        return this.sourceVertex;
    }

    public void sourceVertex(HugeVertex sourceVertex) {
        this.sourceVertex = sourceVertex;
    }

    public HugeVertex targetVertex() {
        return this.targetVertex;
    }

    public void targetVertex(HugeVertex targetVertex) {
        this.targetVertex = targetVertex;
    }

    public boolean belongToLabels(String ... edgeLabels) {
        if (edgeLabels.length == 0) {
            return true;
        }
        for (String label : edgeLabels) {
            if (!label.equals(this.label())) continue;
            return true;
        }
        return false;
    }

    public boolean belongToVertex(HugeVertex vertex) {
        return vertex != null && (vertex.equals(this.sourceVertex) || vertex.equals(this.targetVertex));
    }

    public HugeVertex otherVertex(HugeVertex vertex) {
        if (vertex == this.sourceVertex) {
            return this.targetVertex;
        }
        E.checkArgument((vertex == this.targetVertex ? 1 : 0) != 0, (String)"Invalid argument vertex '%s', must be in [%s, %s]", (Object[])new Object[]{vertex, this.sourceVertex, this.targetVertex});
        return this.sourceVertex;
    }

    public HugeVertex otherVertex() {
        return this.otherVertex(this.ownerVertex);
    }

    public HugeEdge prepareRemoved() {
        HugeEdge edge = this.clone();
        edge.removed = true;
        edge.resetProperties();
        return edge;
    }

    @Override
    public HugeEdge copy() {
        HugeEdge edge = this.clone();
        edge.properties = new HashMap(edge.properties);
        return edge;
    }

    protected HugeEdge clone() {
        try {
            return (HugeEdge)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new HugeException("Failed to clone HugeEdge", e);
        }
    }

    public String toString() {
        return StringFactory.edgeString((Edge)this);
    }

    public static Id getIdValue(Object idValue) {
        Id id = HugeElement.getIdValue(idValue);
        if (id == null || id instanceof EdgeId) {
            return id;
        }
        return EdgeId.parse(id.asString());
    }
}

