/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.structure;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.EdgeId;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.IdGenerator;
import com.baidu.hugegraph.backend.tx.GraphTransaction;
import com.baidu.hugegraph.perf.PerfUtil;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.schema.SchemaLabel;
import com.baidu.hugegraph.schema.VertexLabel;
import com.baidu.hugegraph.structure.GraphType;
import com.baidu.hugegraph.structure.HugeProperty;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.Cardinality;
import com.baidu.hugegraph.type.define.HugeKeys;
import com.baidu.hugegraph.util.CollectionUtil;
import com.baidu.hugegraph.util.E;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;

public abstract class HugeElement
implements Element,
GraphType {
    private final HugeGraph graph;
    protected Id id;
    protected Map<Id, HugeProperty<?>> properties;
    protected boolean removed;
    protected boolean fresh;
    protected boolean propLoaded;

    public HugeElement(HugeGraph graph, Id id) {
        E.checkArgument((graph != null ? 1 : 0) != 0, (String)"HugeElement graph can't be null", (Object[])new Object[0]);
        this.graph = graph;
        this.id = id;
        this.properties = new HashMap();
        this.removed = false;
        this.fresh = false;
        this.propLoaded = true;
    }

    public abstract SchemaLabel schemaLabel();

    protected abstract GraphTransaction tx();

    protected abstract <V> HugeProperty<V> newProperty(PropertyKey var1, V var2);

    protected abstract <V> void onUpdateProperty(Cardinality var1, HugeProperty<V> var2);

    public Id id() {
        return this.id;
    }

    public HugeGraph graph() {
        return this.graph;
    }

    public boolean removed() {
        return this.removed;
    }

    public boolean fresh() {
        return this.fresh;
    }

    public boolean propLoaded() {
        return this.propLoaded;
    }

    public void propNotLoaded() {
        this.propLoaded = false;
    }

    public void committed() {
        this.fresh = false;
    }

    public Map<Id, HugeProperty<?>> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Map<Id, Object> getPropertiesMap() {
        HashMap<Id, Object> props = new HashMap<Id, Object>();
        for (Map.Entry<Id, HugeProperty<?>> entry : this.properties.entrySet()) {
            props.put(entry.getKey(), entry.getValue().value());
        }
        return props;
    }

    public <V> HugeProperty<V> getProperty(Id key) {
        return this.properties.get(key);
    }

    public <V> V getPropertyValue(Id key) {
        HugeProperty<?> prop = this.properties.get(key);
        if (prop == null) {
            return null;
        }
        return (V)prop.value();
    }

    public boolean hasProperty(Id key) {
        return this.properties.containsKey(key);
    }

    public boolean hasProperties() {
        return this.properties.size() > 0;
    }

    public int sizeOfProperties() {
        return this.properties.size();
    }

    @PerfUtil.Watched(prefix="element")
    public <V> HugeProperty<?> setProperty(HugeProperty<V> prop) {
        PropertyKey pkey = prop.propertyKey();
        return this.properties.put(pkey.id(), prop);
    }

    public <V> HugeProperty<?> removeProperty(Id key) {
        return this.properties.remove(key);
    }

    public <V> HugeProperty<V> addProperty(PropertyKey pkey, V value) {
        return this.addProperty(pkey, value, false);
    }

    @PerfUtil.Watched(prefix="element")
    public <V> HugeProperty<V> addProperty(PropertyKey pkey, V value, boolean notify) {
        HugeProperty<V> prop = null;
        switch (pkey.cardinality()) {
            case SINGLE: {
                prop = this.newProperty(pkey, value);
                if (notify) {
                    this.onUpdateProperty(pkey.cardinality(), prop);
                }
                this.setProperty(prop);
                break;
            }
            case SET: {
                prop = this.addProperty(pkey, value, HashSet::new);
                if (!notify) break;
                this.onUpdateProperty(pkey.cardinality(), prop);
                break;
            }
            case LIST: {
                prop = this.addProperty(pkey, value, ArrayList::new);
                if (!notify) break;
                this.onUpdateProperty(pkey.cardinality(), prop);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return prop;
    }

    @PerfUtil.Watched(prefix="element")
    private <V> HugeProperty<V> addProperty(PropertyKey pkey, V value, Supplier<Collection<V>> supplier) {
        HugeProperty<Object> property;
        if (this.hasProperty(pkey.id())) {
            property = this.getProperty(pkey.id());
        } else {
            property = this.newProperty(pkey, supplier.get());
            this.setProperty(property);
        }
        Collection values = null;
        if (value instanceof Collection) {
            values = (Collection)value;
        } else if (value.getClass().isArray()) {
            values = CollectionUtil.toList(value);
        }
        if (values != null) {
            E.checkArgument((boolean)pkey.checkDataType(values), (String)"Invalid type of property values %s for key '%s'", (Object[])new Object[]{value, pkey.name()});
            ((Collection)property.value()).addAll(values);
        } else {
            E.checkArgument((boolean)pkey.checkDataType(value), (String)"Invalid type of property value '%s' for key '%s'", (Object[])new Object[]{value, pkey.name()});
            ((Collection)property.value()).add(value);
        }
        return property;
    }

    public void resetProperties() {
        this.properties = new HashMap();
        this.propLoaded = false;
    }

    public void copyProperties(HugeElement element) {
        this.properties = new HashMap(element.properties);
        this.propLoaded = true;
    }

    public HugeElement copyAsFresh() {
        HugeElement elem = this.copy();
        elem.fresh = true;
        return elem;
    }

    public abstract HugeElement copy();

    public abstract Object sysprop(HugeKeys var1);

    public boolean equals(Object obj) {
        if (!(obj instanceof Element)) {
            return false;
        }
        Element other = (Element)obj;
        if (this.id() == null) {
            return false;
        }
        return this.id().equals(other.id());
    }

    public int hashCode() {
        E.checkState((this.id() != null ? 1 : 0) != 0, (String)"Element id can't be null", (Object[])new Object[0]);
        return ElementHelper.hashCode((Element)this);
    }

    @PerfUtil.Watched(prefix="element")
    public static ElementKeys classifyKeys(Object ... keyValues) {
        ElementKeys elemKeys = new ElementKeys();
        if ((keyValues.length & 1) == 1) {
            throw Element.Exceptions.providedKeyValuesMustBeAMultipleOfTwo();
        }
        for (int i = 0; i < keyValues.length; i += 2) {
            Object key = keyValues[i];
            Object val = keyValues[i + 1];
            if (!(key instanceof String) && !(key instanceof T)) {
                throw Element.Exceptions.providedKeyValuesMustHaveALegalKeyOnEvenIndices();
            }
            if (val == null) {
                throw Property.Exceptions.propertyValueCanNotBeNull();
            }
            if (key.equals(T.id)) {
                elemKeys.id = val;
                continue;
            }
            if (key.equals(T.label)) {
                elemKeys.label = val;
                continue;
            }
            elemKeys.keys.add(key.toString());
        }
        return elemKeys;
    }

    public static Id getIdValue(HugeType type, Object idValue) {
        assert (type.isGraph());
        Id id = HugeElement.getIdValue(idValue);
        if (type.isVertex()) {
            return id;
        }
        return EdgeId.parse(id.asString());
    }

    @PerfUtil.Watched(prefix="element")
    protected static Id getIdValue(Object idValue) {
        if (idValue == null) {
            return null;
        }
        if (idValue instanceof String) {
            return IdGenerator.of((String)idValue);
        }
        if (idValue instanceof Number) {
            return IdGenerator.of(((Number)idValue).longValue());
        }
        if (idValue instanceof Id) {
            return (Id)idValue;
        }
        if (idValue instanceof Element) {
            return (Id)((Element)idValue).id();
        }
        throw new UnsupportedOperationException(String.format("Invalid element id type: %s, must be a string", idValue.getClass().getSimpleName()));
    }

    @PerfUtil.Watched(prefix="element")
    public static Object getLabelValue(Object ... keyValues) {
        Object labelValue = null;
        for (int i = 0; i < keyValues.length; i += 2) {
            if (!keyValues[i].equals(T.label)) continue;
            labelValue = keyValues[i + 1];
            E.checkArgument((labelValue instanceof String || labelValue instanceof VertexLabel ? 1 : 0) != 0, (String)"Expect a string or a VertexLabel object as the vertex label argument, but got: '%s'", (Object[])new Object[]{labelValue});
            if (!(labelValue instanceof String)) break;
            ElementHelper.validateLabel((String)((String)labelValue));
            break;
        }
        return labelValue;
    }

    public static class ElementKeys {
        private Object label = null;
        private Object id = null;
        private Set<String> keys = new HashSet<String>();

        public Object label() {
            return this.label;
        }

        public void label(Object label) {
            this.label = label;
        }

        public Object id() {
            return this.id;
        }

        public void id(Object id) {
            this.id = id;
        }

        public Set<String> keys() {
            return this.keys;
        }

        public void keys(Set<String> keys) {
            this.keys = keys;
        }
    }
}

