/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.structure;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.config.CoreOptions;
import com.baidu.hugegraph.config.HugeConfig;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.FeatureDescriptor;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class HugeFeatures
implements Graph.Features {
    protected final HugeGraph graph;
    protected final boolean supportsPersistence;
    protected final HugeGraphFeatures graphFeatures;
    protected final HugeVertexFeatures vertexFeatures;
    protected final HugeEdgeFeatures edgeFeatures;

    public HugeFeatures(HugeGraph graph, boolean supportsPersistence) {
        this.graph = graph;
        this.supportsPersistence = supportsPersistence;
        this.graphFeatures = new HugeGraphFeatures();
        this.vertexFeatures = new HugeVertexFeatures();
        this.edgeFeatures = new HugeEdgeFeatures();
    }

    public HugeGraphFeatures graph() {
        return this.graphFeatures;
    }

    public HugeVertexFeatures vertex() {
        return this.vertexFeatures;
    }

    public HugeEdgeFeatures edge() {
        return this.edgeFeatures;
    }

    public String toString() {
        return StringFactory.featureString((Graph.Features)this);
    }

    public class HugeDataTypeFeatures
    implements Graph.Features.DataTypeFeatures {
        @FeatureDescriptor(name="StringValues")
        public boolean supportsStringValues() {
            return true;
        }

        @FeatureDescriptor(name="BooleanValues")
        public boolean supportsBooleanValues() {
            return true;
        }

        @FeatureDescriptor(name="ByteValues")
        public boolean supportsByteValues() {
            return true;
        }

        @FeatureDescriptor(name="FloatValues")
        public boolean supportsFloatValues() {
            return true;
        }

        @FeatureDescriptor(name="DoubleValues")
        public boolean supportsDoubleValues() {
            return true;
        }

        @FeatureDescriptor(name="IntegerValues")
        public boolean supportsIntegerValues() {
            return true;
        }

        @FeatureDescriptor(name="LongValues")
        public boolean supportsLongValues() {
            return true;
        }

        @FeatureDescriptor(name="UniformListValues")
        public boolean supportsUniformListValues() {
            return true;
        }

        @FeatureDescriptor(name="MixedListValues")
        public boolean supportsMixedListValues() {
            return false;
        }

        @FeatureDescriptor(name="MapValues")
        public boolean supportsMapValues() {
            return false;
        }

        @FeatureDescriptor(name="SerializableValues")
        public boolean supportsSerializableValues() {
            return false;
        }

        @FeatureDescriptor(name="ByteArrayValues")
        public boolean supportsByteArrayValues() {
            return true;
        }

        @FeatureDescriptor(name="BooleanArrayValues")
        public boolean supportsBooleanArrayValues() {
            return false;
        }

        @FeatureDescriptor(name="FloatArrayValues")
        public boolean supportsFloatArrayValues() {
            return false;
        }

        @FeatureDescriptor(name="DoubleArrayValues")
        public boolean supportsDoubleArrayValues() {
            return false;
        }

        @FeatureDescriptor(name="IntegerArrayValues")
        public boolean supportsIntegerArrayValues() {
            return false;
        }

        @FeatureDescriptor(name="LongArrayValues")
        public boolean supportsLongArrayValues() {
            return false;
        }

        @FeatureDescriptor(name="StringArrayValues")
        public boolean supportsStringArrayValues() {
            return false;
        }
    }

    public class HugeEdgeFeatures
    extends HugeElementFeatures
    implements Graph.Features.EdgeFeatures {
        private final Graph.Features.EdgePropertyFeatures edgePropertyFeatures;

        public HugeEdgeFeatures() {
            this.edgePropertyFeatures = new HugeEdgePropertyFeatures();
        }

        public Graph.Features.EdgePropertyFeatures properties() {
            return this.edgePropertyFeatures;
        }
    }

    public class HugeVertexFeatures
    extends HugeElementFeatures
    implements Graph.Features.VertexFeatures {
        private final Graph.Features.VertexPropertyFeatures vertexPropertyFeatures;

        public HugeVertexFeatures() {
            this.vertexPropertyFeatures = new HugeVertexPropertyFeatures();
        }

        @Override
        public boolean supportsUserSuppliedIds() {
            return true;
        }

        public Graph.Features.VertexPropertyFeatures properties() {
            return this.vertexPropertyFeatures;
        }

        public boolean supportsMultiProperties() {
            return true;
        }

        public boolean supportsDuplicateMultiProperties() {
            return true;
        }

        public boolean supportsMetaProperties() {
            return false;
        }

        public VertexProperty.Cardinality getCardinality(String key) {
            return VertexProperty.Cardinality.single;
        }

        public boolean supportsDefaultLabel() {
            return true;
        }

        public String defaultLabel() {
            HugeConfig conf = HugeFeatures.this.graph.configuration();
            return (String)conf.get(CoreOptions.VERTEX_DEFAULT_LABEL);
        }
    }

    public class HugeEdgePropertyFeatures
    extends HugeDataTypeFeatures
    implements Graph.Features.EdgePropertyFeatures {
        @Override
        public boolean supportsMapValues() {
            return false;
        }

        @Override
        public boolean supportsMixedListValues() {
            return false;
        }

        @Override
        public boolean supportsSerializableValues() {
            return false;
        }

        @Override
        public boolean supportsUniformListValues() {
            return true;
        }
    }

    public class HugeVertexPropertyFeatures
    extends HugeDataTypeFeatures
    implements Graph.Features.VertexPropertyFeatures {
        public boolean supportsAddProperty() {
            return true;
        }

        public boolean supportsRemoveProperty() {
            return true;
        }

        @Override
        public boolean supportsMapValues() {
            return false;
        }

        @Override
        public boolean supportsMixedListValues() {
            return false;
        }

        @Override
        public boolean supportsSerializableValues() {
            return false;
        }

        @Override
        public boolean supportsUniformListValues() {
            return true;
        }

        public boolean supportsUserSuppliedIds() {
            return false;
        }

        public boolean supportsAnyIds() {
            return false;
        }

        public boolean supportsCustomIds() {
            return false;
        }
    }

    public class HugeVariableFeatures
    extends HugeDataTypeFeatures
    implements Graph.Features.VariableFeatures {
    }

    public class HugeElementFeatures
    implements Graph.Features.ElementFeatures {
        public boolean supportsAddProperty() {
            return true;
        }

        public boolean supportsRemoveProperty() {
            return true;
        }

        public boolean supportsStringIds() {
            return true;
        }

        public boolean supportsNumericIds() {
            return false;
        }

        public boolean supportsUuidIds() {
            return false;
        }

        public boolean supportsAnyIds() {
            return false;
        }

        public boolean supportsCustomIds() {
            return true;
        }

        public boolean supportsUserSuppliedIds() {
            return false;
        }

        public boolean willAllowId(Object id) {
            if (!this.supportsUserSuppliedIds()) {
                return false;
            }
            return this.supportsAnyIds() || this.supportsCustomIds() && id instanceof Id || this.supportsStringIds() && id instanceof String || this.supportsNumericIds() && id instanceof Number || this.supportsUuidIds() && id instanceof UUID;
        }
    }

    public class HugeGraphFeatures
    implements Graph.Features.GraphFeatures {
        private final Graph.Features.VariableFeatures variableFeatures;

        public HugeGraphFeatures() {
            this.variableFeatures = new HugeVariableFeatures();
        }

        public boolean supportsConcurrentAccess() {
            return false;
        }

        public boolean supportsComputer() {
            return false;
        }

        public boolean supportsPersistence() {
            return HugeFeatures.this.supportsPersistence;
        }

        public Graph.Features.VariableFeatures variables() {
            return this.variableFeatures;
        }

        public boolean supportsTransactions() {
            return true;
        }

        public boolean supportsThreadedTransactions() {
            return false;
        }
    }
}

