/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.structure;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.IdGenerator;
import com.baidu.hugegraph.backend.id.SplicingIdGenerator;
import com.baidu.hugegraph.backend.serializer.BytesBuffer;
import com.baidu.hugegraph.schema.IndexLabel;
import com.baidu.hugegraph.schema.SchemaElement;
import com.baidu.hugegraph.structure.GraphType;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.DataType;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.HashUtil;
import com.baidu.hugegraph.util.NumericUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class HugeIndex
implements GraphType {
    private Object fieldValues;
    private IndexLabel indexLabel;
    private Set<Id> elementIds;

    public HugeIndex(IndexLabel indexLabel) {
        E.checkNotNull((Object)indexLabel, (String)"label");
        E.checkNotNull((Object)indexLabel.id(), (String)"label id");
        this.indexLabel = indexLabel;
        this.elementIds = new LinkedHashSet<Id>();
        this.fieldValues = null;
    }

    @Override
    public String name() {
        return this.indexLabel.name();
    }

    @Override
    public HugeType type() {
        return this.indexLabel.indexType().type();
    }

    public Id id() {
        return HugeIndex.formatIndexId(this.type(), this.indexLabel(), this.fieldValues());
    }

    public Id hashId() {
        return HugeIndex.formatIndexHashId(this.type(), this.indexLabel(), this.fieldValues());
    }

    public Object fieldValues() {
        return this.fieldValues;
    }

    public void fieldValues(Object fieldValues) {
        this.fieldValues = fieldValues;
    }

    public Id indexLabel() {
        return this.indexLabel.id();
    }

    public Id elementId() {
        E.checkState((this.elementIds.size() == 1 ? 1 : 0) != 0, (String)"Expect one element id, actual %s", (Object[])new Object[]{this.elementIds.size()});
        return this.elementIds.iterator().next();
    }

    public Set<Id> elementIds() {
        return Collections.unmodifiableSet(this.elementIds);
    }

    public void elementIds(Id ... elementIds) {
        this.elementIds.addAll(Arrays.asList(elementIds));
    }

    public void resetElementIds() {
        this.elementIds = new LinkedHashSet<Id>();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HugeIndex)) {
            return false;
        }
        HugeIndex other = (HugeIndex)obj;
        return this.id().equals(other.id());
    }

    public int hashCode() {
        return this.id().hashCode();
    }

    public String toString() {
        return String.format("{label=%s<%s>, fieldValues=%s, elementIds=%s}", this.indexLabel.name(), this.indexLabel.indexType().string(), this.fieldValues, this.elementIds);
    }

    public static Id formatIndexHashId(HugeType type, Id indexLabel, Object fieldValues) {
        E.checkState((!type.isRangeIndex() ? 1 : 0) != 0, (String)"RangeIndex can't return a hash id", (Object[])new Object[0]);
        String value = fieldValues == null ? "" : fieldValues.toString();
        return HugeIndex.formatIndexId(type, indexLabel, HashUtil.hash((String)value));
    }

    public static Id formatIndexId(HugeType type, Id indexLabel, Object fieldValues) {
        if (type.isStringIndex()) {
            String value = fieldValues == null ? "" : fieldValues.toString();
            return SplicingIdGenerator.splicing(indexLabel.asString(), value);
        }
        assert (type.isRangeIndex());
        BytesBuffer buffer = BytesBuffer.allocate(16);
        buffer.writeInt((int)indexLabel.asLong());
        if (fieldValues != null) {
            E.checkState((boolean)(fieldValues instanceof Number), (String)"Field value of range index must be number: %s", (Object[])new Object[]{fieldValues.getClass().getSimpleName()});
            byte[] value = HugeIndex.number2bytes((Number)fieldValues);
            buffer.write(value);
        }
        return buffer.asId();
    }

    public static HugeIndex parseIndexId(HugeGraph graph, HugeType type, byte[] id) {
        Object values;
        IndexLabel indexLabel;
        if (type.isStringIndex()) {
            Id idObject = IdGenerator.of(id, false);
            String[] parts = SplicingIdGenerator.parse(idObject);
            E.checkState((parts.length == 2 ? 1 : 0) != 0, (String)"Invalid secondary index id", (Object[])new Object[0]);
            Id label = SchemaElement.schemaId(parts[0]);
            indexLabel = IndexLabel.label(graph, label);
            values = parts[1];
        } else {
            assert (type.isRangeIndex());
            int labelLength = 4;
            E.checkState((id.length > 4 ? 1 : 0) != 0, (String)"Invalid range index id", (Object[])new Object[0]);
            BytesBuffer buffer = BytesBuffer.wrap(id);
            Id label = IdGenerator.of(buffer.readInt());
            indexLabel = IndexLabel.label(graph, label);
            List<Id> fields = indexLabel.indexFields();
            E.checkState((fields.size() == 1 ? 1 : 0) != 0, (String)"Invalid range index fields", (Object[])new Object[0]);
            DataType dataType = graph.propertyKey(fields.get(0)).dataType();
            E.checkState((dataType.isNumber() || dataType.isDate() ? 1 : 0) != 0, (String)"Invalid range index field type", (Object[])new Object[0]);
            Class<?> clazz = dataType.isNumber() ? dataType.clazz() : DataType.LONG.clazz();
            values = HugeIndex.bytes2number(buffer.read(id.length - 4), clazz);
        }
        HugeIndex index = new HugeIndex(indexLabel);
        index.fieldValues(values);
        return index;
    }

    public static byte[] number2bytes(Number number) {
        return NumericUtil.numberToSortableBytes((Number)number);
    }

    public static Number bytes2number(byte[] bytes, Class<?> clazz) {
        return NumericUtil.sortableBytesToNumber((byte[])bytes, clazz);
    }
}

