/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.structure;

import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.structure.GraphType;
import com.baidu.hugegraph.structure.HugeElement;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.util.E;
import java.util.Date;
import java.util.NoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public abstract class HugeProperty<V>
implements Property<V>,
GraphType {
    protected final HugeElement owner;
    protected final PropertyKey pkey;
    protected final V value;

    public HugeProperty(HugeElement owner, PropertyKey pkey, V value) {
        E.checkArgument((owner != null ? 1 : 0) != 0, (String)"Property owner can't be null", (Object[])new Object[0]);
        E.checkArgument((pkey != null ? 1 : 0) != 0, (String)"Property key can't be null", (Object[])new Object[0]);
        E.checkArgument((value != null ? 1 : 0) != 0, (String)"Property value can't be null", (Object[])new Object[0]);
        this.owner = owner;
        this.pkey = pkey;
        this.value = pkey.validValue(value);
        if (this.value == null) {
            E.checkArgument((boolean)false, (String)"Invalid property value '%s' for key '%s', expect a value of type %s, actual type %s", (Object[])new Object[]{value, pkey.name(), pkey.clazz().getSimpleName(), value.getClass().getSimpleName()});
        }
    }

    public PropertyKey propertyKey() {
        return this.pkey;
    }

    @Override
    public HugeType type() {
        return HugeType.PROPERTY;
    }

    @Override
    public String name() {
        return this.pkey.name();
    }

    public String key() {
        return this.pkey.name();
    }

    public V value() throws NoSuchElementException {
        return this.value;
    }

    public Object serialValue() {
        if (this.value instanceof Date) {
            return ((Date)this.value).getTime();
        }
        return this.value;
    }

    public boolean isPresent() {
        return null != this.value;
    }

    public HugeElement element() {
        return this.owner;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HugeProperty)) {
            return false;
        }
        HugeProperty other = (HugeProperty)obj;
        return this.owner.equals(other.owner) && this.pkey.equals(other.pkey);
    }

    public int hashCode() {
        return ElementHelper.hashCode((Property)this);
    }

    public String toString() {
        return StringFactory.propertyString((Property)this);
    }
}

