/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.structure;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.SnowflakeIdGenerator;
import com.baidu.hugegraph.backend.id.SplicingIdGenerator;
import com.baidu.hugegraph.backend.query.ConditionQuery;
import com.baidu.hugegraph.backend.tx.GraphTransaction;
import com.baidu.hugegraph.perf.PerfUtil;
import com.baidu.hugegraph.schema.EdgeLabel;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.schema.VertexLabel;
import com.baidu.hugegraph.structure.HugeEdge;
import com.baidu.hugegraph.structure.HugeElement;
import com.baidu.hugegraph.structure.HugeProperty;
import com.baidu.hugegraph.structure.HugeVertexProperty;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.Cardinality;
import com.baidu.hugegraph.type.define.Directions;
import com.baidu.hugegraph.type.define.HugeKeys;
import com.baidu.hugegraph.type.define.IdStrategy;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.InsertionOrderUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class HugeVertex
extends HugeElement
implements Vertex,
Cloneable {
    protected GraphTransaction tx;
    protected VertexLabel label;
    protected String name;
    protected Set<HugeEdge> edges;

    public HugeVertex(GraphTransaction tx, Id id, VertexLabel label) {
        this(tx.graph(), id, label);
        this.tx = tx;
        this.fresh = true;
    }

    public HugeVertex(HugeGraph graph, Id id, VertexLabel label) {
        super(graph, id);
        this.vertexLabel(label);
        this.edges = InsertionOrderUtil.newSet();
        this.tx = null;
        this.name = null;
        if (this.id != null) {
            this.checkIdLength();
        }
    }

    @Override
    public HugeType type() {
        return HugeType.VERTEX;
    }

    @Override
    public VertexLabel schemaLabel() {
        return this.label;
    }

    @Override
    public String name() {
        assert (this.label.idStrategy() == IdStrategy.PRIMARY_KEY);
        if (this.name == null) {
            if (this.id != null) {
                String[] parts = SplicingIdGenerator.parse(this.id);
                E.checkState((parts.length == 2 ? 1 : 0) != 0, (String)"Invalid vertex id '%s'", (Object[])new Object[]{this.id});
                this.name = parts[1];
            } else {
                assert (this.id == null);
                List<Object> propValues = this.primaryValues();
                E.checkState((!propValues.isEmpty() ? 1 : 0) != 0, (String)"Primary values must not be empty (has properties %s)", (Object[])new Object[]{this.hasProperties()});
                this.name = SplicingIdGenerator.concatValues(propValues);
            }
        }
        return this.name;
    }

    @Override
    protected GraphTransaction tx() {
        GraphTransaction tx = this.tx;
        if (tx == null) {
            tx = super.graph().graphTransaction();
        }
        E.checkNotNull((Object)tx, (String)"transaction");
        return tx;
    }

    public HugeVertex resetTx() {
        this.tx = null;
        return this;
    }

    public void assignId(Id id) {
        this.assignId(id, false);
    }

    @PerfUtil.Watched(prefix="vertex")
    public void assignId(Id id, boolean force) {
        IdStrategy strategy = this.label.idStrategy();
        switch (strategy) {
            case CUSTOMIZE_STRING: {
                assert (!id.number());
                this.id = id;
                break;
            }
            case CUSTOMIZE_NUMBER: {
                assert (id.number());
                this.id = id;
                break;
            }
            case PRIMARY_KEY: {
                this.id = SplicingIdGenerator.instance().generate(this);
                break;
            }
            case AUTOMATIC: {
                if (force) {
                    assert (id.number());
                    this.id = id;
                    break;
                }
                this.id = SnowflakeIdGenerator.instance(this.graph()).generate(this);
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unknown id strategy '%s'", strategy));
            }
        }
        this.checkIdLength();
    }

    protected void checkIdLength() {
        assert (this.id != null);
        int len = this.id.asBytes().length;
        E.checkArgument((len <= 128 ? 1 : 0) != 0, (String)"The max length of vertex id is %s, but got %s {%s}", (Object[])new Object[]{128, len, this.id});
    }

    public String label() {
        return this.label.name();
    }

    public void vertexLabel(VertexLabel label) {
        E.checkArgumentNotNull((Object)label, (String)"Vertex label can't be null", (Object[])new Object[0]);
        this.label = label;
    }

    @PerfUtil.Watched(prefix="vertex")
    public List<Object> primaryValues() {
        E.checkArgument((this.label.idStrategy() == IdStrategy.PRIMARY_KEY ? 1 : 0) != 0, (String)"The id strategy '%s' don't have primary keys", (Object[])new Object[]{this.label.idStrategy()});
        List<Id> primaryKeys = this.label.primaryKeys();
        E.checkArgument((!primaryKeys.isEmpty() ? 1 : 0) != 0, (String)"Primary key can't be empty for id strategy '%s'", (Object[])new Object[]{IdStrategy.PRIMARY_KEY});
        ArrayList<Object> propValues = new ArrayList<Object>(primaryKeys.size());
        for (Id pk : primaryKeys) {
            HugeProperty property = this.getProperty(pk);
            E.checkState((property != null ? 1 : 0) != 0, (String)"The value of primary key '%s' can't be null", (Object[])new Object[]{this.graph().propertyKey(pk).name()});
            propValues.add(property.value());
        }
        return propValues;
    }

    public boolean existsEdges() {
        return this.edges.size() > 0;
    }

    public Set<HugeEdge> getEdges() {
        return Collections.unmodifiableSet(this.edges);
    }

    public void resetEdges() {
        this.edges = InsertionOrderUtil.newSet();
    }

    public void removeEdge(HugeEdge edge) {
        this.edges.remove(edge);
    }

    public void addEdge(HugeEdge edge) {
        this.edges.add(edge);
    }

    @PerfUtil.Watched(prefix="vertex")
    public HugeEdge addEdge(String label, Vertex vertex, Object ... keyValues) {
        HugeElement.ElementKeys elemKeys = HugeElement.classifyKeys(keyValues);
        if (elemKeys.id() != null) {
            throw Edge.Exceptions.userSuppliedIdsNotSupported();
        }
        Id id = HugeElement.getIdValue(elemKeys.id());
        E.checkArgumentNotNull((Object)vertex, (String)"Target vertex can't be null", (Object[])new Object[0]);
        E.checkArgument((boolean)(vertex instanceof HugeVertex), (String)"Target vertex must be an instance of HugeVertex", (Object[])new Object[0]);
        HugeVertex targetVertex = (HugeVertex)vertex;
        E.checkArgument((label != null && !label.isEmpty() ? 1 : 0) != 0, (String)"Edge label can't be null or empty", (Object[])new Object[0]);
        EdgeLabel edgeLabel = this.graph().edgeLabel(label);
        E.checkArgument((boolean)edgeLabel.checkLinkEqual(this.schemaLabel().id(), ((HugeVertex)vertex).schemaLabel().id()), (String)"Undefined link of edge label '%s': '%s' -> '%s'", (Object[])new Object[]{label, this.label(), vertex.label()});
        List<Id> keys = this.graph().mapPkName2Id(elemKeys.keys());
        E.checkArgument((boolean)keys.containsAll(edgeLabel.sortKeys()), (String)"The sort key(s) must be setted for the edge with label: '%s'", (Object[])new Object[]{edgeLabel.name()});
        Collection nonNullKeys = CollectionUtils.subtract(edgeLabel.properties(), edgeLabel.nullableKeys());
        if (!keys.containsAll(nonNullKeys)) {
            Collection missed = CollectionUtils.subtract((Collection)nonNullKeys, keys);
            E.checkArgument((boolean)false, (String)"All non-null property keys: %s of edge label '%s' must be setted, but missed keys: %s", (Object[])new Object[]{this.graph().mapPkId2Name(nonNullKeys), edgeLabel.name(), this.graph().mapPkId2Name(missed)});
        }
        HugeEdge edge = new HugeEdge(this, id, edgeLabel);
        edge.vertices(this, targetVertex);
        ElementHelper.attachProperties((Element)edge, (Object[])keyValues);
        if (id == null) {
            edge.assignId();
        }
        this.addOutEdge(edge);
        targetVertex.addInEdge(edge.switchOwner());
        return this.tx().addEdge(edge);
    }

    public void addOutEdge(HugeEdge edge) {
        if (edge.ownerVertex() == null) {
            edge.sourceVertex(this);
            edge.ownerVertex(this);
        }
        E.checkState((boolean)edge.isDirection(Directions.OUT), (String)"The owner vertex('%s') of OUT edge '%s' should be '%s'", (Object[])new Object[]{edge.ownerVertex().id(), edge, this.id()});
        this.edges.add(edge);
    }

    public void addInEdge(HugeEdge edge) {
        if (edge.ownerVertex() == null) {
            edge.targetVertex(this);
            edge.ownerVertex(this);
        }
        E.checkState((boolean)edge.isDirection(Directions.IN), (String)"The owner vertex('%s') of IN edge '%s' should be '%s'", (Object[])new Object[]{edge.ownerVertex().id(), edge, this.id()});
        this.edges.add(edge);
    }

    public Iterator<Edge> getEdges(Directions direction, String ... edgeLabels) {
        LinkedList<HugeEdge> list = new LinkedList<HugeEdge>();
        for (HugeEdge edge : this.edges) {
            if (!edge.matchDirection(direction) || !edge.belongToLabels(edgeLabels)) continue;
            list.add(edge);
        }
        return list.iterator();
    }

    public Iterator<Vertex> getVertices(Directions direction, String ... edgeLabels) {
        LinkedList<HugeVertex> list = new LinkedList<HugeVertex>();
        Iterator<Edge> edges = this.getEdges(direction, edgeLabels);
        while (edges.hasNext()) {
            HugeEdge edge = (HugeEdge)edges.next();
            list.add(edge.otherVertex(this));
        }
        return list.iterator();
    }

    @PerfUtil.Watched(prefix="vertex")
    public Iterator<Edge> edges(Direction tinkerpopDir, String ... edgeLabels) {
        Directions direction = Directions.convert(tinkerpopDir);
        if (this.existsEdges()) {
            return this.getEdges(direction, edgeLabels);
        }
        Id[] edgeLabelIds = this.graph().mapElName2Id(edgeLabels);
        ConditionQuery query = GraphTransaction.constructEdgesQuery(this.id(), direction, edgeLabelIds);
        return this.tx().queryEdges(query);
    }

    @PerfUtil.Watched(prefix="vertex")
    public Iterator<Vertex> vertices(Direction direction, String ... edgeLabels) {
        Iterator<Edge> edges = this.edges(direction, edgeLabels);
        return this.tx().queryAdjacentVertices(edges);
    }

    @PerfUtil.Watched(prefix="vertex")
    public void remove() {
        this.removed = true;
        this.tx().removeVertex(this);
    }

    @PerfUtil.Watched(prefix="vertex")
    public <V> VertexProperty<V> property(VertexProperty.Cardinality cardinality, String key, V value, Object ... objects) {
        if (objects.length != 0 && objects[0].equals(T.id)) {
            throw VertexProperty.Exceptions.userSuppliedIdsNotSupported();
        }
        if (objects.length != 0) {
            throw VertexProperty.Exceptions.metaPropertiesNotSupported();
        }
        PropertyKey propertyKey = this.graph().propertyKey(key);
        E.checkArgument((boolean)this.label.properties().contains(propertyKey.id()), (String)"Invalid property '%s' for vertex label '%s'", (Object[])new Object[]{key, this.label()});
        if (this.schemaLabel().primaryKeys().contains(propertyKey.id())) {
            E.checkArgument((!this.hasProperty(propertyKey.id()) ? 1 : 0) != 0, (String)"Can't update primary key: '%s'", (Object[])new Object[]{key});
        }
        return (VertexProperty)this.addProperty(propertyKey, value, true);
    }

    @PerfUtil.Watched(prefix="vertex")
    protected <V> HugeVertexProperty<V> newProperty(PropertyKey pkey, V val) {
        return new HugeVertexProperty<V>(this, pkey, val);
    }

    @Override
    @PerfUtil.Watched(prefix="vertex")
    protected <V> void onUpdateProperty(Cardinality cardinality, HugeProperty<V> prop) {
        if (prop != null) {
            assert (prop instanceof HugeVertexProperty);
            this.tx().addVertexProperty((HugeVertexProperty)prop);
        }
    }

    @PerfUtil.Watched(prefix="vertex")
    protected boolean ensureVertexProperties(boolean throwIfNotExist) {
        if (this.propLoaded) {
            return true;
        }
        Iterator<Vertex> vertices = this.tx().queryVertices(this.id());
        boolean exist = vertices.hasNext();
        if (!exist && !throwIfNotExist) {
            return false;
        }
        E.checkState((boolean)exist, (String)"Vertex '%s' does not exist", (Object[])new Object[]{this.id});
        this.copyProperties((HugeVertex)vertices.next());
        assert (exist);
        return true;
    }

    @PerfUtil.Watched(prefix="vertex")
    public <V> Iterator<VertexProperty<V>> properties(String ... keys) {
        this.ensureVertexProperties(true);
        int propsCapacity = keys.length == 0 ? this.sizeOfProperties() : keys.length;
        ArrayList<VertexProperty> props = new ArrayList<VertexProperty>(propsCapacity);
        if (keys.length == 0) {
            for (HugeProperty<?> prop : this.getProperties().values()) {
                assert (prop instanceof VertexProperty);
                props.add((VertexProperty)prop);
            }
        } else {
            for (String key : keys) {
                HugeProperty prop;
                PropertyKey propertyKey = this.graph().schemaTransaction().getPropertyKey(key);
                if (propertyKey == null || (prop = this.getProperty(propertyKey.id())) == null) continue;
                assert (prop instanceof VertexProperty);
                props.add((VertexProperty)prop);
            }
        }
        return props.iterator();
    }

    @Override
    public Object sysprop(HugeKeys key) {
        switch (key) {
            case LABEL: {
                return this.schemaLabel().id();
            }
            case PRIMARY_VALUES: {
                return this.name();
            }
            case PROPERTIES: {
                return this.getPropertiesMap();
            }
        }
        E.checkArgument((boolean)false, (String)"Invalid system property '%s' of Vertex", (Object[])new Object[]{key});
        return null;
    }

    public boolean valid() {
        try {
            return this.ensureVertexProperties(false);
        }
        catch (Throwable e) {
            return false;
        }
    }

    public HugeVertex prepareRemoved() {
        HugeVertex vertex = this.clone();
        vertex.removed = true;
        vertex.resetEdges();
        vertex.resetProperties();
        return vertex;
    }

    @Override
    public HugeVertex copy() {
        HugeVertex vertex = this.clone();
        vertex.properties = new HashMap(this.properties);
        return vertex;
    }

    protected HugeVertex clone() {
        try {
            return (HugeVertex)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new HugeException("Failed to clone HugeVertex", e);
        }
    }

    public String toString() {
        return StringFactory.vertexString((Vertex)this);
    }

    public static Id getIdValue(Object idValue) {
        return HugeElement.getIdValue(idValue);
    }
}

