/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.task;

import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.IdGenerator;
import com.baidu.hugegraph.task.TaskCallable;
import com.baidu.hugegraph.task.TaskStatus;
import com.baidu.hugegraph.type.define.SerialEnum;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.InsertionOrderUtil;
import com.baidu.hugegraph.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.FutureTask;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.slf4j.Logger;

public class HugeTask<V>
extends FutureTask<V> {
    private static final Logger LOG = Log.logger(HugeTask.class);
    private final TaskCallable<V> callable;
    private String type;
    private String name;
    private final Id id;
    private final Id parent;
    private Set<Id> dependencies;
    private String description;
    private Date create;
    private volatile TaskStatus status;
    private volatile int progress;
    private volatile Date update;
    private volatile int retries;
    private volatile String input;
    private volatile String result;

    public HugeTask(Id id, Id parent, String callable, String input) {
        this(id, parent, TaskCallable.fromClass(callable));
        this.input = input;
    }

    public HugeTask(Id id, Id parent, TaskCallable<V> callable) {
        super(callable);
        E.checkArgumentNotNull((Object)id, (String)"Task id can't be null", (Object[])new Object[0]);
        E.checkArgument((boolean)id.number(), (String)"Invalid task id type, it must be number", (Object[])new Object[0]);
        assert (callable != null);
        this.callable = callable;
        this.type = null;
        this.name = null;
        this.id = id;
        this.parent = parent;
        this.dependencies = null;
        this.description = null;
        this.status = TaskStatus.NEW;
        this.progress = 0;
        this.create = new Date();
        this.update = null;
        this.retries = 0;
        this.input = null;
        this.result = null;
    }

    public Id id() {
        return this.id;
    }

    public Id parent() {
        return this.parent;
    }

    public Set<Id> dependencies() {
        return Collections.unmodifiableSet(this.dependencies);
    }

    public void depends(Id id) {
        E.checkState((this.status == TaskStatus.NEW ? 1 : 0) != 0, (String)"Can't add dependency in status '%s'", (Object[])new Object[]{this.status});
        if (this.dependencies == null) {
            this.dependencies = InsertionOrderUtil.newSet();
        }
        this.dependencies.add(id);
    }

    public TaskStatus status() {
        return this.status;
    }

    public void type(String type) {
        this.type = type;
    }

    public String type() {
        return this.type;
    }

    public void name(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public void description(String description) {
        this.description = description;
    }

    public String description() {
        return this.description;
    }

    public void progress(int progress) {
        this.progress = progress;
    }

    public int progress() {
        return this.progress;
    }

    public void createTime(Date create) {
        this.create = create;
    }

    public Date createTime() {
        return this.create;
    }

    public void updateTime(Date update) {
        this.update = update;
    }

    public Date updateTime() {
        return this.update;
    }

    public void retry() {
        ++this.retries;
    }

    public int retries() {
        return this.retries;
    }

    public void input(String input) {
        this.input = input;
    }

    public String input() {
        return this.input;
    }

    public String result() {
        return this.result;
    }

    public boolean completed() {
        return TaskStatus.COMPLETED_STATUSES.contains(this.status);
    }

    @Override
    public String toString() {
        return String.format("HugeTask(%s)%s", this.id, this.asMap());
    }

    @Override
    public void run() {
        try {
            assert (this.status.code() < TaskStatus.RUNNING.code());
            if (this.checkDependenciesSuccess()) {
                this.status(TaskStatus.RUNNING);
                super.run();
            }
        }
        catch (Throwable e) {
            this.setException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        try {
            boolean bl = super.cancel(mayInterruptIfRunning);
            return bl;
        }
        finally {
            this.status(TaskStatus.CANCELLED);
            try {
                this.callable.cancelled();
            }
            catch (Throwable e) {
                LOG.error("An exception occurred when calling cancelled()", e);
            }
        }
    }

    @Override
    protected void done() {
        try {
            this.callable.done();
        }
        catch (Throwable e) {
            LOG.error("An exception occurred when calling done()", e);
        }
        finally {
            this.callable.scheduler().remove(this.id);
        }
    }

    @Override
    protected void set(V v) {
        this.status(TaskStatus.SUCCESS);
        if (v != null) {
            this.result = v.toString();
        }
        super.set(v);
    }

    @Override
    protected void setException(Throwable e) {
        if (this.status != TaskStatus.CANCELLED || !(e instanceof InterruptedException)) {
            LOG.warn("An exception occurred when running task: {}", (Object)this.id(), (Object)e);
            this.status(TaskStatus.FAILED);
            this.result = e.toString();
        }
        super.setException(e);
    }

    protected boolean checkDependenciesSuccess() {
        if (this.dependencies == null || this.dependencies.isEmpty()) {
            return true;
        }
        for (Id dependency : this.dependencies) {
            HugeTask task = this.callable.scheduler().task(dependency);
            if (!task.completed()) {
                this.callable.scheduler().schedule(this);
                return false;
            }
            if (task.status() == TaskStatus.CANCELLED) {
                this.status(TaskStatus.CANCELLED);
                this.result = String.format("Cancelled due to dependent task '%s' cancelled", dependency);
                this.done();
                return false;
            }
            if (task.status() != TaskStatus.FAILED) continue;
            this.status(TaskStatus.FAILED);
            this.result = String.format("Failed due to dependent task '%s' failed", dependency);
            this.done();
            return false;
        }
        return true;
    }

    protected TaskCallable<V> callable() {
        return this.callable;
    }

    protected void status(TaskStatus status) {
        this.status = status;
    }

    protected void property(String key, Object value) {
        E.checkNotNull((Object)key, (String)"property key");
        switch (key) {
            case "~task_type": {
                this.type = (String)value;
                break;
            }
            case "~task_name": {
                this.name = (String)value;
                break;
            }
            case "~task_callable": {
                break;
            }
            case "~task_status": {
                this.status(SerialEnum.fromCode(TaskStatus.class, (Byte)value));
                break;
            }
            case "~task_progress": {
                this.progress = (Integer)value;
                break;
            }
            case "~task_create": {
                this.create = (Date)value;
                break;
            }
            case "~task_retries": {
                this.retries = (Integer)value;
                break;
            }
            case "~task_description": {
                this.description = (String)value;
                break;
            }
            case "~task_update": {
                this.update = (Date)value;
                break;
            }
            case "~task_dependencies": {
                Set values = (Set)value;
                this.dependencies = values.stream().map(IdGenerator::of).collect(HugeTask.toOrderSet());
                break;
            }
            case "~task_input": {
                this.input = (String)value;
                break;
            }
            case "~task_result": {
                this.result = (String)value;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported key: " + key));
            }
        }
    }

    protected Object[] asArray() {
        E.checkState((this.type != null ? 1 : 0) != 0, (String)"Task type can't be null", (Object[])new Object[0]);
        E.checkState((this.name != null ? 1 : 0) != 0, (String)"Task name can't be null", (Object[])new Object[0]);
        ArrayList<Object> list = new ArrayList<Object>(28);
        list.add(T.label);
        list.add(P.TASK);
        list.add(T.id);
        list.add(this.id);
        list.add("~task_type");
        list.add(this.type);
        list.add("~task_name");
        list.add(this.name);
        list.add("~task_callable");
        list.add(this.callable.getClass().getName());
        list.add("~task_status");
        list.add(this.status.code());
        list.add("~task_progress");
        list.add(this.progress);
        list.add("~task_create");
        list.add(this.create);
        list.add("~task_retries");
        list.add(this.retries);
        if (this.description != null) {
            list.add("~task_description");
            list.add(this.description);
        }
        if (this.update != null) {
            list.add("~task_update");
            list.add(this.update);
        }
        if (this.dependencies != null) {
            list.add("~task_dependencies");
            list.add(this.dependencies.stream().map(Id::asLong).collect(HugeTask.toOrderSet()));
        }
        if (this.input != null) {
            list.add("~task_input");
            list.add(this.input);
        }
        if (this.result != null) {
            list.add("~task_result");
            list.add(this.result);
        }
        return list.toArray();
    }

    public Map<String, Object> asMap() {
        return this.asMap(true);
    }

    public Map<String, Object> asMap(boolean withDetails) {
        E.checkState((this.type != null ? 1 : 0) != 0, (String)"Task type can't be null", (Object[])new Object[0]);
        E.checkState((this.name != null ? 1 : 0) != 0, (String)"Task name can't be null", (Object[])new Object[0]);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(Graph.Hidden.unHide((String)P.ID), this.id);
        map.put(Graph.Hidden.unHide((String)"~task_type"), this.type);
        map.put(Graph.Hidden.unHide((String)"~task_name"), this.name);
        map.put(Graph.Hidden.unHide((String)"~task_callable"), this.callable.getClass().getName());
        map.put(Graph.Hidden.unHide((String)"~task_status"), this.status.string());
        map.put(Graph.Hidden.unHide((String)"~task_progress"), this.progress);
        map.put(Graph.Hidden.unHide((String)"~task_create"), this.create);
        map.put(Graph.Hidden.unHide((String)"~task_retries"), this.retries);
        if (this.description != null) {
            map.put(Graph.Hidden.unHide((String)"~task_description"), this.description);
        }
        if (this.update != null) {
            map.put(Graph.Hidden.unHide((String)"~task_update"), this.update);
        }
        if (this.dependencies != null) {
            Set<V> value = this.dependencies.stream().map(Id::asLong).collect(HugeTask.toOrderSet());
            map.put(Graph.Hidden.unHide((String)"~task_dependencies"), value);
        }
        if (withDetails && this.input != null) {
            map.put(Graph.Hidden.unHide((String)"~task_input"), this.input);
        }
        if (withDetails && this.result != null) {
            map.put(Graph.Hidden.unHide((String)"~task_result"), this.result);
        }
        return map;
    }

    public static <V> HugeTask<V> fromVertex(Vertex vertex) {
        TaskCallable callable;
        String callableName = (String)vertex.value("~task_callable");
        try {
            callable = TaskCallable.fromClass(callableName);
        }
        catch (Exception e) {
            callable = TaskCallable.empty(e);
        }
        HugeTask task = new HugeTask((Id)vertex.id(), null, callable);
        Iterator itor = vertex.properties(new String[0]);
        while (itor.hasNext()) {
            VertexProperty prop = (VertexProperty)itor.next();
            task.property(prop.key(), prop.value());
        }
        return task;
    }

    private static <V> Collector<V, ?, Set<V>> toOrderSet() {
        return Collectors.toCollection(InsertionOrderUtil::newSet);
    }

    public static final class P {
        public static final String TASK = Graph.Hidden.hide((String)"task");
        public static final String ID = T.id.getAccessor();
        public static final String LABEL = T.label.getAccessor();
        public static final String TYPE = "~task_type";
        public static final String NAME = "~task_name";
        public static final String CALLABLE = "~task_callable";
        public static final String DESCRIPTION = "~task_description";
        public static final String STATUS = "~task_status";
        public static final String PROGRESS = "~task_progress";
        public static final String CREATE = "~task_create";
        public static final String UPDATE = "~task_update";
        public static final String RETRIES = "~task_retries";
        public static final String INPUT = "~task_input";
        public static final String RESULT = "~task_result";
        public static final String DEPENDENCIES = "~task_dependencies";

        public static String hide(String key) {
            return Graph.Hidden.hide((String)("task_" + key));
        }

        public static String unhide(String key) {
            String prefix = Graph.Hidden.hide((String)"task_");
            if (key.startsWith(prefix)) {
                return key.substring(prefix.length());
            }
            return key;
        }
    }
}

