/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.task;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.task.HugeTask;
import com.baidu.hugegraph.task.TaskScheduler;
import com.baidu.hugegraph.util.E;
import java.util.concurrent.Callable;

public abstract class TaskCallable<V>
implements Callable<V> {
    private TaskScheduler scheduler = null;
    private HugeTask<V> task = null;

    protected void done() {
    }

    protected void cancelled() {
    }

    public HugeGraph graph() {
        return this.scheduler().graph();
    }

    protected void scheduler(TaskScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public TaskScheduler scheduler() {
        E.checkState((this.scheduler != null ? 1 : 0) != 0, (String)"Can't call scheduler() before scheduling task", (Object[])new Object[0]);
        return this.scheduler;
    }

    protected void task(HugeTask<V> task) {
        this.task = task;
    }

    public HugeTask<V> task() {
        E.checkState((this.task != null ? 1 : 0) != 0, (String)"Can't call task() before scheduling task", (Object[])new Object[0]);
        return this.task;
    }

    public static <V> TaskCallable<V> fromClass(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return (TaskCallable)clazz.newInstance();
        }
        catch (Exception e) {
            throw new HugeException("Failed to load task: %s", (Throwable)e, className);
        }
    }

    public static <V> TaskCallable<V> empty(final Exception e) {
        return new TaskCallable<V>(){

            @Override
            public V call() throws Exception {
                throw e;
            }
        };
    }
}

