/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.task;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.task.TaskScheduler;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.ExecutorUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TaskManager {
    public static final String TASK_WORKER = "task-worker-%d";
    public static final String TASK_DB_WORKER = "task-db-worker-%d";
    private static final int THREADS = 4;
    private static final TaskManager MANAGER = new TaskManager(4);
    private final Map<HugeGraph, TaskScheduler> schedulers = new HashMap<HugeGraph, TaskScheduler>();
    private final ExecutorService taskExecutor;
    private final ExecutorService dbExecutor;

    public static TaskManager instance() {
        return MANAGER;
    }

    private TaskManager(int pool) {
        this.taskExecutor = ExecutorUtil.newFixedThreadPool((int)pool, (String)TASK_WORKER);
        this.dbExecutor = ExecutorUtil.newFixedThreadPool((int)1, (String)TASK_DB_WORKER);
    }

    public void addScheduler(HugeGraph graph) {
        E.checkArgumentNotNull((Object)graph, (String)"The graph can't be null", (Object[])new Object[0]);
        ExecutorService task = this.taskExecutor;
        ExecutorService db = this.dbExecutor;
        this.schedulers.put(graph, new TaskScheduler(graph, task, db));
    }

    public void closeScheduler(HugeGraph graph) {
        TaskScheduler scheduler = this.schedulers.get(graph);
        if (scheduler != null && scheduler.close()) {
            this.schedulers.remove(graph);
        }
        this.closeTaskTx(graph);
    }

    private void closeTaskTx(HugeGraph graph) {
        ConcurrentHashMap threadsTimes = new ConcurrentHashMap();
        ArrayList<Callable<Void>> tasks = new ArrayList<Callable<Void>>();
        Callable<Void> closeTx = () -> {
            Thread current = Thread.currentThread();
            threadsTimes.putIfAbsent(current, 0);
            int times = (Integer)threadsTimes.get(current);
            if (times == 0) {
                graph.closeTx();
                Thread.yield();
            } else {
                assert (times < 4);
                assert (threadsTimes.size() < 4);
                E.checkState((tasks.size() == 4 ? 1 : 0) != 0, (String)"Bad tasks size: %s", (Object[])new Object[]{tasks.size()});
                this.taskExecutor.invokeAny(tasks.subList(0, 1));
            }
            threadsTimes.put(current, ++times);
            return null;
        };
        for (int i = 0; i < 4; ++i) {
            tasks.add(closeTx);
        }
        try {
            this.taskExecutor.invokeAll(tasks);
        }
        catch (Exception e) {
            throw new HugeException("Exception when closing task tx", e);
        }
    }

    public TaskScheduler getScheduler(HugeGraph graph) {
        return this.schedulers.get(graph);
    }

    public void shutdown(long timeout) {
        Throwable ex = null;
        assert (this.schedulers.isEmpty()) : this.schedulers.size();
        if (!this.taskExecutor.isShutdown()) {
            this.taskExecutor.shutdown();
            try {
                this.taskExecutor.awaitTermination(timeout, TimeUnit.SECONDS);
            }
            catch (Throwable e) {
                ex = e;
            }
        }
        if (!this.dbExecutor.isShutdown()) {
            this.dbExecutor.shutdown();
            try {
                this.dbExecutor.awaitTermination(timeout, TimeUnit.SECONDS);
            }
            catch (Throwable e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw new HugeException("Failed to wait for TaskScheduler", ex);
        }
    }

    public int workerPoolSize() {
        return ((ThreadPoolExecutor)this.taskExecutor).getCorePoolSize();
    }

    public int pendingTasks() {
        int size = 0;
        for (TaskScheduler scheduler : this.schedulers.values()) {
            size += scheduler.pendingTasks();
        }
        return size;
    }
}

