/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.traversal.optimize;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.query.ConditionQuery;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.traversal.optimize.QueryHolder;
import com.baidu.hugegraph.traversal.optimize.TraversalUtil;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.slf4j.Logger;

public final class HugeGraphStep<S, E extends Element>
extends GraphStep<S, E>
implements QueryHolder {
    private static final long serialVersionUID = -679873894532085972L;
    private static final Logger LOG = Log.logger(HugeGraphStep.class);
    private final List<HasContainer> hasContainers = new ArrayList<HasContainer>();
    private final Query queryInfo = new Query(HugeType.UNKNOWN);
    private Iterator<E> lastTimeResults = null;

    public HugeGraphStep(GraphStep<S, E> originGraphStep) {
        super(originGraphStep.getTraversal(), originGraphStep.getReturnClass(), originGraphStep.isStartStep(), originGraphStep.getIds());
        originGraphStep.getLabels().forEach(arg_0 -> ((HugeGraphStep)this).addLabel(arg_0));
        boolean queryVertex = this.returnsVertex();
        boolean queryEdge = this.returnsEdge();
        assert (queryVertex || queryEdge);
        this.setIteratorSupplier(() -> {
            Iterator<E> results = queryVertex ? this.vertices() : this.edges();
            this.lastTimeResults = results;
            return results;
        });
    }

    private Iterator<E> vertices() {
        LOG.debug("HugeGraphStep.vertices(): {}", (Object)this);
        HugeGraph graph = (HugeGraph)this.getTraversal().getGraph().get();
        if (this.ids != null && this.ids.length > 0) {
            return TraversalUtil.filterResult(this.hasContainers, graph.vertices(this.ids));
        }
        Query query = null;
        if (this.hasContainers.isEmpty()) {
            query = new Query(HugeType.VERTEX);
        } else {
            ConditionQuery q = new ConditionQuery(HugeType.VERTEX);
            query = TraversalUtil.fillConditionQuery(this.hasContainers, q, graph);
        }
        query = this.injectQueryInfo(query);
        Iterator<Vertex> result = graph.vertices(query);
        return result;
    }

    private Iterator<E> edges() {
        LOG.debug("HugeGraphStep.edges(): {}", (Object)this);
        HugeGraph graph = (HugeGraph)this.getTraversal().getGraph().get();
        if (this.ids != null && this.ids.length > 0) {
            return TraversalUtil.filterResult(this.hasContainers, graph.edges(this.ids));
        }
        Query query = null;
        if (this.hasContainers.isEmpty()) {
            query = new Query(HugeType.EDGE);
        } else {
            ConditionQuery q = new ConditionQuery(HugeType.EDGE);
            query = TraversalUtil.fillConditionQuery(this.hasContainers, q, graph);
        }
        query = this.injectQueryInfo(query);
        Iterator<Edge> result = graph.edges(query);
        return result;
    }

    public String toString() {
        if (this.hasContainers.isEmpty()) {
            return super.toString();
        }
        return this.ids.length == 0 ? StringFactory.stepString((Step)this, (Object[])new Object[]{this.returnClass.getSimpleName(), this.hasContainers}) : StringFactory.stepString((Step)this, (Object[])new Object[]{this.returnClass.getSimpleName(), Arrays.toString(this.ids), this.hasContainers});
    }

    public List<HasContainer> getHasContainers() {
        return Collections.unmodifiableList(this.hasContainers);
    }

    public void addHasContainer(HasContainer has) {
        if ("~page".equals(has.getKey())) {
            this.setPage((String)has.getValue());
            return;
        }
        this.hasContainers.add(has);
    }

    @Override
    public Query queryInfo() {
        return this.queryInfo;
    }

    @Override
    public Iterator<?> lastTimeResults() {
        return this.lastTimeResults;
    }

    public int hashCode() {
        return super.hashCode() ^ this.queryInfo.hashCode() ^ this.hasContainers.hashCode();
    }
}

