/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.traversal.optimize;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.query.ConditionQuery;
import com.baidu.hugegraph.backend.tx.GraphTransaction;
import com.baidu.hugegraph.rest.ClientException;
import com.baidu.hugegraph.schema.SchemaLabel;
import com.baidu.hugegraph.structure.HugeEdge;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.Directions;
import com.baidu.hugegraph.util.E;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.tinkerpop.gremlin.structure.Edge;

public class HugeTraverser {
    private HugeGraph graph;
    public static final List<Id> PATH_NONE = ImmutableList.of();
    public static final long NO_LIMIT = -1L;

    public HugeTraverser(HugeGraph graph) {
        this.graph = graph;
    }

    public List<Id> shortestPath(Id sourceV, Id targetV, Directions dir, String label, int maxDepth, long degree, long capacity) {
        List<Id> path;
        E.checkNotNull((Object)sourceV, (String)"source vertex id");
        E.checkNotNull((Object)targetV, (String)"target vertex id");
        E.checkNotNull((Object)dir, (String)"direction");
        HugeTraverser.checkPositive(maxDepth, "Shortest path max depth");
        HugeTraverser.checkDegree(degree);
        HugeTraverser.checkCapacity(capacity);
        if (sourceV.equals(targetV)) {
            return ImmutableList.of((Object)sourceV);
        }
        Id labelId = this.getEdgeLabelId(label);
        ShortestPathTraverser traverser = new ShortestPathTraverser(sourceV, targetV, dir, labelId, degree, capacity);
        while ((path = traverser.forward()) == PATH_NONE && --maxDepth > 0 && !traverser.reachCapacity()) {
            path = traverser.backward();
            if (path == PATH_NONE && --maxDepth > 0 && !traverser.reachCapacity()) continue;
            Collections.reverse(path);
            break;
        }
        return path;
    }

    public Set<Path> paths(Id sourceV, Directions sourceDir, Id targetV, Directions targetDir, String label, int maxDepth, long degree, long capacity, long limit) {
        E.checkNotNull((Object)sourceV, (String)"source vertex id");
        E.checkNotNull((Object)targetV, (String)"target vertex id");
        E.checkNotNull((Object)sourceDir, (String)"source direction");
        E.checkNotNull((Object)targetDir, (String)"target direction");
        E.checkArgument((sourceDir == targetDir || sourceDir == targetDir.opposite() ? 1 : 0) != 0, (String)"Source direction must equal to target direction,or opposite to target direction", (Object[])new Object[0]);
        HugeTraverser.checkPositive(maxDepth, "Paths max depth");
        HugeTraverser.checkDegree(degree);
        HugeTraverser.checkCapacity(capacity);
        HugeTraverser.checkLimit(limit);
        HashSet<Path> paths = new HashSet<Path>();
        if (sourceV.equals(targetV)) {
            paths.add(new Path(sourceV, (List<Id>)ImmutableList.of((Object)sourceV)));
        }
        Id labelId = this.getEdgeLabelId(label);
        PathsTraverser traverser = new PathsTraverser(sourceV, targetV, labelId, degree, capacity, limit);
        while (--maxDepth >= 0 && !traverser.reachLimit()) {
            List<Path> foundPaths = traverser.forward(sourceDir);
            paths.addAll(foundPaths);
            if (--maxDepth < 0 || traverser.reachLimit()) break;
            foundPaths = traverser.backward(targetDir);
            for (Path path : foundPaths) {
                path.reverse();
                paths.add(path);
            }
        }
        return paths;
    }

    public List<Path> rays(Id sourceV, Directions dir, String label, int maxDepth, long degree, long capacity, long limit) {
        return this.subGraphPaths(sourceV, dir, label, maxDepth, degree, capacity, limit, false);
    }

    public List<Path> rings(Id sourceV, Directions dir, String label, int maxDepth, long degree, long capacity, long limit) {
        return this.subGraphPaths(sourceV, dir, label, maxDepth, degree, capacity, limit, true);
    }

    private List<Path> subGraphPaths(Id sourceV, Directions dir, String label, int maxDepth, long degree, long capacity, long limit, boolean rings) {
        E.checkNotNull((Object)sourceV, (String)"source vertex id");
        E.checkNotNull((Object)dir, (String)"direction");
        HugeTraverser.checkPositive(maxDepth, "Paths max depth");
        HugeTraverser.checkDegree(degree);
        HugeTraverser.checkCapacity(capacity);
        HugeTraverser.checkLimit(limit);
        Id labelId = this.getEdgeLabelId(label);
        SubGraphTraverser traverser = new SubGraphTraverser(sourceV, labelId, degree, capacity, limit, rings);
        ArrayList<Path> paths = new ArrayList<Path>();
        do {
            paths.addAll(traverser.forward(dir));
        } while (--maxDepth >= 0 && !traverser.reachLimit() && !traverser.finished());
        return paths;
    }

    public Set<Id> kout(Id sourceV, Directions dir, String label, int depth, boolean nearest, long degree, long capacity, long limit) {
        long remaining;
        E.checkNotNull((Object)sourceV, (String)"source vertex id");
        E.checkNotNull((Object)dir, (String)"direction");
        HugeTraverser.checkPositive(depth, "K-out depth");
        HugeTraverser.checkDegree(degree);
        HugeTraverser.checkCapacity(capacity);
        HugeTraverser.checkLimit(limit);
        if (capacity != -1L) {
            E.checkArgument((capacity > limit && limit != -1L ? 1 : 0) != 0, (String)"Capacity must be greater than limit, but got capacity '%s' and limit '%s'", (Object[])new Object[]{capacity, limit});
        }
        Id labelId = this.getEdgeLabelId(label);
        Set<Id> latest = HugeTraverser.newSet();
        latest.add(sourceV);
        Set<Id> all = HugeTraverser.newSet();
        all.add(sourceV);
        long l = remaining = capacity == -1L ? -1L : capacity - (long)latest.size();
        while (depth-- > 0) {
            if (depth == 0 && limit != -1L && (limit < remaining || remaining == -1L)) {
                remaining = limit;
            }
            if (nearest) {
                latest = this.adjacentVertices(latest, dir, labelId, all, degree, remaining);
                all.addAll(latest);
            } else {
                latest = this.adjacentVertices(latest, dir, labelId, null, degree, remaining);
            }
            if (capacity == -1L || (remaining -= (long)latest.size()) > 0L || depth <= 0) continue;
            throw new ClientException("Reach limit '%s' while remaining depth '%s'", new Object[]{limit, depth});
        }
        return latest;
    }

    public Set<Id> kneighbor(Id sourceV, Directions dir, String label, int depth, long degree, long limit) {
        E.checkNotNull((Object)sourceV, (String)"source vertex id");
        E.checkNotNull((Object)dir, (String)"direction");
        HugeTraverser.checkPositive(depth, "K-neighbor depth");
        HugeTraverser.checkDegree(degree);
        HugeTraverser.checkLimit(limit);
        Id labelId = this.getEdgeLabelId(label);
        Set<Id> latest = HugeTraverser.newSet();
        latest.add(sourceV);
        Set<Id> all = HugeTraverser.newSet();
        all.add(sourceV);
        while (depth-- > 0) {
            long remaining = limit == -1L ? -1L : limit - (long)all.size();
            latest = this.adjacentVertices(latest, dir, labelId, all, degree, remaining);
            all.addAll(latest);
            if (limit == -1L || (long)all.size() < limit) continue;
            break;
        }
        return all;
    }

    private Set<Id> adjacentVertices(Set<Id> vertices, Directions dir, Id label, Set<Id> excluded, long degree, long limit) {
        if (limit == 0L) {
            return ImmutableSet.of();
        }
        Set<Id> neighbors = HugeTraverser.newSet();
        for (Id source : vertices) {
            Iterator<Edge> edges = this.edgesOfVertex(source, dir, label, degree);
            while (edges.hasNext()) {
                HugeEdge e = (HugeEdge)edges.next();
                Id target = e.id().otherVertexId();
                if (excluded != null && excluded.contains(target)) continue;
                neighbors.add(target);
                if (limit == -1L || (long)neighbors.size() < limit) continue;
                return neighbors;
            }
        }
        return neighbors;
    }

    private Iterator<Edge> edgesOfVertex(Id source, Directions dir, Id label, long limit) {
        Id[] labels = new Id[]{};
        if (label != null) {
            labels = new Id[]{label};
        }
        ConditionQuery query = GraphTransaction.constructEdgesQuery(source, dir, labels);
        if (limit != -1L) {
            query.limit(limit);
        }
        return this.graph.edges(query);
    }

    private Id getEdgeLabelId(Object label) {
        if (label == null) {
            return null;
        }
        return SchemaLabel.getLabelId(this.graph, HugeType.EDGE, label);
    }

    private static void checkPositive(int value, String name) {
        E.checkArgument((value > 0 ? 1 : 0) != 0, (String)"%s must be > 0, but got '%s'", (Object[])new Object[]{name, value});
    }

    private static void checkDegree(long degree) {
        HugeTraverser.checkLimit(degree, "Degree");
    }

    private static void checkCapacity(long capacity) {
        HugeTraverser.checkLimit(capacity, "Capacity");
    }

    private static void checkLimit(long limit) {
        HugeTraverser.checkLimit(limit, "Limit");
    }

    private static void checkLimit(long value, String name) {
        E.checkArgument((value > 0L || value == -1L ? 1 : 0) != 0, (String)"%s must be > 0 or == %s, but got: %s", (Object[])new Object[]{name, -1L, value});
    }

    private static <V> Set<V> newSet() {
        return new HashSet();
    }

    private static <K, V> Map<K, V> newMap() {
        return new HashMap();
    }

    private static <K, V> MultivaluedMap<K, V> newMultivalueMap() {
        return new MultivaluedHashMap();
    }

    static /* synthetic */ Set access$700() {
        return HugeTraverser.newSet();
    }

    public static class Path {
        private Id crosspoint;
        private List<Id> vertices;

        public Path(Id crosspoint, List<Id> vertices) {
            this.crosspoint = crosspoint;
            this.vertices = vertices;
        }

        public Id crosspoint() {
            return this.crosspoint;
        }

        public List<Id> vertices() {
            return this.vertices;
        }

        public void reverse() {
            Collections.reverse(this.vertices);
        }

        public Map<String, Object> toMap(boolean withCrossPoint) {
            if (withCrossPoint) {
                return ImmutableMap.of((Object)"crosspoint", (Object)this.crosspoint, (Object)"objects", this.vertices);
            }
            return ImmutableMap.of((Object)"objects", this.vertices);
        }

        public int hashCode() {
            return this.vertices.hashCode();
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof Path)) {
                return false;
            }
            return this.vertices.equals(((Path)other).vertices);
        }
    }

    private static class Node {
        private Id id;
        private Node parent;

        public Node(Id id) {
            this(id, null);
        }

        public Node(Id id, Node parent) {
            E.checkArgumentNotNull((Object)id, (String)"Id of Node can't be null", (Object[])new Object[0]);
            this.id = id;
            this.parent = parent;
        }

        public Id id() {
            return this.id;
        }

        public Node parent() {
            return this.parent;
        }

        public List<Id> path() {
            ArrayList<Id> ids = new ArrayList<Id>();
            Node current = this;
            do {
                ids.add(current.id);
            } while ((current = current.parent) != null);
            Collections.reverse(ids);
            return ids;
        }

        public List<Id> joinPath(Node back) {
            List<Id> path = this.path();
            List<Id> backPath = back.path();
            Collections.reverse(backPath);
            if (CollectionUtils.containsAny(path, backPath)) {
                return ImmutableList.of();
            }
            path.addAll(backPath);
            return path;
        }

        public boolean contains(Id id) {
            Node node = this;
            do {
                if (!node.id.equals(id)) continue;
                return true;
            } while ((node = node.parent) != null);
            return false;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Node)) {
                return false;
            }
            Node other = (Node)object;
            return this.id.equals(other.id);
        }
    }

    private class SubGraphTraverser {
        private MultivaluedMap<Id, Node> sources = HugeTraverser.access$600();
        private Set<Id> accessedVertices = HugeTraverser.access$700();
        private final Id label;
        private final long degree;
        private final long capacity;
        private final long limit;
        private final boolean rings;
        private long pathCount;

        public SubGraphTraverser(Id sourceV, Id label, long degree, long capacity, long limit, boolean rings) {
            this.sources.add((Object)sourceV, (Object)new Node(sourceV));
            this.accessedVertices.add(sourceV);
            this.label = label;
            this.degree = degree;
            this.capacity = capacity;
            this.limit = limit;
            this.rings = rings;
            this.pathCount = 0L;
        }

        public List<Path> forward(Directions direction) {
            ArrayList<Path> paths = new ArrayList<Path>();
            MultivaluedMap newVertices = HugeTraverser.newMultivalueMap();
            for (List nodes : this.sources.values()) {
                for (Node n : nodes) {
                    Iterator edges = HugeTraverser.this.edgesOfVertex(n.id(), direction, this.label, this.degree);
                    if (!edges.hasNext()) {
                        if (this.rings) continue;
                        paths.add(new Path(null, n.path()));
                        ++this.pathCount;
                        if (!this.reachLimit()) continue;
                        return paths;
                    }
                    while (edges.hasNext()) {
                        HugeEdge edge = (HugeEdge)edges.next();
                        Id target = edge.id().otherVertexId();
                        this.accessedVertices.add(target);
                        if (!n.contains(target)) {
                            newVertices.add((Object)target, (Object)new Node(target, n));
                            continue;
                        }
                        if (!this.rings) continue;
                        assert (n.contains(target));
                        List<Id> prePath = n.path();
                        prePath.add(target);
                        paths.add(new Path(null, prePath));
                        ++this.pathCount;
                        if (!this.reachLimit()) continue;
                        return paths;
                    }
                }
            }
            this.sources = newVertices;
            return paths;
        }

        private boolean reachLimit() {
            if (this.capacity != -1L && (long)this.accessedVertices.size() > this.capacity) {
                return true;
            }
            return this.limit != -1L && this.pathCount >= this.limit;
        }

        private boolean finished() {
            return this.sources.isEmpty();
        }
    }

    private class PathsTraverser {
        private MultivaluedMap<Id, Node> sources = HugeTraverser.access$600();
        private MultivaluedMap<Id, Node> targets = HugeTraverser.access$600();
        private MultivaluedMap<Id, Node> sourcesAll = HugeTraverser.access$600();
        private MultivaluedMap<Id, Node> targetsAll = HugeTraverser.access$600();
        private final Id label;
        private final long degree;
        private final long capacity;
        private final long limit;
        private long count;

        public PathsTraverser(Id sourceV, Id targetV, Id label, long degree, long capacity, long limit) {
            this.sources.add((Object)sourceV, (Object)new Node(sourceV));
            this.targets.add((Object)targetV, (Object)new Node(targetV));
            this.sourcesAll.putAll(this.sources);
            this.targetsAll.putAll(this.targets);
            this.label = label;
            this.degree = degree;
            this.capacity = capacity;
            this.limit = limit;
            this.count = 0L;
        }

        public List<Path> forward(Directions direction) {
            ArrayList<Path> paths = new ArrayList<Path>();
            MultivaluedMap newVertices = HugeTraverser.newMultivalueMap();
            for (List nodes : this.sources.values()) {
                for (Node n : nodes) {
                    Iterator edges = HugeTraverser.this.edgesOfVertex(n.id(), direction, this.label, this.degree);
                    while (edges.hasNext()) {
                        HugeEdge edge = (HugeEdge)edges.next();
                        Id target = edge.id().otherVertexId();
                        if (n.contains(target)) continue;
                        if (this.targetsAll.containsKey((Object)target)) {
                            for (Node node : (List)this.targetsAll.get((Object)target)) {
                                List<Id> path = n.joinPath(node);
                                if (path.isEmpty()) continue;
                                paths.add(new Path(target, path));
                                ++this.count;
                                if (!this.reachLimit()) continue;
                                return paths;
                            }
                        }
                        newVertices.add((Object)target, (Object)new Node(target, n));
                    }
                }
            }
            this.sources = newVertices;
            this.sourcesAll.putAll((Map)newVertices);
            return paths;
        }

        public List<Path> backward(Directions direction) {
            ArrayList<Path> paths = new ArrayList<Path>();
            MultivaluedMap newVertices = HugeTraverser.newMultivalueMap();
            for (List nodes : this.targets.values()) {
                for (Node n : nodes) {
                    Iterator edges = HugeTraverser.this.edgesOfVertex(n.id(), direction, this.label, this.degree);
                    while (edges.hasNext()) {
                        HugeEdge edge = (HugeEdge)edges.next();
                        Id target = edge.id().otherVertexId();
                        if (n.contains(target)) continue;
                        if (this.sourcesAll.containsKey((Object)target)) {
                            for (Node node : (List)this.sourcesAll.get((Object)target)) {
                                List<Id> path = n.joinPath(node);
                                if (path.isEmpty()) continue;
                                paths.add(new Path(target, path));
                                ++this.count;
                                if (!this.reachLimit()) continue;
                                return paths;
                            }
                        }
                        newVertices.add((Object)target, (Object)new Node(target, n));
                    }
                }
            }
            this.targets = newVertices;
            this.targetsAll.putAll((Map)newVertices);
            return paths;
        }

        private int accessedNodes() {
            return this.sourcesAll.size() + this.targetsAll.size();
        }

        private boolean reachLimit() {
            if (this.capacity != -1L && (long)this.accessedNodes() > this.capacity) {
                return true;
            }
            return this.limit != -1L && this.count >= this.limit;
        }
    }

    private class ShortestPathTraverser {
        private Map<Id, Node> sources = HugeTraverser.access$400();
        private Map<Id, Node> targets = HugeTraverser.access$400();
        private final Directions direction;
        private final Id label;
        private final long degree;
        private final long capacity;
        private long size;

        public ShortestPathTraverser(Id sourceV, Id targetV, Directions dir, Id label, long degree, long capacity) {
            this.sources.put(sourceV, new Node(sourceV));
            this.targets.put(targetV, new Node(targetV));
            this.direction = dir;
            this.label = label;
            this.degree = degree;
            this.capacity = capacity;
            this.size = 0L;
        }

        public List<Id> forward() {
            Map newVertices = HugeTraverser.newMap();
            for (Node v : this.sources.values()) {
                Iterator edges = HugeTraverser.this.edgesOfVertex(v.id(), this.direction, this.label, this.degree);
                while (edges.hasNext()) {
                    HugeEdge edge = (HugeEdge)edges.next();
                    Id target = edge.id().otherVertexId();
                    if (this.targets.containsKey(target)) {
                        return v.joinPath(this.targets.get(target));
                    }
                    if (newVertices.containsKey(target) || this.sources.containsKey(target) || v.contains(target)) continue;
                    newVertices.put(target, new Node(target, v));
                }
            }
            this.sources = newVertices;
            this.size += (long)newVertices.size();
            return PATH_NONE;
        }

        public List<Id> backward() {
            Map newVertices = HugeTraverser.newMap();
            Directions opposite = this.direction.opposite();
            for (Node v : this.targets.values()) {
                Iterator edges = HugeTraverser.this.edgesOfVertex(v.id(), opposite, this.label, this.degree);
                while (edges.hasNext()) {
                    HugeEdge edge = (HugeEdge)edges.next();
                    Id target = edge.id().otherVertexId();
                    if (this.sources.containsKey(target)) {
                        return v.joinPath(this.sources.get(target));
                    }
                    if (newVertices.containsKey(target) || this.targets.containsKey(target) || v.contains(target)) continue;
                    newVertices.put(target, new Node(target, v));
                }
            }
            this.targets = newVertices;
            this.size += (long)newVertices.size();
            return PATH_NONE;
        }

        private boolean reachCapacity() {
            return this.capacity != -1L && this.size >= this.capacity;
        }
    }
}

