/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.traversal.optimize;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.query.Condition;
import com.baidu.hugegraph.backend.query.ConditionQuery;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.iterator.FilterIterator;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.schema.SchemaLabel;
import com.baidu.hugegraph.structure.HugeEdge;
import com.baidu.hugegraph.structure.HugeVertex;
import com.baidu.hugegraph.traversal.optimize.HugeGraphStep;
import com.baidu.hugegraph.traversal.optimize.HugeVertexStep;
import com.baidu.hugegraph.traversal.optimize.QueryHolder;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.Directions;
import com.baidu.hugegraph.type.define.HugeKeys;
import com.baidu.hugegraph.util.E;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.Contains;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.HasContainerHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.CountGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.NoOpBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.OrderGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ElementValueComparator;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public final class TraversalUtil {
    public static void extractHasContainer(HugeGraphStep<?, ?> newStep, Traversal.Admin<?, ?> traversal) {
        Step step = newStep;
        do {
            if (!((step = step.getNextStep()) instanceof HasStep)) continue;
            HasContainerHolder holder = (HasContainerHolder)step;
            for (HasContainer has : holder.getHasContainers()) {
                if (GraphStep.processHasContainerIds((GraphStep)newStep, (HasContainer)has)) continue;
                newStep.addHasContainer(has);
            }
            TraversalHelper.copyLabels((Step)step, (Step)step.getPreviousStep(), (boolean)false);
            traversal.removeStep(step);
        } while (step instanceof HasStep || step instanceof NoOpBarrierStep);
    }

    public static void extractHasContainer(HugeVertexStep<?> newStep, Traversal.Admin<?, ?> traversal) {
        Step step = newStep;
        do {
            if (!(step instanceof HasStep)) continue;
            HasContainerHolder holder = (HasContainerHolder)step;
            for (HasContainer has : holder.getHasContainers()) {
                newStep.addHasContainer(has);
            }
            TraversalHelper.copyLabels((Step)step, (Step)step.getPreviousStep(), (boolean)false);
            traversal.removeStep(step);
        } while ((step = step.getNextStep()) instanceof HasStep || step instanceof NoOpBarrierStep);
    }

    public static void extractOrder(Step<?, ?> newStep, Traversal.Admin<?, ?> traversal) {
        Step step = newStep;
        do {
            if (!((step = step.getNextStep()) instanceof OrderGlobalStep)) continue;
            QueryHolder holder = (QueryHolder)newStep;
            OrderGlobalStep orderStep = (OrderGlobalStep)step;
            orderStep.getComparators().forEach(comp -> {
                ElementValueComparator comparator = (ElementValueComparator)comp.getValue1();
                holder.orderBy(comparator.getPropertyKey(), (Order)comparator.getValueComparator());
            });
            TraversalHelper.copyLabels((Step)step, (Step)newStep, (boolean)false);
            traversal.removeStep(step);
        } while ((step = step.getNextStep()) instanceof OrderGlobalStep || step instanceof IdentityStep);
    }

    public static void extractRange(Step<?, ?> newStep, Traversal.Admin<?, ?> traversal, boolean extractOnlyLimit) {
        QueryHolder holder = (QueryHolder)newStep;
        Step step = newStep;
        do {
            if (!((step = step.getNextStep()) instanceof RangeGlobalStep)) continue;
            RangeGlobalStep range = (RangeGlobalStep)step;
            if (extractOnlyLimit) {
                holder.setRange(0L, range.getHighRange());
                continue;
            }
            long limit = holder.setRange(range.getLowRange(), range.getHighRange());
            RangeGlobalStep newRange = new RangeGlobalStep(traversal, 0L, limit);
            TraversalHelper.replaceStep((Step)range, (Step)newRange, traversal);
        } while (step instanceof RangeGlobalStep || step instanceof IdentityStep || step instanceof NoOpBarrierStep);
    }

    public static void extractCount(Step<?, ?> newStep, Traversal.Admin<?, ?> traversal) {
        Step step = newStep;
        do {
            if (!((step = step.getNextStep()) instanceof CountGlobalStep)) continue;
            QueryHolder holder = (QueryHolder)newStep;
            holder.setCount();
        } while (step instanceof CountGlobalStep || step instanceof FilterStep || step instanceof IdentityStep || step instanceof NoOpBarrierStep);
    }

    public static ConditionQuery fillConditionQuery(List<HasContainer> hasContainers, ConditionQuery query, HugeGraph graph) {
        HugeType resultType = query.resultType();
        for (HasContainer has : hasContainers) {
            Condition condition = TraversalUtil.convHas2Condition(has, resultType, graph);
            query.query(condition);
        }
        return query;
    }

    public static Condition convHas2Condition(HasContainer has, HugeType type, HugeGraph graph) {
        Condition condition;
        P p = has.getPredicate();
        E.checkArgument((p != null ? 1 : 0) != 0, (String)"The predicate of has(%s) is null", (Object[])new Object[]{has});
        BiPredicate bp = p.getBiPredicate();
        if (TraversalUtil.keyForContainsKeyOrValue(has.getKey())) {
            condition = TraversalUtil.convContains2Relation(graph, has);
        } else if (bp instanceof Compare) {
            condition = TraversalUtil.convCompare2Relation(graph, type, has);
        } else if (bp instanceof Condition.RelationType) {
            condition = TraversalUtil.convRelationType2Relation(graph, type, has);
        } else if (bp instanceof Contains) {
            condition = TraversalUtil.convIn2Relation(graph, type, has);
        } else if (p instanceof AndP) {
            condition = TraversalUtil.convAnd(graph, type, has);
        } else if (p instanceof OrP) {
            condition = TraversalUtil.convOr(graph, type, has);
        } else {
            throw TraversalUtil.newUnsupportedPredicate(p);
        }
        return condition;
    }

    public static Condition convAnd(HugeGraph graph, HugeType type, HasContainer has) {
        P p = has.getPredicate();
        assert (p instanceof AndP);
        List predicates = ((AndP)p).getPredicates();
        if (predicates.size() < 2) {
            throw TraversalUtil.newUnsupportedPredicate(p);
        }
        Condition cond = null;
        for (P predicate : predicates) {
            HasContainer newHas = new HasContainer(has.getKey(), predicate);
            Condition newCond = TraversalUtil.convHas2Condition(newHas, type, graph);
            if (cond == null) {
                cond = newCond;
                continue;
            }
            cond = Condition.and(newCond, cond);
        }
        return cond;
    }

    public static Condition convOr(HugeGraph graph, HugeType type, HasContainer has) {
        P p = has.getPredicate();
        assert (p instanceof OrP);
        List predicates = ((OrP)p).getPredicates();
        if (predicates.size() < 2) {
            throw TraversalUtil.newUnsupportedPredicate(p);
        }
        Condition cond = null;
        for (P predicate : predicates) {
            HasContainer newHas = new HasContainer(has.getKey(), predicate);
            Condition newCond = TraversalUtil.convHas2Condition(newHas, type, graph);
            if (cond == null) {
                cond = newCond;
                continue;
            }
            cond = Condition.or(newCond, cond);
        }
        return cond;
    }

    private static Condition.Relation convCompare2Relation(HugeGraph graph, HugeType type, HasContainer has) {
        assert (type.isGraph());
        BiPredicate bp = has.getPredicate().getBiPredicate();
        assert (bp instanceof Compare);
        boolean isSyspropKey = true;
        try {
            TraversalUtil.string2HugeKey(has.getKey());
        }
        catch (IllegalArgumentException ignored) {
            isSyspropKey = false;
        }
        return isSyspropKey ? TraversalUtil.convCompare2SyspropRelation(graph, type, has) : TraversalUtil.convCompare2UserpropRelation(graph, type, has);
    }

    private static Condition.Relation convCompare2SyspropRelation(HugeGraph graph, HugeType type, HasContainer has) {
        BiPredicate bp = has.getPredicate().getBiPredicate();
        assert (bp instanceof Compare);
        HugeKeys key = TraversalUtil.string2HugeKey(has.getKey());
        Object value = TraversalUtil.convSysValueIfNeeded(graph, type, key, has.getValue());
        switch ((Compare)bp) {
            case eq: {
                return Condition.eq(key, value);
            }
            case gt: {
                return Condition.gt(key, value);
            }
            case gte: {
                return Condition.gte(key, value);
            }
            case lt: {
                return Condition.lt(key, value);
            }
            case lte: {
                return Condition.lte(key, value);
            }
            case neq: {
                return Condition.neq(key, value);
            }
        }
        throw TraversalUtil.newUnsupportedPredicate(has.getPredicate());
    }

    private static Condition.Relation convCompare2UserpropRelation(HugeGraph graph, HugeType type, HasContainer has) {
        BiPredicate bp = has.getPredicate().getBiPredicate();
        assert (bp instanceof Compare);
        String key = has.getKey();
        PropertyKey pkey = graph.propertyKey(key);
        Id pkeyId = pkey.id();
        Object value = TraversalUtil.validPredicateValue(has.getValue(), pkey);
        switch ((Compare)bp) {
            case eq: {
                return Condition.eq(pkeyId, value);
            }
            case gt: {
                return Condition.gt(pkeyId, value);
            }
            case gte: {
                return Condition.gte(pkeyId, value);
            }
            case lt: {
                return Condition.lt(pkeyId, value);
            }
            case lte: {
                return Condition.lte(pkeyId, value);
            }
            case neq: {
                return Condition.neq(pkeyId, value);
            }
        }
        throw TraversalUtil.newUnsupportedPredicate(has.getPredicate());
    }

    private static Condition convRelationType2Relation(HugeGraph graph, HugeType type, HasContainer has) {
        assert (type.isGraph());
        BiPredicate bp = has.getPredicate().getBiPredicate();
        assert (bp instanceof Condition.RelationType);
        String key = has.getKey();
        PropertyKey pkey = graph.propertyKey(key);
        Id pkeyId = pkey.id();
        Object value = TraversalUtil.validPredicateValue(has.getValue(), pkey);
        return new Condition.UserpropRelation(pkeyId, (Condition.RelationType)bp, value);
    }

    public static Condition convIn2Relation(HugeGraph graph, HugeType type, HasContainer has) {
        BiPredicate bp = has.getPredicate().getBiPredicate();
        assert (bp instanceof Contains);
        List<?> values = (List<?>)has.getValue();
        try {
            String originKey = has.getKey();
            if (values.size() > 1) {
                E.checkArgument((!originKey.equals(T.key) && !originKey.equals(T.value) ? 1 : 0) != 0, (String)"Not support hasKey() or hasValue() with multiple values", (Object[])new Object[0]);
            }
            HugeKeys key = TraversalUtil.string2HugeKey(originKey);
            values = TraversalUtil.convSysListValueIfNeeded(graph, type, key, values);
            switch ((Contains)bp) {
                case within: {
                    return Condition.in(key, values);
                }
                case without: {
                    return Condition.nin(key, values);
                }
            }
        }
        catch (IllegalArgumentException e) {
            String key = has.getKey();
            PropertyKey pkey = graph.propertyKey(key);
            switch ((Contains)bp) {
                case within: {
                    return Condition.in(pkey.id(), values);
                }
                case without: {
                    return Condition.nin(pkey.id(), values);
                }
            }
        }
        throw TraversalUtil.newUnsupportedPredicate(has.getPredicate());
    }

    public static Condition convContains2Relation(HugeGraph graph, HasContainer has) {
        BiPredicate bp = has.getPredicate().getBiPredicate();
        E.checkArgument((bp == Compare.eq ? 1 : 0) != 0, (String)"CONTAINS query with relation '%s' is not supported", (Object[])new Object[]{bp});
        HugeKeys key = TraversalUtil.string2HugeKey(has.getKey());
        Object value = has.getValue();
        if (TraversalUtil.keyForContainsKey(has.getKey())) {
            if (value instanceof String) {
                value = graph.propertyKey((String)value).id();
            }
            return Condition.containsKey(key, value);
        }
        assert (TraversalUtil.keyForContainsValue(has.getKey()));
        return Condition.contains(key, value);
    }

    public static BackendException newUnsupportedPredicate(P<?> predicate) {
        return new BackendException("Unsupported predicate: '%s'", predicate);
    }

    public static HugeKeys string2HugeKey(String key) {
        if (key.equals(T.label.getAccessor())) {
            return HugeKeys.LABEL;
        }
        if (key.equals(T.id.getAccessor())) {
            return HugeKeys.ID;
        }
        if (TraversalUtil.keyForContainsKeyOrValue(key)) {
            return HugeKeys.PROPERTIES;
        }
        return HugeKeys.valueOf(key);
    }

    public static boolean keyForContainsKeyOrValue(String key) {
        return key.equals(T.key.getAccessor()) || key.equals(T.value.getAccessor());
    }

    public static boolean keyForContainsKey(String key) {
        return key.equals(T.key.getAccessor());
    }

    public static boolean keyForContainsValue(String key) {
        return key.equals(T.value.getAccessor());
    }

    public static <V> Iterator<V> filterResult(List<HasContainer> hasContainers, Iterator<? extends Element> iterator) {
        FilterIterator result = new FilterIterator(iterator, elem -> HasContainer.testAll((Element)elem, (List)hasContainers));
        return result;
    }

    public static void convAllHasSteps(Traversal.Admin<?, ?> traversal) {
        List steps = TraversalHelper.getStepsOfAssignableClassRecursively(HasStep.class, traversal);
        HugeGraph graph = (HugeGraph)traversal.getGraph().get();
        for (HasStep step : steps) {
            TraversalUtil.convHasStep(graph, step);
        }
    }

    public static void convHasStep(HugeGraph graph, HasStep<?> step) {
        HasStep<?> holder = step;
        for (HasContainer has : holder.getHasContainers()) {
            TraversalUtil.convPredicateValue(graph, has);
        }
    }

    private static void convPredicateValue(HugeGraph graph, HasContainer has) {
        if (TraversalUtil.isSysProp(has.getKey())) {
            return;
        }
        PropertyKey pkey = graph.propertyKey(has.getKey());
        ArrayList<P<Object>> leafPredicates = new ArrayList<P<Object>>();
        TraversalUtil.collectPredicates(leafPredicates, ImmutableList.of((Object)has.getPredicate()));
        for (P p : leafPredicates) {
            Object value = TraversalUtil.validPredicateValue(p.getValue(), pkey);
            p.setValue(value);
        }
    }

    private static boolean isSysProp(String key) {
        if ("~page".equals(key)) {
            return true;
        }
        try {
            TraversalUtil.string2HugeKey(key);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static void collectPredicates(List<P<Object>> results, List<P<?>> predicates) {
        for (P<?> p : predicates) {
            if (p instanceof ConnectiveP) {
                TraversalUtil.collectPredicates(results, ((ConnectiveP)p).getPredicates());
                continue;
            }
            results.add(p);
        }
    }

    private static Object convSysValueIfNeeded(HugeGraph graph, HugeType type, HugeKeys key, Object value) {
        if (key == HugeKeys.LABEL && !(value instanceof Id)) {
            value = SchemaLabel.getLabelId(graph, type, value);
        } else if (key == HugeKeys.ID && !(value instanceof Id)) {
            value = type.isVertex() ? HugeVertex.getIdValue(value) : HugeEdge.getIdValue(value);
        }
        return value;
    }

    private static List<?> convSysListValueIfNeeded(HugeGraph graph, HugeType type, HugeKeys key, List<?> values) {
        ArrayList<Object> newValues = new ArrayList<Object>(values.size());
        for (Object value : values) {
            newValues.add(TraversalUtil.convSysValueIfNeeded(graph, type, key, value));
        }
        return newValues;
    }

    public static Iterator<Edge> filterResult(Vertex vertex, Directions dir, Iterator<Edge> edges) {
        ArrayList<Edge> list = new ArrayList<Edge>();
        while (edges.hasNext()) {
            Edge edge = edges.next();
            if ((dir != Directions.OUT || !vertex.equals(edge.outVertex())) && (dir != Directions.IN || !vertex.equals(edge.inVertex()))) continue;
            list.add(edge);
        }
        return list.iterator();
    }

    public static Query.Order convOrder(Order order) {
        return order == Order.decr ? Query.Order.DESC : Query.Order.ASC;
    }

    private static <V> V validPredicateValue(V value, PropertyKey pkey) {
        V validValue = pkey.convValue(value, false);
        E.checkArgumentNotNull(validValue, (String)"Invalid data type of query value, expect '%s', actual '%s'", (Object[])new Object[]{pkey.dataType().clazz(), value.getClass()});
        return validValue;
    }

    public static void retriveSysprop(List<HasContainer> hasContainers, Function<HasContainer, Boolean> func) {
        Iterator<HasContainer> itor = hasContainers.iterator();
        while (itor.hasNext()) {
            HasContainer container = itor.next();
            if (!container.getKey().startsWith("~") || !func.apply(container).booleanValue()) continue;
            itor.remove();
        }
    }

    public static String page(GraphTraversal<?, ?> traversal) {
        QueryHolder holder = TraversalUtil.rootStep(traversal);
        E.checkState((holder != null ? 1 : 0) != 0, (String)"Invalid traversal: %s", (Object[])new Object[]{traversal});
        return (String)holder.metadata("page", new Object[0]);
    }

    public static QueryHolder rootStep(GraphTraversal<?, ?> traversal) {
        for (Step step : traversal.asAdmin().getSteps()) {
            if (!(step instanceof QueryHolder)) continue;
            return (QueryHolder)step;
        }
        return null;
    }
}

