/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.type;

import com.baidu.hugegraph.type.define.SerialEnum;
import java.util.HashMap;
import java.util.Map;

public final class HugeType
extends Enum<HugeType>
implements SerialEnum {
    public static final /* enum */ HugeType UNKNOWN = new HugeType(0, "UNKNOWN");
    public static final /* enum */ HugeType VERTEX_LABEL = new HugeType(1, "VL");
    public static final /* enum */ HugeType EDGE_LABEL = new HugeType(2, "EL");
    public static final /* enum */ HugeType PROPERTY_KEY = new HugeType(3, "PK");
    public static final /* enum */ HugeType INDEX_LABEL = new HugeType(4, "IL");
    public static final /* enum */ HugeType VERTEX = new HugeType(101, "V");
    public static final /* enum */ HugeType SYS_PROPERTY = new HugeType(102, "S");
    public static final /* enum */ HugeType PROPERTY = new HugeType(103, "U");
    public static final /* enum */ HugeType EDGE = new HugeType(120, "E");
    public static final /* enum */ HugeType EDGE_OUT = new HugeType(130, "O");
    public static final /* enum */ HugeType EDGE_IN = new HugeType(140, "I");
    public static final /* enum */ HugeType SECONDARY_INDEX = new HugeType(150, "SI");
    public static final /* enum */ HugeType RANGE_INDEX = new HugeType(160, "RI");
    public static final /* enum */ HugeType SEARCH_INDEX = new HugeType(170, "FI");
    public static final /* enum */ HugeType TASK = new HugeType(180, "T");
    public static final /* enum */ HugeType SYS_SCHEMA = new HugeType(250, "SS");
    public static final /* enum */ HugeType MAX_TYPE = new HugeType(255, "~");
    private byte type = 0;
    private String name;
    private static final Map<String, HugeType> ALL_NAME;
    private static final /* synthetic */ HugeType[] $VALUES;

    public static HugeType[] values() {
        return (HugeType[])$VALUES.clone();
    }

    public static HugeType valueOf(String name) {
        return Enum.valueOf(HugeType.class, name);
    }

    private HugeType(int type, String name) {
        assert (type < 256);
        this.type = (byte)type;
        this.name = name;
    }

    @Override
    public byte code() {
        return this.type;
    }

    public String string() {
        return this.name;
    }

    public boolean isSchema() {
        return this == VERTEX_LABEL || this == EDGE_LABEL || this == PROPERTY_KEY || this == INDEX_LABEL;
    }

    public boolean isGraph() {
        return this.isVertex() || this.isEdge();
    }

    public boolean isVertex() {
        return this == VERTEX;
    }

    public boolean isEdge() {
        return this == EDGE || this == EDGE_OUT || this == EDGE_IN;
    }

    public boolean isIndex() {
        return this == SECONDARY_INDEX || this == SEARCH_INDEX || this == RANGE_INDEX;
    }

    public boolean isStringIndex() {
        return this == SECONDARY_INDEX || this == SEARCH_INDEX;
    }

    public boolean isSecondaryIndex() {
        return this == SECONDARY_INDEX;
    }

    public boolean isSearchIndex() {
        return this == SEARCH_INDEX;
    }

    public boolean isRangeIndex() {
        return this == RANGE_INDEX;
    }

    public static HugeType fromString(String type) {
        return ALL_NAME.get(type);
    }

    static {
        $VALUES = new HugeType[]{UNKNOWN, VERTEX_LABEL, EDGE_LABEL, PROPERTY_KEY, INDEX_LABEL, VERTEX, SYS_PROPERTY, PROPERTY, EDGE, EDGE_OUT, EDGE_IN, SECONDARY_INDEX, RANGE_INDEX, SEARCH_INDEX, TASK, SYS_SCHEMA, MAX_TYPE};
        ALL_NAME = new HashMap<String, HugeType>();
        SerialEnum.register(HugeType.class);
        for (HugeType type : HugeType.values()) {
            ALL_NAME.put(type.name, type);
        }
    }
}

