/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.type.define;

import com.baidu.hugegraph.io.HugeGraphSONModule;
import com.baidu.hugegraph.type.define.SerialEnum;
import com.baidu.hugegraph.util.E;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.UUID;

public final class DataType
extends Enum<DataType>
implements SerialEnum {
    public static final /* enum */ DataType OBJECT = new DataType(1, "object", Serializable.class);
    public static final /* enum */ DataType BOOLEAN = new DataType(2, "boolean", Boolean.class);
    public static final /* enum */ DataType BYTE = new DataType(3, "byte", Byte.class);
    public static final /* enum */ DataType INT = new DataType(4, "int", Integer.class);
    public static final /* enum */ DataType LONG = new DataType(5, "long", Long.class);
    public static final /* enum */ DataType FLOAT = new DataType(6, "float", Float.class);
    public static final /* enum */ DataType DOUBLE = new DataType(7, "double", Double.class);
    public static final /* enum */ DataType TEXT = new DataType(8, "text", String.class);
    public static final /* enum */ DataType BLOB = new DataType(9, "blob", byte[].class);
    public static final /* enum */ DataType DATE = new DataType(10, "date", Date.class);
    public static final /* enum */ DataType UUID = new DataType(11, "uuid", UUID.class);
    private byte code = 0;
    private String name = null;
    private Class<?> clazz = null;
    private static final /* synthetic */ DataType[] $VALUES;

    public static DataType[] values() {
        return (DataType[])$VALUES.clone();
    }

    public static DataType valueOf(String name) {
        return Enum.valueOf(DataType.class, name);
    }

    private DataType(int code, String name, Class<?> clazz) {
        assert (code < 256);
        this.code = (byte)code;
        this.name = name;
        this.clazz = clazz;
    }

    @Override
    public byte code() {
        return this.code;
    }

    public String string() {
        return this.name;
    }

    public Class<?> clazz() {
        return this.clazz;
    }

    public boolean isText() {
        return this == TEXT;
    }

    public boolean isNumber() {
        return this == BYTE || this == INT || this == LONG || this == FLOAT || this == DOUBLE;
    }

    public boolean isDate() {
        return this == DATE;
    }

    public boolean isUUID() {
        return this == UUID;
    }

    public <V> Number valueToNumber(V value) {
        if (!this.isNumber() || !(value instanceof Number)) {
            return null;
        }
        if (this.clazz.isInstance(value)) {
            return (Number)value;
        }
        Number number = null;
        try {
            switch (this) {
                case BYTE: {
                    number = Byte.valueOf(value.toString());
                    break;
                }
                case INT: {
                    number = Integer.valueOf(value.toString());
                    break;
                }
                case LONG: {
                    number = Long.valueOf(value.toString());
                    break;
                }
                case FLOAT: {
                    number = Float.valueOf(value.toString());
                    break;
                }
                case DOUBLE: {
                    number = Double.valueOf(value.toString());
                    break;
                }
                default: {
                    throw new AssertionError((Object)String.format("Number type only contains Byte, Integer, Long, Float, Double, but got %s", this.clazz()));
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return number;
    }

    public <V> Date valueToDate(V value) {
        if (value instanceof Date) {
            return (Date)value;
        }
        if (this.isDate()) {
            if (value instanceof Number) {
                return new Date(((Number)value).longValue());
            }
            if (value instanceof String) {
                try {
                    return HugeGraphSONModule.DATE_FORMAT.parse((String)value);
                }
                catch (ParseException e) {
                    E.checkArgument((boolean)false, (String)"%s, expect format: %s", (Object[])new Object[]{e.getMessage(), HugeGraphSONModule.DATE_FORMAT.toPattern()});
                }
            }
        }
        return null;
    }

    public <V> UUID valueToUUID(V value) {
        if (value instanceof UUID) {
            return (UUID)value;
        }
        if (this.isUUID() && value instanceof String) {
            return java.util.UUID.fromString((String)value);
        }
        return null;
    }

    static {
        $VALUES = new DataType[]{OBJECT, BOOLEAN, BYTE, INT, LONG, FLOAT, DOUBLE, TEXT, BLOB, DATE, UUID};
        SerialEnum.register(DataType.class);
    }
}

