/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.util;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.util.JsonUtil;
import com.baidu.hugegraph.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public final class CopyUtil {
    public static <T> T cloneObject(T o, T clone) throws Exception {
        if (clone == null) {
            clone = o.getClass().newInstance();
        }
        for (Field field : o.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            Object childObj = field.get(o);
            if (childObj == null || Modifier.isFinal(field.getModifiers())) continue;
            Class<?> declareType = field.getType();
            Class<?> valueType = childObj.getClass();
            if (ReflectionUtil.isSimpleType(declareType) || ReflectionUtil.isSimpleType(valueType)) {
                field.set(clone, field.get(o));
                continue;
            }
            if (childObj == o) {
                field.set(clone, clone);
                continue;
            }
            field.set(clone, CopyUtil.cloneObject(field.get(o), null));
        }
        return clone;
    }

    public static <T> T copy(T object) {
        return CopyUtil.copy(object, null);
    }

    public static <T> T copy(T object, T clone) {
        try {
            return CopyUtil.cloneObject(object, clone);
        }
        catch (Exception e) {
            throw new HugeException("Failed to clone object", e);
        }
    }

    public static <T> T deepCopy(T object) {
        Class<?> cls = object.getClass();
        return (T)JsonUtil.fromJson(JsonUtil.toJson(object), cls);
    }
}

