/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.util;

import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.util.E;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Date;

public final class JsonUtil {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static void registerModule(Module module) {
        mapper.registerModule(module);
    }

    public static String toJson(Object object) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new BackendException(e);
        }
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        E.checkState((json != null ? 1 : 0) != 0, (String)"Json value can't be null for '%s'", (Object[])new Object[]{clazz.getSimpleName()});
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new BackendException(e);
        }
    }

    public static <T> T fromJson(String json, TypeReference<?> typeRef) {
        E.checkState((json != null ? 1 : 0) != 0, (String)"Json value can't be null for '%s'", (Object[])new Object[]{typeRef.getType()});
        try {
            ObjectReader reader = mapper.readerFor(typeRef);
            return (T)reader.readValue(json);
        }
        catch (IOException e) {
            throw new BackendException(e);
        }
    }

    public static Object castNumber(Object object, Class<?> clazz) {
        if (object instanceof Number) {
            Number number = (Number)object;
            if (clazz == Byte.class) {
                object = number.byteValue();
            } else if (clazz == Integer.class) {
                object = number.intValue();
            } else if (clazz == Long.class) {
                object = number.longValue();
            } else if (clazz == Float.class) {
                object = Float.valueOf(number.floatValue());
            } else assert (clazz == Double.class);
        }
        return object;
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addSerializer(Date.class, (JsonSerializer)new DateSerializer());
        module.addDeserializer(Date.class, (JsonDeserializer)new DateDeserializer());
        mapper.registerModule((Module)module);
    }

    private static class DateDeserializer
    extends StdDeserializer<Date> {
        private static final long serialVersionUID = 1209944821349424949L;

        public DateDeserializer() {
            super(Date.class);
        }

        public Date deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            Long number = (Long)jsonParser.readValueAs(Long.class);
            return new Date(number);
        }
    }

    private static class DateSerializer
    extends StdSerializer<Date> {
        private static final long serialVersionUID = -6615155657857746161L;

        public DateSerializer() {
            super(Date.class);
        }

        public void serialize(Date date, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            jsonGenerator.writeNumber(date.getTime());
        }
    }
}

