/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.util;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.concurrent.LockManager;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;

public final class LockUtil {
    private static final Logger LOG = Log.logger(LockUtil.class);
    public static final String WRITE = "write";
    public static final String READ = "read";
    public static final String INDEX_LABEL_DELETE = "il_delete";
    public static final String EDGE_LABEL_DELETE = "el_delete";
    public static final String VERTEX_LABEL_DELETE = "vl_delete";
    public static final String INDEX_LABEL_REBUILD = "il_rebuild";
    public static final String INDEX_LABEL_ADD_UPDATE = "il_add_update";
    public static final String EDGE_LABEL_ADD_UPDATE = "el_add_update";
    public static final String VERTEX_LABEL_ADD_UPDATE = "vl_add_update";
    public static final String PROPERTY_KEY_ADD_UPDATE = "pk_add_update";
    public static final long WRITE_WAIT_TIMEOUT = 30L;

    public static void init(String graph) {
        LockManager.instance().create(LockUtil.join(graph, INDEX_LABEL_DELETE));
        LockManager.instance().create(LockUtil.join(graph, EDGE_LABEL_DELETE));
        LockManager.instance().create(LockUtil.join(graph, VERTEX_LABEL_DELETE));
        LockManager.instance().create(LockUtil.join(graph, INDEX_LABEL_REBUILD));
        LockManager.instance().create(LockUtil.join(graph, INDEX_LABEL_ADD_UPDATE));
        LockManager.instance().create(LockUtil.join(graph, EDGE_LABEL_ADD_UPDATE));
        LockManager.instance().create(LockUtil.join(graph, VERTEX_LABEL_ADD_UPDATE));
        LockManager.instance().create(LockUtil.join(graph, PROPERTY_KEY_ADD_UPDATE));
    }

    public static void destroy(String graph) {
        LockManager.instance().destroy(LockUtil.join(graph, INDEX_LABEL_DELETE));
        LockManager.instance().destroy(LockUtil.join(graph, EDGE_LABEL_DELETE));
        LockManager.instance().destroy(LockUtil.join(graph, VERTEX_LABEL_DELETE));
        LockManager.instance().destroy(LockUtil.join(graph, INDEX_LABEL_REBUILD));
        LockManager.instance().destroy(LockUtil.join(graph, INDEX_LABEL_ADD_UPDATE));
        LockManager.instance().destroy(LockUtil.join(graph, EDGE_LABEL_ADD_UPDATE));
        LockManager.instance().destroy(LockUtil.join(graph, VERTEX_LABEL_ADD_UPDATE));
        LockManager.instance().destroy(LockUtil.join(graph, PROPERTY_KEY_ADD_UPDATE));
    }

    private static String join(String graph, String group) {
        return graph + "_" + group;
    }

    private static Lock lockRead(String group, String lock) {
        Lock readLock = LockManager.instance().get(group).readWriteLock(lock).readLock();
        LOG.debug("Trying to get the read lock '{}' of LockGroup '{}'", (Object)lock, (Object)group);
        if (!readLock.tryLock()) {
            throw new HugeException("Lock [%s:%s] is locked by other operation", group, lock);
        }
        LOG.debug("Got the read lock '{}' of LockGroup '{}'", (Object)lock, (Object)group);
        return readLock;
    }

    private static Lock lockWrite(String group, String lock, long time) {
        Lock writeLock = LockManager.instance().get(group).readWriteLock(lock).writeLock();
        LOG.debug("Trying to get the write lock '{}' of LockGroup '{}'", (Object)lock, (Object)group);
        while (true) {
            try {
                if (!writeLock.tryLock(time, TimeUnit.SECONDS)) {
                    throw new HugeException("Lock [%s:%s] is locked by other operation", group, lock);
                }
            }
            catch (InterruptedException ignore) {
                LOG.info("Trying to lock write of is interrupted!");
                continue;
            }
            break;
        }
        LOG.debug("Got the write lock '{}' of LockGroup '{}'", (Object)lock, (Object)group);
        return writeLock;
    }

    public static List<Lock> lock(String ... locks) {
        ArrayList<Lock> lockList = new ArrayList<Lock>();
        E.checkArgument((locks.length % 3 == 0 ? 1 : 0) != 0, (String)"Invalid arguments number, expect multiple of 3.", (Object[])new Object[0]);
        block8: for (int i = 0; i < locks.length; i += 3) {
            switch (locks[i]) {
                case "write": {
                    lockList.add(LockUtil.lockWrite(locks[i + 1], locks[i + 2], 30L));
                    continue block8;
                }
                case "read": {
                    lockList.add(LockUtil.lockRead(locks[i + 1], locks[i + 2]));
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Invalid args '%s' at position '%s', expect 'write' or 'read'", locks[i], i));
                }
            }
        }
        return lockList;
    }

    public static String hugeType2Group(HugeType type) {
        switch (type) {
            case PROPERTY_KEY: {
                return PROPERTY_KEY_ADD_UPDATE;
            }
            case VERTEX_LABEL: {
                return VERTEX_LABEL_ADD_UPDATE;
            }
            case EDGE_LABEL: {
                return EDGE_LABEL_ADD_UPDATE;
            }
            case INDEX_LABEL: {
                return INDEX_LABEL_ADD_UPDATE;
            }
        }
        throw new AssertionError((Object)String.format("Invalid HugeType '%s'", type));
    }

    public static class LocksTable {
        private Map<String, Set<Id>> table = new HashMap<String, Set<Id>>();
        private Locks locks;

        public LocksTable(String graph) {
            this.locks = new Locks(graph);
        }

        public void lockReads(String group, Id ... locks) {
            this.lockReads(group, Arrays.asList(locks));
        }

        public void lockReads(String group, Collection<Id> locks) {
            ArrayList<Id> newLocks = new ArrayList<Id>(locks.size());
            for (Id lock : locks) {
                Set<Id> locked = this.locksOfGroup(group);
                if (locked.contains(lock)) continue;
                newLocks.add(lock);
            }
            this.locks.lockReads(group, newLocks);
        }

        public void unlock() {
            this.locks.unlock();
        }

        private Set<Id> locksOfGroup(String group) {
            if (!this.table.containsKey(group)) {
                this.table.putIfAbsent(group, new HashSet());
            }
            return this.table.get(group);
        }
    }

    public static class Locks {
        private final String graph;
        private final List<Lock> lockList;

        public Locks(String graph) {
            this.graph = graph;
            this.lockList = new ArrayList<Lock>();
        }

        public void lockReads(String group, Id ... locks) {
            for (Id lock : locks) {
                this.lockList.add(this.lockRead(group, lock));
            }
        }

        public void lockReads(String group, Collection<Id> locks) {
            for (Id lock : locks) {
                this.lockList.add(this.lockRead(group, lock));
            }
        }

        private Lock lockRead(String group, Id lock) {
            return LockUtil.lockRead(LockUtil.join(this.graph, group), lock.asString());
        }

        public void lockWrites(String group, Id ... locks) {
            for (Id lock : locks) {
                this.lockList.add(this.lockWrite(group, lock));
            }
        }

        public void lockWrites(String group, Collection<Id> locks) {
            for (Id lock : locks) {
                this.lockList.add(this.lockWrite(group, lock));
            }
        }

        private Lock lockWrite(String group, Id lock) {
            return LockUtil.lockWrite(LockUtil.join(this.graph, group), lock.asString(), 30L);
        }

        public void unlock() {
            Collections.reverse(this.lockList);
            for (Lock lock : this.lockList) {
                lock.unlock();
            }
            this.lockList.clear();
        }
    }
}

