/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.util;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.util.E;
import com.google.common.base.CharMatcher;
import java.io.UnsupportedEncodingException;

public final class StringEncoding {
    public static int writeAsciiString(byte[] array, int startPos, String attribute) {
        E.checkArgument((boolean)CharMatcher.ascii().matchesAllOf((CharSequence)attribute), (String)"'%s' must be ASCII string", (Object[])new Object[]{attribute});
        int len = attribute.length();
        if (len == 0) {
            array[startPos++] = -128;
            return startPos;
        }
        int i = 0;
        do {
            char c = attribute.charAt(i);
            assert (c <= '\u007f');
            byte b = (byte)c;
            if (++i == len) {
                b = (byte)(b | 0x80);
            }
            array[startPos++] = b;
        } while (i < len);
        return startPos;
    }

    public static String readAsciiString(byte[] array, int startPos) {
        StringBuilder sb = new StringBuilder();
        int c = 0;
        do {
            if ((c = 0xFF & array[startPos++]) == 128) continue;
            sb.append((char)(c & 0x7F));
        } while ((c & 0x80) <= 0);
        return sb.toString();
    }

    public static int getAsciiByteLength(String attribute) {
        E.checkArgument((boolean)CharMatcher.ascii().matchesAllOf((CharSequence)attribute), (String)"'%s' must be ASCII string", (Object[])new Object[]{attribute});
        return attribute.isEmpty() ? 1 : attribute.length();
    }

    public static byte[] encode(String value) {
        try {
            return value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new HugeException("Failed to encode string", e);
        }
    }

    public static String decode(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new HugeException("Failed to decode string", e);
        }
    }
}

