/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.util;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.backend.id.Id;
import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public final class StringUtil {
    public static String desc(String prefix, Collection<Id> elems) {
        StringBuilder sb = new StringBuilder();
        for (Id elem : elems) {
            sb.append("\"").append(elem.asString()).append("\",");
        }
        int endIdx = sb.lastIndexOf(",") > 0 ? sb.length() - 1 : sb.length();
        return String.format(".%s(%s)", prefix, sb.substring(0, endIdx));
    }

    public static String escape(char splitor, char escape, String ... values) {
        StringBuilder escaped = new StringBuilder(values.length + 1 << 4);
        for (String value : values) {
            if (escaped.length() > 0) {
                escaped.append(splitor);
            }
            if (value.indexOf(splitor) == -1) {
                escaped.append(value);
                continue;
            }
            int n = value.length();
            for (int i = 0; i < n; ++i) {
                char ch = value.charAt(i);
                if (ch == splitor) {
                    escaped.append(escape);
                }
                escaped.append(ch);
            }
        }
        return escaped.toString();
    }

    public static String[] unescape(String id, String splitor, String escape) {
        String[] parts = id.split("(?<!" + escape + ")" + splitor, -1);
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = StringUtils.replace((String)parts[i], (String)(escape + splitor), (String)splitor);
        }
        return parts;
    }

    public static Object valueOf(Class<? extends Object> clazz, String number) {
        try {
            Method valueOf = clazz.getMethod("valueOf", String.class);
            return valueOf.invoke(null, number);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new HugeException("Invalid number class: %s", (Throwable)e, clazz);
        }
        catch (Exception e) {
            throw new HugeException("Invalid value '%s' for number class: %s", (Throwable)e, number, clazz);
        }
    }
}

