/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.variables;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.query.Condition;
import com.baidu.hugegraph.backend.query.ConditionQuery;
import com.baidu.hugegraph.backend.tx.GraphTransaction;
import com.baidu.hugegraph.exception.NotFoundException;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.schema.SchemaManager;
import com.baidu.hugegraph.schema.VertexLabel;
import com.baidu.hugegraph.structure.HugeVertex;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.Cardinality;
import com.baidu.hugegraph.type.define.DataType;
import com.baidu.hugegraph.type.define.HugeKeys;
import com.baidu.hugegraph.util.Log;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.slf4j.Logger;

public class HugeVariables
implements Graph.Variables {
    private static final Logger LOG = Log.logger(HugeVariables.class);
    private static final String VARIABLES = "variables";
    private static final String VARIABLE_KEY = "variableKey";
    private static final String VARIABLE_TYPE = "variableType";
    private static final String BYTE_VALUE = "byteValue";
    private static final String BOOLEAN_VALUE = "booleanValue";
    private static final String INTEGER_VALUE = "integerValue";
    private static final String LONG_VALUE = "longValue";
    private static final String FLOAT_VALUE = "floatValue";
    private static final String DOUBLE_VALUE = "doubleValue";
    private static final String STRING_VALUE = "stringValue";
    private static final String UNIFORM_LIST = "UniformList";
    private static final String SET = "Set";
    private static final String[] TYPES = new String[]{Graph.Hidden.hide((String)"byteValue"), Graph.Hidden.hide((String)"booleanValue"), Graph.Hidden.hide((String)"integerValue"), Graph.Hidden.hide((String)"longValue"), Graph.Hidden.hide((String)"floatValue"), Graph.Hidden.hide((String)"doubleValue"), Graph.Hidden.hide((String)"stringValue"), Graph.Hidden.hide((String)"byteValueUniformList"), Graph.Hidden.hide((String)"booleanValueUniformList"), Graph.Hidden.hide((String)"integerValueUniformList"), Graph.Hidden.hide((String)"longValueUniformList"), Graph.Hidden.hide((String)"floatValueUniformList"), Graph.Hidden.hide((String)"doubleValueUniformList"), Graph.Hidden.hide((String)"stringValueUniformList"), Graph.Hidden.hide((String)"byteValueSet"), Graph.Hidden.hide((String)"booleanValueSet"), Graph.Hidden.hide((String)"integerValueSet"), Graph.Hidden.hide((String)"longValueSet"), Graph.Hidden.hide((String)"floatValueSet"), Graph.Hidden.hide((String)"doubleValueSet"), Graph.Hidden.hide((String)"stringValueSet")};
    private HugeGraph graph;

    public HugeVariables(HugeGraph graph) {
        this.graph = graph;
    }

    public void initSchema() {
        SchemaManager schema = this.graph.schema();
        try {
            schema.getVertexLabel(Graph.Hidden.hide((String)VARIABLES));
            return;
        }
        catch (NotFoundException ignored) {
            LOG.debug("Variables schema not exist, create them...");
            this.createPropertyKey(Graph.Hidden.hide((String)VARIABLE_KEY), DataType.TEXT, Cardinality.SINGLE);
            this.createPropertyKey(Graph.Hidden.hide((String)VARIABLE_TYPE), DataType.TEXT, Cardinality.SINGLE);
            this.createPropertyKey(Graph.Hidden.hide((String)BYTE_VALUE), DataType.BYTE, Cardinality.SINGLE);
            this.createPropertyKey(Graph.Hidden.hide((String)BOOLEAN_VALUE), DataType.BOOLEAN, Cardinality.SINGLE);
            this.createPropertyKey(Graph.Hidden.hide((String)INTEGER_VALUE), DataType.INT, Cardinality.SINGLE);
            this.createPropertyKey(Graph.Hidden.hide((String)LONG_VALUE), DataType.LONG, Cardinality.SINGLE);
            this.createPropertyKey(Graph.Hidden.hide((String)FLOAT_VALUE), DataType.FLOAT, Cardinality.SINGLE);
            this.createPropertyKey(Graph.Hidden.hide((String)DOUBLE_VALUE), DataType.DOUBLE, Cardinality.SINGLE);
            this.createPropertyKey(Graph.Hidden.hide((String)STRING_VALUE), DataType.TEXT, Cardinality.SINGLE);
            this.createPropertyKey(Graph.Hidden.hide((String)"byteValueUniformList"), DataType.BYTE, Cardinality.LIST);
            this.createPropertyKey(Graph.Hidden.hide((String)"booleanValueUniformList"), DataType.BOOLEAN, Cardinality.LIST);
            this.createPropertyKey(Graph.Hidden.hide((String)"integerValueUniformList"), DataType.INT, Cardinality.LIST);
            this.createPropertyKey(Graph.Hidden.hide((String)"longValueUniformList"), DataType.LONG, Cardinality.LIST);
            this.createPropertyKey(Graph.Hidden.hide((String)"floatValueUniformList"), DataType.FLOAT, Cardinality.LIST);
            this.createPropertyKey(Graph.Hidden.hide((String)"doubleValueUniformList"), DataType.DOUBLE, Cardinality.LIST);
            this.createPropertyKey(Graph.Hidden.hide((String)"stringValueUniformList"), DataType.TEXT, Cardinality.LIST);
            this.createPropertyKey(Graph.Hidden.hide((String)"byteValueSet"), DataType.BYTE, Cardinality.SET);
            this.createPropertyKey(Graph.Hidden.hide((String)"booleanValueSet"), DataType.BOOLEAN, Cardinality.SET);
            this.createPropertyKey(Graph.Hidden.hide((String)"integerValueSet"), DataType.INT, Cardinality.SET);
            this.createPropertyKey(Graph.Hidden.hide((String)"longValueSet"), DataType.LONG, Cardinality.SET);
            this.createPropertyKey(Graph.Hidden.hide((String)"floatValueSet"), DataType.FLOAT, Cardinality.SET);
            this.createPropertyKey(Graph.Hidden.hide((String)"doubleValueSet"), DataType.DOUBLE, Cardinality.SET);
            this.createPropertyKey(Graph.Hidden.hide((String)"stringValueSet"), DataType.TEXT, Cardinality.SET);
            Object[] properties = new String[]{Graph.Hidden.hide((String)VARIABLE_KEY), Graph.Hidden.hide((String)VARIABLE_TYPE)};
            properties = (String[])ArrayUtils.addAll((Object[])properties, (Object[])TYPES);
            VertexLabel variables = (VertexLabel)schema.vertexLabel(Graph.Hidden.hide((String)VARIABLES)).properties((String[])properties).usePrimaryKeyId().primaryKeys(Graph.Hidden.hide((String)VARIABLE_KEY)).nullableKeys(TYPES).build();
            this.graph.schemaTransaction().addVertexLabel(variables);
            LOG.debug("Variables schema created");
            return;
        }
    }

    private void createPropertyKey(String name, DataType dataType, Cardinality cardinality) {
        SchemaManager schema = this.graph.schema();
        PropertyKey propertyKey = (PropertyKey)schema.propertyKey(name).dataType(dataType).cardinality(cardinality).build();
        this.graph.schemaTransaction().addPropertyKey(propertyKey);
    }

    public Set<String> keys() {
        Iterator<Vertex> vertices = this.queryAllVariableVertices();
        HashSet<String> keys = new HashSet<String>();
        while (vertices.hasNext()) {
            keys.add((String)vertices.next().value(Graph.Hidden.hide((String)VARIABLE_KEY)));
        }
        return keys;
    }

    public <R> Optional<R> get(String key) {
        if (key == null) {
            throw Graph.Variables.Exceptions.variableKeyCanNotBeNull();
        }
        if (key.isEmpty()) {
            throw Graph.Variables.Exceptions.variableKeyCanNotBeEmpty();
        }
        HugeVertex vertex = this.queryVariableVertex(key);
        if (vertex == null) {
            return Optional.empty();
        }
        String type = (String)vertex.value(Graph.Hidden.hide((String)VARIABLE_TYPE));
        if (!Arrays.asList(TYPES).contains(Graph.Hidden.hide((String)type))) {
            throw Graph.Variables.Exceptions.dataTypeOfVariableValueNotSupported((Object)type);
        }
        return Optional.of(vertex.value(Graph.Hidden.hide((String)type)));
    }

    public void set(String key, Object value) {
        if (key == null) {
            throw Graph.Variables.Exceptions.variableKeyCanNotBeNull();
        }
        if (key.isEmpty()) {
            throw Graph.Variables.Exceptions.variableKeyCanNotBeEmpty();
        }
        if (value == null) {
            throw Graph.Variables.Exceptions.variableValueCanNotBeNull();
        }
        this.createVariableVertex(key, value);
    }

    public void remove(String key) {
        if (key == null) {
            throw Graph.Variables.Exceptions.variableKeyCanNotBeNull();
        }
        if (key.isEmpty()) {
            throw Graph.Variables.Exceptions.variableKeyCanNotBeEmpty();
        }
        HugeVertex vertex = this.queryVariableVertex(key);
        if (vertex != null) {
            this.removeVariableVertex(vertex);
        }
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        Iterator<Vertex> vertices = this.queryAllVariableVertices();
        while (vertices.hasNext()) {
            Vertex vertex = vertices.next();
            String key = (String)vertex.value(Graph.Hidden.hide((String)VARIABLE_KEY));
            String type = (String)vertex.value(Graph.Hidden.hide((String)VARIABLE_TYPE));
            if (!Arrays.asList(TYPES).contains(Graph.Hidden.hide((String)type))) {
                throw Graph.Variables.Exceptions.dataTypeOfVariableValueNotSupported((Object)type);
            }
            Object value = vertex.value(Graph.Hidden.hide((String)type));
            variables.put(key, value);
        }
        return Collections.unmodifiableMap(variables);
    }

    public String toString() {
        return StringFactory.graphVariablesString((Graph.Variables)this);
    }

    private void setProperty(HugeVertex vertex, String key, Object value) {
        String suffix = value instanceof List ? UNIFORM_LIST : (value instanceof Set ? SET : "");
        vertex.property(Graph.Hidden.hide((String)VARIABLE_KEY), key);
        Object object = HugeVariables.extractSingleObject(value);
        if (object == null) {
            vertex.property(Graph.Hidden.hide((String)(STRING_VALUE + suffix)), value);
            vertex.property(Graph.Hidden.hide((String)VARIABLE_TYPE), STRING_VALUE + suffix);
            return;
        }
        if (object instanceof Byte) {
            vertex.property(Graph.Hidden.hide((String)(BYTE_VALUE + suffix)), value);
            vertex.property(Graph.Hidden.hide((String)VARIABLE_TYPE), BYTE_VALUE + suffix);
        } else if (object instanceof Boolean) {
            vertex.property(Graph.Hidden.hide((String)(BOOLEAN_VALUE + suffix)), value);
            vertex.property(Graph.Hidden.hide((String)VARIABLE_TYPE), BOOLEAN_VALUE + suffix);
        } else if (object instanceof Integer) {
            vertex.property(Graph.Hidden.hide((String)(INTEGER_VALUE + suffix)), value);
            vertex.property(Graph.Hidden.hide((String)VARIABLE_TYPE), INTEGER_VALUE + suffix);
        } else if (object instanceof Long) {
            vertex.property(Graph.Hidden.hide((String)(LONG_VALUE + suffix)), value);
            vertex.property(Graph.Hidden.hide((String)VARIABLE_TYPE), LONG_VALUE + suffix);
        } else if (object instanceof Float) {
            vertex.property(Graph.Hidden.hide((String)(FLOAT_VALUE + suffix)), value);
            vertex.property(Graph.Hidden.hide((String)VARIABLE_TYPE), FLOAT_VALUE + suffix);
        } else if (object instanceof Double) {
            vertex.property(Graph.Hidden.hide((String)(DOUBLE_VALUE + suffix)), value);
            vertex.property(Graph.Hidden.hide((String)VARIABLE_TYPE), DOUBLE_VALUE + suffix);
        } else if (object instanceof String) {
            vertex.property(Graph.Hidden.hide((String)(STRING_VALUE + suffix)), value);
            vertex.property(Graph.Hidden.hide((String)VARIABLE_TYPE), STRING_VALUE + suffix);
        } else {
            throw Graph.Variables.Exceptions.dataTypeOfVariableValueNotSupported((Object)value);
        }
    }

    private void createVariableVertex(String key, Object value) {
        VertexLabel vl = this.graph.vertexLabel(Graph.Hidden.hide((String)VARIABLES));
        GraphTransaction tx = this.graph.graphTransaction();
        HugeVertex vertex = new HugeVertex(tx, null, vl);
        try {
            this.setProperty(vertex, key, value);
        }
        catch (IllegalArgumentException e) {
            throw Graph.Variables.Exceptions.dataTypeOfVariableValueNotSupported((Object)value);
        }
        vertex.assignId(null);
        tx.addVertex(vertex);
    }

    private void removeVariableVertex(HugeVertex vertex) {
        this.graph.graphTransaction().removeVertex(vertex);
    }

    private HugeVertex queryVariableVertex(String key) {
        ConditionQuery query = new ConditionQuery(HugeType.VERTEX);
        VertexLabel vl = this.graph.vertexLabel(Graph.Hidden.hide((String)VARIABLES));
        query.eq(HugeKeys.LABEL, vl.id());
        PropertyKey pkey = this.graph.propertyKey(Graph.Hidden.hide((String)VARIABLE_KEY));
        query.query(Condition.eq(pkey.id(), (Object)key));
        query.showHidden(true);
        Iterator<Vertex> vertices = this.graph.vertices(query);
        if (!vertices.hasNext()) {
            return null;
        }
        return (HugeVertex)vertices.next();
    }

    private Iterator<Vertex> queryAllVariableVertices() {
        ConditionQuery query = new ConditionQuery(HugeType.VERTEX);
        VertexLabel vl = this.graph.vertexLabel(Graph.Hidden.hide((String)VARIABLES));
        query.eq(HugeKeys.LABEL, vl.id());
        query.showHidden(true);
        return this.graph.vertices(query);
    }

    private static Object extractSingleObject(Object value) {
        if (value instanceof List || value instanceof Set) {
            Collection collection = (Collection)value;
            if (collection.isEmpty()) {
                return null;
            }
            value = collection.iterator().next();
        }
        return value;
    }
}

