/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.creator.druid;

import com.alibaba.druid.filter.stat.StatFilter;
import com.baomidou.dynamic.datasource.toolkit.DsConfigUtil;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DruidStatConfigUtil {
    private static final Logger log = LoggerFactory.getLogger(DruidStatConfigUtil.class);
    private static final Map<String, Method> METHODS = DsConfigUtil.getSetterMethods(StatFilter.class);

    public static StatFilter toStatFilter(Map<String, Object> c, Map<String, Object> g) {
        StatFilter filter = new StatFilter();
        Map<String, Object> map = DsConfigUtil.mergeMap(c, g);
        for (Map.Entry<String, Object> item : map.entrySet()) {
            String key = DsConfigUtil.lineToUpper(item.getKey());
            Method method = METHODS.get(key);
            if (method != null) {
                try {
                    method.invoke((Object)filter, DsConfigUtil.convertValue(method, item.getValue()));
                }
                catch (Exception e) {
                    log.warn("druid stat set param {} error", (Object)key, (Object)e);
                }
                continue;
            }
            log.warn("druid stat does not have param {}", (Object)key);
        }
        return filter;
    }

    static {
        try {
            METHODS.put("dbType", StatFilter.class.getDeclaredMethod("setDbType", String.class));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

