/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.datalog;

import biscuit.format.schema.Schema;
import com.clevercloud.biscuit.datalog.Combinator;
import com.clevercloud.biscuit.datalog.Fact;
import com.clevercloud.biscuit.datalog.ID;
import com.clevercloud.biscuit.datalog.MatchedVariables;
import com.clevercloud.biscuit.datalog.Predicate;
import com.clevercloud.biscuit.datalog.constraints.Constraint;
import com.clevercloud.biscuit.error.Error;
import io.vavr.API;
import io.vavr.control.Either;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class Rule
implements Serializable {
    private final Predicate head;
    private final List<Predicate> body;
    private final List<Constraint> constraints;

    public final Predicate head() {
        return this.head;
    }

    public final List<Predicate> body() {
        return this.body;
    }

    public final List<Constraint> constraints() {
        return this.constraints;
    }

    public void apply(Set<Fact> facts, Set<Fact> new_facts) {
        HashSet<Long> variables_set = new HashSet<Long>();
        for (Predicate pred : this.body) {
            variables_set.addAll(pred.ids().stream().filter(id -> id instanceof ID.Variable).map(id -> ((ID.Variable)id).value()).collect(Collectors.toSet()));
        }
        MatchedVariables variables = new MatchedVariables(variables_set);
        for (Map<Long, ID> h : new Combinator(variables, this.body, this.constraints, facts).combine()) {
            Predicate p = this.head.clone();
            ListIterator<ID> idit = p.ids_iterator();
            while (idit.hasNext()) {
                ID id2 = idit.next();
                if (!(id2 instanceof ID.Variable)) continue;
                ID value = h.get(((ID.Variable)id2).value());
                idit.set(value);
            }
            new_facts.add(new Fact(p));
        }
    }

    public Rule(Predicate head, List<Predicate> body, List<Constraint> constraints) {
        this.head = head;
        this.body = body;
        this.constraints = constraints;
    }

    public Schema.Rule serialize() {
        int i;
        Schema.Rule.Builder b = Schema.Rule.newBuilder().setHead(this.head.serialize());
        for (i = 0; i < this.body.size(); ++i) {
            b.addBody(this.body.get(i).serialize());
        }
        for (i = 0; i < this.constraints.size(); ++i) {
            b.addConstraints(this.constraints.get(i).serialize());
        }
        return b.build();
    }

    public static Either<Error.FormatError, Rule> deserialize(Schema.Rule rule) {
        ArrayList<Predicate> body = new ArrayList<Predicate>();
        for (Schema.Predicate predicate : rule.getBodyList()) {
            Either<Error.FormatError, Predicate> res = Predicate.deserialize(predicate);
            if (res.isLeft()) {
                Error.FormatError e = (Error.FormatError)res.getLeft();
                return API.Left((Object)e);
            }
            body.add((Predicate)res.get());
        }
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        for (Schema.Constraint constraint : rule.getConstraintsList()) {
            Either<Error.FormatError, Constraint> res = Constraint.deserialize(constraint);
            if (res.isLeft()) {
                Error.FormatError e = (Error.FormatError)res.getLeft();
                return API.Left((Object)e);
            }
            constraints.add((Constraint)res.get());
        }
        Either<Error.FormatError, Predicate> either = Predicate.deserialize(rule.getHead());
        if (either.isLeft()) {
            Error.FormatError e = (Error.FormatError)either.getLeft();
            return API.Left((Object)e);
        }
        return API.Right((Object)new Rule((Predicate)either.get(), body, constraints));
    }
}

