/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.jdbc.JdbcTypeMapping;
import com.clickhouse.jdbc.JdbcWrapper;
import com.clickhouse.jdbc.SqlExceptionUtils;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;

public class ClickHouseResultSetMetaData
extends JdbcWrapper
implements ResultSetMetaData {
    private final String database;
    private final String table;
    private final List<ClickHouseColumn> columns;

    public static ResultSetMetaData of(String database, String table, List<ClickHouseColumn> columns) throws SQLException {
        if (database == null || table == null || columns == null) {
            throw SqlExceptionUtils.clientError("Non-null database, table, and column list are required");
        }
        return new ClickHouseResultSetMetaData(database, table, columns);
    }

    protected ClickHouseResultSetMetaData(String database, String table, List<ClickHouseColumn> columns) {
        this.database = database;
        this.table = table;
        this.columns = columns;
    }

    protected List<ClickHouseColumn> getColumns() {
        return this.columns;
    }

    protected ClickHouseColumn getColumn(int index) throws SQLException {
        if (index < 1 || index > this.columns.size()) {
            throw SqlExceptionUtils.clientError(ClickHouseUtils.format((String)"Column index must between 1 and %d but we got %d", (Object[])new Object[]{this.columns.size(), index}));
        }
        return this.columns.get(index - 1);
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columns.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.getColumn(column).isNullable() ? 1 : 0;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.getColumn(column).getDataType().isSigned();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return 80;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnName(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumn(column).getColumnName();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.database;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.getColumn(column).getPrecision();
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.getColumn(column).getScale();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.table;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return JdbcTypeMapping.toJdbcType(this.getColumn(column));
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.getColumn(column).getOriginalTypeName();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.getColumn(column).getDataType().getObjectClass().getCanonicalName();
    }
}

