/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.parser;

import com.clickhouse.jdbc.parser.LanguageType;
import com.clickhouse.jdbc.parser.OperationType;
import com.clickhouse.jdbc.parser.StatementType;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ClickHouseSqlStatement {
    public static final String DEFAULT_DATABASE = "system";
    public static final String DEFAULT_TABLE = "unknown";
    public static final String KEYWORD_DATABASE = "DATABASE";
    public static final String KEYWORD_EXISTS = "EXISTS";
    public static final String KEYWORD_FORMAT = "FORMAT";
    public static final String KEYWORD_REPLACE = "REPLACE";
    public static final String KEYWORD_TOTALS = "TOTALS";
    public static final String KEYWORD_VALUES = "VALUES";
    private final String sql;
    private final StatementType stmtType;
    private final String cluster;
    private final String database;
    private final String table;
    private final String input;
    private final String format;
    private final String outfile;
    private final List<Integer> parameters;
    private final Map<String, Integer> positions;
    private final Map<String, String> settings;
    private final Set<String> tempTables;

    public ClickHouseSqlStatement(String sql) {
        this(sql, StatementType.UNKNOWN, null, null, null, null, null, null, null, null, null, null);
    }

    public ClickHouseSqlStatement(String sql, StatementType stmtType) {
        this(sql, stmtType, null, null, null, null, null, null, null, null, null, null);
    }

    public ClickHouseSqlStatement(String sql, StatementType stmtType, String cluster, String database, String table, String input, String format, String outfile, List<Integer> parameters, Map<String, Integer> positions, Map<String, String> settings, Set<String> tempTables) {
        Cloneable s;
        this.sql = sql;
        this.stmtType = stmtType;
        this.cluster = cluster;
        this.database = database;
        this.table = table == null || table.isEmpty() ? DEFAULT_TABLE : table;
        this.input = input;
        this.format = format;
        this.outfile = outfile;
        this.parameters = parameters != null && !parameters.isEmpty() ? Collections.unmodifiableList(parameters) : Collections.emptyList();
        if (positions != null && !positions.isEmpty()) {
            HashMap<String, Integer> p = new HashMap<String, Integer>();
            for (Map.Entry<String, Integer> entry : positions.entrySet()) {
                String keyword = entry.getKey();
                Integer position = entry.getValue();
                if (keyword == null || position == null) continue;
                p.put(keyword, position);
            }
            this.positions = Collections.unmodifiableMap(p);
        } else {
            this.positions = Collections.emptyMap();
        }
        if (settings != null && !settings.isEmpty()) {
            s = new LinkedHashMap();
            for (Map.Entry<String, Object> entry : settings.entrySet()) {
                String key = entry.getKey();
                String value = (String)entry.getValue();
                if (key == null || value == null) continue;
                s.put(key, String.valueOf(entry.getValue()));
            }
            this.settings = Collections.unmodifiableMap(s);
        } else {
            this.settings = Collections.emptyMap();
        }
        if (tempTables != null && !tempTables.isEmpty()) {
            s = new LinkedHashSet();
            s.addAll(tempTables);
            this.tempTables = Collections.unmodifiableSet(s);
        } else {
            this.tempTables = Collections.emptySet();
        }
    }

    public String getSQL() {
        return this.sql;
    }

    public boolean isRecognized() {
        return this.stmtType != StatementType.UNKNOWN;
    }

    public boolean isDDL() {
        return this.stmtType.getLanguageType() == LanguageType.DDL;
    }

    public boolean isDML() {
        return this.stmtType.getLanguageType() == LanguageType.DML;
    }

    public boolean isQuery() {
        return this.stmtType.getOperationType() == OperationType.READ && !this.hasOutfile();
    }

    public boolean isMutation() {
        return this.stmtType.getOperationType() == OperationType.WRITE || this.hasOutfile();
    }

    public boolean isIdemponent() {
        boolean result;
        boolean bl = result = this.stmtType.isIdempotent() && !this.hasOutfile();
        if (!result) {
            switch (this.stmtType) {
                case ATTACH: 
                case CREATE: 
                case DETACH: 
                case DROP: {
                    result = this.positions.containsKey(KEYWORD_EXISTS) || this.positions.containsKey(KEYWORD_REPLACE);
                    break;
                }
            }
        }
        return result;
    }

    public LanguageType getLanguageType() {
        return this.stmtType.getLanguageType();
    }

    public OperationType getOperationType() {
        return this.stmtType.getOperationType();
    }

    public StatementType getStatementType() {
        return this.stmtType;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getDatabaseOrDefault(String database) {
        return this.database == null ? (database == null ? DEFAULT_DATABASE : database) : this.database;
    }

    public String getTable() {
        return this.table;
    }

    public String getInput() {
        return this.input;
    }

    public String getFormat() {
        return this.format;
    }

    public String getOutfile() {
        return this.outfile;
    }

    public boolean containsKeyword(String keyword) {
        if (keyword == null || keyword.isEmpty()) {
            return false;
        }
        return this.positions.containsKey(keyword.toUpperCase(Locale.ROOT));
    }

    public boolean hasFormat() {
        return this.format != null && !this.format.isEmpty();
    }

    public boolean hasInput() {
        return this.input != null && !this.input.isEmpty();
    }

    public boolean hasOutfile() {
        return this.outfile != null && !this.outfile.isEmpty();
    }

    public boolean hasSettings() {
        return !this.settings.isEmpty();
    }

    public boolean hasWithTotals() {
        return this.positions.containsKey(KEYWORD_TOTALS);
    }

    public boolean hasValues() {
        return this.positions.containsKey(KEYWORD_VALUES);
    }

    public boolean hasTempTable() {
        return !this.tempTables.isEmpty();
    }

    public List<Integer> getParameters() {
        return this.parameters;
    }

    public int getStartPosition(String keyword) {
        Integer p;
        int position = -1;
        if (!this.positions.isEmpty() && keyword != null && (p = this.positions.get(keyword.toUpperCase(Locale.ROOT))) != null) {
            position = p;
        }
        return position;
    }

    public int getEndPosition(String keyword) {
        int position = this.getStartPosition(keyword);
        return position != -1 && keyword != null ? position + keyword.length() : position;
    }

    public Map<String, Integer> getPositions() {
        return this.positions;
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public Set<String> getTempTables() {
        return this.tempTables;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(this.stmtType.name()).append(']').append(" cluster=").append(this.cluster).append(", database=").append(this.database).append(", table=").append(this.table).append(", input=").append(this.input).append(", format=").append(this.format).append(", outfile=").append(this.outfile).append(", parameters=").append(this.parameters).append(", positions=").append(this.positions).append(", settings=").append(this.settings).append(", tempTables=").append(this.settings).append("\nSQL:\n").append(this.sql);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sql == null ? 0 : this.sql.hashCode());
        result = 31 * result + (this.cluster == null ? 0 : this.cluster.hashCode());
        result = 31 * result + (this.database == null ? 0 : this.database.hashCode());
        result = 31 * result + this.table.hashCode();
        result = 31 * result + (this.input == null ? 0 : this.input.hashCode());
        result = 31 * result + (this.format == null ? 0 : this.format.hashCode());
        result = 31 * result + (this.outfile == null ? 0 : this.outfile.hashCode());
        result = 31 * result + (this.stmtType == null ? 0 : this.stmtType.hashCode());
        result = 31 * result + this.parameters.hashCode();
        result = 31 * result + this.positions.hashCode();
        result = 31 * result + this.settings.hashCode();
        result = 31 * result + this.tempTables.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseSqlStatement other = (ClickHouseSqlStatement)obj;
        return this.stmtType == other.stmtType && Objects.equals(this.sql, other.sql) && Objects.equals(this.cluster, other.cluster) && Objects.equals(this.database, other.database) && Objects.equals(this.table, other.table) && Objects.equals(this.input, other.input) && Objects.equals(this.format, other.format) && Objects.equals(this.outfile, other.outfile) && this.parameters.equals(other.parameters) && this.positions.equals(other.positions) && this.settings.equals(other.settings) && this.tempTables.equals(other.tempTables);
    }
}

