/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.livy.client.common;

import com.cloudera.livy.annotations.Private;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.ByteBufferInputStream;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.shaded.org.objenesis.strategy.InstantiatorStrategy;
import com.esotericsoftware.shaded.org.objenesis.strategy.StdInstantiatorStrategy;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

@Private
public class Serializer {
    private static final int REG_ID_BASE = 16;
    private final ThreadLocal<Kryo> kryos;

    public Serializer(final Class<?> ... klasses) {
        this.kryos = new ThreadLocal<Kryo>(){

            @Override
            protected Kryo initialValue() {
                Kryo kryo = new Kryo();
                int count = 0;
                for (Class klass : klasses) {
                    kryo.register(klass, 16 + count);
                    ++count;
                }
                kryo.setInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy());
                kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
                return kryo;
            }
        };
    }

    public Object deserialize(ByteBuffer data) {
        Input kryoIn = new Input((InputStream)new ByteBufferInputStream(data));
        return this.kryos.get().readClassAndObject(kryoIn);
    }

    public ByteBuffer serialize(Object data) {
        ByteBufferOutputStream out = new ByteBufferOutputStream();
        Output kryoOut = new Output((OutputStream)out);
        this.kryos.get().writeClassAndObject(kryoOut, data);
        kryoOut.flush();
        return out.getBuffer();
    }

    private static class ByteBufferOutputStream
    extends ByteArrayOutputStream {
        private ByteBufferOutputStream() {
        }

        public ByteBuffer getBuffer() {
            ByteBuffer result = ByteBuffer.wrap(this.buf, 0, this.count);
            this.buf = null;
            this.reset();
            return result;
        }
    }
}

