/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.components.InfiniteProgress;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Display;
import com.codename1.ui.Graphics;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.layouts.FlowLayout;

public class InfiniteScrollAdapter {
    private Container infiniteContainer;
    private Runnable fetchMore;
    private Component ip;
    private int componentLimit = -1;
    private InfiniteProgress progress;
    private Component endMarker = new EdgeMarker(true);

    private InfiniteScrollAdapter() {
        this.progress = new InfiniteProgress();
        Container p = new Container(new FlowLayout(4));
        p.addComponent(this.progress);
        this.ip = p;
    }

    void reachedEnd() {
        this.infiniteContainer.removeComponent(this.endMarker);
        this.infiniteContainer.addComponent(this.ip);
        this.infiniteContainer.revalidate();
        Display.getInstance().callSerially(this.fetchMore);
    }

    public static InfiniteScrollAdapter createInfiniteScroll(Container cont, Runnable fetchMore) {
        return InfiniteScrollAdapter.createInfiniteScroll(cont, fetchMore, true);
    }

    public static InfiniteScrollAdapter createInfiniteScroll(Container cont, Runnable fetchMore, boolean fetchOnCreate) {
        InfiniteScrollAdapter a = new InfiniteScrollAdapter();
        cont.putClientProperty("cn1$infinite", a);
        a.infiniteContainer = cont;
        a.fetchMore = fetchMore;
        if (fetchOnCreate) {
            cont.addComponent(a.ip);
            Display.getInstance().callSerially(fetchMore);
        } else {
            a.infiniteContainer.addComponent(a.endMarker);
        }
        return a;
    }

    public static void addMoreComponents(Container cnt, Component[] components, boolean areThereMore) {
        InfiniteScrollAdapter ia = (InfiniteScrollAdapter)cnt.getClientProperty("cn1$infinite");
        ia.addMoreComponents(components, areThereMore);
    }

    public void addMoreComponents(Component[] components, boolean areThereMore) {
        this.infiniteContainer.removeComponent(this.ip);
        this.infiniteContainer.removeComponent(this.endMarker);
        for (Component c : components) {
            c.setY(this.infiniteContainer.getHeight());
            this.infiniteContainer.addComponent(c);
        }
        if (this.componentLimit > 0) {
            for (int diff = this.infiniteContainer.getComponentCount() - this.componentLimit; diff > 0; --diff) {
                this.infiniteContainer.removeComponent(this.infiniteContainer.getComponentAt(0));
            }
        }
        this.infiniteContainer.revalidate();
        if (areThereMore) {
            this.infiniteContainer.addComponent(this.endMarker);
            this.infiniteContainer.revalidate();
        }
    }

    public void continueFetching() {
        if (this.endMarker.getParent() == null) {
            this.fetchMore.run();
        }
    }

    public static void continueFetching(Container cnt) {
        InfiniteScrollAdapter ia = (InfiniteScrollAdapter)cnt.getClientProperty("cn1$infinite");
        ia.continueFetching();
    }

    public int getComponentLimit() {
        return this.componentLimit;
    }

    public void setComponentLimit(int componentLimit) {
        this.componentLimit = componentLimit;
    }

    public InfiniteProgress getInfiniteProgress() {
        return this.progress;
    }

    class EdgeMarker
    extends Component {
        private boolean top;

        public EdgeMarker(boolean top) {
            this.top = top;
        }

        public Dimension calcPreferredSize() {
            return new Dimension(1, 1);
        }

        public void paint(Graphics g) {
            if (this.getParent() != null && this.isInClippingRegion(g)) {
                InfiniteScrollAdapter.this.reachedEnd();
            }
        }
    }
}

