/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.testing;

import com.codename1.io.Log;
import com.codename1.testing.UnitTest;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class TestReporting {
    private static TestReporting instance;
    private final Hashtable<String, Boolean> testsExecuted = new Hashtable();

    public static TestReporting getInstance() {
        if (instance == null) {
            instance = new TestReporting();
        }
        return instance;
    }

    public static void setInstance(TestReporting i) {
        instance = i;
    }

    public void startingTestCase(String testName) {
        Log.p("Starting test case " + testName);
    }

    public void startingTestCase(UnitTest test) {
        this.startingTestCase(test.getClass().getName());
    }

    public void logMessage(String message) {
        Log.p(message);
    }

    public void logException(Throwable err) {
        Log.e(err);
    }

    public void finishedTestCase(String testName, boolean passed) {
        if (passed) {
            Log.p(testName + " passed");
            this.testsExecuted.put(testName, Boolean.TRUE);
        } else {
            Log.p(testName + " failed");
            this.testsExecuted.put(testName, Boolean.FALSE);
        }
    }

    public void finishedTestCase(UnitTest test, boolean passed) {
        this.finishedTestCase(test.getClass().getName(), passed);
    }

    public void writeReport(String testSuiteName, OutputStream os) throws IOException {
        Enumeration<String> e = this.testsExecuted.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            if (this.testsExecuted.get(key).booleanValue()) {
                os.write((key + " passed\n").getBytes());
                continue;
            }
            os.write((key + " failed\n").getBytes());
        }
    }

    public void writeReport(OutputStream os) throws IOException {
    }

    public void testExecutionFinished(String testSuiteName) {
        this.testExecutionFinished();
    }

    public void testExecutionFinished() {
    }
}

