/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.plaf;

import com.codename1.io.Util;
import com.codename1.l10n.L10NManager;
import com.codename1.ui.Display;
import com.codename1.ui.Font;
import com.codename1.ui.Image;
import com.codename1.ui.plaf.Border;
import com.codename1.ui.plaf.RoundBorder;
import com.codename1.ui.plaf.RoundRectBorder;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.util.Resources;
import com.codename1.util.CaseInsensitiveOrder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleParser {
    public static final byte UNIT_INHERIT = 99;
    private static Map<String, Integer> bgTypes;

    static StyleInfo parseString(StyleInfo out, String str) {
        Map<String, String> map = StyleParser.parseString(new HashMap<String, String>(), str);
        for (Map.Entry<String, String> e : map.entrySet()) {
            out.values.put(e.getKey(), e.getValue());
        }
        return out;
    }

    static StyleInfo parseString(String str) {
        return StyleParser.parseString(new StyleInfo(), str);
    }

    static Map<String, String> parseString(Map<String, String> out, String str) {
        String[] rules;
        for (String rule : rules = Util.split(str, ";")) {
            int pos;
            if ((rule = rule.trim()).length() == 0 || (pos = rule.indexOf(":")) == -1) continue;
            String key = rule.substring(0, pos);
            if ("font".equals(key) && out.containsKey("font")) {
                FontInfo newFinfo = StyleParser.parseFont(new FontInfo(), rule.substring(pos + 1));
                FontInfo origFinfo = StyleParser.parseFont(new FontInfo(), out.get("font"));
                Float newSize = newFinfo.getSize();
                if (newSize != null && newFinfo.getSizeUnit() != 99) {
                    origFinfo.setSize(newSize);
                    origFinfo.setSizeUnit(newFinfo.getSizeUnit());
                }
                if (newFinfo.getName() != null) {
                    origFinfo.setName(newFinfo.getName());
                }
                if (newFinfo.getFile() != null) {
                    origFinfo.setFile(newFinfo.getFile());
                }
                out.put(key, origFinfo.toString());
                continue;
            }
            out.put(key, rule.substring(pos + 1));
        }
        return out;
    }

    static MarginInfo parseMargin(MarginInfo out, String margin) {
        out.setValues(StyleParser.parseTRBLValue(margin));
        return out;
    }

    static MarginInfo parseMargin(String margin) {
        ScalarValue[] v = StyleParser.parseTRBLValue(margin);
        if (v == null) {
            return null;
        }
        return new MarginInfo(v);
    }

    static String parseMargin(Style baseStyle, String margin) {
        ScalarValue[] vals = StyleParser.parseTRBLValue(margin);
        StringBuilder sb = new StringBuilder();
        if (vals[0].getUnit() == 99) {
            sb.append(baseStyle == null ? 0.0f : baseStyle.margin[0]);
        } else {
            sb.append(vals[0].getValue());
        }
        sb.append(",");
        if (vals[2].getUnit() == 99) {
            sb.append(baseStyle == null ? 0.0f : baseStyle.margin[2]);
        } else {
            sb.append(vals[2].getValue());
        }
        sb.append(",");
        if (vals[1].getUnit() == 99) {
            sb.append(baseStyle == null ? 0.0f : baseStyle.margin[1]);
        } else {
            sb.append(vals[1].getValue());
        }
        sb.append(",");
        if (vals[3].getUnit() == 99) {
            sb.append(baseStyle == null ? 0.0f : baseStyle.margin[3]);
        } else {
            sb.append(vals[3].getValue());
        }
        return sb.toString();
    }

    static PaddingInfo parsePadding(PaddingInfo out, String padding) {
        out.setValues(StyleParser.parseTRBLValue(padding));
        return out;
    }

    static PaddingInfo parsePadding(String padding) {
        ScalarValue[] v = StyleParser.parseTRBLValue(padding);
        if (v == null) {
            return null;
        }
        return new PaddingInfo(v);
    }

    static String parsePadding(Style baseStyle, String padding) {
        ScalarValue[] vals = StyleParser.parseTRBLValue(padding);
        StringBuilder sb = new StringBuilder();
        if (vals[0].getUnit() == 99) {
            sb.append(baseStyle == null ? 0.0f : baseStyle.padding[0]);
        } else {
            sb.append(vals[0].getValue());
        }
        sb.append(",");
        if (vals[2].getUnit() == 99) {
            sb.append(baseStyle == null ? 0.0f : baseStyle.padding[2]);
        } else {
            sb.append(vals[2].getValue());
        }
        sb.append(",");
        if (vals[1].getUnit() == 99) {
            sb.append(baseStyle == null ? 0.0f : baseStyle.padding[1]);
        } else {
            sb.append(vals[1].getValue());
        }
        sb.append(",");
        if (vals[3].getUnit() == 99) {
            sb.append(baseStyle == null ? 0.0f : baseStyle.padding[3]);
        } else {
            sb.append(vals[3].getValue());
        }
        return sb.toString();
    }

    static byte[] parsePaddingUnit(Style baseStyle, String padding) {
        ScalarValue[] vals = StyleParser.parseTRBLValue(padding);
        byte[] out = new byte[4];
        for (int i = 0; i < 4; ++i) {
            out[i] = vals[i].getUnit() == 99 ? (baseStyle == null ? (byte)0 : baseStyle.paddingUnit[i]) : vals[i].getUnit();
        }
        return out;
    }

    static byte[] parseMarginUnit(Style baseStyle, String margin) {
        ScalarValue[] vals = StyleParser.parseTRBLValue(margin);
        byte[] out = new byte[4];
        for (int i = 0; i < 4; ++i) {
            out[i] = vals[i].getUnit() == 99 ? (baseStyle == null ? (byte)0 : baseStyle.marginUnit[i]) : vals[i].getUnit();
        }
        return out;
    }

    static Integer parseAlignment(String alignment) {
        if (Character.isDigit(alignment.charAt(0))) {
            return Integer.parseInt(alignment);
        }
        if ("center".equalsIgnoreCase(alignment)) {
            return 4;
        }
        if ("left".equalsIgnoreCase(alignment)) {
            return 1;
        }
        if ("right".equalsIgnoreCase(alignment)) {
            return 3;
        }
        return null;
    }

    private static String getAlignmentString(Integer alignment) {
        if (alignment == null) {
            return null;
        }
        switch (alignment) {
            case 4: {
                return "center";
            }
            case 1: {
                return "left";
            }
            case 3: {
                return "right";
            }
        }
        return null;
    }

    private static int getPixelValue(String val) {
        ScalarValue v = StyleParser.parseSingleTRBLValue(val);
        switch (v.getUnit()) {
            case 0: {
                return (int)Math.round(v.getValue());
            }
            case 2: {
                return Display.getInstance().convertToPixels((float)v.getValue());
            }
            case 1: {
                return (int)Math.round((double)Display.getInstance().getDisplayWidth() * v.getValue() / 100.0);
            }
        }
        return 0;
    }

    private static float getMMValue(String val) {
        ScalarValue v = StyleParser.parseSingleTRBLValue(val);
        switch (v.getUnit()) {
            case 0: {
                return (float)v.getValue() / (float)Display.getInstance().convertToPixels(1.0f);
            }
            case 2: {
                return (float)v.getValue();
            }
            case 1: {
                return (int)Math.round((double)Display.getInstance().getDisplayWidth() * v.getValue() / 100.0) / Display.getInstance().convertToPixels(1.0f);
            }
        }
        return 0.0f;
    }

    private static String parseStroke(BorderInfo out, String rem) {
        int p1 = rem.indexOf("(");
        int p2 = rem.indexOf(")");
        if (p1 != -1 && p2 != -1) {
            String[] strokeArgs;
            String strokeStr = rem.substring(p1 + 1, p2).trim();
            for (String strokeArg : strokeArgs = Util.split(strokeStr, " ")) {
                if ((strokeArg = strokeArg.trim()).endsWith("mm") || strokeArg.endsWith("px")) {
                    ScalarValue sv = StyleParser.parseScalarValue(strokeArg);
                    out.width = Float.valueOf((float)sv.value);
                    out.widthUnit = sv.unit;
                    continue;
                }
                if (strokeArg.length() <= 0) continue;
                if (strokeArg.length() == 8) {
                    out.setStrokeOpacity(Integer.parseInt(strokeArg.substring(0, 2), 16) & 0xFF);
                    out.setStrokeColor(Integer.parseInt(strokeArg.substring(2), 16) & 0xFFFFFF);
                    continue;
                }
                out.setStrokeOpacity(255);
                out.setStrokeColor(Integer.parseInt(strokeArg, 16) & 0xFFFFFF);
            }
            rem = rem.substring(p2 + 1);
        } else {
            rem = rem.substring(6);
        }
        return rem;
    }

    private static String parseShadow(BorderInfo out, String rem) {
        int p1 = rem.indexOf("(");
        int p2 = rem.indexOf(")");
        if (p1 != -1 && p2 != -1) {
            String[] shadowArgs;
            String shadowStr = rem.substring(p1 + 1, p2);
            for (String shadowArg : shadowArgs = Util.split(shadowStr, " ")) {
                if ((shadowArg = shadowArg.trim()).startsWith("shadowSpread:") || shadowArg.endsWith("mm") || shadowArg.endsWith("px")) {
                    int colonPos = shadowArg.indexOf(":");
                    if (colonPos != -1) {
                        shadowArg = shadowArg.substring(colonPos + 1);
                    }
                    out.setShadowSpread(StyleParser.parseScalarValue(shadowArg));
                    continue;
                }
                if (shadowArg.startsWith("x:")) {
                    out.setShadowX(Float.valueOf(Float.parseFloat(shadowArg.substring(shadowArg.indexOf(":") + 1).trim())));
                    continue;
                }
                if (shadowArg.startsWith("y:")) {
                    out.setShadowY(Float.valueOf(Float.parseFloat(shadowArg.substring(shadowArg.indexOf(":") + 1).trim())));
                    continue;
                }
                if (shadowArg.startsWith("blur:")) {
                    out.setShadowBlur(Float.valueOf(Float.parseFloat(shadowArg.substring(shadowArg.indexOf(":") + 1).trim())));
                    continue;
                }
                if (!shadowArg.startsWith("opacity:")) continue;
                out.setShadowOpacity(Integer.parseInt(shadowArg.substring(shadowArg.indexOf(":") + 1).trim()));
            }
            if (out.getShadowSpread() == null) {
                out.setShadowSpread(StyleParser.parseScalarValue("0.5mm"));
            }
            if (out.getShadowX() == null) {
                out.setShadowX(Float.valueOf(0.5f));
            }
            if (out.getShadowY() == null) {
                out.setShadowY(Float.valueOf(0.5f));
            }
            if (out.getShadowBlur() == null) {
                out.setShadowBlur(Float.valueOf(0.1f));
            }
            if (out.getShadowOpacity() == null) {
                out.setShadowOpacity(128);
            }
            rem = rem.substring(p2 + 1);
        } else {
            rem = rem.substring(6);
        }
        return rem;
    }

    private static BorderInfo parseRoundBorder(BorderInfo out, String args, String[] parts1) {
        int plen = parts1.length;
        out.setType("round");
        if (plen > 1) {
            int nextSpacePos;
            String rem = args;
            while ((nextSpacePos = rem.indexOf(" ")) != -1) {
                if ((rem = rem.substring(nextSpacePos + 1).trim()).startsWith("rect")) {
                    out.setRectangle(true);
                    continue;
                }
                if (rem.startsWith("stroke")) {
                    rem = StyleParser.parseStroke(out, rem);
                    continue;
                }
                if (rem.startsWith("shadow")) {
                    rem = StyleParser.parseShadow(out, rem);
                    continue;
                }
                if (rem.length() == 8 || rem.indexOf(" ") == 8) {
                    String colorStr = rem.substring(0, 8);
                    out.color = Integer.parseInt(colorStr.substring(2), 16) & 0xFFFFFF;
                    out.setOpacity(Integer.valueOf(Integer.parseInt(colorStr.substring(0, 2), 16)) & 0xFF);
                    rem = rem.substring(8);
                    continue;
                }
                int spacePos = rem.indexOf(" ");
                String colorStr = rem;
                if (spacePos != -1) {
                    colorStr = colorStr.substring(0, spacePos);
                }
                if (colorStr.length() > 0 && colorStr.length() <= 6) {
                    out.color = Integer.parseInt(colorStr, 16) & 0xFFFFFF;
                    out.setOpacity(255);
                }
                rem = rem.substring(colorStr.length());
            }
        }
        return out;
    }

    private static BorderInfo parseRoundRectBorder(BorderInfo out, String args, String[] parts1) {
        int plen = parts1.length;
        out.setType("roundRect");
        if (plen > 1) {
            int nextSpacePos;
            String rem = args;
            while ((nextSpacePos = rem.indexOf(" ")) != -1) {
                if ((rem = rem.substring(nextSpacePos + 1).trim()).startsWith("stroke")) {
                    rem = StyleParser.parseStroke(out, rem);
                    continue;
                }
                if (rem.startsWith("shadow")) {
                    rem = StyleParser.parseShadow(out, rem);
                    continue;
                }
                if (rem.startsWith("-") || rem.startsWith("+")) {
                    boolean value = rem.charAt(0) == '+';
                    String flagName = rem.substring(1);
                    if (flagName.startsWith("top-only")) {
                        out.setTopOnlyMode(value);
                        continue;
                    }
                    if (flagName.startsWith("bottom-only")) {
                        out.setBottomOnlyMode(value);
                        continue;
                    }
                    if (flagName.startsWith("top-left")) {
                        out.setTopLeftMode(value);
                        continue;
                    }
                    if (flagName.startsWith("top-right")) {
                        out.setTopRightMode(value);
                        continue;
                    }
                    if (flagName.startsWith("bottom-left")) {
                        out.setBottomLeftMode(value);
                        continue;
                    }
                    if (!flagName.startsWith("bottom-right")) continue;
                    out.setBottomRightMode(value);
                    continue;
                }
                if (rem.length() <= 0 || !Character.isDigit(rem.charAt(0))) continue;
                out.setCornerRadius(Float.valueOf(StyleParser.getMMValue(rem)));
            }
        }
        return out;
    }

    static BorderInfo parseBorder(BorderInfo out, String args) {
        if (args == null) {
            out.setType("empty");
            return out;
        }
        if ("none".equals(args = args.trim())) {
            out.setType("empty");
            return out;
        }
        String[] parts1 = Util.split(args, " ");
        int plen = parts1.length;
        if (plen == 0) {
            out.setType("empty");
            return out;
        }
        if (plen > 3 && ("image".equals(parts1[0]) || "horizontalImage".equals(parts1[0]) || "verticalImage".equals(parts1[0]))) {
            out.setType(parts1[0]);
            out.setImages(new String[plen - 1]);
            for (int i = 1; i < plen; ++i) {
                out.getImages()[i - 1] = parts1[i];
            }
            return out;
        }
        if ("splicedImage".equals(parts1[0]) && plen == 6) {
            out.setType(parts1[0]);
            out.setSpliceImage(parts1[1]);
            out.setSpliceInsets(parts1[2] + " " + parts1[3] + " " + parts1[4] + " " + parts1[5]);
            return out;
        }
        if ("round".equals(parts1[0])) {
            return StyleParser.parseRoundBorder(out, args, parts1);
        }
        if ("roundRect".equals(parts1[0])) {
            return StyleParser.parseRoundRectBorder(out, args, parts1);
        }
        if (plen == 3) {
            String type = parts1[1];
            out.setColor(Integer.parseInt(parts1[2], 16));
            ScalarValue thicknessVal = StyleParser.parseSingleTRBLValue(parts1[0]);
            out.setWidth(Float.valueOf((float)thicknessVal.getValue()));
            out.setWidthUnit(thicknessVal.getUnit());
            if ("solid".equals(type) || "line".equals(type)) {
                out.setType("line");
            } else if ("dashed".equals(type)) {
                out.setType("dashed");
            } else if ("dotted".equals(type)) {
                out.setType("dotted");
            } else if ("underline".equals(type)) {
                out.setType("underline");
            }
            return out;
        }
        out.setType("empty");
        return out;
    }

    static Border parseBorder(Resources theme, String args) {
        BorderInfo info = StyleParser.parseBorder(new BorderInfo(), args);
        if (info == null) {
            return null;
        }
        return info.createBorder(theme);
    }

    private static Image getImage(Resources theme, String imageStr) {
        Image im = null;
        try {
            im = imageStr.startsWith("/") ? Image.createImage(imageStr) : theme.getImage(imageStr);
        }
        catch (IOException ex) {
            System.out.println("failed to parse image");
        }
        return im;
    }

    static Integer parseTextDecoration(String decoration) {
        return null;
    }

    private static FontInfo parseFontSize(FontInfo out, String arg) {
        arg = arg.trim();
        ScalarValue sizeVal = StyleParser.parseSingleTRBLValue(arg);
        out.setSize(Float.valueOf((float)sizeVal.getValue()));
        out.setSizeUnit(sizeVal.getUnit());
        return out;
    }

    private static FontInfo parseFontName(FontInfo out, String arg) {
        if ((arg = arg.trim()).length() > 0 && arg.charAt(0) == '/') {
            arg = arg.substring(1);
        }
        if (arg.indexOf(47) != -1) {
            arg = arg.substring(0, arg.indexOf(47)).trim();
        } else {
            int len = arg.length();
            if (len > 3 && arg.charAt(len - 4) == '.') {
                arg = arg.substring(0, len - 4);
            }
        }
        out.setName(arg);
        return out;
    }

    private static FontInfo parseFontFile(FontInfo out, String arg) {
        if ((arg = arg.trim()).indexOf(47) != -1) {
            arg = arg.substring(arg.indexOf(47));
        }
        arg = arg.length() > 0 && arg.charAt(0) == '/' ? arg.substring(1) : (arg.indexOf("native:") == 0 ? arg : (arg.indexOf(".ttf") != arg.length() - 4 ? arg + ".ttf" : arg));
        out.setFile(arg);
        return out;
    }

    private static boolean isFontSizeArg(String arg) {
        return arg != null && arg.length() > 0 && Character.isDigit(arg.charAt(0));
    }

    static FontInfo parseFont(FontInfo out, String font) {
        String arg;
        if (font == null || font.trim().length() == 0) {
            return null;
        }
        String[] args = Util.split(font = font.trim(), " ");
        int len = args.length;
        if (len == 1) {
            arg = args[0].trim();
            if (arg.length() == 0) {
                out.setSize(null);
                out.setSizeUnit((byte)99);
                out.setFile(null);
                out.setName(null);
                return out;
            }
            if (StyleParser.isFontSizeArg(arg)) {
                StyleParser.parseFontSize(out, arg);
                out.setName(null);
                out.setFile(null);
                return out;
            }
        } else {
            if (len == 2) {
                if (StyleParser.isFontSizeArg(args[0])) {
                    StyleParser.parseFontSize(out, args[0]);
                    StyleParser.parseFontName(out, args[1]);
                    StyleParser.parseFontFile(out, args[1]);
                    return out;
                }
                out.setSize(null);
                out.setSizeUnit((byte)99);
                StyleParser.parseFontName(out, args[0]);
                StyleParser.parseFontFile(out, args[1]);
                return out;
            }
            if (len == 3) {
                StyleParser.parseFontSize(out, args[0]);
                StyleParser.parseFontName(out, args[1]);
                StyleParser.parseFontFile(out, args[2]);
                return out;
            }
            throw new IllegalArgumentException("Failed to parse font");
        }
        out.setSizeUnit((byte)99);
        out.setSize(null);
        StyleParser.parseFontName(out, arg);
        StyleParser.parseFontFile(out, arg);
        return out;
    }

    static Font parseFont(Style baseStyle, String font) {
        if (font == null || font.trim().length() == 0) {
            return null;
        }
        FontInfo finfo = StyleParser.parseFont(new FontInfo(), font);
        return finfo.createFont(baseStyle);
    }

    private static ScalarValue[] parseTRBLValue(String val) {
        ScalarValue[] out = new ScalarValue[4];
        String[] parts = Util.split(val, " ");
        int len = parts.length;
        switch (len) {
            case 1: {
                ScalarValue v = StyleParser.parseSingleTRBLValue(parts[0]);
                for (int i = 0; i < 4; ++i) {
                    out[i] = v;
                }
                return out;
            }
            case 2: {
                ScalarValue v1 = StyleParser.parseSingleTRBLValue(parts[0]);
                ScalarValue v2 = StyleParser.parseSingleTRBLValue(parts[1]);
                out[0] = out[2] = v1;
                out[1] = out[3] = v2;
                return out;
            }
            case 3: {
                ScalarValue v1 = StyleParser.parseSingleTRBLValue(parts[0]);
                ScalarValue v2 = StyleParser.parseSingleTRBLValue(parts[1]);
                ScalarValue v3 = StyleParser.parseSingleTRBLValue(parts[2]);
                out[0] = v1;
                out[1] = out[3] = v2;
                out[2] = v3;
                return out;
            }
            case 4: {
                ScalarValue v1 = StyleParser.parseSingleTRBLValue(parts[0]);
                ScalarValue v2 = StyleParser.parseSingleTRBLValue(parts[1]);
                ScalarValue v3 = StyleParser.parseSingleTRBLValue(parts[2]);
                ScalarValue v4 = StyleParser.parseSingleTRBLValue(parts[3]);
                out[0] = v1;
                out[3] = v2;
                out[2] = v3;
                out[1] = v4;
                return out;
            }
        }
        return null;
    }

    private static ScalarValue parseSingleTRBLValue(String val) {
        val = val.trim();
        int plen = val.length();
        StringBuilder sb = new StringBuilder();
        ScalarValue out = new ScalarValue();
        boolean parsedValue = false;
        for (int i = 0; i < plen; ++i) {
            char c = val.charAt(i);
            if (!(parsedValue || c != '%' && c != 'm' && c != 'p' && c != 'i')) {
                out.setValue(sb.length() > 0 ? Double.parseDouble(sb.toString()) : 0.0);
                parsedValue = true;
                sb.setLength(0);
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        if (parsedValue) {
            String unitStr = sb.toString();
            out.setUnit((byte)("mm".equals(unitStr) ? 2 : ("%".equals(unitStr) ? 1 : ("inherit".equals(unitStr) ? 99 : 0))));
        } else {
            out.setUnit((byte)0);
            out.setValue(Double.parseDouble(sb.toString()));
        }
        return out;
    }

    static Image parseBgImage(Resources theme, String val) {
        if (val == null || val.trim().length() == 0) {
            return null;
        }
        return StyleParser.getImage(theme, val);
    }

    private static Map<String, Integer> bgTypes() {
        if (bgTypes == null) {
            bgTypes = new HashMap<String, Integer>();
            Object[] types = new Object[]{"image_aligned_bottom", 21, "image_aligned_top", 20, "image_aligned_bottom_right", 28, "image_aligned_bottom_left", 27, "image_aligned_top_right", 26, "image_aligned_top_left", 25, "image_aligned_left", 22, "image_aligned_right", 23, "image_aligned_center", 24, "image_scaled", 1, "image_scaled_fill", 33, "image_scaled_fit", 34, "image_tile_both", 2, "image_tile_horizontal", 4, "image_tile_vertical", 3, "image_tile_horizontal_align_bottom", 30, "image_tile_horizontal_align_top", 4, "image_tile_horizontal_align_center", 29, "image_tile_vertical_align_left", 3, "image_tile_vertical_align_right", 32, "image_tile_vertical_align_center", 31, "gradient_radial", 8, "gradient_linear_horizontal", 7, "gradient_linear_vertical", 6, "none", 0};
            int len = types.length;
            for (int i = 0; i < len; i += 2) {
                bgTypes.put((String)types[i], (Integer)types[i + 1]);
            }
        }
        return bgTypes;
    }

    public static List<String> getBackgroundTypes() {
        ArrayList<String> out = new ArrayList<String>();
        out.addAll(StyleParser.bgTypes().keySet());
        Collections.sort(out, new CaseInsensitiveOrder());
        return out;
    }

    private static <T, V> Map<T, V> flip(Map<V, T> map) {
        HashMap<T, V> out = new HashMap<T, V>();
        for (Map.Entry<V, T> e : map.entrySet()) {
            out.put(e.getValue(), e.getKey());
        }
        return out;
    }

    static Integer parseBgType(String val) {
        if (val == null || val.length() == 0) {
            return null;
        }
        if (Character.isDigit(val.charAt(0))) {
            return Integer.parseInt(val);
        }
        Map<String, Integer> bgTypes = StyleParser.bgTypes();
        if (bgTypes.containsKey(val)) {
            return bgTypes.get(val);
        }
        return null;
    }

    public static boolean validateScalarValue(String val) {
        try {
            StyleParser.parseSingleTRBLValue(val);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static ScalarValue parseScalarValue(String val) {
        return StyleParser.parseSingleTRBLValue(val);
    }

    public static List<String> getSupportedBackgroundTypes() {
        ArrayList<String> out = new ArrayList<String>();
        out.addAll(bgTypes.keySet());
        return out;
    }

    private static String format(double d, int decimalPlaces) {
        int decLen;
        int i;
        for (i = 0; i < decimalPlaces; ++i) {
            d *= 10.0;
        }
        d = Math.round(d);
        for (i = 0; i < decimalPlaces; ++i) {
            d /= 10.0;
        }
        String dStr = String.valueOf(d);
        int decPos = dStr.indexOf(".");
        if (decPos != -1 && (decLen = dStr.length() - decPos) > decimalPlaces) {
            dStr = dStr.substring(0, dStr.length() - (decLen - decimalPlaces));
        }
        return dStr;
    }

    public static class FontInfo {
        private Float size;
        private byte sizeUnit;
        private String name;
        private String file;

        public String toString() {
            return (this.sizeString("") + this.nameString(" ") + this.fileString(" ")).trim();
        }

        public String sizeString(String prefix) {
            if (this.getSize() == null) {
                return prefix;
            }
            if (this.getSizeUnit() == 2) {
                return prefix + this.getSize() + this.unitString();
            }
            if (this.getSizeUnit() == 99) {
                return prefix;
            }
            return prefix + this.getSize().intValue() + this.unitString();
        }

        public float getSizeInPixels(Style baseStyle) {
            if (this.getSize() == null || this.getSizeUnit() == 99) {
                float pixS;
                Font f = baseStyle.getFont();
                if (f == null) {
                    f = Font.getDefaultFont();
                }
                if ((pixS = f.getPixelSize()) < 1.0f) {
                    pixS = f.getHeight();
                }
                return pixS;
            }
            switch (this.getSizeUnit()) {
                case 2: {
                    return Display.getInstance().convertToPixels(this.getSize().floatValue());
                }
            }
            return this.getSize().floatValue();
        }

        private String unitString() {
            switch (this.getSizeUnit()) {
                case 2: {
                    return "mm";
                }
                case 0: {
                    return "px";
                }
            }
            return "px";
        }

        private String nameString(String prefix) {
            if (this.getName() == null) {
                return prefix;
            }
            return prefix + this.getName();
        }

        private String fileString(String prefix) {
            if (this.getFile() == null) {
                return prefix;
            }
            return prefix + this.getFile();
        }

        public Float getSize() {
            return this.size;
        }

        public void setSize(Float size) {
            this.size = size;
        }

        public byte getSizeUnit() {
            return this.sizeUnit;
        }

        public void setSizeUnit(byte sizeUnit) {
            this.sizeUnit = sizeUnit;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public Font createFont(Style baseStyle) {
            Font f = this.name == null ? (baseStyle == null ? Font.getDefaultFont() : baseStyle.getFont()) : Font.createTrueTypeFont(this.name, this.file);
            if (f == null || this.getSize() != null && !f.isTTFNativeFont()) {
                f = Font.createTrueTypeFont("native:MainRegular", "native:MainRegular");
            }
            if (f != null) {
                if (f.isTTFNativeFont()) {
                    return f.derive(this.getSizeInPixels(baseStyle), f.getStyle());
                }
                return Font.getDefaultFont();
            }
            return Font.getDefaultFont();
        }
    }

    public static class BorderInfo {
        private Integer opacity;
        private Integer strokeColor;
        private Integer strokeOpacity;
        private Integer shadowOpacity;
        private Float shadowX;
        private Float shadowY;
        private Float shadowBlur;
        private ScalarValue shadowSpread;
        private Boolean rectangle;
        private Boolean topOnlyMode;
        private Boolean bottomOnlyMode;
        private Boolean topLeftMode;
        private Boolean topRightMode;
        private Boolean bottomLeftMode;
        private Boolean bottomRightMode;
        private Float cornerRadius;
        private String type;
        private String spliceImage;
        private String[] images;
        private String spliceInsets;
        private Float width;
        private byte widthUnit;
        private Integer color;

        private String splicedImageToString() {
            return this.getType() + " " + this.getSpliceImage() + " " + this.getSpliceInsets();
        }

        private String imageToString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getType()).append(" ");
            for (String img : this.getImages()) {
                sb.append(img).append(" ");
            }
            return sb.toString().trim();
        }

        private String lineToString() {
            int color = this.getColor() == null ? 0 : this.getColor();
            return this.widthString() + " " + this.lineTypeString() + " " + Integer.toHexString(color);
        }

        private void shadowToString(StringBuilder sb) {
            sb.append("shadow(");
            sb.append("opacity:").append(this.getShadowOpacity()).append(" ");
            if (this.getShadowSpread() != null) {
                sb.append("spread:").append(this.getShadowSpread().toString()).append(" ");
            }
            if (this.getShadowX() != null) {
                sb.append("x:").append(BorderInfo.round(this.getShadowX().floatValue(), 3)).append(" ");
            }
            if (this.getShadowY() != null) {
                sb.append("y:").append(BorderInfo.round(this.getShadowY().floatValue(), 3)).append(" ");
            }
            if (this.getShadowBlur() != null) {
                sb.append("blur:").append(BorderInfo.round(this.getShadowBlur().floatValue(), 3)).append(" ");
            }
            sb.append(") ");
        }

        private void strokeToString(StringBuilder sb) {
            sb.append("stroke(");
            if (this.width != null) {
                sb.append(this.widthString()).append(" ");
            }
            int c = this.getStrokeColor() & 0xFFFFFF;
            String hex = Integer.toHexString(c);
            while (hex.length() < 6) {
                hex = "0" + hex;
            }
            if (this.getStrokeOpacity() != null && this.getStrokeOpacity() != 255) {
                String opacityStr = Integer.toHexString(this.getStrokeOpacity());
                while (opacityStr.length() < 2) {
                    opacityStr = "0" + opacityStr;
                }
                hex = opacityStr + hex;
            }
            sb.append(hex).append(") ");
        }

        private void colorToString(StringBuilder sb) {
            String hex = Integer.toHexString(this.color & 0xFFFFFF);
            while (hex.length() < 6) {
                hex = "0" + hex;
            }
            if (this.getOpacity() != null) {
                String opacityStr = Integer.toHexString(this.getOpacity() & 0xFF);
                while (opacityStr.length() < 2) {
                    opacityStr = "0" + opacityStr;
                }
                hex = opacityStr + hex;
            }
            sb.append(hex).append(" ");
        }

        private String roundToString() {
            StringBuilder sb = new StringBuilder();
            sb.append("round ");
            if (this.color != null) {
                this.colorToString(sb);
            }
            if (this.getShadowOpacity() != null && this.getShadowOpacity() != 0) {
                this.shadowToString(sb);
            }
            if (this.width != null && this.width.floatValue() != 0.0f && this.getStrokeColor() != null) {
                this.strokeToString(sb);
            }
            if (this.getRectangle() != null && this.getRectangle().booleanValue()) {
                sb.append("rect").append(" ");
            }
            return sb.toString().trim();
        }

        private String roundRectToString() {
            String prefix;
            StringBuilder sb = new StringBuilder();
            sb.append("roundRect ");
            if (this.color != null) {
                this.colorToString(sb);
            }
            if (this.getShadowOpacity() != null && this.getShadowOpacity() != 0) {
                this.shadowToString(sb);
            }
            if (this.width != null && this.width.floatValue() != 0.0f && this.getStrokeColor() != null) {
                this.strokeToString(sb);
            }
            if (this.getTopLeftMode() != null) {
                prefix = this.getTopLeftMode() != false ? "+" : "-";
                sb.append(prefix).append("top-left ");
            }
            if (this.getTopRightMode() != null) {
                prefix = this.getTopRightMode() != false ? "+" : "-";
                sb.append(prefix).append("top-right ");
            }
            if (this.getBottomLeftMode() != null) {
                prefix = this.getBottomLeftMode() != false ? "+" : "-";
                sb.append(prefix).append("bottom-left ");
            }
            if (this.getBottomRightMode() != null) {
                prefix = this.getBottomRightMode() != false ? "+" : "-";
                sb.append(prefix).append("bottom-right ");
            }
            if (this.getTopOnlyMode() != null) {
                prefix = this.getTopOnlyMode() != false ? "+" : "-";
                sb.append(prefix).append("top-only ");
            }
            if (this.getBottomOnlyMode() != null) {
                prefix = this.getBottomOnlyMode() != false ? "+" : "-";
                sb.append(prefix).append("bottom-only ");
            }
            if (this.cornerRadius != null) {
                sb.append(BorderInfo.round(this.cornerRadius.floatValue(), 2)).append("mm");
            }
            return sb.toString().trim();
        }

        public String toString() {
            if ("splicedImage".equals(this.getType())) {
                return this.splicedImageToString();
            }
            if ("image".equals(this.getType()) || "horizontalImage".equals(this.getType()) || "verticalImage".equals(this.getType())) {
                return this.imageToString();
            }
            if ("line".equals(this.getType()) || "dashed".equals(this.getType()) || "dotted".equals(this.getType()) || "underline".equals(this.getType())) {
                return this.lineToString();
            }
            if ("round".equals(this.getType())) {
                return this.roundToString();
            }
            if ("roundRect".equals(this.getType())) {
                return this.roundRectToString();
            }
            return "none";
        }

        public String widthString() {
            if (this.width == null) {
                return "1px";
            }
            return this.getWidth() + this.widthUnitString();
        }

        public String colorString() {
            if (this.color == null) {
                return "";
            }
            return Integer.toHexString(this.color);
        }

        private String widthUnitString() {
            switch (this.getWidthUnit()) {
                case 2: {
                    return "mm";
                }
            }
            return "px";
        }

        private String lineTypeString() {
            if ("line".equals(this.getType())) {
                return "solid";
            }
            return this.getType();
        }

        private Border createLineBorder() {
            if (this.getWidthUnit() == 2) {
                return Border.createLineBorder(this.getWidth().floatValue(), (int)this.getColor());
            }
            return Border.createLineBorder(this.getWidth().intValue(), (int)this.getColor());
        }

        private Border createDashedBorder() {
            if (this.getWidthUnit() == 2) {
                return Border.createDashedBorder(Display.getInstance().convertToPixels(this.getWidth().floatValue()), this.getColor());
            }
            return Border.createDashedBorder(this.getWidth().intValue(), this.getColor());
        }

        private Border createDottedBorder() {
            if (this.getWidthUnit() == 2) {
                return Border.createDottedBorder(Display.getInstance().convertToPixels(this.getWidth().floatValue()), this.getColor());
            }
            return Border.createDottedBorder(this.getWidth().intValue(), this.getColor());
        }

        private Border createUnderlineBorder() {
            if (this.getWidthUnit() == 2) {
                return Border.createUnderlineBorder(Display.getInstance().convertToPixels(this.getWidth().floatValue()), (int)this.getColor());
            }
            return Border.createUnderlineBorder(this.getWidth().intValue(), (int)this.getColor());
        }

        private Border createImageBorder(Resources theme) {
            int ilen = this.getImages().length;
            if (ilen == 9) {
                return Border.createImageBorder(StyleParser.getImage(theme, this.getImages()[0]), StyleParser.getImage(theme, this.getImages()[1]), StyleParser.getImage(theme, this.getImages()[2]), StyleParser.getImage(theme, this.getImages()[3]), StyleParser.getImage(theme, this.getImages()[4]), StyleParser.getImage(theme, this.getImages()[5]), StyleParser.getImage(theme, this.getImages()[6]), StyleParser.getImage(theme, this.getImages()[7]), StyleParser.getImage(theme, this.getImages()[8]));
            }
            if (ilen == 3) {
                return Border.createImageBorder(StyleParser.getImage(theme, this.getImages()[0]), StyleParser.getImage(theme, this.getImages()[1]), StyleParser.getImage(theme, this.getImages()[2]));
            }
            return Border.createEmpty();
        }

        private Border createHorizontalImageBorder(Resources theme) {
            return Border.createHorizonalImageBorder(StyleParser.getImage(theme, this.getImages()[0]), StyleParser.getImage(theme, this.getImages()[1]), StyleParser.getImage(theme, this.getImages()[2]));
        }

        private Border createVerticalImageBorder(Resources theme) {
            return Border.createVerticalImageBorder(StyleParser.getImage(theme, this.getImages()[0]), StyleParser.getImage(theme, this.getImages()[1]), StyleParser.getImage(theme, this.getImages()[2]));
        }

        private Border createSplicedImageBorder(Resources theme) {
            double[] insets = this.getSpliceInsets(new double[4]);
            return Border.createImageSplicedBorder(StyleParser.getImage(theme, this.getSpliceImage()), insets[0], insets[3], insets[2], insets[1]);
        }

        private Border createRoundBorder() {
            RoundBorder b = RoundBorder.create();
            if (this.width != null) {
                b.stroke(this.getWidthInPixels().intValue(), false);
            }
            if (this.getOpacity() != null) {
                b.opacity(this.getOpacity());
            }
            if (this.getStrokeColor() != null) {
                b.strokeColor(this.getStrokeColor());
            }
            if (this.getStrokeOpacity() != null) {
                b.strokeOpacity(this.getStrokeOpacity());
            }
            if (this.getShadowOpacity() != null) {
                b.shadowOpacity(this.getShadowOpacity());
            }
            if (this.getShadowSpread() != null) {
                b.shadowSpread(this.getShadowSpread().getPixelValue(), false);
            }
            if (this.getShadowX() != null) {
                b.shadowX(this.getShadowX().floatValue());
            }
            if (this.getShadowY() != null) {
                b.shadowY(this.getShadowY().floatValue());
            }
            if (this.getShadowBlur() != null) {
                b.shadowBlur(this.getShadowBlur().floatValue());
            }
            if (this.getRectangle() != null && this.getRectangle().booleanValue()) {
                b.rectangle(this.getRectangle());
            }
            if (this.color != null) {
                b.color(this.color);
            }
            return b;
        }

        private Border createRoundRectBorder() {
            RoundRectBorder b = RoundRectBorder.create();
            if (this.width != null) {
                b.stroke(this.getWidthInPixels().intValue(), false);
            }
            if (this.getStrokeColor() != null) {
                b.strokeColor(this.getStrokeColor());
            }
            if (this.getStrokeOpacity() != null) {
                b.strokeOpacity(this.getStrokeOpacity());
            }
            if (this.getShadowOpacity() != null) {
                b.shadowOpacity(this.getShadowOpacity());
            }
            if (this.getShadowSpread() != null) {
                ScalarValue sv = this.getShadowSpread();
                switch (sv.unit) {
                    case 0: {
                        b.shadowSpread(sv.getPixelValue());
                        break;
                    }
                    case 2: {
                        b.shadowSpread((float)sv.getValue());
                    }
                }
            }
            if (this.getShadowX() != null) {
                b.shadowX(this.getShadowX().floatValue());
            }
            if (this.getShadowY() != null) {
                b.shadowY(this.getShadowY().floatValue());
            }
            if (this.getShadowBlur() != null) {
                b.shadowBlur(this.getShadowBlur().floatValue());
            }
            if (this.getTopOnlyMode() != null) {
                b.topOnlyMode(this.getTopOnlyMode());
            }
            if (this.getBottomOnlyMode() != null) {
                b.bottomOnlyMode(this.getBottomOnlyMode());
            }
            if (this.getTopLeftMode() != null) {
                b.topLeftMode(this.getTopLeftMode());
            }
            if (this.getTopRightMode() != null) {
                b.topRightMode(this.getTopRightMode());
            }
            if (this.getBottomLeftMode() != null) {
                b.bottomLeftMode(this.getBottomLeftMode());
            }
            if (this.getBottomRightMode() != null) {
                b.bottomRightMode(this.getBottomRightMode());
            }
            if (this.cornerRadius != null) {
                b.cornerRadius(this.cornerRadius.floatValue());
            }
            return b;
        }

        public Border createBorder(Resources theme) {
            if (this.getType() == null || "empty".equals(this.getType()) || "none".equals(this.getType())) {
                return Border.createEmpty();
            }
            if ("line".equals(this.getType())) {
                return this.createLineBorder();
            }
            if ("dashed".equals(this.getType())) {
                return this.createDashedBorder();
            }
            if ("dotted".equals(this.getType())) {
                return this.createDottedBorder();
            }
            if ("underline".equals(this.getType())) {
                return this.createUnderlineBorder();
            }
            if ("image".equals(this.getType())) {
                return this.createImageBorder(theme);
            }
            if ("horizontalImage".equals(this.getType())) {
                return this.createHorizontalImageBorder(theme);
            }
            if ("verticalImage".equals(this.getType())) {
                return this.createVerticalImageBorder(theme);
            }
            if ("splicedImage".equals(this.getType())) {
                return this.createSplicedImageBorder(theme);
            }
            if ("round".equals(this.getType())) {
                return this.createRoundBorder();
            }
            if ("roundRect".equals(this.getType())) {
                return this.createRoundRectBorder();
            }
            return Border.createEmpty();
        }

        public double[] getSpliceInsets(double[] out) {
            String[] parts = Util.split(this.getSpliceInsets(), " ");
            out[0] = Double.parseDouble(parts[0]);
            out[3] = Double.parseDouble(parts[1]);
            out[2] = Double.parseDouble(parts[2]);
            out[1] = Double.parseDouble(parts[3]);
            return out;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getSpliceImage() {
            return this.spliceImage;
        }

        public void setSpliceImage(String spliceImage) {
            this.spliceImage = spliceImage;
        }

        public String[] getImages() {
            return this.images;
        }

        public void setImages(String[] images) {
            this.images = images;
        }

        public String getSpliceInsets() {
            return this.spliceInsets;
        }

        public void setSpliceInsets(String spliceInsets) {
            this.spliceInsets = spliceInsets;
        }

        public void setSpliceInsets(double[] insets) {
            this.spliceInsets = insets[0] + " " + insets[3] + " " + insets[2] + " " + insets[1];
        }

        public void setSpliceInsets(double[] insets, int decimalPlaces) {
            L10NManager l = L10NManager.getInstance();
            this.spliceInsets = BorderInfo.round(insets[0], decimalPlaces) + " " + BorderInfo.round(insets[3], decimalPlaces) + " " + BorderInfo.round(insets[2], decimalPlaces) + " " + BorderInfo.round(insets[1], decimalPlaces);
        }

        private static double round(double d, int decimalPlaces) {
            int decLen;
            int i;
            for (i = 0; i < decimalPlaces; ++i) {
                d *= 10.0;
            }
            d = Math.round(d);
            for (i = 0; i < decimalPlaces; ++i) {
                d /= 10.0;
            }
            String dStr = String.valueOf(d);
            int decPos = dStr.indexOf(".");
            if (decPos != -1 && (decLen = dStr.length() - decPos) > decimalPlaces) {
                dStr = dStr.substring(0, dStr.length() - (decLen - decimalPlaces));
                d = Double.parseDouble(dStr);
            }
            return d;
        }

        public Float getWidth() {
            return this.width;
        }

        public ScalarValue getThickness() {
            return new ScalarValue(this.width.floatValue(), this.widthUnit);
        }

        public Integer getWidthInPixels() {
            if (this.width == null) {
                return null;
            }
            if (this.widthUnit == 2) {
                return Display.getInstance().convertToPixels(this.width.floatValue());
            }
            return this.width.intValue();
        }

        public void setWidth(Float width) {
            this.width = width;
        }

        public byte getWidthUnit() {
            return this.widthUnit;
        }

        public void setWidthUnit(byte widthUnit) {
            this.widthUnit = widthUnit;
        }

        public Integer getColor() {
            return this.color;
        }

        public void setColor(Integer color) {
            this.color = color;
        }

        public Integer getOpacity() {
            return this.opacity;
        }

        public void setOpacity(Integer opacity) {
            this.opacity = opacity;
        }

        public Integer getStrokeColor() {
            return this.strokeColor;
        }

        public void setStrokeColor(Integer strokeColor) {
            this.strokeColor = strokeColor;
        }

        public Integer getStrokeOpacity() {
            return this.strokeOpacity;
        }

        public void setStrokeOpacity(Integer strokeOpacity) {
            this.strokeOpacity = strokeOpacity;
        }

        public Integer getShadowOpacity() {
            return this.shadowOpacity;
        }

        public void setShadowOpacity(Integer shadowOpacity) {
            this.shadowOpacity = shadowOpacity;
        }

        public Float getShadowX() {
            return this.shadowX;
        }

        public void setShadowX(Float shadowX) {
            this.shadowX = shadowX;
        }

        public Float getShadowY() {
            return this.shadowY;
        }

        public void setShadowY(Float shadowY) {
            this.shadowY = shadowY;
        }

        public Float getShadowBlur() {
            return this.shadowBlur;
        }

        public void setShadowBlur(Float shadowBlur) {
            this.shadowBlur = shadowBlur;
        }

        public ScalarValue getShadowSpread() {
            return this.shadowSpread;
        }

        public void setShadowSpread(ScalarValue shadowSpread) {
            this.shadowSpread = shadowSpread;
        }

        public void setShadowSpread(String val) {
            this.shadowSpread = StyleParser.parseScalarValue(val);
        }

        public Boolean getRectangle() {
            return this.rectangle;
        }

        public void setRectangle(Boolean rectangle) {
            this.rectangle = rectangle;
        }

        public Boolean getTopOnlyMode() {
            return this.topOnlyMode;
        }

        public void setTopOnlyMode(Boolean topOnlyMode) {
            this.topOnlyMode = topOnlyMode;
        }

        public Boolean getBottomOnlyMode() {
            return this.bottomOnlyMode;
        }

        public void setBottomOnlyMode(Boolean bottomOnlyMode) {
            this.bottomOnlyMode = bottomOnlyMode;
        }

        public Boolean getTopLeftMode() {
            return this.topLeftMode;
        }

        public void setTopLeftMode(Boolean topLeftMode) {
            this.topLeftMode = topLeftMode;
        }

        public Boolean getTopRightMode() {
            return this.topRightMode;
        }

        public void setTopRightMode(Boolean topRightMode) {
            this.topRightMode = topRightMode;
        }

        public Boolean getBottomLeftMode() {
            return this.bottomLeftMode;
        }

        public void setBottomLeftMode(Boolean bottomLeftMode) {
            this.bottomLeftMode = bottomLeftMode;
        }

        public Boolean getBottomRightMode() {
            return this.bottomRightMode;
        }

        public void setBottomRightMode(Boolean bottomRightMode) {
            this.bottomRightMode = bottomRightMode;
        }

        public Float getCornerRadius() {
            return this.cornerRadius;
        }

        public void setCornerRadius(Float cornerRadius) {
            this.cornerRadius = cornerRadius;
        }

        public void setCornerRadius(String cornerRadius) {
            this.setCornerRadius(Float.valueOf(StyleParser.getMMValue(cornerRadius)));
        }

        public void setCornerRadius(ScalarValue sv) {
            switch (sv.getUnit()) {
                case 2: {
                    this.setCornerRadius(Float.valueOf((float)sv.getValue()));
                    break;
                }
                default: {
                    this.setCornerRadius(Float.valueOf((float)sv.getPixelValue() / (float)Display.getInstance().convertToPixels(1.0f)));
                }
            }
        }
    }

    public static class MarginInfo
    extends BoxInfo {
        public MarginInfo(ScalarValue[] values) {
            super(values);
        }

        float[] createMargin(Style baseStyle) {
            float[] out = new float[4];
            for (int i = 0; i < 4; ++i) {
                out[i] = this.createMargin(baseStyle, i);
            }
            return out;
        }

        float createMargin(Style baseStyle, int side) {
            ScalarValue v = this.values[side];
            switch (v.unit) {
                case 99: {
                    int px = baseStyle.getPadding(side);
                    byte[] units = baseStyle.getMarginUnit();
                    if (units == null) {
                        return px;
                    }
                    switch (units[side]) {
                        case 2: {
                            return (float)px / (float)Display.getInstance().convertToPixels(1.0f);
                        }
                    }
                    return px;
                }
            }
            return (float)v.value;
        }

        byte[] createMarginUnit(Style baseStyle) {
            byte[] out = new byte[4];
            for (int i = 0; i < 4; ++i) {
                out[i] = this.createMarginUnit(baseStyle, i);
            }
            return out;
        }

        byte createMarginUnit(Style baseStyle, int side) {
            ScalarValue v = this.values[side];
            switch (v.unit) {
                case 99: {
                    byte[] units = baseStyle.getMarginUnit();
                    if (units == null) {
                        return 0;
                    }
                    return units[side];
                }
            }
            return v.unit;
        }
    }

    public static class PaddingInfo
    extends BoxInfo {
        public PaddingInfo(ScalarValue[] values) {
            super(values);
        }

        float[] createPadding(Style baseStyle) {
            float[] out = new float[4];
            for (int i = 0; i < 4; ++i) {
                out[i] = this.createPadding(baseStyle, i);
            }
            return out;
        }

        float createPadding(Style baseStyle, int side) {
            ScalarValue v = this.values[side];
            switch (v.unit) {
                case 99: {
                    int px = baseStyle.getPadding(side);
                    byte[] units = baseStyle.getPaddingUnit();
                    if (units == null) {
                        return px;
                    }
                    switch (units[side]) {
                        case 2: {
                            return (float)px / (float)Display.getInstance().convertToPixels(1.0f);
                        }
                    }
                    return px;
                }
            }
            return (float)v.value;
        }

        byte[] createPaddingUnit(Style baseStyle) {
            byte[] out = new byte[4];
            for (int i = 0; i < 4; ++i) {
                out[i] = this.createPaddingUnit(baseStyle, i);
            }
            return out;
        }

        byte createPaddingUnit(Style baseStyle, int side) {
            ScalarValue v = this.values[side];
            switch (v.unit) {
                case 99: {
                    byte[] units = baseStyle.getPaddingUnit();
                    if (units == null) {
                        return 0;
                    }
                    return units[side];
                }
            }
            return v.unit;
        }
    }

    public static class BoxInfo {
        protected ScalarValue[] values;

        public BoxInfo(ScalarValue[] values) {
            if (values.length != 4) {
                throw new IllegalArgumentException("BoxInfo expected 4-element array");
            }
            this.values = values;
        }

        public String toString() {
            return this.toString(0) + " " + this.toString(3) + " " + this.toString(2) + " " + this.toString(1);
        }

        public String toString(int side) {
            return this.values[side].toString();
        }

        public ScalarValue[] getValues() {
            return this.values;
        }

        public void setValues(ScalarValue[] values) {
            if (values.length != 4) {
                throw new IllegalArgumentException("BoxInfo requires array with 4 values.");
            }
            this.values = values;
        }

        public ScalarValue getValue(int side) {
            return this.values[side];
        }
    }

    public static class ImageInfo {
        private String image;

        public ImageInfo(String image) {
            this.image = image;
        }

        public String toString() {
            return this.image;
        }

        public Image getImage(Resources theme) {
            return StyleParser.getImage(theme, this.image);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StyleInfo {
        Map<String, String> values;

        public StyleInfo(String ... styleString) {
            if (styleString == null) {
                this.values = new HashMap<String, String>();
            } else {
                HashMap<String, String> vals = new HashMap<String, String>();
                for (String str : styleString) {
                    if (str == null || str.length() <= 0) continue;
                    StyleParser.parseString(vals, str);
                }
                this.values = vals;
            }
        }

        public StyleInfo(Map<String, String> values) {
            this.values = values;
        }

        public StyleInfo() {
            this(new HashMap<String, String>());
        }

        public StyleInfo(StyleInfo info) {
            this(info.toStyleString());
        }

        public PaddingInfo getPadding() {
            if (this.values.containsKey("padding")) {
                return StyleParser.parsePadding(this.values.get("padding"));
            }
            return null;
        }

        public MarginInfo getMargin() {
            if (this.values.containsKey("margin")) {
                return StyleParser.parseMargin(this.values.get("margin"));
            }
            return null;
        }

        public BorderInfo getBorder() {
            if (this.values.containsKey("border")) {
                return StyleParser.parseBorder(new BorderInfo(), this.values.get("border"));
            }
            return null;
        }

        public FontInfo getFont() {
            if (this.values.containsKey("font")) {
                return StyleParser.parseFont(new FontInfo(), this.values.get("font"));
            }
            return null;
        }

        public StyleInfo setFont(String font) {
            this.values.put("font", font);
            return this;
        }

        public StyleInfo setFontSize(String fontSize) {
            FontInfo finfo = this.getFont();
            if (finfo == null) {
                finfo = StyleParser.parseFont(new FontInfo(), fontSize);
                if (finfo != null) {
                    this.setFont(finfo.toString());
                }
            } else {
                FontInfo tmp = StyleParser.parseFont(new FontInfo(), fontSize);
                if (tmp != null) {
                    finfo.setSize(tmp.getSize());
                    finfo.setSizeUnit(tmp.getSizeUnit());
                    this.setFont(finfo.toString());
                } else {
                    finfo.setSizeUnit((byte)99);
                    this.setFont(finfo.toString());
                }
            }
            return this;
        }

        public StyleInfo setFontName(String fontName) {
            FontInfo finfo = this.getFont();
            if (finfo == null) {
                finfo = StyleParser.parseFont(new FontInfo(), fontName);
                if (finfo != null) {
                    this.setFont(finfo.toString());
                }
            } else {
                FontInfo tmp = StyleParser.parseFont(new FontInfo(), fontName);
                if (tmp != null) {
                    finfo.setName(tmp.getName());
                    finfo.setFile(tmp.getFile());
                    this.setFont(finfo.toString());
                } else {
                    finfo.setName(null);
                    finfo.setFile(null);
                    this.setFont(finfo.toString());
                }
            }
            return this;
        }

        public Integer getBgColor() {
            if (this.values.containsKey("bgColor")) {
                return Integer.parseInt(this.values.get("bgColor"), 16);
            }
            return null;
        }

        public Integer getFgColor() {
            if (this.values.containsKey("fgColor")) {
                return Integer.parseInt(this.values.get("fgColor"), 16);
            }
            return null;
        }

        public StyleInfo setFgColor(String fgColor) {
            if (fgColor == null || fgColor.trim().length() == 0) {
                this.values.remove("fgColor");
            } else {
                this.values.put("fgColor", fgColor);
            }
            return this;
        }

        public StyleInfo setBgColor(String bgColor) {
            if (bgColor == null || bgColor.trim().length() == 0) {
                this.values.remove("bgColor");
            } else {
                this.values.put("bgColor", bgColor);
            }
            return this;
        }

        public StyleInfo setTransparency(String transparency) {
            if (transparency == null || transparency.trim().length() == 0) {
                this.values.remove("transparency");
            } else {
                this.values.put("transparency", transparency);
            }
            return this;
        }

        public StyleInfo setOpacity(String opacity) {
            if (opacity == null || opacity.trim().length() == 0) {
                this.values.remove("opacity");
            } else {
                this.values.put("opacity", opacity);
            }
            return this;
        }

        public StyleInfo setPadding(String padding) {
            if (padding == null || padding.trim().length() == 0) {
                this.values.remove("padding");
            } else {
                this.values.put("padding", padding);
            }
            return this;
        }

        public StyleInfo setMargin(String margin) {
            if (margin == null || margin.trim().length() == 0) {
                this.values.remove("margin");
            } else {
                this.values.put("margin", margin);
            }
            return this;
        }

        public StyleInfo setBorder(String border) {
            if (border == null || border.trim().length() == 0) {
                this.values.remove("border");
            } else {
                this.values.put("border", border);
            }
            return this;
        }

        public Integer getTransparency() {
            if (this.values.containsKey("transparency")) {
                return Integer.parseInt(this.values.get("transparency"));
            }
            return null;
        }

        public Integer getOpacity() {
            if (this.values.containsKey("opacity")) {
                return Integer.parseInt(this.values.get("opacity"));
            }
            return null;
        }

        public Integer getAlignment() {
            if (this.values.containsKey("alignment")) {
                return StyleParser.parseAlignment(this.values.get("alignment"));
            }
            return null;
        }

        public StyleInfo setAlignment(int alignment) {
            this.values.put("alignment", String.valueOf(alignment));
            return this;
        }

        public StyleInfo setAlignment(String alignment) {
            if (alignment == null || alignment.length() == 0) {
                this.values.remove("alignment");
            } else {
                this.values.put("alignment", alignment);
            }
            return this;
        }

        public String getAlignmentAsString() {
            return StyleParser.getAlignmentString(this.getAlignment());
        }

        public Integer getBgType() {
            if (this.values.containsKey("bgType")) {
                return StyleParser.parseBgType(this.values.get("bgType"));
            }
            return null;
        }

        public StyleInfo setBgType(String type) {
            this.values.put("bgType", type);
            return this;
        }

        public StyleInfo setBgType(Integer i) {
            this.setBgType((String)StyleParser.flip(bgTypes).get(i));
            return this;
        }

        public String getBgTypeAsString() {
            Integer bgType = this.getBgType();
            if (bgType == null) {
                return null;
            }
            Map inverseMap = StyleParser.flip(StyleParser.bgTypes());
            if (inverseMap.containsKey(bgType)) {
                return (String)inverseMap.get(bgType);
            }
            return null;
        }

        public ImageInfo getBgImage() {
            if (this.values.containsKey("bgImage")) {
                ImageInfo out = new ImageInfo(this.values.get("bgImage"));
                return out;
            }
            return null;
        }

        public StyleInfo setBgImage(String bgImage) {
            this.values.put("bgImage", bgImage);
            return this;
        }

        public Integer getTextDecoration() {
            if (this.values.containsKey("textDecoration")) {
                String val = this.values.get("textDecoration");
                if ("3d".equalsIgnoreCase(val)) {
                    return 8;
                }
                if ("3d_lowered".equalsIgnoreCase(val)) {
                    return 16;
                }
                if ("3D_SHADOW_NORTH".equalsIgnoreCase(val)) {
                    return 32;
                }
                if ("none".equalsIgnoreCase(val)) {
                    return 0;
                }
                if ("overline".equalsIgnoreCase(val)) {
                    return 4;
                }
                if ("strikethru".equalsIgnoreCase(val)) {
                    return 2;
                }
                if ("underine".equalsIgnoreCase(val)) {
                    return 1;
                }
            }
            return null;
        }

        public String getTextDecorationAsString() {
            if (this.values.containsKey("textDecoration")) {
                return this.values.get("textDecoration");
            }
            return null;
        }

        public String toStyleString() {
            Integer textDecoration;
            PaddingInfo padding;
            MarginInfo margin;
            Integer alignment;
            ImageInfo image;
            Integer bgType;
            Integer opacity;
            Integer transparency;
            Integer fgColor;
            Integer bgColor;
            BorderInfo binfo;
            StringBuilder sb = new StringBuilder();
            FontInfo finfo = this.getFont();
            if (finfo != null) {
                sb.append("font:").append(finfo.toString()).append("; ");
            }
            if ((binfo = this.getBorder()) != null) {
                sb.append("border:").append(binfo.toString()).append("; ");
            }
            if ((bgColor = this.getBgColor()) != null) {
                sb.append("bgColor:").append(Integer.toHexString(bgColor)).append("; ");
            }
            if ((fgColor = this.getFgColor()) != null) {
                sb.append("fgColor:").append(Integer.toHexString(fgColor)).append("; ");
            }
            if ((transparency = this.getTransparency()) != null) {
                sb.append("transparency:").append(transparency).append("; ");
            }
            if ((opacity = this.getOpacity()) != null) {
                sb.append("opacity:").append(opacity).append("; ");
            }
            if ((bgType = this.getBgType()) != null) {
                sb.append("bgType:").append(this.getBgTypeAsString()).append("; ");
            }
            if ((image = this.getBgImage()) != null) {
                sb.append("bgImage:").append(this.getBgImage().toString()).append("; ");
            }
            if ((alignment = this.getAlignment()) != null) {
                sb.append("alignment:").append(this.getAlignmentAsString()).append("; ");
            }
            if ((margin = this.getMargin()) != null) {
                sb.append("margin:").append(margin.toString()).append("; ");
            }
            if ((padding = this.getPadding()) != null) {
                sb.append("padding:").append(padding.toString()).append("; ");
            }
            if ((textDecoration = this.getTextDecoration()) != null) {
                sb.append("textDecoration:").append(this.getTextDecorationAsString()).append("; ");
            }
            return sb.toString().trim();
        }
    }

    public static class ScalarValue {
        private byte unit;
        private double value;

        public ScalarValue(double value, byte unit) {
            this.value = value;
            this.unit = unit;
        }

        public ScalarValue() {
        }

        public byte getUnit() {
            return this.unit;
        }

        public void setUnit(byte unit) {
            this.unit = unit;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }

        public String toString() {
            switch (this.unit) {
                case 99: {
                    return "inherit";
                }
                case 2: {
                    return this.value + "mm";
                }
                case 1: {
                    return this.value + "%";
                }
            }
            return (int)Math.round(this.value) + "px";
        }

        public String toString(int decimalPlaces) {
            switch (this.unit) {
                case 99: {
                    return "inherit";
                }
                case 2: {
                    return StyleParser.format(this.value, decimalPlaces) + "mm";
                }
                case 1: {
                    return StyleParser.format(this.value, decimalPlaces) + "%";
                }
            }
            return (int)Math.round(this.value) + "px";
        }

        public int getPixelValue() {
            switch (this.unit) {
                case 99: {
                    return 0;
                }
                case 2: {
                    return Display.getInstance().convertToPixels((float)this.value);
                }
                case 1: {
                    return (int)((double)Display.getInstance().getDisplayWidth() * this.value / 100.0);
                }
            }
            return (int)Math.round(this.value);
        }
    }
}

