/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.util.regex;

public class RECharacter {
    public static final byte UNASSIGNED = 0;
    public static final byte UPPERCASE_LETTER = 1;
    public static final byte LOWERCASE_LETTER = 2;
    public static final byte TITLECASE_LETTER = 3;
    public static final byte MODIFIER_LETTER = 4;
    public static final byte OTHER_LETTER = 5;
    public static final byte NON_SPACING_MARK = 6;
    public static final byte ENCLOSING_MARK = 7;
    public static final byte COMBINING_SPACING_MARK = 8;
    public static final byte DECIMAL_DIGIT_NUMBER = 9;
    public static final byte LETTER_NUMBER = 10;
    public static final byte OTHER_NUMBER = 11;
    public static final byte SPACE_SEPARATOR = 12;
    public static final byte LINE_SEPARATOR = 13;
    public static final byte PARAGRAPH_SEPARATOR = 14;
    public static final byte CONTROL = 15;
    public static final byte FORMAT = 16;
    public static final byte PRIVATE_USE = 18;
    public static final byte SURROGATE = 19;
    public static final byte DASH_PUNCTUATION = 20;
    public static final byte START_PUNCTUATION = 21;
    public static final byte END_PUNCTUATION = 22;
    public static final byte CONNECTOR_PUNCTUATION = 23;
    public static final byte OTHER_PUNCTUATION = 24;
    public static final byte MATH_SYMBOL = 25;
    public static final byte CURRENCY_SYMBOL = 26;
    public static final byte MODIFIER_SYMBOL = 27;
    public static final byte OTHER_SYMBOL = 28;
    static final byte[] CHAR_CLASSES = new byte[]{15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 12, 23, 23, 23, 25, 23, 23, 23, 20, 21, 23, 24, 23, 19, 23, 23, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 23, 23, 24, 24, 24, 23, 23, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 20, 23, 21, 26, 22, 26, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 20, 24, 21, 24, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 12, 23, 25, 25, 25, 25, 27, 27, 26, 27, 2, 28, 24, 16, 27, 26, 27, 24, 11, 11, 26, 2, 27, 23, 26, 11, 2, 29, 11, 11, 11, 23, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 24, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 24, 2, 2, 2, 2, 2, 2, 2, 2};

    public static char toLowerCase(char c) {
        return Character.toLowerCase(c);
    }

    public static char toUpperCase(char c) {
        return Character.toUpperCase(c);
    }

    public static boolean isWhitespace(char c) {
        byte type = RECharacter.getType(c);
        return (type == 12 || type == 13 || type == 14) && c != '\u00a0' && c != '\u2007' && c != '\u202f' || c == '\t' || c == '\n' || c == '\u000b' || c == '\f' || c == '\r' || c == '\t' || c == '\u001c' || c == '\u001d' || c == '\u001e' || c == '\u001f';
    }

    public static boolean isDigit(char c) {
        byte type = RECharacter.getType(c);
        return type == 9;
    }

    public static boolean isLetter(char c) {
        byte type = RECharacter.getType(c);
        return type == 2 || type == 1 || type == 3 || type == 5;
    }

    public static boolean isLetterOrDigit(char c) {
        return RECharacter.isDigit(c) || RECharacter.isLetter(c);
    }

    public static boolean isSpaceChar(char c) {
        byte type = RECharacter.getType(c);
        return type == 12 || type == 13 || type == 14;
    }

    public static boolean isJavaIdentifierStart(char c) {
        byte type = RECharacter.getType(c);
        return RECharacter.isLetter(c) || type == 10 || c == '$' || c == '_';
    }

    public static boolean isJavaIdentifierPart(char c) {
        return RECharacter.isJavaIdentifierStart(c) || Character.isDigit(c);
    }

    public static byte getType(char c) {
        if (c < CHAR_CLASSES.length) {
            return CHAR_CLASSES[c];
        }
        return 0;
    }
}

