/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.io.services;

import com.codename1.io.Externalizable;
import com.codename1.io.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CachedData
implements Externalizable {
    private byte[] data;
    private String url;
    private String etag;
    private String modified;
    private boolean fetching;

    public int getVersion() {
        return 1;
    }

    public void externalize(DataOutputStream out) throws IOException {
        Util.writeUTF(this.url, out);
        Util.writeUTF(this.etag, out);
        Util.writeUTF(this.modified, out);
        out.writeInt(this.data.length);
        out.write(this.data);
    }

    public void internalize(int version, DataInputStream in) throws IOException {
        this.url = Util.readUTF(in);
        this.etag = Util.readUTF(in);
        this.modified = Util.readUTF(in);
        this.data = new byte[in.readInt()];
        in.readFully(this.data);
    }

    public String getObjectId() {
        return "CachedData";
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    String getEtag() {
        return this.etag;
    }

    void setEtag(String etag) {
        this.etag = etag;
    }

    String getModified() {
        return this.modified;
    }

    void setModified(String modified) {
        this.modified = modified;
    }

    boolean isFetching() {
        return this.fetching;
    }

    void setFetching(boolean fetching) {
        this.fetching = fetching;
    }
}

