/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.io.services;

import com.codename1.io.CharArrayReader;
import com.codename1.io.ConnectionRequest;
import com.codename1.io.NetworkEvent;
import com.codename1.ui.Dialog;
import com.codename1.ui.Image;
import com.codename1.xml.Element;
import com.codename1.xml.ParserCallback;
import com.codename1.xml.XMLParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;

public class RSSService
extends ConnectionRequest
implements ParserCallback {
    private Vector results;
    private int limit = -1;
    private int startOffset = -1;
    private boolean hasMore;
    private boolean createPlainTextDetails = true;
    private Image iconPlaceholder;

    public RSSService(String url) {
        this.setUrl(url);
        this.setPost(false);
        this.setDuplicateSupported(true);
    }

    public RSSService(String url, int limit) {
        this(url);
        this.limit = limit;
        this.setDuplicateSupported(true);
    }

    public RSSService(String url, int limit, int startOffset) {
        this(url, limit);
        this.startOffset = startOffset;
        this.setDuplicateSupported(true);
    }

    protected void readResponse(InputStream input) throws IOException {
        class FinishParsing
        extends RuntimeException {
            FinishParsing() {
            }
        }
        this.results = new Vector();
        XMLParser p = new XMLParser(){
            private String lastTag;
            private Hashtable current;
            private String url;

            protected boolean startTag(String tag) {
                if ("item".equalsIgnoreCase(tag) || "entry".equalsIgnoreCase(tag)) {
                    if (RSSService.this.startOffset > 0) {
                        return true;
                    }
                    this.current = new Hashtable();
                    if (RSSService.this.iconPlaceholder != null) {
                        this.current.put("icon", RSSService.this.iconPlaceholder);
                    }
                }
                this.lastTag = tag;
                return true;
            }

            protected void attribute(String tag, String attributeName, String value) {
                if (this.current != null) {
                    if ("media:thumbnail".equalsIgnoreCase(tag) && "url".equalsIgnoreCase(attributeName)) {
                        this.current.put("thumb", value);
                    } else if ("media:player".equalsIgnoreCase(tag) && "url".equalsIgnoreCase(attributeName)) {
                        this.current.put("player", value);
                    }
                }
            }

            protected void textElement(String text) {
                if (this.lastTag != null && this.current != null) {
                    if ("summary".equals(this.lastTag)) {
                        this.current.put("details", text);
                    } else if ("content".equals(this.lastTag)) {
                        this.current.put("description", text);
                    } else {
                        this.current.put(this.lastTag, text);
                    }
                }
            }

            protected void endTag(String tag) {
                if ("item".equalsIgnoreCase(tag) || "entry".equalsIgnoreCase(tag)) {
                    if (RSSService.this.startOffset > 0) {
                        RSSService.this.startOffset--;
                        return;
                    }
                    RSSService.this.results.addElement(this.current);
                    this.current = null;
                    if (RSSService.this.limit > -1 && RSSService.this.results.size() >= RSSService.this.limit) {
                        throw new FinishParsing();
                    }
                }
                if (tag.equals(this.lastTag)) {
                    this.lastTag = null;
                }
            }
        };
        p.setParserCallback(this);
        input.mark(10);
        while (input.read() != 60) {
        }
        int question = input.read();
        String cType = "UTF-8";
        if (question == 63) {
            StringBuilder cs = new StringBuilder();
            question = input.read();
            while (question != 62) {
                cs.append((char)question);
                question = input.read();
            }
            String str = cs.toString();
            int index = str.indexOf("encoding=\"") + 10;
            if (index > -1) {
                cType = str.substring(index, Math.max(str.indexOf("\"", index), str.indexOf("'", index)));
            }
        } else {
            input.reset();
        }
        String resultType = this.getResponseContentType();
        if (resultType != null && resultType.indexOf("charset=") > -1) {
            cType = resultType.substring(resultType.indexOf("charset=") + 8);
        }
        try {
            int pos2 = cType.indexOf(59);
            if (pos2 > 0) {
                cType = cType.substring(0, pos2);
            }
            p.eventParser(new InputStreamReader(input, cType));
        }
        catch (FinishParsing ignor) {
            this.hasMore = true;
        }
        if (this.isCreatePlainTextDetails()) {
            int elementCount = this.results.size();
            for (int iter = 0; iter < elementCount; ++iter) {
                Hashtable h = (Hashtable)this.results.elementAt(iter);
                String s = (String)h.get("description");
                if (s == null || h.containsKey("details")) continue;
                XMLParser x = new XMLParser();
                Element e = x.parse(new CharArrayReader(("<xml>" + s + "</xml>").toCharArray()));
                Vector results = e.getTextDescendants(null, false);
                StringBuilder endResult = new StringBuilder();
                for (int i = 0; i < results.size(); ++i) {
                    endResult.append(((Element)results.elementAt(i)).getText());
                }
                h.put("details", endResult.toString());
            }
        }
        this.fireResponseListener(new NetworkEvent((ConnectionRequest)this, this.results));
    }

    public Vector getResults() {
        return this.results;
    }

    public boolean parsingError(int errorId, String tag, String attribute, String value, String description) {
        return Dialog.show("Parsing Error", description, "Continue", "Cancel");
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    public boolean isCreatePlainTextDetails() {
        return this.createPlainTextDetails;
    }

    public void setCreatePlainTextDetails(boolean createPlainTextDetails) {
        this.createPlainTextDetails = createPlainTextDetails;
    }

    public Image getIconPlaceholder() {
        return this.iconPlaceholder;
    }

    public void setIconPlaceholder(Image iconPlaceholder) {
        this.iconPlaceholder = iconPlaceholder;
    }
}

