/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.components.SliderBridge;
import com.codename1.io.ConnectionRequest;
import com.codename1.io.NetworkEvent;
import com.codename1.io.NetworkManager;
import com.codename1.ui.Button;
import com.codename1.ui.Command;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Dialog;
import com.codename1.ui.Display;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.layouts.BoxLayout;
import com.codename1.ui.layouts.FlowLayout;
import com.codename1.ui.plaf.UIManager;

public class Progress
extends Dialog
implements ActionListener {
    private ConnectionRequest request;
    private boolean disposeOnCompletion;
    private boolean autoShow;
    private boolean showing;

    public Progress(String title, ConnectionRequest request) {
        this(title, request, false);
    }

    public Progress(String title, ConnectionRequest request, boolean showPercentage) {
        super(title);
        this.request = request;
        SliderBridge b = new SliderBridge(request);
        b.setRenderPercentageOnTop(showPercentage);
        b.setRenderValueOnTop(true);
        this.setLayout(new BoxLayout(2));
        this.addComponent(b);
        Command cancel = new Command(UIManager.getInstance().localize("cancel", "Cancel"));
        if (Display.getInstance().isTouchScreenDevice() || this.getSoftButtonCount() < 2) {
            Button btn = new Button(cancel);
            Container cnt = new Container(new FlowLayout(4));
            cnt.addComponent(btn);
            this.addComponent(cnt);
        } else {
            this.addCommand(cancel);
        }
        this.setDisposeWhenPointerOutOfBounds(false);
        this.setAutoDispose(false);
        NetworkManager.getInstance().addProgressListener(this);
    }

    protected void actionCommand(Command cmd) {
        if (Display.getInstance().isTouchScreenDevice() || this.getSoftButtonCount() < 2) {
            for (int iter = 0; iter < this.getComponentCount(); ++iter) {
                Component c = this.getComponentAt(iter);
                if (!(c instanceof Button)) continue;
                c.setEnabled(false);
            }
        } else {
            this.removeAllCommands();
        }
        this.request.kill();
        this.dispose();
    }

    public void dispose() {
        NetworkManager.getInstance().removeProgressListener(this);
        super.dispose();
        this.showing = false;
        this.autoShow = false;
    }

    public boolean isDisposeOnCompletion() {
        return this.disposeOnCompletion;
    }

    public void setDisposeOnCompletion(boolean disposeOnCompletion) {
        this.disposeOnCompletion = disposeOnCompletion;
    }

    public void actionPerformed(ActionEvent evt) {
        NetworkEvent ev = (NetworkEvent)evt;
        if (ev.getConnectionRequest() == this.request) {
            if (this.disposeOnCompletion && ev.getProgressType() == 4) {
                this.dispose();
                return;
            }
            if (this.autoShow && !this.showing) {
                this.showing = true;
                this.showModeless();
            }
        }
    }

    public boolean isAutoShow() {
        return this.autoShow;
    }

    public void setAutoShow(boolean autoShow) {
        this.autoShow = autoShow;
    }
}

