/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.ui.Button;
import com.codename1.ui.Display;
import com.codename1.ui.Form;
import com.codename1.ui.Image;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.plaf.Style;

public class ScaleImageButton
extends Button {
    public ScaleImageButton() {
        this.setUIID("ScaleImageButton");
        this.setShowEvenIfBlank(true);
        this.getAllStyles().setBackgroundType((byte)34);
        this.getAllStyles().setBgTransparency(255);
    }

    public ScaleImageButton(Image i) {
        this.setUIID("ScaleImageButton");
        this.setShowEvenIfBlank(true);
        this.getAllStyles().setBackgroundType((byte)34);
        this.getAllStyles().setBgTransparency(255);
        this.setIcon(i);
    }

    public void setBackgroundType(byte behavior) {
        this.getAllStyles().setBackgroundType(behavior);
    }

    public byte getBackgroundType() {
        return this.getUnselectedStyle().getBackgroundType();
    }

    protected Dimension calcPreferredSize() {
        Image i = this.getIcon();
        if (i == null) {
            return new Dimension();
        }
        int dw = Display.getInstance().getDisplayWidth();
        int iw = i.getWidth();
        int ih = i.getHeight();
        if (iw > dw) {
            float ratio = (float)iw / (float)dw;
            iw = (int)((float)iw / ratio);
            ih = (int)((float)ih / ratio);
        }
        Style s = this.getStyle();
        return new Dimension(iw + s.getPaddingLeftNoRTL() + s.getPaddingRightNoRTL(), ih + s.getPaddingTop() + s.getPaddingBottom());
    }

    public void setUIID(String id) {
        byte type = this.getBackgroundType();
        Image icon = this.getIcon();
        super.setUIID(id);
        this.setIcon(icon);
        this.getAllStyles().setBackgroundType(type);
        this.getAllStyles().setBgTransparency(255);
    }

    protected void refreshTheme(String id, boolean merge) {
        byte type = this.getBackgroundType();
        Image icon = this.getIcon();
        super.refreshTheme(id, merge);
        this.setIcon(icon);
        this.getAllStyles().setBackgroundType(type);
        this.getAllStyles().setBgTransparency(255);
    }

    public void setIcon(Image i) {
        this.setShouldCalcPreferredSize(true);
        this.getAllStyles().setBgImage(i);
        if (i != null && i.isAnimation()) {
            this.checkAnimation(i);
        }
    }

    protected void initComponent() {
        super.initComponent();
        this.checkAnimation(this.getIcon());
    }

    void checkAnimation(Image icon) {
        Form parent;
        if (icon != null && icon.isAnimation() && (parent = this.getComponentForm()) != null) {
            parent.registerAnimated(this);
        }
    }

    public Image getIcon() {
        return this.getUnselectedStyle().getBgImage();
    }

    public void setText(String text) {
    }

    public Image getIconFromState() {
        return null;
    }

    public String[] getPropertyNames() {
        return new String[]{"backgroundType"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{Byte.class};
    }

    public String[] getPropertyTypeNames() {
        return new String[]{"Byte"};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("backgroundType")) {
            return this.getBackgroundType();
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("backgroundType")) {
            this.setBackgroundType((Byte)value);
            return null;
        }
        return super.setPropertyValue(name, value);
    }
}

