/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.io;

import com.codename1.annotations.Async;
import com.codename1.io.ConnectionRequest;
import com.codename1.io.Log;
import com.codename1.io.NetworkEvent;
import com.codename1.io.Util;
import com.codename1.ui.CN;
import com.codename1.ui.Dialog;
import com.codename1.ui.Display;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.util.EventDispatcher;
import com.codename1.util.AsyncResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkManager {
    public static final int ACCESS_POINT_TYPE_UNKNOWN = 1;
    public static final int ACCESS_POINT_TYPE_WLAN = 2;
    public static final int ACCESS_POINT_TYPE_CABLE = 3;
    public static final int ACCESS_POINT_TYPE_NETWORK3G = 4;
    public static final int ACCESS_POINT_TYPE_NETWORK2G = 5;
    public static final int ACCESS_POINT_TYPE_CORPORATE = 6;
    private static final Object LOCK = new Object();
    private static final NetworkManager INSTANCE = new NetworkManager();
    private Vector pending = new Vector();
    private boolean running;
    private int threadCount = 1;
    private NetworkThread[] networkThreads;
    private EventDispatcher errorListeners;
    private EventDispatcher progressListeners;
    private int timeout = 300000;
    private Hashtable threadAssignements = new Hashtable();
    private Hashtable userHeaders;
    private boolean autoDetected;
    private static String autoDetectURL = "https://www.google.com/";
    private int nextConnectionId = 1;

    public static String getAutoDetectURL() {
        return autoDetectURL;
    }

    public static void setAutoDetectURL(String aAutoDetectURL) {
        autoDetectURL = aAutoDetectURL;
    }

    private NetworkManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean checkCertificatesNativeCallback(int connectionId) {
        ArrayList<NetworkThread> threads = new ArrayList<NetworkThread>();
        Iterator iterator = LOCK;
        synchronized (iterator) {
            if (INSTANCE == null || NetworkManager.INSTANCE.networkThreads == null) {
                return true;
            }
            for (NetworkThread nt : NetworkManager.INSTANCE.networkThreads) {
                if (nt == null) continue;
                threads.add(nt);
            }
        }
        for (NetworkThread nt : threads) {
            if (nt.currentRequest == null || nt.currentRequest.getId() != connectionId) continue;
            return nt.currentRequest.checkCertificatesNativeCallback();
        }
        return true;
    }

    void resetAPN() {
        this.autoDetected = false;
    }

    boolean handleErrorCode(ConnectionRequest r, int code, String message) {
        if (this.errorListeners != null) {
            NetworkEvent ev = new NetworkEvent(r, code, message);
            this.errorListeners.fireActionEvent(ev);
            return ev.isConsumed();
        }
        return false;
    }

    private boolean handleException(ConnectionRequest r, Exception o) {
        if (this.errorListeners != null) {
            NetworkEvent ev = new NetworkEvent(r, o);
            this.errorListeners.fireActionEvent(ev);
            return ev.isConsumed();
        }
        return false;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        if (!Util.getImplementation().shouldAutoDetectAccessPoint()) {
            this.threadCount = threadCount;
        }
    }

    public void updateThreadCount(int threadCount) {
        this.threadCount = threadCount;
        this.shutdown();
        this.start();
    }

    boolean hasProgressListeners() {
        return this.progressListeners != null;
    }

    void fireProgressEvent(ConnectionRequest c, int type, int length, int sentReceived) {
        EventDispatcher d = this.progressListeners;
        if (d != null) {
            NetworkEvent n = new NetworkEvent(c, type);
            n.setLength(length);
            n.setSentReceived(sentReceived);
            d.fireActionEvent(n);
        }
    }

    private NetworkThread createNetworkThread() {
        return new NetworkThread();
    }

    public void start() {
        if (this.networkThreads != null) {
            return;
        }
        this.running = true;
        this.networkThreads = new NetworkThread[this.getThreadCount()];
        for (int iter = 0; iter < this.getThreadCount(); ++iter) {
            this.networkThreads[iter] = this.createNetworkThread();
            this.networkThreads[iter].start();
        }
        if (!Util.getImplementation().isTimeoutSupported()) {
            Util.getImplementation().startThread("Timeout Thread", new Runnable(){

                public void run() {
                    while (NetworkManager.this.running) {
                        try {
                            Thread.sleep(NetworkManager.this.timeout / 10);
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                        }
                        NetworkThread[] networkThreads = NetworkManager.this.networkThreads;
                        if (networkThreads == null) {
                            return;
                        }
                        int ntlen = networkThreads.length;
                        for (int iter = 0; iter < ntlen; ++iter) {
                            ConnectionRequest c = networkThreads[iter].getCurrentRequest();
                            if (c == null) continue;
                            int cTimeout = Math.min(NetworkManager.this.timeout, c.getTimeout());
                            if (c.getTimeout() < 0) {
                                cTimeout = NetworkManager.this.timeout;
                            }
                            if (c.getTimeSinceLastActivity() <= cTimeout) continue;
                            c.kill();
                            networkThreads[iter].interrupt();
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException ex) {
                                ex.printStackTrace();
                            }
                            if (networkThreads[iter].getCurrentRequest() != c || c.getTimeSinceLastActivity() <= cTimeout || !NetworkManager.this.running) continue;
                            networkThreads[iter] = NetworkManager.this.createNetworkThread();
                            networkThreads[iter].start();
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.running = false;
        if (this.networkThreads != null) {
            for (NetworkThread n : this.networkThreads) {
                n.stopped = true;
            }
        }
        this.networkThreads = null;
        Object object = LOCK;
        synchronized (object) {
            LOCK.notifyAll();
        }
    }

    public void shutdownSync() {
        NetworkThread t;
        NetworkThread[] n = this.networkThreads;
        if (n != null && (t = n[0]) != null) {
            this.shutdown();
            t.join();
        }
    }

    public static NetworkManager getInstance() {
        return INSTANCE;
    }

    private void addSortedToQueue(ConnectionRequest request, int priority) {
        for (int iter = 0; iter < this.pending.size(); ++iter) {
            ConnectionRequest r = (ConnectionRequest)this.pending.elementAt(iter);
            if (r.getPriority() >= priority) continue;
            this.pending.insertElementAt(request, iter);
            return;
        }
        this.pending.addElement(request);
    }

    public void addDefaultHeader(String key, String value) {
        if (this.userHeaders == null) {
            this.userHeaders = new Hashtable();
        }
        this.userHeaders.put(key, value);
    }

    public AsyncResource<ConnectionRequest> addToQueueAsync(final ConnectionRequest request) {
        final AsyncResource<ConnectionRequest> out = new AsyncResource<ConnectionRequest>();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class WaitingClass
        implements ActionListener<NetworkEvent> {
            WaitingClass() {
            }

            @Override
            public void actionPerformed(NetworkEvent e) {
                if (e.getError() != null) {
                    NetworkManager.this.removeProgressListener(this);
                    NetworkManager.this.removeErrorListener(this);
                    if (!out.isDone()) {
                        out.error(e.getError());
                    }
                    return;
                }
                if (e.getConnectionRequest() == request && e.getProgressType() == 4) {
                    if (request.retrying) {
                        request.retrying = false;
                        return;
                    }
                    NetworkManager.this.removeProgressListener(this);
                    NetworkManager.this.removeErrorListener(this);
                    if (!out.isDone()) {
                        out.complete(request);
                    }
                    return;
                }
            }
        }
        WaitingClass w = new WaitingClass();
        this.addProgressListener(w);
        this.addErrorListener(w);
        this.addToQueue(request);
        return out;
    }

    public void addToQueueAndWait(final ConnectionRequest request) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class WaitingClass
        implements Runnable,
        ActionListener<NetworkEvent> {
            private boolean edt = CN.isEdt();
            private boolean finishedWaiting;

            WaitingClass() {
            }

            @Override
            public void run() {
                if (this.edt) {
                    while (!this.finishedWaiting) {
                        try {
                            Thread.sleep(30L);
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                        }
                    }
                } else {
                    while (!request.complete) {
                        try {
                            Thread.sleep(30L);
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }

            @Override
            public void actionPerformed(NetworkEvent e) {
                if (e.getError() != null) {
                    this.finishedWaiting = true;
                    NetworkManager.this.removeProgressListener(this);
                    NetworkManager.this.removeErrorListener(this);
                    return;
                }
                if (e.getConnectionRequest() == request && e.getProgressType() == 4) {
                    if (request.retrying) {
                        request.retrying = false;
                        return;
                    }
                    this.finishedWaiting = true;
                    NetworkManager.this.removeProgressListener(this);
                    NetworkManager.this.removeErrorListener(this);
                    return;
                }
            }
        }
        WaitingClass w = new WaitingClass();
        if (Display.getInstance().isEdt()) {
            this.addProgressListener(w);
            this.addErrorListener(w);
            this.addToQueue(request);
            Display.getInstance().invokeAndBlock(w);
        } else {
            this.addToQueue(request);
            w.run();
        }
    }

    public void addToQueue(ConnectionRequest request) {
        this.addToQueue(request, false);
    }

    public void killAndWait(final ConnectionRequest request) {
        request.kill();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class KillWaitingClass
        implements Runnable {
            KillWaitingClass() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                for (int iter = 0; iter < NetworkManager.this.threadCount; ++iter) {
                    if (NetworkManager.this.networkThreads[iter].currentRequest != request) continue;
                    Object object = LOCK;
                    synchronized (object) {
                        while (NetworkManager.this.networkThreads[iter].currentRequest == request) {
                            try {
                                LOCK.wait(20L);
                            }
                            catch (InterruptedException ex) {
                                ex.printStackTrace();
                            }
                        }
                        continue;
                    }
                }
            }
        }
        Display.getInstance().invokeAndBlock(new KillWaitingClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void kill9(ConnectionRequest request) {
        if (request.isKilled()) {
            for (int iter = 0; iter < this.threadCount; ++iter) {
                if (this.networkThreads[iter].currentRequest != request) continue;
                Object object = LOCK;
                synchronized (object) {
                    if (this.networkThreads[iter].currentRequest == request) {
                        this.networkThreads[iter].interrupt();
                        this.networkThreads[iter].stopped = true;
                        this.networkThreads[iter] = this.createNetworkThread();
                        this.networkThreads[iter].start();
                    }
                    continue;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToQueue(@Async.Schedule ConnectionRequest request, boolean retry) {
        Util.getImplementation().addConnectionToQueue(request);
        if (!this.running) {
            this.start();
        }
        if (!this.autoDetected) {
            this.autoDetected = true;
            if (Util.getImplementation().shouldAutoDetectAccessPoint()) {
                AutoDetectAPN r = new AutoDetectAPN();
                r.setPost(false);
                r.setUrl(autoDetectURL);
                r.setPriority((byte)100);
                this.addToQueue(r, false);
            }
        }
        request.validateImpl();
        Object object = LOCK;
        synchronized (object) {
            ConnectionRequest currentRequest;
            int i = request.getPriority();
            if (!retry) {
                if (!request.isDuplicateSupported()) {
                    if (this.pending.contains(request)) {
                        System.out.println("Duplicate entry in the queue: " + request.getClass().getName() + ": " + request);
                        return;
                    }
                    currentRequest = this.networkThreads[0].getCurrentRequest();
                    if (currentRequest != null && !currentRequest.retrying && currentRequest.equals(request)) {
                        System.out.println("Duplicate entry detected");
                        return;
                    }
                }
            } else {
                i = 80;
            }
            switch (i) {
                case 100: {
                    this.pending.insertElementAt(request, 0);
                    currentRequest = this.networkThreads[0].getCurrentRequest();
                    if (currentRequest == null || currentRequest.getPriority() >= 100) break;
                    if (currentRequest.isPausable()) {
                        currentRequest.pause();
                        this.pending.insertElementAt(currentRequest, 1);
                        break;
                    }
                    currentRequest.kill();
                    break;
                }
                case 0: 
                case 30: 
                case 50: 
                case 80: {
                    this.addSortedToQueue(request, i);
                }
            }
            LOCK.notify();
        }
    }

    public void setTimeout(int t) {
        if (Util.getImplementation().isTimeoutSupported()) {
            Util.getImplementation().setTimeout(t);
        } else {
            this.timeout = t;
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void addErrorListener(ActionListener<NetworkEvent> e) {
        if (this.errorListeners == null) {
            this.errorListeners = new EventDispatcher();
            this.errorListeners.setBlocking(true);
        }
        this.errorListeners.addListener(e);
    }

    public void removeErrorListener(ActionListener<NetworkEvent> e) {
        if (this.errorListeners == null) {
            return;
        }
        this.errorListeners.removeListener(e);
    }

    public void addProgressListener(ActionListener<NetworkEvent> al) {
        if (this.progressListeners == null) {
            this.progressListeners = new EventDispatcher();
            this.progressListeners.setBlocking(false);
        }
        this.progressListeners.addListener(al);
    }

    public void removeProgressListener(ActionListener<NetworkEvent> al) {
        if (this.progressListeners == null) {
            return;
        }
        this.progressListeners.removeListener(al);
        Collection v = this.progressListeners.getListenerCollection();
        if (v == null || v.size() == 0) {
            this.progressListeners = null;
        }
    }

    public void assignToThread(Class requestType, int offset) {
        this.threadAssignements.put(requestType.getName(), new Integer(offset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration enumurateQueue() {
        Vector elements = new Vector();
        Object object = LOCK;
        synchronized (object) {
            Enumeration e = this.pending.elements();
            while (e.hasMoreElements()) {
                elements.addElement(e.nextElement());
            }
        }
        return elements.elements();
    }

    public boolean isQueueIdle() {
        return this.pending == null || this.networkThreads == null || this.networkThreads[0] == null || this.pending.size() == 0 && this.networkThreads[0].getCurrentRequest() == null;
    }

    public boolean isAPSupported() {
        return Util.getImplementation().isAPSupported();
    }

    public String[] getAPIds() {
        return Util.getImplementation().getAPIds();
    }

    public int getAPType(String id) {
        return Util.getImplementation().getAPType(id);
    }

    public String getAPName(String id) {
        return Util.getImplementation().getAPName(id);
    }

    public String getCurrentAccessPoint() {
        return Util.getImplementation().getCurrentAccessPoint();
    }

    public void setCurrentAccessPoint(String id) {
        Util.getImplementation().setCurrentAccessPoint(id);
    }

    class AutoDetectAPN
    extends ConnectionRequest {
        private Vector aps = null;
        private int currentAP;

        AutoDetectAPN() {
        }

        protected void handleErrorResponseCode(int code, String message) {
            this.retryWithDifferentAPN();
        }

        protected void handleException(Exception err) {
            this.retryWithDifferentAPN();
        }

        protected void readResponse(InputStream input) throws IOException {
            String s = Util.readToString(input);
            if (!s.equals("hi")) {
                this.retryWithDifferentAPN();
            }
        }

        private String nextAP() {
            if (this.aps == null) {
                int t;
                int iter;
                this.aps = new Vector();
                String[] ids = NetworkManager.this.getAPIds();
                int idlen = ids.length;
                for (iter = 0; iter < idlen; ++iter) {
                    t = NetworkManager.this.getAPType(ids[iter]);
                    if (t == 2) {
                        this.aps.insertElementAt(ids[iter], 0);
                        continue;
                    }
                    if (t != 6 && t != 4) continue;
                    this.aps.addElement(ids[iter]);
                }
                for (iter = 0; iter < idlen; ++iter) {
                    t = NetworkManager.this.getAPType(ids[iter]);
                    if (t != 5) continue;
                    this.aps.addElement(ids[iter]);
                }
            }
            if (this.currentAP >= this.aps.size()) {
                return null;
            }
            String s = (String)this.aps.elementAt(this.currentAP);
            ++this.currentAP;
            return s;
        }

        private void retryWithDifferentAPN() {
            String n = this.nextAP();
            if (n == null) {
                return;
            }
            NetworkManager.this.setCurrentAccessPoint(n);
            AutoDetectAPN r = new AutoDetectAPN();
            r.setPost(false);
            r.currentAP = this.currentAP;
            r.aps = this.aps;
            r.setUrl(autoDetectURL);
            r.setPriority((byte)100);
            NetworkManager.this.addToQueue(r);
        }

        public boolean equals(Object o) {
            return false;
        }
    }

    class NetworkThread
    implements Runnable {
        private ConnectionRequest currentRequest;
        private Thread threadInstance;
        boolean stopped = false;

        public ConnectionRequest getCurrentRequest() {
            return this.currentRequest;
        }

        public void join() {
            try {
                this.threadInstance.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }

        public void start() {
            Util.getImplementation().startThread("Network Thread", this);
        }

        public void interrupt() {
            if (this.threadInstance != null) {
                this.threadInstance.interrupt();
            }
        }

        public Thread getThreadInstance() {
            return this.threadInstance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean runCurrentRequest(@Async.Execute ConnectionRequest req) {
            block40: {
                if (NetworkManager.this.threadAssignements.size() > 0) {
                    String n = this.currentRequest.getClass().getName();
                    Integer threadOffset = (Integer)NetworkManager.this.threadAssignements.get(n);
                    NetworkThread[] networkThreads = NetworkManager.this.networkThreads;
                    if (networkThreads == null) {
                        return false;
                    }
                    if (threadOffset != null && networkThreads[threadOffset] != this) {
                        Object object = LOCK;
                        synchronized (object) {
                            if (NetworkManager.this.pending.size() > 0) {
                                NetworkManager.this.pending.insertElementAt(this.currentRequest, 1);
                                return false;
                            }
                            NetworkManager.this.pending.addElement(this.currentRequest);
                            LOCK.notify();
                            try {
                                LOCK.wait(30L);
                            }
                            catch (InterruptedException ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                }
                int frameRate = -1;
                boolean requestWasCompleted = true;
                try {
                    try {
                        switch (this.currentRequest.getPriority()) {
                            case 100: {
                                frameRate = Display.getInstance().getFrameRate();
                                Display.getInstance().setFramerate(4);
                                Thread.currentThread().setPriority(9);
                                break;
                            }
                            case 80: {
                                Thread.currentThread().setPriority(7);
                                break;
                            }
                            case 50: {
                                break;
                            }
                            case 30: {
                                Thread.currentThread().setPriority(3);
                                break;
                            }
                            case 0: {
                                Thread.currentThread().setPriority(1);
                                break;
                            }
                        }
                        if (NetworkManager.this.progressListeners != null) {
                            NetworkManager.this.progressListeners.fireActionEvent(new NetworkEvent(this.currentRequest, 1));
                        }
                        if (this.currentRequest.getShowOnInit() != null) {
                            this.currentRequest.getShowOnInit().showModeless();
                        }
                        requestWasCompleted = this.currentRequest.performOperationComplete();
                    }
                    catch (IOException e) {
                        if (!this.currentRequest.isFailSilently()) {
                            if (!NetworkManager.this.handleException(this.currentRequest, e)) {
                                this.currentRequest.handleIOException(e);
                            }
                        } else {
                            Log.e(e);
                        }
                        Object var9_12 = null;
                        Thread.currentThread().setPriority(5);
                        if (frameRate > -1) {
                            Display.getInstance().setFramerate(frameRate);
                        }
                        if (requestWasCompleted) {
                            this.currentRequest.complete = true;
                        }
                        if (NetworkManager.this.progressListeners != null) {
                            NetworkManager.this.progressListeners.fireActionEvent(new NetworkEvent(this.currentRequest, 4));
                        }
                        if (this.currentRequest.getDisposeOnCompletion() == null) return true;
                        if (this.currentRequest.isRedirecting()) return true;
                        ConnectionRequest finalReq = this.currentRequest;
                        Display.getInstance().callSerially(new Runnable(finalReq){
                            final /* synthetic */ ConnectionRequest val$finalReq;
                            {
                                this.val$finalReq = connectionRequest;
                            }

                            public void run() {
                                Dialog dlg = this.val$finalReq.getDisposeOnCompletion();
                                if (dlg != null) {
                                    dlg.dispose();
                                }
                            }
                        });
                        return true;
                    }
                    catch (RuntimeException er) {
                        if (!this.currentRequest.isFailSilently()) {
                            if (!NetworkManager.this.handleException(this.currentRequest, er)) {
                                this.currentRequest.handleRuntimeException(er);
                            }
                        } else {
                            Log.e(er);
                        }
                        Object var9_13 = null;
                        Thread.currentThread().setPriority(5);
                        if (frameRate > -1) {
                            Display.getInstance().setFramerate(frameRate);
                        }
                        if (requestWasCompleted) {
                            this.currentRequest.complete = true;
                        }
                        if (NetworkManager.this.progressListeners != null) {
                            NetworkManager.this.progressListeners.fireActionEvent(new NetworkEvent(this.currentRequest, 4));
                        }
                        if (this.currentRequest.getDisposeOnCompletion() == null) return true;
                        if (this.currentRequest.isRedirecting()) return true;
                        ConnectionRequest finalReq = this.currentRequest;
                        Display.getInstance().callSerially(new /* invalid duplicate definition of identical inner class */);
                        return true;
                    }
                    Object var9_11 = null;
                    Thread.currentThread().setPriority(5);
                    if (frameRate > -1) {
                        Display.getInstance().setFramerate(frameRate);
                    }
                    if (!requestWasCompleted) break block40;
                    this.currentRequest.complete = true;
                }
                catch (Throwable throwable) {
                    Object var9_14 = null;
                    Thread.currentThread().setPriority(5);
                    if (frameRate > -1) {
                        Display.getInstance().setFramerate(frameRate);
                    }
                    if (requestWasCompleted) {
                        this.currentRequest.complete = true;
                    }
                    if (NetworkManager.this.progressListeners != null) {
                        NetworkManager.this.progressListeners.fireActionEvent(new NetworkEvent(this.currentRequest, 4));
                    }
                    if (this.currentRequest.getDisposeOnCompletion() == null) throw throwable;
                    if (this.currentRequest.isRedirecting()) throw throwable;
                    ConnectionRequest finalReq = this.currentRequest;
                    Display.getInstance().callSerially(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
            }
            if (NetworkManager.this.progressListeners != null) {
                NetworkManager.this.progressListeners.fireActionEvent(new NetworkEvent(this.currentRequest, 4));
            }
            if (this.currentRequest.getDisposeOnCompletion() == null) return true;
            if (this.currentRequest.isRedirecting()) return true;
            ConnectionRequest finalReq = this.currentRequest;
            Display.getInstance().callSerially(new /* invalid duplicate definition of identical inner class */);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.threadInstance = Thread.currentThread();
            while (NetworkManager.this.running && !this.stopped) {
                Object object;
                if (NetworkManager.this.pending.size() > 0) {
                    object = LOCK;
                    synchronized (object) {
                        if (NetworkManager.this.pending.size() == 0) {
                            continue;
                        }
                        this.currentRequest = (ConnectionRequest)NetworkManager.this.pending.elementAt(0);
                        NetworkManager.this.pending.removeElementAt(0);
                        this.currentRequest.prepare();
                        if (this.currentRequest.isKilled()) {
                            continue;
                        }
                        this.currentRequest.setId(NetworkManager.this.nextConnectionId++);
                        if (NetworkManager.this.nextConnectionId > 2000000000) {
                            NetworkManager.this.nextConnectionId = 1;
                        }
                    }
                    if (NetworkManager.this.userHeaders != null) {
                        Enumeration e = NetworkManager.this.userHeaders.keys();
                        while (e.hasMoreElements()) {
                            String key = (String)e.nextElement();
                            String value = (String)NetworkManager.this.userHeaders.get(key);
                            this.currentRequest.addRequestHeaderDontRepleace(key, value);
                        }
                    }
                    if (!this.runCurrentRequest(this.currentRequest)) continue;
                    this.currentRequest = null;
                    object = LOCK;
                    synchronized (object) {
                        LOCK.notifyAll();
                        continue;
                    }
                }
                object = LOCK;
                synchronized (object) {
                    try {
                        if (NetworkManager.this.pending.size() == 0) {
                            LOCK.wait();
                        }
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }
}

