/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.io;

import com.codename1.components.InfiniteProgress;
import com.codename1.impl.CodenameOneImplementation;
import com.codename1.io.ConnectionRequest;
import com.codename1.io.Externalizable;
import com.codename1.io.File;
import com.codename1.io.FileSystemStorage;
import com.codename1.io.IOProgressListener;
import com.codename1.io.Log;
import com.codename1.io.NetworkEvent;
import com.codename1.io.NetworkManager;
import com.codename1.io.Preferences;
import com.codename1.io.Storage;
import com.codename1.io.gzip.GZConnectionRequest;
import com.codename1.l10n.ParseException;
import com.codename1.l10n.SimpleDateFormat;
import com.codename1.properties.PropertyBusinessObject;
import com.codename1.ui.CN;
import com.codename1.ui.Dialog;
import com.codename1.ui.EncodedImage;
import com.codename1.ui.Image;
import com.codename1.ui.events.ActionListener;
import com.codename1.util.AsyncResource;
import com.codename1.util.Base64;
import com.codename1.util.CallbackAdapter;
import com.codename1.util.EasyThread;
import com.codename1.util.FailureCallback;
import com.codename1.util.OnComplete;
import com.codename1.util.SuccessCallback;
import com.codename1.util.Wrapper;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static CodenameOneImplementation implInstance;
    private static Hashtable externalizables;
    private static boolean charArrayBugTested;
    private static boolean charArrayBug;
    private static final Random downloadUrlSafelyRandom;
    private static String ignoreCharsWhenEncoding;
    private static SimpleDateFormat dateFormatter;

    public static void setIgnorCharsWhileEncoding(String s) {
        ignoreCharsWhenEncoding = s;
    }

    public static String getIgnorCharsWhileEncoding() {
        return ignoreCharsWhenEncoding;
    }

    public static void copy(InputStream i, OutputStream o) throws IOException {
        Util.copy(i, o, 8192);
    }

    public static void copyNoClose(InputStream i, OutputStream o, int bufferSize) throws IOException {
        Util.copyNoClose(i, o, bufferSize, null);
    }

    public static void copyNoClose(InputStream i, OutputStream o, int bufferSize, IOProgressListener callback) throws IOException {
        byte[] buffer = new byte[bufferSize];
        int size = i.read(buffer);
        int total = 0;
        while (size > -1) {
            o.write(buffer, 0, size);
            if (callback != null) {
                callback.ioStreamUpdate(i, total += size);
            }
            size = i.read(buffer);
        }
    }

    public static void copy(InputStream i, OutputStream o, int bufferSize) throws IOException {
        try {
            Util.copyNoClose(i, o, bufferSize);
        }
        finally {
            Util.getImplementation().cleanup(o);
            Util.getImplementation().cleanup(i);
        }
    }

    public static void cleanup(Object o) {
        Util.getImplementation().cleanup(o);
    }

    public static String readToString(InputStream i) throws IOException {
        return Util.readToString(i, "UTF-8");
    }

    public static String readToString(File file, String charset) throws IOException {
        if (charset == null) {
            charset = "UTF-8";
        }
        if (!file.exists()) {
            throw new IOException("Failed to read file " + file + " because it does not exist.");
        }
        return Util.readToString(FileSystemStorage.getInstance().openInputStream(file.getAbsolutePath()), charset);
    }

    public static String readToString(File file) throws IOException {
        return Util.readToString(file, "UTF-8");
    }

    public static void writeStringToFile(File file, String contents) throws IOException {
        Util.writeStringToFile(file, contents, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(File file, String contents, String charset) throws IOException {
        if (charset == null) {
            charset = "UTF-8";
        }
        OutputStream output = null;
        try {
            output = FileSystemStorage.getInstance().openOutputStream(file.getAbsolutePath());
            output.write(contents.getBytes(charset));
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static String readToString(InputStream i, String encoding) throws IOException {
        byte[] b = Util.readInputStream(i);
        return new String(b, 0, b.length, encoding);
    }

    public static String readToString(Reader reader) throws IOException {
        int len;
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[1024];
        while ((len = reader.read(buf)) != -1) {
            sb.append(buf, 0, len);
        }
        return sb.toString();
    }

    public static byte[] readInputStream(InputStream i) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        Util.copy(i, b);
        return b.toByteArray();
    }

    public static void register(Externalizable e) {
        externalizables.put(e.getObjectId(), e.getClass());
    }

    public static void register(String id, Class c) {
        externalizables.put(id, c);
    }

    public static void writeObject(Object o, DataOutputStream out) throws IOException {
        if (o == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        if (o instanceof Externalizable) {
            Externalizable e = (Externalizable)o;
            out.writeUTF(e.getObjectId());
            out.writeInt(e.getVersion());
            e.externalize(out);
            return;
        }
        if (o instanceof PropertyBusinessObject) {
            Externalizable e = ((PropertyBusinessObject)o).getPropertyIndex().asExternalizable();
            out.writeUTF(e.getObjectId());
            out.writeInt(e.getVersion());
            e.externalize(out);
            return;
        }
        if (o instanceof Vector) {
            Vector v = (Vector)o;
            out.writeUTF("java.util.Vector");
            int size = v.size();
            out.writeInt(size);
            for (int iter = 0; iter < size; ++iter) {
                Util.writeObject(v.elementAt(iter), out);
            }
            return;
        }
        if (o instanceof Set) {
            Collection v = (Collection)o;
            out.writeUTF("java.util.Set");
            int size = v.size();
            out.writeInt(size);
            for (Object cur : v) {
                Util.writeObject(cur, out);
            }
            return;
        }
        if (o instanceof Collection) {
            Collection v = (Collection)o;
            out.writeUTF("java.util.Collection");
            int size = v.size();
            out.writeInt(size);
            for (Object cur : v) {
                Util.writeObject(cur, out);
            }
            return;
        }
        if (o instanceof Hashtable) {
            Hashtable v = (Hashtable)o;
            out.writeUTF("java.util.Hashtable");
            out.writeInt(v.size());
            Enumeration k = v.keys();
            while (k.hasMoreElements()) {
                Object key = k.nextElement();
                Util.writeObject(key, out);
                Util.writeObject(v.get(key), out);
            }
            return;
        }
        if (o instanceof Map) {
            Map v = (Map)o;
            out.writeUTF("java.util.Map");
            out.writeInt(v.size());
            for (Object key : v.keySet()) {
                Util.writeObject(key, out);
                Util.writeObject(v.get(key), out);
            }
            return;
        }
        if (o instanceof String) {
            String v = (String)o;
            out.writeUTF("String");
            out.writeUTF(v);
            return;
        }
        if (o instanceof Date) {
            Date v = (Date)o;
            out.writeUTF("Date");
            out.writeLong(v.getTime());
            return;
        }
        if (o instanceof Integer) {
            Integer v = (Integer)o;
            out.writeUTF("int");
            out.writeInt(v);
            return;
        }
        if (o instanceof Long) {
            Long v = (Long)o;
            out.writeUTF("long");
            out.writeLong(v);
            return;
        }
        if (o instanceof Byte) {
            Byte v = (Byte)o;
            out.writeUTF("byte");
            out.writeByte(v.byteValue());
            return;
        }
        if (o instanceof Short) {
            Short v = (Short)o;
            out.writeUTF("short");
            out.writeShort(v.shortValue());
            return;
        }
        if (o instanceof Float) {
            Float v = (Float)o;
            out.writeUTF("float");
            out.writeFloat(v.floatValue());
            return;
        }
        if (o instanceof Double) {
            Double v = (Double)o;
            out.writeUTF("double");
            out.writeDouble(v);
            return;
        }
        if (o instanceof Boolean) {
            Boolean v = (Boolean)o;
            out.writeUTF("bool");
            out.writeBoolean(v);
            return;
        }
        if (o instanceof EncodedImage) {
            out.writeUTF("EncodedImage");
            EncodedImage e = (EncodedImage)o;
            out.writeInt(e.getWidth());
            out.writeInt(e.getHeight());
            out.writeBoolean(e.isOpaque());
            byte[] b = e.getImageData();
            out.writeInt(b.length);
            out.write(b);
            return;
        }
        if (Util.instanceofObjArray(o)) {
            Object[] v = (Object[])o;
            out.writeUTF("ObjectArray");
            int size = v.length;
            out.writeInt(size);
            for (int iter = 0; iter < size; ++iter) {
                Util.writeObject(v[iter], out);
            }
            return;
        }
        if (Util.instanceofByteArray(o)) {
            byte[] v = (byte[])o;
            out.writeUTF("ByteArray");
            int size = v.length;
            out.writeInt(size);
            out.write(v);
            return;
        }
        if (Util.instanceofShortArray(o)) {
            short[] v = (short[])o;
            out.writeUTF("ShortArray");
            int size = v.length;
            out.writeInt(size);
            for (int iter = 0; iter < size; ++iter) {
                out.writeShort(v[iter]);
            }
            return;
        }
        if (Util.instanceofDoubleArray(o)) {
            double[] v = (double[])o;
            out.writeUTF("DoubleArray");
            int size = v.length;
            out.writeInt(size);
            for (int iter = 0; iter < size; ++iter) {
                out.writeDouble(v[iter]);
            }
            return;
        }
        if (Util.instanceofFloatArray(o)) {
            float[] v = (float[])o;
            out.writeUTF("FloatArray");
            int size = v.length;
            out.writeInt(size);
            for (int iter = 0; iter < size; ++iter) {
                out.writeFloat(v[iter]);
            }
            return;
        }
        if (Util.instanceofIntArray(o)) {
            int[] v = (int[])o;
            out.writeUTF("IntArray");
            int size = v.length;
            out.writeInt(size);
            for (int iter = 0; iter < size; ++iter) {
                out.writeInt(v[iter]);
            }
            return;
        }
        if (Util.instanceofLongArray(o)) {
            long[] v = (long[])o;
            out.writeUTF("LongArray");
            int size = v.length;
            out.writeInt(size);
            for (int iter = 0; iter < size; ++iter) {
                out.writeLong(v[iter]);
            }
            return;
        }
        throw new IOException("Object type not supported: " + o.getClass().getName() + " value: " + o);
    }

    public static boolean instanceofObjArray(Object o) {
        return Util.getImplementation().instanceofObjArray(o);
    }

    public static boolean instanceofByteArray(Object o) {
        return Util.getImplementation().instanceofByteArray(o);
    }

    public static boolean instanceofShortArray(Object o) {
        return Util.getImplementation().instanceofShortArray(o);
    }

    public static boolean instanceofLongArray(Object o) {
        return Util.getImplementation().instanceofLongArray(o);
    }

    public static boolean instanceofIntArray(Object o) {
        return Util.getImplementation().instanceofIntArray(o);
    }

    public static boolean instanceofFloatArray(Object o) {
        return Util.getImplementation().instanceofFloatArray(o);
    }

    public static boolean instanceofDoubleArray(Object o) {
        return Util.getImplementation().instanceofDoubleArray(o);
    }

    public static Object readObject(DataInputStream input) throws IOException {
        try {
            if (!input.readBoolean()) {
                return null;
            }
            String type = input.readUTF();
            if ("int".equals(type)) {
                return new Integer(input.readInt());
            }
            if ("byte".equals(type)) {
                return new Byte(input.readByte());
            }
            if ("short".equals(type)) {
                return new Short(input.readShort());
            }
            if ("long".equals(type)) {
                return new Long(input.readLong());
            }
            if ("float".equals(type)) {
                return new Float(input.readFloat());
            }
            if ("double".equals(type)) {
                return new Double(input.readDouble());
            }
            if ("bool".equals(type)) {
                return new Boolean(input.readBoolean());
            }
            if ("String".equals(type)) {
                return input.readUTF();
            }
            if ("Date".equals(type)) {
                return new Date(input.readLong());
            }
            if ("ObjectArray".equals(type)) {
                Object[] v = new Object[input.readInt()];
                int vlen = v.length;
                for (int iter = 0; iter < vlen; ++iter) {
                    v[iter] = Util.readObject(input);
                }
                return v;
            }
            if ("ByteArray".equals(type)) {
                byte[] v = new byte[input.readInt()];
                input.readFully(v);
                return v;
            }
            if ("LongArray".equals(type)) {
                long[] v = new long[input.readInt()];
                int vlen = v.length;
                for (int iter = 0; iter < vlen; ++iter) {
                    v[iter] = input.readLong();
                }
                return v;
            }
            if ("ShortArray".equals(type)) {
                short[] v = new short[input.readInt()];
                int vlen = v.length;
                for (int iter = 0; iter < vlen; ++iter) {
                    v[iter] = input.readShort();
                }
                return v;
            }
            if ("DoubleArray".equals(type)) {
                double[] v = new double[input.readInt()];
                int vlen = v.length;
                for (int iter = 0; iter < vlen; ++iter) {
                    v[iter] = input.readDouble();
                }
                return v;
            }
            if ("FloatArray".equals(type)) {
                float[] v = new float[input.readInt()];
                int vlen = v.length;
                for (int iter = 0; iter < vlen; ++iter) {
                    v[iter] = input.readFloat();
                }
                return v;
            }
            if ("IntArray".equals(type)) {
                int[] v = new int[input.readInt()];
                int vlen = v.length;
                for (int iter = 0; iter < vlen; ++iter) {
                    v[iter] = input.readInt();
                }
                return v;
            }
            if ("java.util.Vector".equals(type)) {
                Vector<Object> v = new Vector<Object>();
                int size = input.readInt();
                for (int iter = 0; iter < size; ++iter) {
                    v.addElement(Util.readObject(input));
                }
                return v;
            }
            if ("java.util.Hashtable".equals(type)) {
                Hashtable<Object, Object> v = new Hashtable<Object, Object>();
                int size = input.readInt();
                for (int iter = 0; iter < size; ++iter) {
                    v.put(Util.readObject(input), Util.readObject(input));
                }
                return v;
            }
            if ("java.util.Set".equals(type)) {
                HashSet<Object> v = new HashSet<Object>();
                int size = input.readInt();
                for (int iter = 0; iter < size; ++iter) {
                    v.add(Util.readObject(input));
                }
                return v;
            }
            if ("java.util.Collection".equals(type)) {
                ArrayList<Object> v = new ArrayList<Object>();
                int size = input.readInt();
                for (int iter = 0; iter < size; ++iter) {
                    v.add(Util.readObject(input));
                }
                return v;
            }
            if ("java.util.Map".equals(type)) {
                HashMap<Object, Object> v = new HashMap<Object, Object>();
                int size = input.readInt();
                for (int iter = 0; iter < size; ++iter) {
                    v.put(Util.readObject(input), Util.readObject(input));
                }
                return v;
            }
            if ("EncodedImage".equals(type)) {
                int width = input.readInt();
                int height = input.readInt();
                boolean op = input.readBoolean();
                byte[] data = new byte[input.readInt()];
                input.readFully(data);
                return EncodedImage.create(data, width, height, op);
            }
            Class cls = (Class)externalizables.get(type);
            if (cls != null) {
                Object o = cls.newInstance();
                if (o instanceof Externalizable) {
                    Externalizable ex = (Externalizable)o;
                    ex.internalize(input.readInt(), input);
                    return ex;
                }
                PropertyBusinessObject pb = (PropertyBusinessObject)o;
                pb.getPropertyIndex().asExternalizable().internalize(input.readInt(), input);
                return pb;
            }
            throw new IOException("Object type not supported: " + type);
        }
        catch (InstantiationException ex1) {
            Log.e(ex1);
            throw new IOException(ex1.getClass().getName() + ": " + ex1.getMessage());
        }
        catch (IllegalAccessException ex1) {
            Log.e(ex1);
            throw new IOException(ex1.getClass().getName() + ": " + ex1.getMessage());
        }
    }

    public static String encodeUrl(String str) {
        return Util.encode(str, "%20");
    }

    public static String encodeUrl(String str, String doNotEncodeChars) {
        return Util.encode(str.toCharArray(), "%20", doNotEncodeChars);
    }

    public static char[] toCharArray(String s) {
        if (!charArrayBugTested) {
            charArrayBugTested = true;
            if (s.toCharArray() == s.toCharArray()) {
                charArrayBug = true;
            }
        }
        if (charArrayBug) {
            char[] c = new char[s.length()];
            System.arraycopy(s.toCharArray(), 0, c, 0, c.length);
            return c;
        }
        return s.toCharArray();
    }

    private static String encode(String str, String spaceChar) {
        if (str == null) {
            return null;
        }
        return Util.encode(Util.toCharArray(str), spaceChar);
    }

    public static String decode(String s, String enc, boolean plusToSpace) {
        int numChars;
        boolean modified = false;
        if (enc == null || enc.length() == 0) {
            enc = "UTF-8";
        }
        StringBuilder sb = new StringBuilder((numChars = s.length()) > 500 ? numChars / 2 : numChars);
        int i = 0;
        byte[] bytes = null;
        block8: while (i < numChars) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    if (plusToSpace) {
                        sb.append(' ');
                    } else {
                        sb.append('+');
                    }
                    ++i;
                    modified = true;
                    continue block8;
                }
                case '%': {
                    try {
                        if (bytes == null) {
                            bytes = new byte[(numChars - i) / 3];
                        }
                        int pos = 0;
                        while (i + 2 < numChars && c == '%') {
                            bytes[pos++] = (byte)Integer.parseInt(s.substring(i + 1, i + 3), 16);
                            if ((i += 3) >= numChars) continue;
                            c = s.charAt(i);
                        }
                        if (i < numChars && c == '%') {
                            throw new IllegalArgumentException("Illegal URL % character: " + s);
                        }
                        try {
                            sb.append(new String(bytes, 0, pos, enc));
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new RuntimeException(e.toString());
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Illegal URL encoding: " + s);
                    }
                    modified = true;
                    continue block8;
                }
            }
            sb.append(c);
            ++i;
        }
        if (modified) {
            return sb.toString();
        }
        return s;
    }

    private static String encode(char[] buf, String spaceChar) {
        return Util.encode(buf, spaceChar, null);
    }

    private static String encode(char[] buf, String spaceChar, String doNotEncode) {
        StringBuilder sbuf = new StringBuilder(buf.length * 3);
        for (char ch : buf) {
            if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '-' || ch == '_' || ch == '.' || ch == '~' || ch == '!' || ch == '*' || ch == '\'' || ch == '(' || ch == ')' || ignoreCharsWhenEncoding.indexOf(ch) > -1 || doNotEncode != null && doNotEncode.indexOf(ch) > -1) {
                sbuf.append(ch);
                continue;
            }
            if (ch == ' ') {
                sbuf.append(spaceChar);
                continue;
            }
            Util.appendHex(sbuf, ch);
        }
        return sbuf.toString();
    }

    public static String encodeBody(String str) {
        return Util.encode(str, "+");
    }

    public static String encodeUrl(byte[] buf) {
        char[] b = new char[buf.length];
        for (int iter = 0; iter < buf.length; ++iter) {
            b[iter] = (char)buf[iter];
        }
        return Util.encode(b, "%20");
    }

    public static String encodeUrl(char[] buf) {
        return Util.encode(buf, "%20");
    }

    public static String encodeBody(char[] buf) {
        return Util.encode(buf, "+");
    }

    public static String encodeBody(byte[] buf) {
        char[] b = new char[buf.length];
        int blen = buf.length;
        for (int iter = 0; iter < blen; ++iter) {
            b[iter] = (char)buf[iter];
        }
        return Util.encode(b, "+");
    }

    private static void appendHex(StringBuilder sbuf, char ch) {
        int firstLiteral = ch / 256;
        int secLiteral = ch % 256;
        if (firstLiteral == 0 && secLiteral < 127) {
            sbuf.append("%");
            String s = Integer.toHexString(secLiteral).toUpperCase();
            if (s.length() == 1) {
                sbuf.append("0");
            }
            sbuf.append(s);
            return;
        }
        if (ch <= '\u07ff') {
            firstLiteral = 192 + (firstLiteral << 2) + (secLiteral >> 6);
            secLiteral = 128 + (secLiteral & 0x3F);
            sbuf.append("%");
            sbuf.append(Integer.toHexString(firstLiteral).toUpperCase());
            sbuf.append("%");
            sbuf.append(Integer.toHexString(secLiteral).toUpperCase());
        } else {
            int thirdLiteral = 128 + (secLiteral & 0x3F);
            secLiteral = 128 + (firstLiteral % 16 << 2) + (secLiteral >> 6);
            firstLiteral = 224 + (firstLiteral >> 4);
            sbuf.append("%");
            sbuf.append(Integer.toHexString(firstLiteral).toUpperCase());
            sbuf.append("%");
            sbuf.append(Integer.toHexString(secLiteral).toUpperCase());
            sbuf.append("%");
            sbuf.append(Integer.toHexString(thirdLiteral).toUpperCase());
        }
    }

    public static String relativeToAbsolute(String baseURL, String relativeURL) {
        if (relativeURL.startsWith("/")) {
            return Util.getURLProtocol(baseURL) + "://" + Util.getURLHost(baseURL) + relativeURL;
        }
        return Util.getURLProtocol(baseURL) + "://" + Util.getURLHost(baseURL) + Util.getURLBasePath(baseURL) + relativeURL;
    }

    public static String getURLProtocol(String url) {
        int index = url.indexOf("://");
        if (index != -1) {
            return url.substring(0, index);
        }
        return null;
    }

    public static String getURLHost(String url) {
        int start = url.indexOf("://");
        int end = url.indexOf(47, start + 3);
        if (end != -1) {
            return url.substring(start + 3, end);
        }
        return url.substring(start + 3);
    }

    public static String getURLPath(String url) {
        int start = url.indexOf(47, url.indexOf("://") + 3);
        if (start != -1) {
            return url.substring(start + 1);
        }
        return "/";
    }

    public static String getURLBasePath(String url) {
        int start = url.indexOf(47, url.indexOf("://") + 3);
        int end = url.lastIndexOf(47);
        if (start != -1 && end > start) {
            return url.substring(start, end + 1);
        }
        return "/";
    }

    public static void writeUTF(String s, DataOutputStream d) throws IOException {
        if (s == null) {
            d.writeBoolean(false);
            return;
        }
        d.writeBoolean(true);
        d.writeUTF(s);
    }

    public static String readUTF(DataInputStream d) throws IOException {
        if (d.readBoolean()) {
            return d.readUTF();
        }
        return null;
    }

    public static void readFully(InputStream i, byte[] b) throws IOException {
        Util.readFully(i, b, 0, b.length);
    }

    public static final void readFully(InputStream i, byte[] b, int off, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = i.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    public static int readAll(InputStream i, byte[] b) throws IOException {
        int n;
        int count;
        int len = b.length;
        for (n = 0; n < len; n += count) {
            count = i.read(b, n, len - n);
            if (count >= 0) continue;
            return n;
        }
        return n;
    }

    public static String[] split(String original, String separator) {
        Vector<String> nodes = new Vector<String>();
        int index = original.indexOf(separator);
        while (index >= 0) {
            nodes.addElement(original.substring(0, index));
            original = original.substring(index + separator.length());
            index = original.indexOf(separator);
        }
        nodes.addElement(original);
        String[] ret = new String[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            ret[i] = (String)nodes.elementAt(i);
        }
        return ret;
    }

    public static void setImplementation(CodenameOneImplementation impl) {
        implInstance = impl;
    }

    static CodenameOneImplementation getImplementation() {
        return implInstance;
    }

    public static void mergeArrays(Object[] arr1, Object[] arr2, Object[] destinationArray) {
        System.arraycopy(arr1, 0, destinationArray, 0, arr1.length);
        System.arraycopy(arr2, 0, destinationArray, arr1.length, arr2.length);
    }

    public static void removeObjectAtOffset(Object[] sourceArray, Object[] destinationArray, Object o) {
        int off = Util.indexOf(sourceArray, o);
        Util.removeObjectAtOffset(sourceArray, destinationArray, off);
    }

    public static void removeObjectAtOffset(Object[] sourceArray, Object[] destinationArray, int offset) {
        System.arraycopy(sourceArray, 0, destinationArray, 0, offset);
        System.arraycopy(sourceArray, offset + 1, destinationArray, offset, sourceArray.length - offset - 1);
    }

    public static void insertObjectAtOffset(Object[] sourceArray, Object[] destinationArray, int offset, Object o) {
        if (offset == 0) {
            destinationArray[0] = o;
            System.arraycopy(sourceArray, 0, destinationArray, 1, sourceArray.length);
        } else if (offset == sourceArray.length) {
            System.arraycopy(sourceArray, 0, destinationArray, 0, sourceArray.length);
            destinationArray[sourceArray.length] = o;
        } else {
            System.arraycopy(sourceArray, 0, destinationArray, 0, offset);
            destinationArray[offset] = o;
            System.arraycopy(sourceArray, offset, destinationArray, offset + 1, sourceArray.length - offset);
        }
    }

    public static int indexOf(Object[] arr, Object value) {
        int l = arr.length;
        for (int iter = 0; iter < l; ++iter) {
            if (arr[iter] != value) continue;
            return iter;
        }
        return -1;
    }

    public static boolean downloadUrlToStorage(String url, String fileName, boolean showProgress) {
        return Util.downloadUrlTo(url, fileName, showProgress, false, true, null);
    }

    public static boolean downloadUrlToFile(String url, String fileName, boolean showProgress) {
        return Util.downloadUrlTo(url, fileName, showProgress, false, false, null);
    }

    public static void downloadUrlToStorageInBackground(String url, String fileName) {
        Util.downloadUrlTo(url, fileName, false, true, true, null);
    }

    public static void downloadUrlToFileSystemInBackground(String url, String fileName) {
        Util.downloadUrlTo(url, fileName, false, true, false, null);
    }

    public static void downloadUrlToStorageInBackground(String url, String fileName, ActionListener onCompletion) {
        Util.downloadUrlTo(url, fileName, false, true, true, onCompletion);
    }

    public static void downloadUrlToFileSystemInBackground(String url, String fileName, ActionListener onCompletion) {
        Util.downloadUrlTo(url, fileName, false, true, false, onCompletion);
    }

    public static void downloadImageToFileSystem(String url, String fileName, SuccessCallback<Image> onSuccess, FailureCallback<Image> onFail) {
        implInstance.downloadImageToFileSystem(url, fileName, onSuccess, onFail);
    }

    public static AsyncResource<Image> downloadImageToFileSystem(String url, String fileName) {
        final AsyncResource<Image> out = new AsyncResource<Image>();
        Util.downloadImageToFileSystem(url, fileName, new SuccessCallback<Image>(){

            @Override
            public void onSucess(Image value) {
                out.complete(value);
            }
        }, new FailureCallback<Image>(){

            @Override
            public void onError(Object sender, Throwable err, int errorCode, String errorMessage) {
                out.error(err);
            }
        });
        return out;
    }

    public static void downloadImageToFileSystem(String url, String fileName, SuccessCallback<Image> onSuccess) {
        Util.downloadImageToFileSystem(url, fileName, onSuccess, new CallbackAdapter<Image>());
    }

    public static void downloadImageToStorage(String url, String fileName, SuccessCallback<Image> onSuccess, FailureCallback<Image> onFail) {
        implInstance.downloadImageToStorage(url, fileName, onSuccess, onFail);
    }

    public static AsyncResource<Image> downloadImageToStorage(String url, String fileName) {
        final AsyncResource<Image> out = new AsyncResource<Image>();
        Util.downloadImageToStorage(url, fileName, new SuccessCallback<Image>(){

            @Override
            public void onSucess(Image value) {
                out.complete(value);
            }
        }, new FailureCallback<Image>(){

            @Override
            public void onError(Object sender, Throwable err, int errorCode, String errorMessage) {
                out.error(err);
            }
        });
        return out;
    }

    public static void downloadImageToCache(String url, SuccessCallback<Image> onSuccess, FailureCallback<Image> onFail) {
        implInstance.downloadImageToCache(url, onSuccess, onFail);
    }

    public static AsyncResource<Image> downloadImageToCache(String url) {
        final AsyncResource<Image> out = new AsyncResource<Image>();
        Util.downloadImageToCache(url, new SuccessCallback<Image>(){

            @Override
            public void onSucess(Image value) {
                out.complete(value);
            }
        }, new FailureCallback<Image>(){

            @Override
            public void onError(Object sender, Throwable err, int errorCode, String errorMessage) {
                out.error(err);
            }
        });
        return out;
    }

    public static void downloadImageToStorage(String url, String fileName, SuccessCallback<Image> onSuccess) {
        Util.downloadImageToStorage(url, fileName, onSuccess, new CallbackAdapter<Image>());
    }

    private static boolean downloadUrlTo(String url, String fileName, boolean showProgress, boolean background, boolean storage, ActionListener callback) {
        ConnectionRequest cr = new ConnectionRequest();
        cr.setPost(false);
        cr.setFailSilently(true);
        cr.setReadResponseForErrors(false);
        cr.setDuplicateSupported(true);
        cr.setUrl(url);
        if (callback != null) {
            cr.addResponseListener(callback);
        }
        if (storage) {
            cr.setDestinationStorage(fileName);
        } else {
            cr.setDestinationFile(fileName);
        }
        if (background) {
            NetworkManager.getInstance().addToQueue(cr);
            return true;
        }
        if (showProgress) {
            InfiniteProgress ip = new InfiniteProgress();
            Dialog d = ip.showInifiniteBlocking();
            NetworkManager.getInstance().addToQueueAndWait(cr);
            d.dispose();
        } else {
            NetworkManager.getInstance().addToQueueAndWait(cr);
        }
        if (cr.getContentLength() > 0 && (storage ? Storage.getInstance().entrySize(fileName) < cr.getContentLength() : FileSystemStorage.getInstance().getLength(fileName) < (long)cr.getContentLength())) {
            return false;
        }
        int rc = cr.getResponseCode();
        return rc == 200 || rc == 201;
    }

    public static void sleep(int t) {
        try {
            Thread.sleep(t);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wait(Object o, int t) {
        Object object = o;
        synchronized (object) {
            try {
                o.wait(t);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wait(Object o) {
        Object object = o;
        synchronized (object) {
            try {
                o.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static boolean toBooleanValue(Object val) {
        if (val == null) {
            return false;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof String) {
            String sl = ((String)val).toLowerCase();
            return sl.startsWith("t") || sl.equals("1");
        }
        return Util.toIntValue(val) != 0;
    }

    public static int toIntValue(Object number) {
        if (number == null) {
            return 0;
        }
        if (number instanceof Integer) {
            return (Integer)number;
        }
        if (number instanceof String) {
            String n = (String)number;
            if (n.length() == 0 || n.equals(" ")) {
                return 0;
            }
            return Integer.parseInt(n);
        }
        if (number instanceof Double) {
            return ((Double)number).intValue();
        }
        if (number instanceof Float) {
            return ((Float)number).intValue();
        }
        if (number instanceof Long) {
            return ((Long)number).intValue();
        }
        if (number instanceof Boolean) {
            Boolean b = (Boolean)number;
            if (b.booleanValue()) {
                return 1;
            }
            return 0;
        }
        throw new IllegalArgumentException("Not a number: " + number);
    }

    public static long toLongValue(Object number) {
        if (number instanceof Long) {
            return (Long)number;
        }
        if (number instanceof Integer) {
            return ((Integer)number).longValue();
        }
        if (number instanceof String) {
            return Long.parseLong((String)number);
        }
        if (number instanceof Double) {
            return ((Double)number).longValue();
        }
        if (number instanceof Float) {
            return ((Float)number).longValue();
        }
        if (number instanceof Date) {
            return ((Date)number).getTime();
        }
        if (number instanceof Boolean) {
            Boolean b = (Boolean)number;
            if (b.booleanValue()) {
                return 1L;
            }
            return 0L;
        }
        throw new IllegalArgumentException("Not a number: " + number);
    }

    public static float toFloatValue(Object number) {
        if (number instanceof Float) {
            return ((Float)number).floatValue();
        }
        if (number instanceof Long) {
            return ((Long)number).floatValue();
        }
        if (number instanceof Integer) {
            return ((Integer)number).floatValue();
        }
        if (number instanceof String) {
            return Float.parseFloat((String)number);
        }
        if (number instanceof Double) {
            return ((Double)number).floatValue();
        }
        if (number instanceof Boolean) {
            Boolean b = (Boolean)number;
            if (b.booleanValue()) {
                return 1.0f;
            }
            return 0.0f;
        }
        throw new IllegalArgumentException("Not a number: " + number);
    }

    public static double toDoubleValue(Object number) {
        if (number instanceof Double) {
            return (Double)number;
        }
        if (number instanceof Float) {
            return ((Float)number).doubleValue();
        }
        if (number instanceof Long) {
            return ((Long)number).doubleValue();
        }
        if (number instanceof Integer) {
            return ((Integer)number).doubleValue();
        }
        if (number instanceof String) {
            return Double.parseDouble((String)number);
        }
        if (number instanceof Boolean) {
            Boolean b = (Boolean)number;
            if (b.booleanValue()) {
                return 1.0;
            }
            return 0.0;
        }
        throw new IllegalArgumentException("Not a number: " + number);
    }

    public static void setDateFormatter(SimpleDateFormat formatter) {
        dateFormatter = formatter;
    }

    public static Date toDateValue(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof String) {
            if (dateFormatter != null) {
                try {
                    return dateFormatter.parse((String)o);
                }
                catch (ParseException e) {
                    Log.e(e);
                }
            }
            try {
                return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS").parse((String)o);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Not a supported date, we use this format 'yyyy-MM-dd'T'HH:mm:ss.SSS': " + o);
            }
        }
        return new Date(Util.toLongValue(o));
    }

    public static String xorDecode(String s) {
        try {
            byte[] dat = Base64.decode(s.getBytes("UTF-8"));
            for (int iter = 0; iter < dat.length; ++iter) {
                dat[iter] = (byte)(dat[iter] ^ iter % 254 + 1);
            }
            return new String(dat, "UTF-8");
        }
        catch (UnsupportedEncodingException err) {
            err.printStackTrace();
            return null;
        }
    }

    public static String xorEncode(String s) {
        try {
            byte[] dat = s.getBytes("UTF-8");
            for (int iter = 0; iter < dat.length; ++iter) {
                dat[iter] = (byte)(dat[iter] ^ iter % 254 + 1);
            }
            return Base64.encodeNoNewline(dat);
        }
        catch (UnsupportedEncodingException err) {
            err.printStackTrace();
            return null;
        }
    }

    public static String guessMimeType(String sourceFile) throws IOException {
        InputStream inputStream = sourceFile.indexOf(47) > -1 ? FileSystemStorage.getInstance().openInputStream(sourceFile) : Storage.getInstance().createInputStream(sourceFile);
        return Util.guessMimeType(inputStream);
    }

    public static String guessMimeType(InputStream in) throws IOException {
        byte[] header = new byte[11];
        in.read(header, 0, 11);
        return Util.guessMimeType(header);
    }

    public static String guessMimeType(byte[] data) {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("guessMimeType(byte[] data) -> data cannot be empty or null");
        }
        byte[] header = new byte[11];
        System.arraycopy(data, 0, header, 0, Math.min(data.length, header.length));
        int c1 = header[0] & 0xFF;
        int c2 = header[1] & 0xFF;
        int c3 = header[2] & 0xFF;
        int c4 = header[3] & 0xFF;
        int c5 = header[4] & 0xFF;
        int c6 = header[5] & 0xFF;
        int c7 = header[6] & 0xFF;
        int c8 = header[7] & 0xFF;
        int c9 = header[8] & 0xFF;
        int c10 = header[9] & 0xFF;
        int c11 = header[10] & 0xFF;
        if (c1 == 202 && c2 == 254 && c3 == 186 && c4 == 190) {
            return "application/java-vm";
        }
        if (c1 == 208 && c2 == 207 && c3 == 17 && c4 == 224 && c5 == 161 && c6 == 177 && c7 == 26 && c8 == 225) {
            return "application/msword";
        }
        if (c1 == 37 && c2 == 80 && c3 == 68 && c4 == 70 && c5 == 45 && c6 == 49 && c7 == 46) {
            return "application/pdf";
        }
        if (c1 == 56 && c2 == 66 && c3 == 80 && c4 == 83 && c5 == 0 && c6 == 1) {
            return "image/photoshop";
        }
        if (c1 == 37 && c2 == 33 && c3 == 80 && c4 == 83) {
            return "application/postscript";
        }
        if (c1 == 255 && c2 == 251 && c3 == 48) {
            return "audio/mp3";
        }
        if (c1 == 73 && c2 == 68 && c3 == 51) {
            return "audio/mp3";
        }
        if (c1 == 172 && c2 == 237) {
            return "application/x-java-serialized-object";
        }
        if (c1 == 60) {
            if (c2 == 33 || c2 == 104 && (c3 == 116 && c4 == 109 && c5 == 108 || c3 == 101 && c4 == 97 && c5 == 100) || c2 == 98 && c3 == 111 && c4 == 100 && c5 == 121 || c2 == 72 && (c3 == 84 && c4 == 77 && c5 == 76 || c3 == 69 && c4 == 65 && c5 == 68) || c2 == 66 && c3 == 79 && c4 == 68 && c5 == 89) {
                return "text/html";
            }
            if (c2 == 63 && c3 == 120 && c4 == 109 && c5 == 108 && c6 == 32) {
                return "application/xml";
            }
        }
        if (c1 == 254 && c2 == 255 && c3 == 0 && c4 == 60 && c5 == 0 && c6 == 63 && c7 == 0 && c8 == 120) {
            return "application/xml";
        }
        if (c1 == 255 && c2 == 254 && c3 == 60 && c4 == 0 && c5 == 63 && c6 == 0 && c7 == 120 && c8 == 0) {
            return "application/xml";
        }
        if (c1 == 66 && c2 == 77) {
            return "image/bmp";
        }
        if (c1 == 73 && c2 == 73 && c3 == 42 && c4 == 0) {
            return "image/tiff";
        }
        if (c1 == 77 && c2 == 77 && c3 == 0 && c4 == 42) {
            return "image/tiff";
        }
        if (c1 == 71 && c2 == 73 && c3 == 70 && c4 == 56) {
            return "image/gif";
        }
        if (c1 == 35 && c2 == 100 && c3 == 101 && c4 == 102) {
            return "image/x-bitmap";
        }
        if (c1 == 33 && c2 == 32 && c3 == 88 && c4 == 80 && c5 == 77 && c6 == 50) {
            return "image/x-pixmap";
        }
        if (c1 == 137 && c2 == 80 && c3 == 78 && c4 == 71 && c5 == 13 && c6 == 10 && c7 == 26 && c8 == 10) {
            return "image/png";
        }
        if (c1 == 255 && c2 == 216 && c3 == 255) {
            if (c4 == 224) {
                return "image/jpeg";
            }
            if (c4 == 225 && c7 == 69 && c8 == 120 && c9 == 105 && c10 == 102 && c11 == 0) {
                return "image/jpeg";
            }
            if (c4 == 238) {
                return "image/jpg";
            }
        }
        if (c1 == 65 && c2 == 67 && c7 == 0 && c8 == 0 && c9 == 0 && c10 == 0 && c11 == 0) {
            return "application/acad";
        }
        if (c1 == 46 && c2 == 115 && c3 == 110 && c4 == 100) {
            return "audio/basic";
        }
        if (c1 == 100 && c2 == 110 && c3 == 115 && c4 == 46) {
            return "audio/basic";
        }
        if (c1 == 82 && c2 == 73 && c3 == 70 && c4 == 70) {
            return "audio/x-wav";
        }
        if (c1 == 80 && c2 == 75) {
            return "application/zip";
        }
        return "application/octet-stream";
    }

    public static long getFileSizeWithoutDownload(String url) {
        return Util.getFileSizeWithoutDownload(url, false);
    }

    public static long getFileSizeWithoutDownload(String url, final boolean checkPartialDownloadSupport) {
        final Wrapper<Long> result = new Wrapper<Long>(0L);
        GZConnectionRequest cr = new GZConnectionRequest(){

            protected void readHeaders(Object connection) throws IOException {
                String acceptRanges = this.getHeader(connection, "Accept-Ranges");
                if (checkPartialDownloadSupport && (acceptRanges == null || !acceptRanges.equals("bytes"))) {
                    result.set(-2L);
                } else {
                    String contentLength = this.getHeader(connection, "Content-Length");
                    if (contentLength != null) {
                        result.set(Long.parseLong(contentLength));
                    } else {
                        result.set(-1L);
                    }
                }
            }
        };
        cr.setUrl(url);
        cr.setHttpMethod("HEAD");
        cr.setPost(false);
        NetworkManager.getInstance().addToQueueAndWait(cr);
        return result.get();
    }

    public static void downloadUrlSafely(String url, final String fileName, final OnComplete<Integer> percentageCallback, final OnComplete<String> filesavedCallback) throws IOException {
        String partialDownloadsDir = FileSystemStorage.getInstance().getAppHomePath() + FileSystemStorage.getInstance().getFileSystemSeparator() + "partialDownloads";
        if (!FileSystemStorage.getInstance().isDirectory(partialDownloadsDir)) {
            FileSystemStorage.getInstance().mkdir(partialDownloadsDir);
        }
        String uniqueId = url.hashCode() + "" + downloadUrlSafelyRandom.nextInt();
        final String partialDownloadPath = partialDownloadsDir + FileSystemStorage.getInstance().getFileSystemSeparator() + uniqueId;
        boolean isStorage = fileName.indexOf("/") < 0;
        final long fileSize = Util.getFileSizeWithoutDownload(url, true);
        int splittingSize = 524288;
        final Wrapper<Long> downloadedTotalBytes = new Wrapper<Long>(0L);
        final OutputStream out = isStorage ? Storage.getInstance().createOutputStream(fileName) : FileSystemStorage.getInstance().openOutputStream(fileName);
        final EasyThread mergeFilesThread = EasyThread.start("mergeFilesThread");
        final GZConnectionRequest cr = new GZConnectionRequest();
        cr.setUrl(url);
        cr.setPost(false);
        if (fileSize > 524288L) {
            cr.addRequestHeader("Range", "bytes=0-524288");
            cr.setDestinationFile(partialDownloadPath);
        } else {
            Util.cleanup(out);
            if (isStorage) {
                cr.setDestinationStorage(fileName);
            } else {
                cr.setDestinationFile(fileName);
            }
        }
        cr.addResponseListener(new ActionListener<NetworkEvent>(){

            @Override
            public void actionPerformed(NetworkEvent evt) {
                mergeFilesThread.run(new Runnable(){

                    public void run() {
                        try {
                            if (FileSystemStorage.getInstance().exists(partialDownloadPath)) {
                                InputStream in = FileSystemStorage.getInstance().openInputStream(partialDownloadPath);
                                Util.copyNoClose(in, out, 8192);
                                Util.cleanup(in);
                                downloadedTotalBytes.set((Long)downloadedTotalBytes.get() + FileSystemStorage.getInstance().getLength(partialDownloadPath));
                                FileSystemStorage.getInstance().delete(partialDownloadPath);
                            }
                            if ((Long)downloadedTotalBytes.get() > fileSize) {
                                throw new IllegalStateException("More content has been downloaded than the file length, check the code.");
                            }
                            if (fileSize <= 0L || (Long)downloadedTotalBytes.get() == fileSize) {
                                Util.cleanup(out);
                                if (filesavedCallback != null) {
                                    CN.callSerially(new Runnable(){

                                        public void run() {
                                            filesavedCallback.completed(fileName);
                                        }
                                    });
                                }
                            } else {
                                cr.addRequestHeader("Range", "bytes=" + downloadedTotalBytes.get() + "-" + Math.min((Long)downloadedTotalBytes.get() + 524288L, fileSize));
                                NetworkManager.getInstance().addToQueue(cr);
                            }
                        }
                        catch (IOException ex) {
                            Log.p("Error in appending splitted file to output file", 4);
                            Log.e(ex);
                            Log.sendLogAsync();
                        }
                    }
                });
            }
        });
        NetworkManager.getInstance().addToQueue(cr);
        NetworkManager.getInstance().addProgressListener(new ActionListener<NetworkEvent>(){

            @Override
            public void actionPerformed(NetworkEvent evt) {
                if (cr == evt.getConnectionRequest() && fileSize > 0L && percentageCallback != null) {
                    CN.callSerially(new Runnable(){

                        public void run() {
                            percentageCallback.completed((int)((Long)downloadedTotalBytes.get() * 100L / fileSize));
                        }
                    });
                }
            }
        });
    }

    public static String getUUID() {
        return new UUID().toString();
    }

    public static String getUUID(long time, long clockSeqAndNode) {
        return new UUID(time, clockSeqAndNode).toString();
    }

    static {
        externalizables = new Hashtable();
        downloadUrlSafelyRandom = new Random(System.currentTimeMillis());
        Util.register("EncodedImage", EncodedImage.class);
        ignoreCharsWhenEncoding = "";
    }

    static class UUID {
        private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        private static final Random randomTime = new Random(System.currentTimeMillis());
        private static final Random randomClockSeqAndNode = new Random(UUID.getUniqueDeviceID());
        private long time = 0L;
        private long clockSeqAndNode = 0L;

        public UUID() {
            this.time = randomTime.nextLong();
            this.clockSeqAndNode = randomClockSeqAndNode.nextLong();
        }

        public UUID(long time, long clockSeqAndNode) {
            this.time = time;
            this.clockSeqAndNode = clockSeqAndNode;
        }

        public final String toString() {
            return this.toCanonicalForm();
        }

        private String toCanonicalForm() {
            String out = "";
            out = UUID.append(out, (int)(this.time >> 32)) + '-' + UUID.append(out, (short)(this.time >> 16)) + '-' + UUID.append(out, (short)this.time) + '-' + UUID.append(out, (short)(this.clockSeqAndNode >> 48)) + '-' + UUID.append(out, this.clockSeqAndNode, 12);
            return out;
        }

        private static String append(String a, short in) {
            return UUID.append(a, in, 4);
        }

        private static String append(String a, int in) {
            return UUID.append(a, in, 8);
        }

        private static String append(String a, long in, int length) {
            for (int lim = (length << 2) - 4; lim >= 0; lim -= 4) {
                a = a + DIGITS[(byte)(in >> lim) & 0xF];
            }
            return a;
        }

        private static long getUniqueDeviceID() {
            long id = Preferences.get("CustomDeviceId__$", -1L);
            if (id == -1L) {
                id = Preferences.get("DeviceId__$", -1L);
            }
            if (id == -1L) {
                id = UUID.generateLongFromDeviceInfo();
            }
            return id;
        }

        private static long generateLongFromDeviceInfo() {
            long random = (long)(CN.getDeviceDensity() * CN.getDisplayHeight() * CN.getDisplayWidth() * CN.convertToPixels(10.0f)) * Long.parseLong(UUID.sanitizeString(CN.getPlatformName()), 36) * Long.parseLong(UUID.sanitizeString(CN.getProperty("User-Agent", "1")), 36) * Long.parseLong(UUID.sanitizeString(CN.getProperty("OSVer", "1")), 36);
            return random;
        }

        private static String sanitizeString(String input) {
            String result = "";
            for (char myChar : input.toCharArray()) {
                if (!(myChar >= '0' && myChar <= '9' || myChar >= 'a' && myChar <= 'z') && (myChar < 'A' || myChar > 'Z')) continue;
                result = result + myChar;
            }
            return result.substring(0, Math.min(10, result.length())).toUpperCase();
        }
    }
}

