/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.messaging;

import com.codename1.ui.Display;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Message {
    private String content = "";
    private String fileUri = "";
    private String mimeType = "text/plain";
    private String attachmentMimeType = "image/jpeg";
    private HashMap<String, String> attachments;
    private boolean cloudMessageFailSilently = false;
    public static final String MIME_TEXT = "text/plain";
    public static final String MIME_HTML = "text/html";
    public static final String MIME_IMAGE_JPG = "image/jpeg";
    public static final String MIME_IMAGE_PNG = "image/png";

    public Message(String content) {
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    public void setAttachment(String fileUri) {
        this.fileUri = fileUri;
    }

    public Map<String, String> getAttachments() {
        if (this.attachments == null) {
            this.attachments = new HashMap();
        }
        if (this.fileUri != null && this.attachmentMimeType != null && this.fileUri.length() > 0 && this.attachmentMimeType.length() > 0 && !this.attachments.containsKey(this.fileUri)) {
            this.attachments.put(this.fileUri, this.attachmentMimeType);
        }
        return this.attachments;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setAttachmentMimeType(String mimeType) {
        this.attachmentMimeType = mimeType;
    }

    public String getAttachmentMimeType() {
        return this.attachmentMimeType;
    }

    public String getAttachment() {
        return this.fileUri;
    }

    public static void sendMessage(String[] recipients, String subject, Message msg) {
        Display.getInstance().sendMessage(recipients, subject, msg);
    }

    public void sendMessageViaCloud(String sender, String recipient, String recipientName, String subject, String plainTextBody) {
    }

    public boolean sendMessageViaCloudSync(String sender, String recipient, String recipientName, String subject, String plainTextBody) {
        return false;
    }

    public boolean isCloudMessageFailSilently() {
        return this.cloudMessageFailSilently;
    }

    public void setCloudMessageFailSilently(boolean cloudMessageFailSilently) {
        this.cloudMessageFailSilently = cloudMessageFailSilently;
    }
}

