/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.social;

import com.codename1.io.ConnectionRequest;
import com.codename1.io.NetworkManager;
import com.codename1.io.Oauth2;
import com.codename1.social.Login;
import java.util.Hashtable;

public class GoogleConnect
extends Login {
    private static String tokenURL = "https://www.googleapis.com/oauth2/v3/token";
    private static GoogleConnect instance;
    static Class implClass;

    GoogleConnect() {
        this.setOauth2URL("https://accounts.google.com/o/oauth2/auth");
        this.setScope("profile email");
    }

    public static GoogleConnect getInstance() {
        if (instance == null) {
            if (implClass != null) {
                try {
                    instance = (GoogleConnect)implClass.newInstance();
                }
                catch (Throwable t) {
                    instance = new GoogleConnect();
                }
            } else {
                instance = new GoogleConnect();
            }
        }
        return instance;
    }

    public boolean isNativeLoginSupported() {
        return false;
    }

    protected Oauth2 createOauth2() {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("approval_prompt", "force");
        params.put("access_type", "offline");
        Oauth2 auth = new Oauth2(this.oauth2URL, this.clientId, this.redirectURI, this.scope, tokenURL, this.clientSecret, params);
        return auth;
    }

    protected boolean validateToken(String token) {
        final boolean[] retval = new boolean[]{true};
        ConnectionRequest req = new ConnectionRequest(){

            protected void handleErrorResponseCode(int code, String message) {
                if (code >= 400 && code <= 410) {
                    retval[0] = false;
                    return;
                }
                super.handleErrorResponseCode(code, message);
            }
        };
        req.setPost(false);
        req.setUrl("https://www.googleapis.com/plus/v1/people/me");
        req.addRequestHeader("Authorization", "Bearer " + token);
        NetworkManager.getInstance().addToQueueAndWait(req);
        return retval[0];
    }
}

