/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.ui.Component;
import com.codename1.ui.Display;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.geom.Rectangle;

public class PeerComponent
extends Component {
    private Object nativePeer;
    private Rectangle lastPos = new Rectangle(-1, -1, -1, -1);
    private Image peerImage;

    protected PeerComponent(Object nativePeer) {
        this.setGrabsPointerEvents(true);
        this.nativePeer = nativePeer;
    }

    protected Image getPeerImage() {
        if (this.peerImage == null) {
            this.peerImage = this.generatePeerImage();
        }
        return this.peerImage;
    }

    protected Image generatePeerImage() {
        return null;
    }

    protected void setPeerImage(Image i) {
        this.peerImage = i;
    }

    protected boolean shouldRenderPeerImage() {
        return false;
    }

    public static PeerComponent create(Object nativePeer) {
        if (nativePeer == null) {
            return null;
        }
        return Display.impl.createNativePeer(nativePeer);
    }

    public Object getNativePeer() {
        return this.nativePeer;
    }

    void setNativePeer(Object nativePeer) {
        this.nativePeer = nativePeer;
    }

    public boolean animate() {
        return false;
    }

    protected Dimension calcPreferredSize() {
        return super.calcPreferredSize();
    }

    protected Dimension calcScrollSize() {
        return super.calcScrollSize();
    }

    protected void deinitialize() {
        --Form.activePeerCount;
        super.deinitialize();
    }

    protected void fireClicked() {
    }

    protected void focusGained() {
        super.focusGained();
    }

    protected void focusLost() {
        super.focusLost();
    }

    public boolean handlesInput() {
        return super.handlesInput();
    }

    protected void initComponent() {
        ++Form.activePeerCount;
        super.initComponent();
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
    }

    public void keyRepeated(int keyCode) {
    }

    public void paint(Graphics g) {
        this.onPositionSizeChangeImpl();
        if (this.shouldRenderPeerImage() && this.getWidth() > 0 && this.getHeight() > 0) {
            Image img = this.getPeerImage();
            if (img != null) {
                g.drawImage(img, this.getX(), this.getY(), this.getWidth(), this.getHeight());
            }
        } else {
            super.paint(g);
            g.drawPeerComponent(this);
        }
    }

    private void onPositionSizeChangeImpl() {
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.isInitialized() && w > 0 && h > 0) {
            int scrollX = this.getScrollX();
            int scrollY = this.getScrollY();
            int x = this.getAbsoluteX() + scrollX;
            int y = this.getAbsoluteY() + scrollY;
            if (x != this.lastPos.getX() || y != this.lastPos.getY() || w != this.lastPos.getSize().getWidth() || h != this.lastPos.getSize().getHeight()) {
                this.lastPos.setX(x);
                this.lastPos.setY(y);
                this.lastPos.getSize().setWidth(w);
                this.lastPos.getSize().setHeight(h);
                this.onPositionSizeChange();
            }
        }
    }

    void onParentPositionChange() {
        this.onPositionSizeChangeImpl();
    }

    protected void paintBackground(Graphics g) {
    }

    public void paintBackgrounds(Graphics g) {
    }

    protected void paintBorder(Graphics g) {
    }

    protected void paintScrollbarX(Graphics g) {
    }

    protected void paintScrollbarY(Graphics g) {
    }

    protected void paintScrollbars(Graphics g) {
    }

    public void pointerDragged(int[] x, int[] y) {
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerHover(int[] x, int[] y) {
    }

    public void pointerHoverReleased(int[] x, int[] y) {
    }

    public void pointerPressed(int[] x, int[] y) {
    }

    public void pointerPressed(int x, int y) {
    }

    public void pointerReleased(int[] x, int[] y) {
    }

    public void pointerReleased(int x, int y) {
    }

    public void invalidate() {
        this.setShouldCalcPreferredSize(true);
        this.getComponentForm().revalidate();
    }

    protected void onPositionSizeChange() {
    }

    protected void setLightweightMode(boolean l) {
    }
}

