/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.plaf;

import com.codename1.ui.CN;
import com.codename1.ui.Component;
import com.codename1.ui.ComponentImage;
import com.codename1.ui.Display;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.ImageFactory;
import com.codename1.ui.Stroke;
import com.codename1.ui.geom.GeneralPath;
import com.codename1.ui.geom.Rectangle;
import com.codename1.ui.plaf.Border;
import com.codename1.ui.plaf.Style;

public class RoundRectBorder
extends Border {
    private static final String CACHE_KEY = "cn1$$-rrbcache";
    private boolean useCache = true;
    private boolean dirty = true;
    private int strokeColor = 0;
    private int strokeOpacity = 255;
    private Stroke stroke;
    private float trackComponentVerticalPosition = -1.0f;
    private float trackComponentHorizontalPosition = -1.0f;
    private int trackComponentSide = -1;
    private float strokeThickness;
    private boolean strokeMM;
    private float shadowSpread = Display.getInstance().convertToPixels(0.2f);
    private int shadowOpacity = 0;
    private int shadowColor = 0;
    private float shadowX = 0.5f;
    private float shadowY = 0.5f;
    private float shadowBlur = 10.0f;
    private float cornerRadius = 2.0f;
    private boolean bezierCorners;
    private static int instanceCounter;
    private final int instanceVal = ++instanceCounter;
    private boolean topLeft = true;
    private boolean topRight = true;
    private boolean bottomLeft = true;
    private boolean bottomRight = true;
    private int arrowPosition = -1;
    private int arrowDirection = -1;
    private float arrowSize = 1.5f;
    private Stroke stroke1;

    private RoundRectBorder() {
    }

    public static RoundRectBorder create() {
        return new RoundRectBorder();
    }

    public RoundRectBorder arrowSize(float size) {
        this.arrowSize = size;
        return this;
    }

    public void setArrowSize(float size) {
        this.arrowSize = size;
    }

    public RoundRectBorder strokeOpacity(int strokeOpacity) {
        if (strokeOpacity != this.strokeOpacity) {
            this.strokeOpacity = strokeOpacity;
            this.dirty = true;
        }
        return this;
    }

    public RoundRectBorder trackComponentSide(int side) {
        this.trackComponentSide = side;
        return this;
    }

    public int getTrackComponentSide() {
        return this.trackComponentSide;
    }

    public RoundRectBorder trackComponentVerticalPosition(float pos) {
        this.trackComponentVerticalPosition = pos;
        return this;
    }

    public float getTrackComponentVerticalPosition() {
        return this.trackComponentVerticalPosition;
    }

    public RoundRectBorder trackComponentHorizontalPosition(float pos) {
        this.trackComponentHorizontalPosition = pos;
        return this;
    }

    public float getTrackComponentHorizontalPosition() {
        return this.trackComponentHorizontalPosition;
    }

    public RoundRectBorder useCache(boolean useCache) {
        this.useCache = useCache;
        return this;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public RoundRectBorder strokeColor(int strokeColor) {
        if (strokeColor != this.strokeColor) {
            this.strokeColor = strokeColor;
            this.dirty = true;
        }
        return this;
    }

    public RoundRectBorder stroke(Stroke stroke) {
        if (stroke != null) {
            this.strokeThickness = stroke.getLineWidth();
            this.strokeMM = false;
        }
        this.stroke = stroke;
        this.dirty = true;
        return this;
    }

    public RoundRectBorder stroke(float stroke, boolean mm) {
        this.strokeThickness = stroke;
        if (this.strokeThickness == 0.0f) {
            this.stroke = null;
            return this;
        }
        this.strokeMM = mm;
        if (mm) {
            stroke = Display.getInstance().convertToPixels(stroke);
        }
        this.stroke = new Stroke(stroke, 2, 0, 1.0f);
        this.dirty = true;
        return this;
    }

    public RoundRectBorder shadowSpread(float shadowSpread) {
        if (shadowSpread != this.shadowSpread) {
            this.shadowSpread = shadowSpread;
            this.dirty = true;
        }
        return this;
    }

    public RoundRectBorder shadowSpread(int shadowSpread) {
        this.shadowSpread = (float)shadowSpread * 100.0f / (float)Display.getInstance().convertToPixels(100.0f);
        this.dirty = true;
        return this;
    }

    public RoundRectBorder shadowOpacity(int shadowOpacity) {
        if (shadowOpacity != this.shadowOpacity) {
            this.shadowOpacity = shadowOpacity;
            this.dirty = true;
        }
        return this;
    }

    public RoundRectBorder shadowColor(int shadowColor) {
        if (shadowColor != this.shadowColor) {
            this.shadowColor = shadowColor;
            this.dirty = true;
        }
        return this;
    }

    public RoundRectBorder shadowX(float shadowX) {
        if (shadowX != this.shadowX) {
            this.shadowX = shadowX;
            this.dirty = true;
        }
        return this;
    }

    public RoundRectBorder shadowY(float shadowY) {
        if (shadowY != this.shadowY) {
            this.shadowY = shadowY;
            this.dirty = true;
        }
        return this;
    }

    public RoundRectBorder shadowBlur(float shadowBlur) {
        if (shadowBlur != this.shadowBlur) {
            this.shadowBlur = shadowBlur;
            this.dirty = true;
        }
        return this;
    }

    public RoundRectBorder cornerRadius(float cornerRadius) {
        if (cornerRadius != this.cornerRadius) {
            this.cornerRadius = cornerRadius;
            this.dirty = true;
        }
        return this;
    }

    public RoundRectBorder bezierCorners(boolean bezierCorners) {
        if (bezierCorners != this.bezierCorners) {
            this.bezierCorners = bezierCorners;
            this.dirty = true;
        }
        return this;
    }

    public RoundRectBorder topLeftMode(boolean topLeft) {
        if (topLeft != this.topLeft) {
            this.topLeft = topLeft;
            this.dirty = true;
        }
        return this;
    }

    public RoundRectBorder topRightMode(boolean topRight) {
        if (topRight != this.topRight) {
            this.topRight = topRight;
            this.dirty = true;
        }
        return this;
    }

    public RoundRectBorder bottomLeftMode(boolean bottomLeft) {
        if (bottomLeft != this.bottomLeft) {
            this.bottomLeft = bottomLeft;
            this.dirty = true;
        }
        return this;
    }

    public RoundRectBorder bottomRightMode(boolean bottomRight) {
        if (bottomRight != this.bottomRight) {
            this.bottomRight = bottomRight;
            this.dirty = true;
        }
        return this;
    }

    public RoundRectBorder topOnlyMode(boolean topOnlyMode) {
        if (topOnlyMode) {
            this.topLeftMode(true);
            this.topRightMode(true);
            this.bottomLeftMode(false);
            this.bottomRightMode(false);
        } else {
            this.topLeftMode(false);
            this.topRightMode(false);
        }
        return this;
    }

    public RoundRectBorder bottomOnlyMode(boolean bottomOnlyMode) {
        if (bottomOnlyMode) {
            this.topLeftMode(false);
            this.topRightMode(false);
            this.bottomLeftMode(true);
            this.bottomRightMode(true);
        } else {
            this.bottomLeftMode(false);
            this.bottomRightMode(false);
        }
        return this;
    }

    private Image createTargetComponentImage(final Component c, final int w, final int h, boolean fast) {
        return new ComponentImage(new Component(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void paint(Graphics g) {
                super.paint(g);
                try {
                    byte type;
                    g.translate(this.getX(), this.getY());
                    int shapeX = 0;
                    int shapeY = 0;
                    int shapeW = w;
                    int shapeH = h;
                    Graphics tg = g;
                    tg.setAntiAliased(true);
                    int shadowSpreadL = Display.getInstance().convertToPixels(RoundRectBorder.this.shadowSpread);
                    if (RoundRectBorder.this.shadowOpacity > 0) {
                        shapeW -= shadowSpreadL;
                        shapeH -= shadowSpreadL;
                        shapeX += Math.round((float)shadowSpreadL * RoundRectBorder.this.shadowX);
                        shapeY += Math.round((float)shadowSpreadL * RoundRectBorder.this.shadowY);
                        for (int iter = shadowSpreadL - 1; iter >= 0; --iter) {
                            tg.translate(iter, iter);
                            int iterOpacity = Math.max(0, Math.min(255, (int)((float)(RoundRectBorder.this.shadowOpacity * (shadowSpreadL - iter)) / (float)shadowSpreadL)));
                            RoundRectBorder.this.drawShape(tg, RoundRectBorder.this.shadowColor, RoundRectBorder.this.shadowOpacity - iterOpacity, w - iter * 2, h - iter * 2);
                            tg.translate(-iter, -iter);
                        }
                    }
                    tg.translate(shapeX, shapeY);
                    GeneralPath gp = RoundRectBorder.this.createShape(shapeW, shapeH);
                    Style s = c.getStyle();
                    if (s.getBgImage() == null && ((type = s.getBackgroundType()) == 1 || type == 0)) {
                        byte bgt = c.getStyle().getBgTransparency();
                        if (bgt != 0) {
                            tg.setAlpha(bgt & 0xFF);
                            tg.setColor(s.getBgColor());
                            tg.fillShape(gp);
                        }
                        if (RoundRectBorder.this.stroke != null && RoundRectBorder.this.strokeOpacity > 0 && RoundRectBorder.this.strokeThickness > 0.0f) {
                            tg.setAlpha(RoundRectBorder.this.strokeOpacity);
                            tg.setColor(RoundRectBorder.this.strokeColor);
                            tg.drawShape(gp, RoundRectBorder.this.stroke);
                        }
                        return;
                    }
                    c.getStyle().setBorder(Border.createEmpty());
                    tg.setClip(gp);
                    s.getBgPainter().paint(tg, new Rectangle(0, 0, w, h));
                    if (RoundRectBorder.this.stroke != null && RoundRectBorder.this.strokeOpacity > 0 && RoundRectBorder.this.strokeThickness > 0.0f) {
                        tg.setClip(0, 0, w, h);
                        tg.setAlpha(RoundRectBorder.this.strokeOpacity);
                        tg.setColor(RoundRectBorder.this.strokeColor);
                        tg.drawShape(gp, RoundRectBorder.this.stroke);
                    }
                    c.getStyle().setBorder(RoundRectBorder.this);
                    return;
                }
                finally {
                    g.translate(-this.getX(), -this.getY());
                }
            }
        }, w, h);
    }

    private Image createTargetImage(Component c, int w, int h, boolean fast) {
        byte type;
        if (!this.useCache) {
            return this.createTargetComponentImage(c, w, h, fast);
        }
        Image target = ImageFactory.createImage(c, w, h, 0);
        int shapeX = 0;
        int shapeY = 0;
        int shapeW = w;
        int shapeH = h;
        Graphics tg = target.getGraphics();
        tg.setAntiAliased(true);
        int shadowSpreadL = Display.getInstance().convertToPixels(this.shadowSpread);
        if (this.shadowOpacity > 0) {
            shapeW -= shadowSpreadL;
            shapeH -= shadowSpreadL;
            shapeX += Math.round((float)shadowSpreadL * this.shadowX);
            shapeY += Math.round((float)shadowSpreadL * this.shadowY);
            for (int iter = shadowSpreadL - 1; iter >= 0; --iter) {
                tg.translate(iter, iter);
                int iterOpacity = Math.max(0, Math.min(255, (int)((float)(this.shadowOpacity * (shadowSpreadL - iter)) / (float)shadowSpreadL)));
                this.drawShape(tg, this.shadowColor, this.shadowOpacity - iterOpacity, w - iter * 2, h - iter * 2);
                tg.translate(-iter, -iter);
            }
            if (Display.getInstance().isGaussianBlurSupported() && !fast) {
                Image blured = Display.getInstance().gaussianBlurImage(target, this.shadowBlur / 2.0f);
                target = ImageFactory.createImage(c, w, h, 0);
                tg = target.getGraphics();
                tg.drawImage(blured, 0, 0);
                tg.setAntiAliased(true);
            }
        }
        tg.translate(shapeX, shapeY);
        GeneralPath gp = this.createShape(shapeW, shapeH);
        Style s = c.getStyle();
        if (s.getBgImage() == null && ((type = s.getBackgroundType()) == 1 || type == 0)) {
            byte bgt = c.getStyle().getBgTransparency();
            if (bgt != 0) {
                tg.setAlpha(bgt & 0xFF);
                tg.setColor(s.getBgColor());
                tg.fillShape(gp);
            }
            if (this.stroke != null && this.strokeOpacity > 0 && this.strokeThickness > 0.0f) {
                tg.setAlpha(this.strokeOpacity);
                tg.setColor(this.strokeColor);
                tg.drawShape(gp, this.stroke);
            }
            return target;
        }
        c.getStyle().setBorder(Border.createEmpty());
        tg.setClip(gp);
        s.getBgPainter().paint(tg, new Rectangle(0, 0, w, h));
        if (this.stroke != null && this.strokeOpacity > 0 && this.strokeThickness > 0.0f) {
            tg.setClip(0, 0, w, h);
            tg.setAlpha(this.strokeOpacity);
            tg.setColor(this.strokeColor);
            tg.drawShape(gp, this.stroke);
        }
        c.getStyle().setBorder(this);
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintBorderBackground(Graphics g, final Component c) {
        if (this.getTrackComponent() != null) {
            int cabsY = c.getAbsoluteY();
            int trackY = this.getTrackComponent().getY();
            int trackX = this.getTrackComponent().getX();
            int cabsX = c.getAbsoluteX();
            int arrowWH = CN.convertToPixels(this.arrowSize);
            if (cabsY >= trackY + this.getTrackComponent().getHeight()) {
                this.arrowDirection = 0;
                this.arrowPosition = trackX + this.getTrackComponent().getWidth() / 2 - cabsX - arrowWH / 2;
            } else if (this.trackComponentSide == 2 || cabsY + c.getHeight() <= trackY) {
                this.arrowDirection = 2;
                this.arrowPosition = trackX + this.getTrackComponent().getWidth() / 2 - cabsX - arrowWH / 2;
            } else if (cabsX >= trackX + this.getTrackComponent().getWidth()) {
                this.arrowDirection = 1;
                this.arrowPosition = trackY + this.getTrackComponent().getHeight() / 2 - cabsY - arrowWH / 2;
            } else if (cabsX + c.getWidth() <= trackX) {
                this.arrowDirection = 3;
                this.arrowPosition = trackY + this.getTrackComponent().getHeight() / 2 - cabsY - arrowWH / 2;
            }
        } else if (this.trackComponentSide >= 0) {
            switch (this.trackComponentSide) {
                case 0: {
                    this.arrowDirection = 0;
                    this.arrowPosition = 0;
                    if (!(this.trackComponentHorizontalPosition >= 0.0f)) break;
                    this.arrowPosition = (int)((float)c.getWidth() * this.trackComponentHorizontalPosition);
                    break;
                }
                case 2: {
                    this.arrowDirection = 2;
                    this.arrowPosition = 0;
                    if (!(this.trackComponentHorizontalPosition >= 0.0f)) break;
                    this.arrowPosition = (int)((float)c.getWidth() * this.trackComponentHorizontalPosition);
                    break;
                }
                case 1: {
                    this.arrowDirection = 1;
                    this.arrowPosition = 0;
                    if (!(this.trackComponentVerticalPosition >= 0.0f)) break;
                    this.arrowPosition = (int)((float)c.getHeight() * this.trackComponentVerticalPosition);
                    break;
                }
                case 3: {
                    this.arrowDirection = 3;
                    this.arrowPosition = 0;
                    if (!(this.trackComponentVerticalPosition >= 0.0f)) break;
                    this.arrowPosition = (int)((float)c.getHeight() * this.trackComponentVerticalPosition);
                    break;
                }
            }
        }
        final int w = c.getWidth();
        final int h = c.getHeight();
        int x = c.getX();
        int y = c.getY();
        boolean antiAliased = g.isAntiAliased();
        g.setAntiAliased(true);
        try {
            byte type;
            Style s;
            if (this.shadowOpacity == 0 && (s = c.getStyle()).getBgImage() == null && ((type = s.getBackgroundType()) == 1 || type == 0)) {
                int a;
                GeneralPath gp = this.createShape(w, h);
                byte bgt = c.getStyle().getBgTransparency();
                if (bgt != 0) {
                    a = g.getAlpha();
                    g.setAlpha(bgt & 0xFF);
                    g.setColor(s.getBgColor());
                    g.translate(x, y);
                    g.fillShape(gp);
                    if (this.stroke != null && this.strokeOpacity > 0 && this.strokeThickness > 0.0f) {
                        g.setAlpha(this.strokeOpacity);
                        g.setColor(this.strokeColor);
                        g.drawShape(gp, this.stroke);
                    }
                    g.translate(-x, -y);
                    g.setAlpha(a);
                }
                if (this.stroke != null && this.strokeOpacity > 0 && this.strokeThickness > 0.0f) {
                    a = g.getAlpha();
                    g.setAlpha(this.strokeOpacity);
                    g.setColor(this.strokeColor);
                    g.translate(x, y);
                    g.drawShape(gp, this.stroke);
                    g.translate(-x, -y);
                    g.setAlpha(a);
                }
                return;
            }
            if (w > 0 && h > 0) {
                Image background = (Image)c.getClientProperty(CACHE_KEY + this.instanceVal);
                if (!this.dirty && background != null && background.getWidth() == w && background.getHeight() == h) {
                    g.drawImage(background, x, y);
                    return;
                }
            } else {
                return;
            }
            Image target = this.createTargetImage(c, w, h, true);
            g.drawImage(target, x, y);
            c.putClientProperty(CACHE_KEY + this.instanceVal, target);
            this.dirty = false;
            if (!this.useCache) {
                Display.getInstance().callSeriallyOnIdle(new Runnable(){

                    public void run() {
                        if (w == c.getWidth() && h == c.getHeight()) {
                            Image target = RoundRectBorder.this.createTargetImage(c, w, h, false);
                            c.putClientProperty(RoundRectBorder.CACHE_KEY + RoundRectBorder.this.instanceVal, target);
                            c.repaint();
                        }
                    }
                });
            }
        }
        finally {
            g.setAntiAliased(antiAliased);
        }
    }

    private GeneralPath createShape(int shapeW, int shapeH) {
        int actualArrowPosition;
        int ah;
        int actualArrowPosition2;
        int ah2;
        GeneralPath gp = new GeneralPath();
        float radius = Display.getInstance().convertToPixels(this.cornerRadius);
        float x = 0.0f;
        float y = 0.0f;
        float widthF = shapeW;
        float heightF = shapeH;
        if (this.getTrackComponent() != null || this.trackComponentSide >= 0) {
            ah2 = CN.convertToPixels(this.arrowSize);
            switch (this.arrowDirection) {
                case 0: {
                    y = ah2;
                }
                case 2: {
                    heightF -= (float)ah2;
                    break;
                }
                case 1: {
                    x = ah2;
                }
                case 3: {
                    widthF -= (float)ah2;
                }
            }
        }
        if (this.stroke != null && this.strokeOpacity > 0 && this.strokeThickness > 0.0f) {
            int strokePx = (int)this.strokeThickness;
            if (this.strokeMM) {
                strokePx = Display.getInstance().convertToPixels(this.strokeThickness);
            }
            widthF -= (float)strokePx;
            heightF -= (float)strokePx;
            x += (float)(strokePx / 2);
            y += (float)(strokePx / 2);
            if (strokePx % 2 == 1) {
                x += 0.5f;
                y += 0.5f;
            }
        }
        if (this.topLeft) {
            gp.moveTo(x + radius, y);
        } else {
            gp.moveTo(x, y);
        }
        if ((this.trackComponentSide >= 0 || this.getTrackComponent() != null) && this.arrowDirection == 0) {
            actualArrowPosition2 = (int)Math.min(x + widthF, Math.max((float)this.arrowPosition, x + radius));
            gp.lineTo(actualArrowPosition2, y);
            ah = CN.convertToPixels(this.arrowSize);
            gp.lineTo(actualArrowPosition2 + ah / 2 - 4, 4.0f);
            gp.quadTo(actualArrowPosition2 + ah / 2, 4.0f, actualArrowPosition2 + ah / 2 + 4, 4.0f);
            gp.lineTo(actualArrowPosition2 + ah, y);
            gp.lineTo(x + widthF - radius, y);
            gp.quadTo(x + widthF, y, x + widthF, y + radius);
        } else if (this.topRight) {
            gp.lineTo(x + widthF - radius, y);
            gp.quadTo(x + widthF, y, x + widthF, y + radius);
        } else {
            gp.lineTo(x + widthF, y);
        }
        if (this.bottomRight) {
            gp.lineTo(x + widthF, y + heightF - radius);
            gp.quadTo(x + widthF, y + heightF, x + widthF - radius, y + heightF);
        } else {
            gp.lineTo(x + widthF, y + heightF);
        }
        if ((this.trackComponentSide >= 0 || this.getTrackComponent() != null) && this.arrowDirection == 2) {
            actualArrowPosition2 = (int)Math.min(x + widthF, Math.max((float)this.arrowPosition, x + radius));
            gp.lineTo(actualArrowPosition2, y + heightF);
            ah = CN.convertToPixels(this.arrowSize);
            gp.lineTo(actualArrowPosition2 + ah / 2 - 4, y + heightF + (float)ah - 4.0f);
            gp.quadTo(actualArrowPosition2 + ah / 2, y + heightF + (float)ah - 4.0f, actualArrowPosition2 + ah / 2 + 4, y + heightF + (float)ah - 4.0f);
            gp.lineTo(actualArrowPosition2 + ah, y + heightF);
            gp.lineTo(x + radius, y + heightF);
            gp.quadTo(x, y + heightF, x, y + heightF - radius);
        } else if (this.bottomLeft) {
            gp.lineTo(x + radius, y + heightF);
            gp.quadTo(x, y + heightF, x, y + heightF - radius);
        } else {
            gp.lineTo(x, y + heightF);
        }
        if (this.topLeft) {
            gp.lineTo(x, y + radius);
            gp.quadTo(x, y, x + radius, y);
        } else {
            gp.lineTo(x, y);
        }
        gp.closePath();
        if ((this.trackComponentSide >= 0 || this.getTrackComponent() != null) && this.arrowDirection == 1) {
            ah2 = CN.convertToPixels(this.arrowSize);
            actualArrowPosition = (int)Math.max(y, Math.min((float)this.arrowPosition, y + heightF - radius - 4.0f));
            gp.moveTo(0.0f, actualArrowPosition);
            gp.lineTo(x, actualArrowPosition - ah2 / 2);
            gp.lineTo(x, actualArrowPosition + ah2 / 2);
            gp.lineTo(0.0f, actualArrowPosition);
            gp.closePath();
        }
        if ((this.trackComponentSide >= 0 || this.getTrackComponent() != null) && this.arrowDirection == 3) {
            ah2 = CN.convertToPixels(this.arrowSize);
            actualArrowPosition = (int)Math.max(y, Math.min((float)this.arrowPosition, y + heightF - radius - 4.0f));
            gp.moveTo(x + widthF + (float)ah2, actualArrowPosition);
            gp.lineTo(x + widthF, actualArrowPosition + ah2 / 2);
            gp.lineTo(x + widthF, actualArrowPosition - ah2 / 2);
            gp.lineTo(x + widthF + (float)ah2, actualArrowPosition);
            gp.closePath();
        }
        return gp;
    }

    public int getMinimumHeight() {
        return Display.getInstance().convertToPixels(this.shadowSpread) + Display.getInstance().convertToPixels(this.cornerRadius) * 2;
    }

    public int getMinimumWidth() {
        return Display.getInstance().convertToPixels(this.shadowSpread) + Display.getInstance().convertToPixels(this.cornerRadius) * 2;
    }

    private void drawShape(Graphics g, int color, int opacity, int width, int height) {
        g.setColor(color);
        g.setAlpha(opacity);
        GeneralPath gp = this.createShape(width, height);
        if (this.stroke1 == null) {
            this.stroke1 = new Stroke(1.0f, 1, 0, 1.0f);
        }
        g.drawShape(gp, this.stroke1);
    }

    public boolean isBackgroundPainter() {
        return true;
    }

    public int getStrokeColor() {
        return this.strokeColor;
    }

    public int getStrokeOpacity() {
        return this.strokeOpacity;
    }

    public float getStrokeThickness() {
        return this.strokeThickness;
    }

    public boolean isStrokeMM() {
        return this.strokeMM;
    }

    public boolean isBezierCorners() {
        return this.bezierCorners;
    }

    public float getShadowSpread() {
        return this.shadowSpread;
    }

    public int getShadowOpacity() {
        return this.shadowOpacity;
    }

    public int getShadowColor() {
        return this.shadowColor;
    }

    public float getShadowX() {
        return this.shadowX;
    }

    public float getShadowY() {
        return this.shadowY;
    }

    public float getShadowBlur() {
        return this.shadowBlur;
    }

    public float getCornerRadius() {
        return this.cornerRadius;
    }

    public boolean isTopOnlyMode() {
        return this.topLeft && this.topRight && !this.bottomLeft && !this.bottomRight;
    }

    public boolean isBottomOnlyMode() {
        return !this.topLeft && !this.topRight && this.bottomLeft && this.bottomRight;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public boolean isTopLeft() {
        return this.topLeft;
    }

    public boolean isTopRight() {
        return this.topRight;
    }

    public boolean isBottomLeft() {
        return this.bottomLeft;
    }

    public boolean isBottomRight() {
        return this.bottomRight;
    }
}

