/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.ui.CN;
import com.codename1.ui.Component;
import com.codename1.ui.Display;
import com.codename1.ui.Font;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.ImageFactory;
import com.codename1.ui.ReleasableComponent;
import com.codename1.ui.animations.Animation;
import com.codename1.ui.animations.Motion;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.events.ActionSource;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.plaf.UIManager;
import com.codename1.ui.util.EventDispatcher;
import java.util.Collection;

public class Switch
extends Component
implements ActionSource,
ReleasableComponent {
    private boolean value;
    private Image thumbOnImage;
    private Image thumbOffImage;
    private Image thumbDisabledImage;
    private Image trackOnImage;
    private Image trackOffImage;
    private Image trackDisabledImage;
    private boolean dragged;
    private long dragStartTime;
    private int pressX;
    private int pressY;
    private int deltaX;
    private int deltaY;
    private final EventDispatcher dispatcher = new EventDispatcher();
    private final EventDispatcher changeDispatcher = new EventDispatcher();
    private boolean animationLock;
    private int valign = 4;
    private final ActionListener pointerPressed = new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            Form f = Switch.this.getComponentForm();
            if (f != null) {
                f.addComponentAwaitingRelease(Switch.this);
            }
            Switch.this.dragged = false;
            Switch.this.dragStartTime = System.currentTimeMillis();
            Switch.this.deltaX = 0;
            Switch.this.deltaY = 0;
            Switch.this.pressX = evt.getX();
            Switch.this.pressY = evt.getY();
        }
    };
    private final ActionListener pointerDragged = new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            Switch.this.dragged = true;
            Switch.this.deltaX = Switch.this.pressX - evt.getX();
            Switch.this.deltaY = Switch.this.pressY - evt.getY();
            if ((double)Math.abs(Switch.this.deltaY) >= Math.abs((double)Switch.this.deltaX * 0.5)) {
                Switch.this.dragged = false;
                Switch.this.deltaX = 0;
                Switch.this.deltaY = 0;
            } else {
                evt.consume();
            }
        }
    };
    private final ActionListener pointerReleased = new ActionListener(){
        private int tapThreshold = CN.convertToPixels(1.0f);

        private boolean dragWasActuallyATap() {
            return System.currentTimeMillis() - Switch.this.dragStartTime < 60L && Math.abs(Switch.this.deltaX) < this.tapThreshold;
        }

        public void actionPerformed(ActionEvent evt) {
            if (Switch.this.animationLock) {
                return;
            }
            Switch.this.animationLock = true;
            if (!this.dragWasActuallyATap() && Switch.this.dragged) {
                if (Switch.this.deltaX > 0) {
                    int trackLength = 0;
                    trackLength = Switch.this.isRTL() ? Switch.this.getCurrentTrackOffImage().getWidth() - Switch.this.getCurrentThumbImage().getWidth() : Switch.this.getCurrentTrackOnImage().getWidth() - Switch.this.getCurrentThumbImage().getWidth();
                    if (Switch.this.deltaX > trackLength / 2) {
                        Switch.this.animateTo(Switch.this.isRTL(), Switch.this.deltaX, trackLength, trackLength);
                    } else {
                        Switch.this.animateTo(!Switch.this.isRTL(), Switch.this.deltaX, 0, trackLength);
                    }
                } else {
                    int trackLength = 0;
                    trackLength = Switch.this.isRTL() ? Switch.this.getCurrentTrackOnImage().getWidth() - Switch.this.getCurrentThumbImage().getWidth() : Switch.this.getCurrentTrackOffImage().getWidth() - Switch.this.getCurrentThumbImage().getWidth();
                    if (Switch.this.deltaX * -1 > trackLength / 2) {
                        Switch.this.animateTo(!Switch.this.isRTL(), Switch.this.deltaX, -trackLength, trackLength);
                    } else {
                        Switch.this.animateTo(Switch.this.isRTL(), Switch.this.deltaX, 0, trackLength);
                    }
                }
            } else if (Switch.this.value) {
                int trackLength = 0;
                trackLength = Switch.this.isRTL() ? Switch.this.getCurrentTrackOnImage().getWidth() - Switch.this.getCurrentThumbImage().getWidth() : Switch.this.getCurrentTrackOffImage().getWidth() - Switch.this.getCurrentThumbImage().getWidth();
                Switch.this.animateTo(false, 0, trackLength, trackLength);
            } else {
                int trackLength = 0;
                trackLength = Switch.this.isRTL() ? Switch.this.getCurrentTrackOffImage().getWidth() - Switch.this.getCurrentThumbImage().getWidth() : Switch.this.getCurrentTrackOnImage().getWidth() - Switch.this.getCurrentThumbImage().getWidth();
                Switch.this.animateTo(true, 0, -trackLength, trackLength);
            }
            Switch.this.animationLock = false;
        }
    };

    public Switch() {
        this("Switch");
    }

    public Switch(String uiid) {
        this.setUIID(uiid);
        this.setOpaque(false);
        this.initialize();
    }

    private int getFontSize() {
        Font f = this.getUnselectedStyle().getFont();
        if (f == null) {
            f = Font.getDefaultFont();
        }
        return f.getHeight();
    }

    private Image getThumbOnImage() {
        if (this.thumbOnImage == null) {
            this.thumbOnImage = Switch.createPlatformThumbImage(this, (int)((double)this.getFontSize() * this.getThumbScaleY()), this.getSelectedStyle().getFgColor(), 2, this.getThumbInset());
        }
        return this.thumbOnImage;
    }

    private Image getThumbOffImage() {
        if (this.thumbOffImage == null) {
            this.thumbOffImage = Switch.createPlatformThumbImage(this, (int)((double)this.getFontSize() * this.getThumbScaleY()), this.getUnselectedStyle().getFgColor(), 2, this.getThumbInset());
        }
        return this.thumbOffImage;
    }

    private Image getThumbDisabledImage() {
        if (this.thumbDisabledImage == null) {
            this.thumbDisabledImage = Switch.createPlatformThumbImage(this, (int)((double)this.getFontSize() * this.getThumbScaleY()), this.getDisabledStyle().getFgColor(), 2, this.getThumbInset());
        }
        return this.thumbDisabledImage;
    }

    protected int getDragRegionStatus(int x, int y) {
        return 31;
    }

    private Image getCurrentThumbImage() {
        if (this.isEnabled()) {
            if (this.value) {
                return this.getThumbOnImage();
            }
            return this.getThumbOffImage();
        }
        return this.getThumbDisabledImage();
    }

    private double getTrackScaleY() {
        return Double.parseDouble(this.getUIManager().getThemeConstant(this.getUIID().toLowerCase() + "TrackScaleY", "0.9"));
    }

    private double getThumbScaleY() {
        return Double.parseDouble(this.getUIManager().getThemeConstant(this.getUIID().toLowerCase() + "ThumbScaleY", "1.5"));
    }

    private double getTrackScaleX() {
        return Double.parseDouble(this.getUIManager().getThemeConstant(this.getUIID().toLowerCase() + "TrackScaleX", "3"));
    }

    private int getTrackOnOutlineWidth() {
        return Display.getInstance().convertToPixels(Float.parseFloat(this.getUIManager().getThemeConstant(this.getUIID().toLowerCase() + "TrackOnOutlineWidthMM", "0")));
    }

    private int getTrackOnOutlineColor() {
        return Integer.parseInt(this.getUIManager().getThemeConstant(this.getUIID().toLowerCase() + "TrackOnOutlineColor", "0"), 16);
    }

    private int getTrackOffOutlineWidth() {
        return Display.getInstance().convertToPixels(Float.parseFloat(this.getUIManager().getThemeConstant(this.getUIID().toLowerCase() + "TrackOffOutlineWidthMM", "0")));
    }

    private int getTrackOffOutlineColor() {
        return Integer.parseInt(this.getUIManager().getThemeConstant(this.getUIID().toLowerCase() + "TrackOffOutlineColor", "0"), 16);
    }

    private int getThumbInset() {
        return Display.getInstance().convertToPixels(Float.parseFloat(this.getUIManager().getThemeConstant(this.getUIID().toLowerCase() + "ThumbInsetMM", "0")));
    }

    private Image getTrackOnImage() {
        if (this.trackOnImage == null) {
            this.trackOnImage = Switch.createPlatformTrackImage(this, (int)((double)this.getFontSize() * this.getTrackScaleX()), (int)((double)this.getFontSize() * this.getTrackScaleY()), this.getSelectedStyle().getBgColor(), 255, 2, this.getTrackOnOutlineColor(), this.getTrackOnOutlineWidth());
        }
        return this.trackOnImage;
    }

    private Image getTrackDisabledImage() {
        if (this.trackDisabledImage == null) {
            this.trackDisabledImage = Switch.createPlatformTrackImage(this, (int)((double)this.getFontSize() * this.getTrackScaleX()), (int)((double)this.getFontSize() * this.getTrackScaleY()), this.getDisabledStyle().getBgColor(), 255, 2, this.getTrackOffOutlineColor(), this.getTrackOffOutlineWidth());
        }
        return this.trackDisabledImage;
    }

    private Image getCurrentTrackOnImage() {
        if (this.isEnabled()) {
            return this.getTrackOnImage();
        }
        return this.getTrackDisabledImage();
    }

    private Image getTrackOffImage() {
        if (this.trackOffImage == null) {
            this.trackOffImage = Switch.createPlatformTrackImage(this, (int)((double)this.getFontSize() * this.getTrackScaleX()), (int)((double)this.getFontSize() * this.getTrackScaleY()), this.getUnselectedStyle().getBgColor(), 255, 2, this.getTrackOffOutlineColor(), this.getTrackOffOutlineWidth());
        }
        return this.trackOffImage;
    }

    private Image getCurrentTrackOffImage() {
        if (this.isEnabled()) {
            return this.getTrackOffImage();
        }
        return this.getTrackDisabledImage();
    }

    public void styleChanged(String propertyName, Style source) {
        if ("fgColor".equals(propertyName) || "bgColor".equals(propertyName) || "font".equals(propertyName)) {
            this.initTheme();
        }
        super.styleChanged(propertyName, source);
    }

    protected Dimension calcPreferredSize() {
        return new Dimension(this.getStyle().getHorizontalPadding() + Math.max(this.getCurrentThumbImage().getWidth(), Math.max(this.getCurrentTrackOnImage().getWidth(), this.getCurrentTrackOffImage().getWidth())), this.getStyle().getVerticalPadding() + Math.max(this.getCurrentThumbImage().getHeight(), Math.max(this.getCurrentTrackOnImage().getHeight(), this.getCurrentTrackOffImage().getHeight())));
    }

    protected void resetFocusable() {
        this.setFocusable(true);
    }

    private void initialize() {
        this.setFocusable(true);
        this.initTheme();
    }

    public void refreshTheme(boolean merge) {
        super.refreshTheme(merge);
        this.initTheme();
    }

    private void initTheme() {
        this.thumbOffImage = null;
        this.thumbOnImage = null;
        this.thumbDisabledImage = null;
        this.trackOnImage = null;
        this.trackOffImage = null;
        this.trackDisabledImage = null;
        this.setThumbOnImage(UIManager.getInstance().getThemeImageConstant(this.getUIID().toLowerCase() + "ThumbOnImage"));
        this.setThumbOffImage(UIManager.getInstance().getThemeImageConstant(this.getUIID().toLowerCase() + "ThumbOffImage"));
        this.setThumbDisabledImage(UIManager.getInstance().getThemeImageConstant(this.getUIID().toLowerCase() + "ThumbDisabledImage"));
        this.setTrackOnImage(UIManager.getInstance().getThemeImageConstant(this.getUIID().toLowerCase() + "OnTrackImage"));
        this.setTrackOffImage(UIManager.getInstance().getThemeImageConstant(this.getUIID().toLowerCase() + "OffTrackImage"));
        this.setTrackDisabledImage(UIManager.getInstance().getThemeImageConstant(this.getUIID().toLowerCase() + "DisabledTrackImage"));
    }

    private static Image createRoundThumbImage(Component context, int pxDim, int color, int shadowSpread, int thumbInset) {
        Image img = ImageFactory.createImage(context, pxDim + 2 * shadowSpread, pxDim + 2 * shadowSpread, 0);
        Graphics g = img.getGraphics();
        g.setAntiAliased(true);
        int shadowOpacity = 200;
        float shadowBlur = 10.0f;
        if (shadowSpread > 0) {
            for (int iter = shadowSpread - 1; iter >= 0; --iter) {
                g.translate(iter, iter);
                g.setColor(0);
                int alpha = g.concatenateAlpha(shadowOpacity / shadowSpread);
                g.fillArc(Math.max(1, thumbInset + shadowSpread + shadowSpread / 2 - iter), Math.max(1, thumbInset + 2 * shadowSpread - iter), Math.max(1, pxDim - iter * 2 - 2 * thumbInset), Math.max(1, pxDim - iter * 2 - 2 * thumbInset), 0, 360);
                g.setAlpha(alpha);
                g.translate(-iter, -iter);
            }
            if (Display.getInstance().isGaussianBlurSupported()) {
                Image blured;
                img = blured = Display.getInstance().gaussianBlurImage(img, shadowBlur / 2.0f);
                g = img.getGraphics();
                g.setAntiAliased(true);
            }
        }
        int alpha = g.concatenateAlpha(255);
        g.setColor(color);
        g.fillArc(shadowSpread + thumbInset, shadowSpread + thumbInset, Math.max(1, pxDim - 2 * thumbInset), Math.max(1, pxDim - 2 * thumbInset), 0, 360);
        g.setAlpha(alpha);
        return img;
    }

    private static Image createPlatformThumbImage(Component context, int pxDim, int color, int shadowSpread, int thumbInset) {
        return Switch.createRoundThumbImage(context, pxDim, color, shadowSpread, thumbInset);
    }

    private static Image createRoundRectTrackImage(Component context, int width, int height, int color, int alpha, int thumbPadding, int outlineColor, int outlineWidth) {
        Image img = ImageFactory.createImage(context, width + 2 * thumbPadding, height, 0);
        Graphics g = img.getGraphics();
        g.setAntiAliased(true);
        int oldAlpha = g.concatenateAlpha(alpha);
        int topPadding = 0;
        if (outlineWidth > 0) {
            g.setColor(outlineColor);
            g.fillRoundRect(thumbPadding, 0, width, height, height, height);
            thumbPadding += outlineWidth;
            topPadding += outlineWidth;
            width -= 2 * outlineWidth;
            height -= 2 * outlineWidth;
        }
        thumbPadding = Math.max(0, thumbPadding);
        topPadding = Math.max(0, topPadding);
        width = Math.max(2, width);
        height = Math.max(2, height);
        g.setColor(color);
        g.fillRoundRect(thumbPadding, topPadding, width, height, height, height);
        g.setAlpha(oldAlpha);
        return img;
    }

    private static Image createPlatformTrackImage(Component context, int width, int height, int color, int alpha, int thumbPadding, int outlineColor, int outlineWidth) {
        return Switch.createRoundRectTrackImage(context, width, height, color, alpha, thumbPadding, outlineColor, outlineWidth);
    }

    protected boolean isStickyDrag() {
        return true;
    }

    public void addActionListener(ActionListener l) {
        this.dispatcher.addListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.dispatcher.removeListener(l);
    }

    public void addChangeListener(ActionListener l) {
        this.changeDispatcher.addListener(l);
    }

    public void removeChangeListener(ActionListener l) {
        this.changeDispatcher.removeListener(l);
    }

    public Collection getListeners() {
        return this.dispatcher.getListenerCollection();
    }

    void fireActionEvent() {
        this.dispatcher.fireActionEvent(new ActionEvent((Object)this, ActionEvent.Type.PointerPressed));
        Display d = Display.getInstance();
        if (d.isBuiltinSoundsEnabled()) {
            d.playBuiltinSound("press");
        }
    }

    void fireChangeEvent() {
        this.changeDispatcher.fireActionEvent(new ActionEvent((Object)this, ActionEvent.Type.Change));
    }

    public void paint(Graphics g) {
        int trackMLength;
        Image cthumbImage = this.getCurrentThumbImage();
        Image cTrackImage = this.value ? this.getCurrentTrackOnImage() : this.getCurrentTrackOffImage();
        int strackLength = Math.max(cTrackImage.getWidth(), cTrackImage.getWidth());
        int sheight = Math.max(cthumbImage.getHeight(), Math.max(cTrackImage.getHeight(), cTrackImage.getHeight()));
        int vdeltaX = -this.deltaX;
        if (this.isRTL()) {
            vdeltaX = this.deltaX;
        }
        Style s = this.getStyle();
        int padLeft = s.getPaddingLeft(this.isRTL());
        int padRight = s.getPaddingRight(this.isRTL());
        int padTop = s.getPaddingTop();
        int padBot = s.getPaddingBottom();
        int innerHeight = this.getHeight() - padTop - padBot;
        int innerWidth = this.getWidth() - padLeft - padRight;
        int halign = s.getAlignment();
        int thumbrX = 0;
        if (this.isRTL()) {
            if (!this.value) {
                thumbrX = cTrackImage.getWidth() - cthumbImage.getWidth();
            }
        } else if (this.value) {
            thumbrX = cTrackImage.getWidth() - cthumbImage.getWidth();
        }
        Image nextThumbImage = null;
        Image nextTrackImage = null;
        double nextImageProgress = 0.0;
        if (this.value) {
            if (vdeltaX > 0) {
                this.dragged = false;
            } else {
                nextThumbImage = this.getThumbOffImage();
                nextTrackImage = this.getTrackOffImage();
                trackMLength = cTrackImage.getWidth() - cthumbImage.getWidth();
                if (vdeltaX < -trackMLength) {
                    vdeltaX = -trackMLength;
                }
                nextImageProgress = (double)Math.abs(vdeltaX) / (double)Math.abs(trackMLength);
            }
        } else if (vdeltaX < 0) {
            this.dragged = false;
        } else {
            nextThumbImage = this.getThumbOnImage();
            nextTrackImage = this.getTrackOnImage();
            trackMLength = cTrackImage.getWidth() - cthumbImage.getWidth();
            if (vdeltaX > trackMLength) {
                vdeltaX = trackMLength;
            }
            nextImageProgress = 1.0 - (double)Math.abs(trackMLength - vdeltaX) / (double)Math.abs(trackMLength);
        }
        if (this.dragged) {
            int thumbCenterrX = this.value ? (this.isRTL() ? -vdeltaX + cthumbImage.getWidth() / 2 : cTrackImage.getWidth() + vdeltaX - cthumbImage.getWidth() / 2) : (this.isRTL() ? cTrackImage.getWidth() - vdeltaX - cthumbImage.getWidth() / 2 : vdeltaX + cthumbImage.getWidth() / 2);
            thumbrX = thumbCenterrX - cthumbImage.getWidth() / 2;
            int imgY = this.getY() + padTop + Switch.getAlignedCoord(sheight / 2 - cTrackImage.getHeight() / 2, innerHeight, sheight, this.valign);
            int imgX = this.getX() + padLeft + Switch.getAlignedCoord(0, innerWidth, strackLength, halign);
            int alph = g.getAlpha();
            if (nextImageProgress > 0.0 && nextTrackImage != null) {
                g.setAlpha((int)Math.round((1.0 - nextImageProgress) * 255.0));
            }
            g.drawImage(cTrackImage, imgX, imgY);
            if (nextImageProgress > 0.0 && nextTrackImage != null) {
                g.setAlpha((int)Math.round(nextImageProgress * 255.0));
                g.drawImage(nextTrackImage, imgX, imgY);
                g.setAlpha(alph);
            }
        } else {
            int imgX = this.getX() + padLeft + Switch.getAlignedCoord(0, innerWidth, strackLength, halign);
            int imgY = this.getY() + padTop + Switch.getAlignedCoord(sheight / 2 - cTrackImage.getHeight() / 2, innerHeight, sheight, this.valign);
            g.drawImage(cTrackImage, imgX, imgY);
        }
        int alph = g.getAlpha();
        if (nextImageProgress > 0.0 && nextThumbImage != null) {
            g.setAlpha((int)Math.round((1.0 - nextImageProgress) * 255.0));
        }
        g.drawImage(cthumbImage, this.getX() + padLeft + Switch.getAlignedCoord(thumbrX, innerWidth, strackLength, halign), this.getY() + padTop + Switch.getAlignedCoord(sheight / 2 - cthumbImage.getHeight() / 2, innerHeight, sheight, this.valign));
        if (nextImageProgress > 0.0 && nextThumbImage != null) {
            g.setAlpha((int)Math.round(nextImageProgress * 255.0));
            g.drawImage(nextThumbImage, this.getX() + padLeft + Switch.getAlignedCoord(thumbrX, innerWidth, strackLength, halign), this.getY() + padTop + Switch.getAlignedCoord(sheight / 2 - cthumbImage.getHeight() / 2, innerHeight, sheight, this.valign));
            g.setAlpha(alph);
        }
    }

    private static int getAlignedCoord(int coord, int parentDim, int elemDim, int alignment) {
        switch (alignment) {
            case 4: {
                return coord + parentDim / 2 - elemDim / 2;
            }
            case 2: 
            case 3: {
                return coord + parentDim - elemDim;
            }
        }
        return coord;
    }

    protected void initComponent() {
        super.initComponent();
        this.addPointerPressedListener(this.pointerPressed);
        this.addPointerDraggedListener(this.pointerDragged);
        this.addPointerReleasedListener(this.pointerReleased);
    }

    protected void deinitialize() {
        this.removePointerPressedListener(this.pointerPressed);
        this.removePointerDraggedListener(this.pointerDragged);
        this.removePointerReleasedListener(this.pointerReleased);
        super.deinitialize();
    }

    private void animateTo(final boolean value, int deltaStart, int deltaEnd, int maxMoveDist) {
        int anim_duration = (int)Math.abs((double)(deltaEnd - deltaStart) / (double)maxMoveDist * 100.0);
        final Motion current = Motion.createEaseInOutMotion(deltaStart, deltaEnd, anim_duration);
        if (anim_duration > 0) {
            current.start();
            this.deltaX = deltaStart;
            this.getComponentForm().registerAnimated(new Animation(){

                public boolean animate() {
                    Switch.this.deltaX = current.getValue();
                    Switch.this.dragged = true;
                    if (current.isFinished()) {
                        Switch.this.dragged = false;
                        Switch.this.deltaX = 0;
                        Switch.this.deltaY = 0;
                        Form f = Switch.this.getComponentForm();
                        if (f != null) {
                            f.deregisterAnimated(this);
                        }
                        Switch.this.setValue(value, true);
                    }
                    Switch.this.repaint();
                    return false;
                }

                public void paint(Graphics g) {
                }
            });
            this.dragged = true;
        } else {
            this.deltaX = 0;
            this.deltaY = 0;
            this.dragged = false;
            this.setValue(value, true);
        }
    }

    public boolean isValue() {
        return this.value;
    }

    public void setValue(boolean value) {
        this.setValue(value, false);
    }

    private void setValue(boolean value, boolean fireEvent) {
        boolean orig = this.animationLock;
        this.animationLock = true;
        boolean oldValue = this.value;
        this.value = value;
        if (oldValue != value) {
            this.fireChangeEvent();
        }
        if (fireEvent && oldValue != value) {
            this.fireActionEvent();
        }
        this.repaint();
        this.animationLock = orig;
    }

    private void flip() {
        this.setValue(!this.value);
    }

    public boolean isOn() {
        return this.value;
    }

    public void setOn() {
        this.setValue(true);
    }

    public boolean isOff() {
        return !this.value;
    }

    public void setOff() {
        this.setValue(false);
    }

    public String[] getPropertyNames() {
        return new String[]{"value"};
    }

    public Object getComponentState() {
        if (this.value) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void setComponentState(Object state) {
        System.out.println("Setting component state " + state);
        this.value = (Boolean)state;
    }

    public Class[] getPropertyTypes() {
        return new Class[]{Boolean.class};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("value")) {
            if (this.value) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("value")) {
            this.setValue((Boolean)value);
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    private void setThumbOnImage(Image image) {
        if (image != null) {
            this.thumbOnImage = image;
            if (this.thumbOffImage == null) {
                this.thumbOffImage = image;
            }
            if (this.thumbDisabledImage == null) {
                this.thumbDisabledImage = image;
            }
            this.setShouldCalcPreferredSize(true);
        }
    }

    private void setThumbOffImage(Image image) {
        if (image != null) {
            this.thumbOffImage = image;
            if (this.thumbOnImage == null) {
                this.thumbOnImage = image;
            }
            if (this.thumbDisabledImage == null) {
                this.thumbDisabledImage = image;
            }
            this.setShouldCalcPreferredSize(true);
        }
    }

    private void setThumbDisabledImage(Image image) {
        if (image != null) {
            this.thumbDisabledImage = image;
            if (this.thumbOnImage == null) {
                this.thumbOnImage = image;
            }
            if (this.thumbDisabledImage == null) {
                this.thumbDisabledImage = image;
            }
            this.setShouldCalcPreferredSize(true);
        }
    }

    private void setTrackOnImage(Image image) {
        if (image != null) {
            this.trackOnImage = image;
            if (this.trackOffImage == null) {
                this.trackOffImage = image;
            }
            if (this.trackDisabledImage == null) {
                this.trackDisabledImage = image;
            }
            this.setShouldCalcPreferredSize(true);
        }
    }

    private void setTrackOffImage(Image image) {
        if (image != null) {
            this.trackOffImage = image;
            if (this.trackOnImage == null) {
                this.trackOnImage = image;
            }
            if (this.trackDisabledImage == null) {
                this.trackDisabledImage = image;
            }
            this.setShouldCalcPreferredSize(true);
        }
    }

    private void setTrackDisabledImage(Image image) {
        if (image != null) {
            this.trackDisabledImage = image;
            if (this.trackOnImage == null) {
                this.trackOnImage = image;
            }
            if (this.trackOffImage == null) {
                this.trackOffImage = image;
            }
            this.setShouldCalcPreferredSize(true);
        }
    }

    public boolean isAutoRelease() {
        return false;
    }

    public void setAutoRelease(boolean arg0) {
    }

    public int getReleaseRadius() {
        return 0;
    }

    public void setReleaseRadius(int arg0) {
    }

    public void setReleased() {
    }
}

