/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.social;

import com.codename1.facebook.FaceBookAccess;
import com.codename1.io.AccessToken;
import com.codename1.io.ConnectionRequest;
import com.codename1.io.Log;
import com.codename1.io.NetworkManager;
import com.codename1.io.Oauth2;
import com.codename1.social.Login;
import com.codename1.social.LoginCallback;
import com.codename1.util.Callback;

public class FacebookConnect
extends Login {
    private static FacebookConnect instance;
    static Class implClass;
    private String[] permissions = new String[]{"public_profile", "email", "user_friends"};

    FacebookConnect() {
        this.setOauth2URL("https://www.facebook.com/dialog/oauth");
    }

    public static FacebookConnect getInstance() {
        if (instance == null) {
            if (implClass != null) {
                try {
                    instance = (FacebookConnect)implClass.newInstance();
                }
                catch (Throwable t) {
                    Log.e(t);
                    instance = new FacebookConnect();
                }
            } else {
                instance = new FacebookConnect();
            }
        }
        return instance;
    }

    public boolean isFacebookSDKSupported() {
        return false;
    }

    public void login() {
        throw new RuntimeException("Native facebook unsupported");
    }

    public void doLogout() {
        super.doLogout();
        if (!this.isNativeLoginSupported()) {
            FaceBookAccess.logOut();
        }
    }

    public AccessToken getAccessToken() {
        AccessToken t = super.getAccessToken();
        if (t != null) {
            return t;
        }
        if (this.isNativeLoginSupported()) {
            return new AccessToken(this.getToken(), null);
        }
        return null;
    }

    public boolean isLoggedIn() {
        throw new RuntimeException("Native facebook unsupported, if you are running on the Simulator use isUserLoggedIn");
    }

    public String getToken() {
        throw new RuntimeException("Native facebook unsupported, if you are running on the Simulator use getAccessToken");
    }

    public void logout() {
        throw new RuntimeException("Native facebook unsupported, if you are running on the Simulator use doLogout");
    }

    public void askPublishPermissions(LoginCallback lc) {
        throw new RuntimeException("Native facebook unsupported");
    }

    public boolean hasPublishPermissions() {
        throw new RuntimeException("Native facebook unsupported");
    }

    public boolean isNativeLoginSupported() {
        return this.isFacebookSDKSupported();
    }

    protected Oauth2 createOauth2() {
        FaceBookAccess.setClientId(this.clientId);
        FaceBookAccess.setClientSecret(this.clientSecret);
        FaceBookAccess.setRedirectURI(this.redirectURI);
        FaceBookAccess.setPermissions(this.permissions);
        return FaceBookAccess.getInstance().createOAuth();
    }

    public void nativelogin() {
        this.login();
    }

    public void nativeLogout() {
        this.logout();
    }

    public boolean nativeIsLoggedIn() {
        return this.isLoggedIn();
    }

    public void inviteFriends(String appLinkUrl, String previewImageUrl) {
    }

    public void inviteFriends(String appLinkUrl, String previewImageUrl, Callback cb) {
    }

    public boolean isInviteFriendsSupported() {
        return false;
    }

    protected boolean validateToken(String token) {
        final boolean[] retval = new boolean[]{true};
        ConnectionRequest req = new ConnectionRequest(){

            protected void handleErrorResponseCode(int code, String message) {
                if (code >= 400 && code <= 410) {
                    retval[0] = false;
                    return;
                }
                super.handleErrorResponseCode(code, message);
            }
        };
        req.setPost(false);
        req.setUrl("https://graph.facebook.com/v2.4/me");
        req.addArgumentNoEncoding("access_token", token);
        NetworkManager.getInstance().addToQueueAndWait(req);
        return retval[0];
    }
}

